/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.pages.panels;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.model.UserProfile;
import org.sakaiproject.profile2.tool.pages.panels.MyInfoDisplay;
import org.sakaiproject.profile2.tool.pages.panels.MyStaffDisplay;
import org.sakaiproject.profile2.util.ProfileUtils;

public class MyStaffDisplay
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MyInfoDisplay.class);
    private int visibleFieldCount = 0;
    @SpringBean(name="org.sakaiproject.profile2.logic.SakaiProxy")
    private SakaiProxy sakaiProxy;

    public MyStaffDisplay(String id, UserProfile userProfile) {
        super(id);
        MyStaffDisplay thisPanel = this;
        String department = userProfile.getDepartment();
        String position = userProfile.getPosition();
        String school = userProfile.getSchool();
        String room = userProfile.getRoom();
        String staffProfile = userProfile.getStaffProfile();
        String universityProfileUrl = userProfile.getUniversityProfileUrl();
        String academicProfileUrl = userProfile.getAcademicProfileUrl();
        String publications = userProfile.getPublications();
        this.add(new Component[]{new Label("heading", (IModel)new ResourceModel("heading.staff"))});
        WebMarkupContainer departmentContainer = new WebMarkupContainer("departmentContainer");
        departmentContainer.add(new Component[]{new Label("departmentLabel", (IModel)new ResourceModel("profile.department"))});
        departmentContainer.add(new Component[]{new Label("department", department)});
        this.add(new Component[]{departmentContainer});
        if (StringUtils.isBlank((String)department)) {
            departmentContainer.setVisible(false);
        } else {
            ++this.visibleFieldCount;
        }
        WebMarkupContainer positionContainer = new WebMarkupContainer("positionContainer");
        positionContainer.add(new Component[]{new Label("positionLabel", (IModel)new ResourceModel("profile.position"))});
        positionContainer.add(new Component[]{new Label("position", position)});
        this.add(new Component[]{positionContainer});
        if (StringUtils.isBlank((String)position)) {
            positionContainer.setVisible(false);
        } else {
            ++this.visibleFieldCount;
        }
        WebMarkupContainer schoolContainer = new WebMarkupContainer("schoolContainer");
        schoolContainer.add(new Component[]{new Label("schoolLabel", (IModel)new ResourceModel("profile.school"))});
        schoolContainer.add(new Component[]{new Label("school", school)});
        this.add(new Component[]{schoolContainer});
        if (StringUtils.isBlank((String)school)) {
            schoolContainer.setVisible(false);
        } else {
            ++this.visibleFieldCount;
        }
        WebMarkupContainer roomContainer = new WebMarkupContainer("roomContainer");
        roomContainer.add(new Component[]{new Label("roomLabel", (IModel)new ResourceModel("profile.room"))});
        roomContainer.add(new Component[]{new Label("room", room)});
        this.add(new Component[]{roomContainer});
        if (StringUtils.isBlank((String)room)) {
            roomContainer.setVisible(false);
        } else {
            ++this.visibleFieldCount;
        }
        WebMarkupContainer staffProfileContainer = new WebMarkupContainer("staffProfileContainer");
        staffProfileContainer.add(new Component[]{new Label("staffProfileLabel", (IModel)new ResourceModel("profile.staffprofile"))});
        staffProfileContainer.add(new Component[]{new Label("staffProfile", ProfileUtils.processHtml((String)staffProfile)).setEscapeModelStrings(false)});
        this.add(new Component[]{staffProfileContainer});
        if (StringUtils.isBlank((String)staffProfile)) {
            staffProfileContainer.setVisible(false);
        } else {
            ++this.visibleFieldCount;
        }
        WebMarkupContainer universityProfileUrlContainer = new WebMarkupContainer("universityProfileUrlContainer");
        universityProfileUrlContainer.add(new Component[]{new Label("universityProfileUrlLabel", (IModel)new ResourceModel("profile.universityprofileurl"))});
        universityProfileUrlContainer.add(new Component[]{new ExternalLink("universityProfileUrl", universityProfileUrl, universityProfileUrl)});
        this.add(new Component[]{universityProfileUrlContainer});
        if (StringUtils.isBlank((String)universityProfileUrl)) {
            universityProfileUrlContainer.setVisible(false);
        } else {
            ++this.visibleFieldCount;
        }
        WebMarkupContainer academicProfileUrlContainer = new WebMarkupContainer("academicProfileUrlContainer");
        academicProfileUrlContainer.add(new Component[]{new Label("academicProfileUrlLabel", (IModel)new ResourceModel("profile.academicprofileurl"))});
        academicProfileUrlContainer.add(new Component[]{new ExternalLink("academicProfileUrl", academicProfileUrl, academicProfileUrl)});
        this.add(new Component[]{academicProfileUrlContainer});
        if (StringUtils.isBlank((String)academicProfileUrl)) {
            academicProfileUrlContainer.setVisible(false);
        } else {
            ++this.visibleFieldCount;
        }
        WebMarkupContainer publicationsContainer = new WebMarkupContainer("publicationsContainer");
        publicationsContainer.add(new Component[]{new Label("publicationsLabel", (IModel)new ResourceModel("profile.publications"))});
        publicationsContainer.add(new Component[]{new Label("publications", ProfileUtils.processHtml((String)publications)).setEscapeModelStrings(false)});
        this.add(new Component[]{publicationsContainer});
        if (StringUtils.isBlank((String)publications)) {
            publicationsContainer.setVisible(false);
        } else {
            ++this.visibleFieldCount;
        }
        1 editButton = new /* Unavailable Anonymous Inner Class!! */;
        editButton.add(new Component[]{new Label("editButtonLabel", (IModel)new ResourceModel("button.edit"))});
        editButton.setOutputMarkupId(true);
        if (userProfile.isLocked() && !this.sakaiProxy.isSuperUser()) {
            editButton.setVisible(false);
        }
        this.add(new Component[]{editButton});
        Label noFieldsMessage = new Label("noFieldsMessage", (IModel)new ResourceModel("text.no.fields"));
        this.add(new Component[]{noFieldsMessage});
        if (this.visibleFieldCount > 0) {
            noFieldsMessage.setVisible(false);
        }
    }
}

