/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.pages.panels;

import java.io.Serializable;
import java.util.Date;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.markup.html.navigation.paging.AjaxPagingNavigator;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.sakaiproject.profile2.logic.ProfileConnectionsLogic;
import org.sakaiproject.profile2.logic.ProfilePrivacyLogic;
import org.sakaiproject.profile2.logic.ProfileWallLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.model.WallItem;
import org.sakaiproject.profile2.tool.components.ErrorLevelsFeedbackMessageFilter;
import org.sakaiproject.profile2.tool.dataproviders.WallItemDataProvider;
import org.sakaiproject.profile2.tool.pages.panels.ViewWallPanel;
import org.sakaiproject.profile2.types.PrivacyType;

public class ViewWallPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    @SpringBean(name="org.sakaiproject.profile2.logic.SakaiProxy")
    private SakaiProxy sakaiProxy;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileWallLogic")
    private ProfileWallLogic wallLogic;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfilePrivacyLogic")
    private ProfilePrivacyLogic privacyLogic;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileConnectionsLogic")
    private ProfileConnectionsLogic connectionsLogic;

    public ViewWallPanel(String panelId, String userUuid) {
        super(panelId);
        this.setOutputMarkupId(true);
        String currentUserId = this.sakaiProxy.getCurrentUserId();
        WebMarkupContainer wallItemsContainer = new WebMarkupContainer("wallItemsContainer");
        wallItemsContainer.setOutputMarkupId(true);
        this.add(new Component[]{wallItemsContainer});
        WallItem wallItem = new WallItem();
        wallItem.setUserUuid(userUuid);
        wallItem.setCreatorUuid(this.sakaiProxy.getCurrentUserId());
        wallItem.setType(2);
        Form form = new Form("viewWallPostForm", (IModel)new Model((Serializable)wallItem));
        form.setOutputMarkupId(true);
        this.add(new Component[]{form});
        if (!this.privacyLogic.isActionAllowed(userUuid, this.sakaiProxy.getCurrentUserId(), PrivacyType.PRIVACY_OPTION_MYWALL)) {
            form.setEnabled(false);
            form.setVisible(false);
        }
        Label formFeedback = new Label("formFeedback");
        formFeedback.setOutputMarkupPlaceholderTag(true);
        form.add(new Component[]{formFeedback});
        FeedbackPanel feedback = new FeedbackPanel("feedback");
        feedback.setOutputMarkupId(true);
        form.add(new Component[]{feedback});
        int[] filteredErrorLevels = new int[]{400};
        feedback.setFilter((IFeedbackMessageFilter)new ErrorLevelsFeedbackMessageFilter(filteredErrorLevels));
        WebMarkupContainer viewWallPostContainer = new WebMarkupContainer("viewWallPostContainer");
        TextArea myWallPost = new TextArea("viewWallPost", (IModel)new PropertyModel((Object)wallItem, "text"));
        viewWallPostContainer.add(new Component[]{myWallPost});
        form.add(new Component[]{viewWallPostContainer});
        1 submitButton = new /* Unavailable Anonymous Inner Class!! */;
        submitButton.setModel((IModel)new ResourceModel("button.wall.post"));
        viewWallPostContainer.add(new Component[]{submitButton});
        WallItemDataProvider provider = new WallItemDataProvider(userUuid);
        if (0L == provider.size()) {
            if (this.privacyLogic.isActionAllowed(userUuid, currentUserId, PrivacyType.PRIVACY_OPTION_MYWALL)) {
                this.add(new Component[]{new Label("wallInformationMessage", (IModel)new StringResourceModel("text.view.wall.nothing", null, new Object[]{this.sakaiProxy.getUserDisplayName(userUuid)})).setEscapeModelStrings(false)});
            } else {
                this.add(new Component[]{new Label("wallInformationMessage", (IModel)new StringResourceModel("text.view.wall.restricted", null, new Object[]{this.sakaiProxy.getUserDisplayName(userUuid)})).setEscapeModelStrings(false)});
            }
        } else {
            this.add(new Component[]{new Label("wallInformationMessage")});
        }
        2 wallItemsDataView = new /* Unavailable Anonymous Inner Class!! */;
        wallItemsDataView.setOutputMarkupId(true);
        if (provider.size() <= 10L) {
            wallItemsContainer.add(new Component[]{new AjaxPagingNavigator("navigator", (IPageable)wallItemsDataView).setVisible(false)});
        } else {
            wallItemsContainer.add(new Component[]{new AjaxPagingNavigator("navigator", (IPageable)wallItemsDataView)});
        }
        wallItemsDataView.setItemsPerPage(10L);
        wallItemsContainer.add(new Component[]{wallItemsDataView});
    }

    private boolean save(Form form, String userUuid) {
        WallItem wallItem = (WallItem)form.getModelObject();
        wallItem.setDate(new Date());
        return this.wallLogic.postWallItemToWall(userUuid, wallItem);
    }

    static /* synthetic */ boolean access$000(ViewWallPanel x0, Form x1, String x2) {
        return x0.save(x1, x2);
    }

    static /* synthetic */ SakaiProxy access$100(ViewWallPanel x0) {
        return x0.sakaiProxy;
    }

    static /* synthetic */ ProfilePrivacyLogic access$200(ViewWallPanel x0) {
        return x0.privacyLogic;
    }
}

