/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.dataproviders;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.injection.Injector;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.sakaiproject.profile2.logic.ProfileConnectionsLogic;
import org.sakaiproject.profile2.model.Person;
import org.sakaiproject.profile2.tool.models.DetachablePersonModel;

public class FriendsFeedDataProvider
implements IDataProvider<Person>,
Serializable {
    private static final long serialVersionUID = 1L;
    private String userUuid;
    private int subListSize = 0;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileConnectionsLogic")
    private ProfileConnectionsLogic connectionsLogic;

    public FriendsFeedDataProvider(String userUuid) {
        this.userUuid = userUuid;
        Injector.get().inject((Object)this);
        int count = this.connectionsLogic.getConnectionsForUserCount(userUuid);
        this.subListSize = 6;
        if (count < this.subListSize) {
            this.subListSize = count;
        }
    }

    public Iterator<Person> iterator(long first, long count) {
        int f = (int)first;
        int c = (int)count;
        try {
            List connections = this.connectionsLogic.getConnectionsForUser(this.userUuid).subList(f, f + c);
            Collections.shuffle(connections);
            List slice = connections.subList(f, f + c);
            return slice.iterator();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.EMPTY_LIST.iterator();
        }
    }

    public long size() {
        return this.subListSize;
    }

    public IModel<Person> model(Person object) {
        return new DetachablePersonModel(object);
    }

    public void detach() {
    }
}

