/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.dataproviders;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.injection.Injector;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.sakaiproject.profile2.logic.ProfileMessagingLogic;
import org.sakaiproject.profile2.model.MessageThread;
import org.sakaiproject.profile2.tool.models.DetachableMessageThreadModel;

public class MessageThreadsDataProvider
implements IDataProvider<MessageThread> {
    private static final long serialVersionUID = 1L;
    private final String userUuid;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileMessagingLogic")
    private ProfileMessagingLogic messagingLogic;

    public MessageThreadsDataProvider(String userUuid) {
        this.userUuid = userUuid;
        Injector.get().inject((Object)this);
    }

    public Iterator<MessageThread> iterator(long first, long count) {
        int f = (int)first;
        int c = (int)count;
        List slice = this.messagingLogic.getMessageThreads(this.userUuid).subList(f, f + c);
        Collections.sort(slice, Collections.reverseOrder());
        return slice.iterator();
    }

    public long size() {
        return this.messagingLogic.getMessageThreadsCount(this.userUuid);
    }

    public IModel<MessageThread> model(MessageThread object) {
        return new DetachableMessageThreadModel(object);
    }

    public void detach() {
    }
}

