/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.entityprovider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.authz.api.AuthzGroupService;
import org.sakaiproject.authz.api.GroupNotDefinedException;
import org.sakaiproject.authz.api.Member;
import org.sakaiproject.entitybroker.EntityView;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityCustomAction;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityURLRedirect;
import org.sakaiproject.entitybroker.entityprovider.capabilities.ActionsExecutable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.AutoRegisterEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Describeable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Outputable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Redirectable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Sampleable;
import org.sakaiproject.entitybroker.exception.EntityNotFoundException;
import org.sakaiproject.entitybroker.util.AbstractEntityProvider;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.profile2.logic.ProfileLogic;
import org.sakaiproject.profile2.model.Person;
import org.sakaiproject.profile2.tool.entityprovider.RosterEntityProvider;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;

public class RosterEntityProvider
extends AbstractEntityProvider
implements AutoRegisterEntityProvider,
ActionsExecutable,
Outputable,
Describeable,
Sampleable,
Redirectable {
    private static final Log log = LogFactory.getLog(RosterEntityProvider.class);
    private static final String OFFICIAL_IMAGES_PARAM = "officialImages";
    public static final String ENTITY_PREFIX = "roster";
    public static final String PROFILE_PREFIX = "profile";
    private AuthzGroupService authzGroupService;
    private SiteService siteService;
    private ProfileLogic profileLogic;

    public String getEntityPrefix() {
        return ENTITY_PREFIX;
    }

    public String[] getHandledOutputFormats() {
        return new String[]{"xml", "json"};
    }

    @EntityURLRedirect(value="/{prefix}/user/{id}")
    public String redirectUserAccount(Map<String, String> vars) {
        return "profile/" + vars.get("id") + vars.get("dot-extension");
    }

    public Object getSampleEntity() {
        return new RosterItem();
    }

    @EntityCustomAction(action="site", viewKey="list")
    public List<RosterItem> getRosterForSite(EntityView view, Map<String, Object> params) {
        Site site;
        String siteId = view.getPathSegment(2);
        if (StringUtils.isBlank((String)siteId)) {
            throw new IllegalArgumentException("siteId must be set in order to get the roster for a site, via the URL /roster/site/siteId");
        }
        try {
            site = this.siteService.getSiteVisit(siteId);
        }
        catch (IdUnusedException e) {
            throw new EntityNotFoundException("Invalid siteId: " + siteId, siteId);
        }
        catch (PermissionException e) {
            throw new EntityNotFoundException("No access to site: " + siteId, siteId);
        }
        String paramValue = (String)params.get(OFFICIAL_IMAGES_PARAM);
        boolean officialImage = Boolean.valueOf(paramValue);
        ArrayList<RosterItem> rosterList = new ArrayList<RosterItem>();
        try {
            Set members = this.authzGroupService.getAuthzGroup(site.getReference()).getMembers();
            for (Member member : members) {
                if (!member.isActive()) continue;
                Person person = this.profileLogic.getPerson(member.getUserId());
                RosterItem item = new RosterItem(person, officialImage);
                rosterList.add(item);
            }
        }
        catch (GroupNotDefinedException e) {
            log.error((Object)("getUsersInAllSections: " + e.getMessage()), (Throwable)e);
        }
        Collections.sort(rosterList);
        return rosterList;
    }

    @EntityCustomAction(action="group", viewKey="list")
    public List<RosterItem> getGroupForSite(EntityView view, Map<String, Object> params) {
        Site site;
        String siteId = view.getPathSegment(2);
        String groupId = view.getPathSegment(3);
        if (StringUtils.isBlank((String)siteId) || StringUtils.isBlank((String)groupId)) {
            throw new IllegalArgumentException("siteId and groupId must be set in order to get the roster, via the URL /roster/group/{siteId}/{groupId/groupName}");
        }
        try {
            site = this.siteService.getSiteVisit(siteId);
        }
        catch (IdUnusedException e) {
            throw new EntityNotFoundException("Invalid siteId: " + siteId, siteId);
        }
        catch (PermissionException e) {
            throw new EntityNotFoundException("No access to site: " + siteId, siteId);
        }
        String paramValue = (String)params.get(OFFICIAL_IMAGES_PARAM);
        boolean officialImage = Boolean.valueOf(paramValue);
        ArrayList<RosterItem> rosterList = new ArrayList<RosterItem>();
        Group group = site.getGroup(groupId);
        if (group == null) {
            Collection groups = site.getGroups();
            for (Group g : groups) {
                if (!groupId.equalsIgnoreCase(g.getTitle())) continue;
                group = g;
                break;
            }
            if (group == null) {
                log.warn((Object)("Group " + groupId + " not found"));
                return rosterList;
            }
        }
        Set members = group.getMembers();
        for (Member member : members) {
            if (!member.isActive()) continue;
            Person person = this.profileLogic.getPerson(member.getUserId());
            RosterItem item = new RosterItem(person, officialImage);
            rosterList.add(item);
        }
        Collections.sort(rosterList);
        return rosterList;
    }

    public void setAuthzGroupService(AuthzGroupService authzGroupService) {
        this.authzGroupService = authzGroupService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setProfileLogic(ProfileLogic profileLogic) {
        this.profileLogic = profileLogic;
    }
}

