/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.pages;

import org.apache.log4j.Logger;
import org.apache.wicket.Component;
import org.sakaiproject.profile2.exception.ProfileFriendsIllegalAccessException;
import org.sakaiproject.profile2.tool.pages.BasePage;
import org.sakaiproject.profile2.tool.pages.MyFriends;
import org.sakaiproject.profile2.tool.pages.panels.ConfirmedFriends;
import org.sakaiproject.profile2.types.PrivacyType;

public class ViewFriends
extends BasePage {
    private static final Logger log = Logger.getLogger(MyFriends.class);

    public ViewFriends(String userUuid) {
        boolean isFriendsListVisible;
        log.debug((Object)"ViewFriends()");
        String currentUserUuid = this.sakaiProxy.getCurrentUserId();
        if (!this.sakaiProxy.isSuperUser() && !(isFriendsListVisible = this.privacyLogic.isActionAllowed(userUuid, currentUserUuid, PrivacyType.PRIVACY_OPTION_MYFRIENDS))) {
            throw new ProfileFriendsIllegalAccessException("User: " + currentUserUuid + " is not allowed to view the friends list for: " + userUuid);
        }
        ConfirmedFriends confirmedFriends = new ConfirmedFriends("confirmedFriends", userUuid);
        confirmedFriends.setOutputMarkupId(true);
        this.add(new Component[]{confirmedFriends});
        this.sakaiProxy.postEvent("profile.friends.view.other", "/profile/" + userUuid, false);
    }
}

