/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.tool.pages.panels;

import java.io.Serializable;
import org.apache.log4j.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.sakaiproject.api.common.edu.person.SakaiPerson;
import org.sakaiproject.profile2.logic.ProfileLogic;
import org.sakaiproject.profile2.logic.ProfileWallLogic;
import org.sakaiproject.profile2.logic.SakaiProxy;
import org.sakaiproject.profile2.model.UserProfile;
import org.sakaiproject.profile2.tool.pages.panels.MyStudentEdit;

public class MyStudentEdit
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MyStudentEdit.class);
    @SpringBean(name="org.sakaiproject.profile2.logic.SakaiProxy")
    private SakaiProxy sakaiProxy;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileWallLogic")
    private ProfileWallLogic wallLogic;
    @SpringBean(name="org.sakaiproject.profile2.logic.ProfileLogic")
    private ProfileLogic profileLogic;

    public MyStudentEdit(String id, UserProfile userProfile) {
        super(id);
        this.add(new Component[]{new Label("heading", (IModel)new ResourceModel("heading.student.edit"))});
        Form form = new Form("form", (IModel)new Model((Serializable)userProfile));
        form.setOutputMarkupId(true);
        Label formFeedback = new Label("formFeedback");
        formFeedback.setOutputMarkupPlaceholderTag(true);
        form.add(new Component[]{formFeedback});
        Label editWarning = new Label("editWarning");
        editWarning.setVisible(false);
        if (this.sakaiProxy.isSuperUserAndProxiedToUser(userProfile.getUserUuid())) {
            editWarning.setDefaultModel((IModel)new StringResourceModel("text.edit.other.warning", null, new Object[]{userProfile.getDisplayName()}));
            editWarning.setEscapeModelStrings(false);
            editWarning.setVisible(true);
        }
        form.add(new Component[]{editWarning});
        WebMarkupContainer courseContainer = new WebMarkupContainer("courseContainer");
        courseContainer.add(new Component[]{new Label("courseLabel", (IModel)new ResourceModel("profile.course"))});
        TextField course = new TextField("course", (IModel)new PropertyModel((Object)userProfile, "course"));
        course.setMarkupId("courseinput");
        course.setOutputMarkupId(true);
        courseContainer.add(new Component[]{course});
        form.add(new Component[]{courseContainer});
        WebMarkupContainer subjectsContainer = new WebMarkupContainer("subjectsContainer");
        subjectsContainer.add(new Component[]{new Label("subjectsLabel", (IModel)new ResourceModel("profile.subjects"))});
        TextField subjects = new TextField("subjects", (IModel)new PropertyModel((Object)userProfile, "subjects"));
        subjects.setMarkupId("subjectsinput");
        subjects.setOutputMarkupId(true);
        subjectsContainer.add(new Component[]{subjects});
        form.add(new Component[]{subjectsContainer});
        1 submitButton = new /* Unavailable Anonymous Inner Class!! */;
        form.add(new Component[]{submitButton});
        2 cancelButton = new /* Unavailable Anonymous Inner Class!! */;
        cancelButton.setDefaultFormProcessing(false);
        form.add(new Component[]{cancelButton});
        this.add(new Component[]{form});
    }

    private boolean save(Form form) {
        UserProfile userProfile = (UserProfile)form.getModelObject();
        SakaiPerson sakaiPerson = this.sakaiProxy.getSakaiPerson(userProfile.getUserUuid());
        sakaiPerson.setEducationCourse(userProfile.getCourse());
        sakaiPerson.setEducationSubjects(userProfile.getSubjects());
        if (this.profileLogic.saveUserProfile(sakaiPerson)) {
            log.info((Object)("Saved SakaiPerson for: " + userProfile.getUserUuid()));
            return true;
        }
        log.info((Object)("Couldn't save SakaiPerson for: " + userProfile.getUserUuid()));
        return false;
    }

    static /* synthetic */ boolean access$000(MyStudentEdit x0, Form x1) {
        return x0.save(x1);
    }

    static /* synthetic */ SakaiProxy access$100(MyStudentEdit x0) {
        return x0.sakaiProxy;
    }

    static /* synthetic */ ProfileWallLogic access$200(MyStudentEdit x0) {
        return x0.wallLogic;
    }
}

