/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.profile2.util;

import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.log4j.Logger;
import org.imgscalr.Scalr;
import org.sakaiproject.profile2.util.Messages;
import org.sakaiproject.util.FormattedText;
import org.sakaiproject.util.ResourceLoader;

public class ProfileUtils {
    private static final Logger log = Logger.getLogger(ProfileUtils.class);

    public static boolean checkContentTypeForProfileImage(String contentType) {
        ArrayList<String> allowedTypes = new ArrayList<String>();
        allowedTypes.add("image/jpeg");
        allowedTypes.add("image/gif");
        allowedTypes.add("image/png");
        allowedTypes.add("image/x-png");
        allowedTypes.add("image/pjpeg");
        allowedTypes.add("image/jpg");
        return allowedTypes.contains(contentType);
    }

    public static String getInformalFormatForMimeType(String mimeType) {
        HashMap<String, String> formats = new HashMap<String, String>();
        formats.put("image/jpeg", "jpg");
        formats.put("image/gif", "gif");
        formats.put("image/png", "png");
        formats.put("image/x-png", "png");
        formats.put("image/pjpeg", "jpg");
        formats.put("image/jpg", "jpg");
        String format = (String)formats.get(mimeType);
        if (format != null) {
            return format;
        }
        return "jpg";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] scaleImage(byte[] imageData, int maxSize, String mimeType) {
        ByteArrayInputStream in = null;
        byte[] scaledImageBytes = null;
        try {
            in = new ByteArrayInputStream(imageData);
            BufferedImage originalImage = ImageIO.read(in);
            BufferedImage scaledImage = Scalr.resize((BufferedImage)originalImage, (int)maxSize, (BufferedImageOp[])new BufferedImageOp[0]);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)scaledImage, ProfileUtils.getInformalFormatForMimeType(mimeType), baos);
            baos.flush();
            scaledImageBytes = baos.toByteArray();
            baos.close();
        }
        catch (Exception e) {
            log.error((Object)"Scaling image failed.", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                    log.debug((Object)"Image stream closed.");
                }
                catch (IOException e) {
                    log.error((Object)"Error closing image stream: ", (Throwable)e);
                }
            }
        }
        return scaledImageBytes;
    }

    public static String convertDateToString(Date date, String format) {
        if (date == null || "".equals(format)) {
            throw new IllegalArgumentException("Null Argument in Profile.convertDateToString()");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        String dateStr = dateFormat.format(date);
        log.debug((Object)("Profile.convertDateToString(): Input date: " + date.toString()));
        log.debug((Object)("Profile.convertDateToString(): Converted date string: " + dateStr));
        return dateStr;
    }

    public static Date convertStringToDate(String dateStr, String format) {
        if ("".equals(dateStr) || "".equals(format)) {
            throw new IllegalArgumentException("Null Argument in Profile.convertStringToDate()");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        try {
            Date date = dateFormat.parse(dateStr);
            log.debug((Object)("Profile.convertStringToDate(): Input date string: " + dateStr));
            log.debug((Object)("Profile.convertStringToDate(): Converted date: " + date.toString()));
            return date;
        }
        catch (ParseException e) {
            log.error((Object)("Profile.convertStringToDate() failed. " + e.getClass() + ": " + e.getMessage()));
            return null;
        }
    }

    public static Date stripYear(Date date) {
        return DateUtils.setYears((Date)date, (int)1);
    }

    public static String getDayName(int day, Locale locale) {
        String[] dayNames = new DateFormatSymbols(locale).getWeekdays();
        String dayName = null;
        try {
            dayName = dayNames[day];
        }
        catch (Exception e) {
            log.error((Object)("Profile.getDayName() failed. " + e.getClass() + ": " + e.getMessage()));
        }
        return dayName;
    }

    public static String toProperCase(String input) {
        return WordUtils.capitalizeFully((String)input);
    }

    public static String convertDateForStatus(Date date) {
        Calendar currentCal = Calendar.getInstance();
        long currentTimeMillis = currentCal.getTimeInMillis();
        long postingTimeMillis = date.getTime();
        int diff = (int)(currentTimeMillis - postingTimeMillis);
        Locale locale = ProfileUtils.getUserPreferredLocale();
        int MILLIS_IN_SECOND = 1000;
        int MILLIS_IN_MINUTE = 60000;
        int MILLIS_IN_HOUR = 3600000;
        int MILLIS_IN_DAY = 86400000;
        int MILLIS_IN_WEEK = 604800000;
        if (diff < MILLIS_IN_SECOND) {
            return Messages.getString("Label.just_then");
        }
        if (diff < MILLIS_IN_MINUTE) {
            int numSeconds = diff / MILLIS_IN_SECOND;
            if (numSeconds == 1) {
                return Messages.getString("Label.second_ago", new Object[]{numSeconds});
            }
            return Messages.getString("Label.seconds_ago", new Object[]{numSeconds});
        }
        if (diff < MILLIS_IN_HOUR) {
            int numMinutes = diff / MILLIS_IN_MINUTE;
            if (numMinutes == 1) {
                return Messages.getString("Label.minute_ago", new Object[]{numMinutes});
            }
            return Messages.getString("Label.minutes_ago", new Object[]{numMinutes});
        }
        if (diff < MILLIS_IN_DAY) {
            int numHours = diff / MILLIS_IN_HOUR;
            if (numHours == 1) {
                return Messages.getString("Label.hour_ago", new Object[]{numHours});
            }
            return Messages.getString("Label.hours_ago", new Object[]{numHours});
        }
        if (diff < MILLIS_IN_WEEK) {
            int numDays = diff / MILLIS_IN_DAY;
            if (numDays == 1) {
                return Messages.getString("Label.yesterday");
            }
            Calendar postingCal = Calendar.getInstance();
            postingCal.setTimeInMillis(postingTimeMillis);
            int postingDay = postingCal.get(7);
            String dayName = ProfileUtils.getDayName(postingDay, locale);
            if (dayName != null) {
                return Messages.getString("Label.on", new Object[]{ProfileUtils.toProperCase(dayName)});
            }
        }
        return null;
    }

    public static Locale getUserPreferredLocale() {
        ResourceLoader rl = new ResourceLoader();
        return rl.getLocale();
    }

    public static String createEventRef(String ref) {
        return "/profile/" + ref;
    }

    public static Object getValueFromMapOrDefault(Map<?, ?> map, Object key, Object defaultValue) {
        return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    public static List<String> getListFromString(String str, char separator) {
        String[] items = StringUtils.split((String)str, (char)separator);
        return Arrays.asList(items);
    }

    public static String processHtml(String s) {
        return FormattedText.processFormattedText((String)s, (StringBuilder)new StringBuilder(), (boolean)true, (boolean)false);
    }

    public static String stripHtml(String s) {
        return FormattedText.convertFormattedTextToPlaintext((String)s);
    }

    public static String truncate(String s, int maxNumOfChars, boolean isHtml) {
        if (StringUtils.isBlank((String)s)) {
            return "";
        }
        if (isHtml) {
            StringBuilder trimmedHtml = new StringBuilder();
            FormattedText.trimFormattedText((String)s, (int)maxNumOfChars, (StringBuilder)trimmedHtml);
            return trimmedHtml.toString();
        }
        return StringUtils.substring((String)s, (int)0, (int)maxNumOfChars);
    }

    public static String truncateAndAbbreviate(String s, int maxNumOfChars, boolean isHtml) {
        if (StringUtils.isBlank((String)s)) {
            return "";
        }
        if (isHtml) {
            StringBuilder trimmedHtml = new StringBuilder();
            boolean trimmed = FormattedText.trimFormattedText((String)s, (int)(maxNumOfChars - 3), (StringBuilder)trimmedHtml);
            if (trimmed) {
                int index = trimmedHtml.lastIndexOf("</");
                if (-1 != index) {
                    trimmedHtml.insert(index, "...");
                } else {
                    trimmedHtml.append("...");
                }
            }
            return trimmedHtml.toString();
        }
        return StringUtils.abbreviate((String)s, (int)maxNumOfChars);
    }

    public static String generateUuid() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString();
    }

    public static String getSkypeMeURL(String skypeUsername) {
        return "skype:" + skypeUsername + "?call";
    }

    public static <T> void removeDuplicates(List<T> list) {
        HashSet<T> set = new HashSet<T>();
        set.addAll(list);
        list.clear();
        list.addAll(set);
    }

    public static <T> void removeDuplicatesWithOrder(List<T> list) {
        HashSet<T> set = new HashSet<T>();
        ArrayList<T> newList = new ArrayList<T>();
        for (T e : list) {
            if (!set.add(e)) continue;
            newList.add(e);
        }
        list.clear();
        list.addAll(newList);
    }

    public static String calculateMD5(String s) {
        return DigestUtils.md5Hex((String)s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] createAvatar(byte[] imageData, String mimeType) {
        ByteArrayInputStream in = null;
        byte[] outputBytes = null;
        try {
            in = new ByteArrayInputStream(imageData);
            BufferedImage originalImage = ImageIO.read(in);
            int smallestSide = originalImage.getWidth();
            if (originalImage.getHeight() < originalImage.getWidth()) {
                smallestSide = originalImage.getHeight();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("smallestSide:" + smallestSide));
            }
            int startX = originalImage.getWidth() / 2 - smallestSide / 2;
            int startY = originalImage.getHeight() / 2 - smallestSide / 2;
            if (log.isDebugEnabled()) {
                log.debug((Object)("originalImage.getWidth():" + originalImage.getWidth()));
                log.debug((Object)("originalImage.getHeight():" + originalImage.getHeight()));
                log.debug((Object)("startX:" + startX));
                log.debug((Object)("startY:" + startY));
            }
            BufferedImage croppedImage = Scalr.crop((BufferedImage)originalImage, (int)startX, (int)startY, (int)smallestSide, (int)smallestSide, (BufferedImageOp[])new BufferedImageOp[0]);
            BufferedImage scaledImage = Scalr.resize((BufferedImage)croppedImage, (int)80, (BufferedImageOp[])new BufferedImageOp[0]);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)scaledImage, ProfileUtils.getInformalFormatForMimeType(mimeType), baos);
            baos.flush();
            outputBytes = baos.toByteArray();
            baos.close();
        }
        catch (Exception e) {
            log.error((Object)"Cropping and scaling image failed.", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                    log.debug((Object)"Image stream closed.");
                }
                catch (IOException e) {
                    log.error((Object)"Error closing image stream: ", (Throwable)e);
                }
            }
        }
        return outputBytes;
    }
}

