/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.accountvalidator.logic.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.sakaiproject.accountvalidator.logic.ValidationException;
import org.sakaiproject.accountvalidator.logic.ValidationLogic;
import org.sakaiproject.accountvalidator.logic.dao.ValidationDao;
import org.sakaiproject.accountvalidator.model.ValidationAccount;
import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.api.AuthzGroupService;
import org.sakaiproject.authz.api.AuthzPermissionException;
import org.sakaiproject.authz.api.GroupNotDefinedException;
import org.sakaiproject.authz.api.GroupProvider;
import org.sakaiproject.authz.api.Member;
import org.sakaiproject.authz.api.SecurityAdvisor;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.emailtemplateservice.model.EmailTemplate;
import org.sakaiproject.emailtemplateservice.service.EmailTemplateService;
import org.sakaiproject.entitybroker.DeveloperHelperService;
import org.sakaiproject.entitybroker.EntityReference;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.genericdao.api.search.Restriction;
import org.sakaiproject.genericdao.api.search.Search;
import org.sakaiproject.id.api.IdManager;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.user.api.UserEdit;
import org.sakaiproject.user.api.UserLockedException;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.sakaiproject.user.api.UserPermissionException;

public class ValidationLogicImpl
implements ValidationLogic {
    private static final String TEMPLATE_KEY_EXISTINGUSER = "validate.existinguser";
    private static final String TEMPLATE_KEY_NEW_USER = "validate.newUser";
    private static final String TEMPLATE_KEY_LEGACYUSER = "validate.legacyuser";
    private static final String TEMPLATE_KEY_PASSWORDRESET = "validate.passwordreset";
    private static final int VALIDATION_PERIOD_MONTHS = -36;
    private static Log log = LogFactory.getLog(ValidationLogicImpl.class);
    private static final String ADMIN = "admin";
    private IdManager idManager;
    private ValidationDao dao;
    private EmailTemplateService emailTemplateService;
    private UserDirectoryService userDirectoryService;
    private AuthzGroupService authzGroupService;
    private SiteService siteService;
    private DeveloperHelperService developerHelperService;
    private ServerConfigurationService serverConfigurationService;
    private SecurityService securityService;
    private SessionManager sessionManager;
    private GroupProvider groupProvider;

    public void init() {
        log.info((Object)"init()");
        this.loadTemplate("validate_newUser.xml", TEMPLATE_KEY_NEW_USER);
        this.loadTemplate("validate_existingUser.xml", TEMPLATE_KEY_EXISTINGUSER);
        this.loadTemplate("validate_legacyUser.xml", TEMPLATE_KEY_LEGACYUSER);
        this.loadTemplate("validate_newPassword.xml", TEMPLATE_KEY_PASSWORDRESET);
        if (this.groupProvider == null) {
            this.groupProvider = (GroupProvider)ComponentManager.get((String)GroupProvider.class.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTemplate(String fileName, String templateKey) {
        Session sakaiSession = this.sessionManager.getCurrentSession();
        try {
            sakaiSession.setUserId(ADMIN);
            sakaiSession.setUserEid(ADMIN);
            InputStream in = ValidationLogicImpl.class.getClassLoader().getResourceAsStream(fileName);
            if (in == null) {
                log.warn((Object)("Could not load resource from '" + fileName + "'. Skipping ..."));
                return;
            }
            Document document = new SAXBuilder().build(in);
            List it = document.getRootElement().getChildren("emailTemplate");
            for (int i = 0; i < it.size(); ++i) {
                Element xmlTemplate = (Element)it.get(i);
                this.xmlToTemplate(xmlTemplate, templateKey);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        finally {
            sakaiSession.setUserId(null);
            sakaiSession.setUserEid(null);
        }
    }

    public void setIdManager(IdManager idm) {
        this.idManager = idm;
    }

    public void setDao(ValidationDao dao) {
        this.dao = dao;
    }

    public void setEmailTemplateService(EmailTemplateService emailTemplateService) {
        this.emailTemplateService = emailTemplateService;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    public void setAuthzGroupService(AuthzGroupService authzGroupService) {
        this.authzGroupService = authzGroupService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setDeveloperHelperService(DeveloperHelperService developerHelperService) {
        this.developerHelperService = developerHelperService;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void setGroupProvider(GroupProvider groupProvider) {
        this.groupProvider = groupProvider;
    }

    public ValidationAccount getVaLidationAcountById(Long id) {
        Search search = new Search();
        Restriction rest = new Restriction("id", (Object)id);
        search.addRestriction(rest);
        List l = this.dao.findBySearch(ValidationAccount.class, search);
        if (l.size() > 0) {
            return (ValidationAccount)l.get(0);
        }
        return null;
    }

    public ValidationAccount getVaLidationAcountBytoken(String token) {
        Search search = new Search();
        Restriction rest = new Restriction("validationToken", (Object)token);
        search.addRestriction(rest);
        List l = this.dao.findBySearch(ValidationAccount.class, search);
        if (l.size() > 0) {
            return (ValidationAccount)l.get(0);
        }
        return null;
    }

    public boolean isAccountValidated(String userId) {
        log.debug((Object)("validating" + userId));
        ValidationAccount va = this.getVaLidationAcountByUserId(userId);
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).add(2, -36);
        Date validationDeadline = cal.getTime();
        if (va == null) {
            log.debug((Object)"no account found!");
            return false;
        }
        if (ValidationAccount.STATUS_EXPIRED.equals(va.getStatus())) {
            return true;
        }
        if (va.getValidationReceived() == null && va.getValidationSent().after(validationDeadline)) {
            log.debug((Object)"validation sent still awaiting reply");
            return true;
        }
        if (va.getValidationReceived() == null && va.getValidationSent().before(validationDeadline)) {
            log.debug((Object)"validation sent but no reply received");
            return true;
        }
        log.debug((Object)("got an item of staus " + va.getStatus()));
        if (ValidationAccount.STATUS_CONFIRMED.equals(va.getStatus())) {
            log.info((Object)"account is validated");
            return true;
        }
        log.debug((Object)"no conditions met assuming account is not validated");
        return false;
    }

    public ValidationAccount getVaLidationAcountByUserId(String userId) {
        Search search = new Search();
        Restriction rest = new Restriction("userId", (Object)userId);
        search.addRestriction(rest);
        List l = this.dao.findBySearch(ValidationAccount.class, search);
        if (l.size() > 0) {
            return (ValidationAccount)l.get(0);
        }
        return null;
    }

    public List<ValidationAccount> getValidationAccountsByStatus(Integer status) {
        Search search = new Search();
        Restriction rest = new Restriction("status", (Object)status);
        search.addRestriction(rest);
        List l = this.dao.findBySearch(ValidationAccount.class, search);
        if (l.size() > 0) {
            return l;
        }
        return new ArrayList<ValidationAccount>();
    }

    public ValidationAccount createValidationAccount(String userRef) {
        return this.createValidationAccount(userRef, false);
    }

    public ValidationAccount createValidationAccount(String UserId, boolean newAccount) {
        Integer status = 2;
        if (newAccount) {
            status = 1;
        }
        return this.createValidationAccount(UserId, status);
    }

    public ValidationAccount createValidationAccount(String userRef, Integer accountStatus) {
        log.debug((Object)("createValidationAccount(" + userRef + ", " + accountStatus));
        ValidationAccount v = new ValidationAccount();
        v.setUserId(userRef);
        v.setValidationToken(this.idManager.createUuid());
        v.setValidationsSent(Integer.valueOf(1));
        if (accountStatus == null) {
            accountStatus = 1;
        } else {
            v.setAccountStatus(accountStatus);
        }
        ArrayList<String> userReferences = new ArrayList<String>();
        userReferences.add(userRef);
        HashMap<String, String> replacementValues = new HashMap<String, String>();
        replacementValues.put("validationToken", v.getValidationToken());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("tokenId", v.getValidationToken());
        String serverUrl = this.serverConfigurationService.getServerUrl();
        String url = serverUrl + "/accountvalidator/faces/validate?tokenId=" + v.getValidationToken();
        replacementValues.put("url", url);
        String userId = EntityReference.getIdFromRef((String)userRef);
        String userFirstName = "";
        String userLastName = "";
        String userDisplayName = "";
        String userEid = "";
        try {
            User u = this.userDirectoryService.getUser(userId);
            if (u.getFirstName() != null) {
                userFirstName = u.getFirstName();
            }
            if (u.getLastName() != null) {
                userLastName = u.getLastName();
            }
            userDisplayName = u.getDisplayName();
            userEid = u.getEid();
            User added = u.getCreatedBy();
            replacementValues.put("addedBy", added.getDisplayName());
            replacementValues.put("addedByEmail", added.getEmail());
        }
        catch (UserNotDefinedException e) {
            e.printStackTrace();
        }
        Set groups = this.authzGroupService.getAuthzGroupsIsAllowed(userId, "site.visit", null);
        log.info((Object)("got a list of: " + groups.size()));
        Iterator itg = groups.iterator();
        StringBuilder sb = new StringBuilder();
        int siteCount = 0;
        while (itg.hasNext()) {
            String groupRef = (String)itg.next();
            String siteId = this.developerHelperService.getLocationIdFromRef(groupRef);
            try {
                Site s = this.siteService.getSite(siteId);
                if (siteCount > 0) {
                    sb.append(", ");
                }
                log.info((Object)("adding site: " + s.getTitle()));
                sb.append(s.getTitle());
                ++siteCount;
            }
            catch (IdUnusedException e) {
                e.printStackTrace();
            }
        }
        replacementValues.put("memberSites", sb.toString());
        replacementValues.put("displayName", userDisplayName);
        replacementValues.put("userEid", userEid);
        replacementValues.put("support.email", this.serverConfigurationService.getString("support.email"));
        replacementValues.put("institution", this.serverConfigurationService.getString("ui.institution"));
        String templateKey = this.getTemplateKey(accountStatus);
        this.emailTemplateService.sendRenderedMessages(templateKey, userReferences, replacementValues, this.serverConfigurationService.getString("support.email"), this.serverConfigurationService.getString("support.email"));
        v.setValidationSent(new Date());
        v.setStatus(ValidationAccount.STATUS_SENT);
        v.setFirstName(userFirstName);
        v.setSurname(userLastName);
        this.dao.save(v);
        return v;
    }

    private String getTemplateKey(Integer accountStatus) {
        log.info((Object)("getTemplateKey( " + accountStatus));
        String templateKey = TEMPLATE_KEY_NEW_USER;
        if (2 == accountStatus) {
            templateKey = TEMPLATE_KEY_EXISTINGUSER;
        } else if (3 == accountStatus || 4 == accountStatus) {
            templateKey = TEMPLATE_KEY_LEGACYUSER;
        } else if (5 == accountStatus) {
            templateKey = TEMPLATE_KEY_PASSWORDRESET;
        }
        return templateKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeAccounts(String oldUserReference, String newUserReference) throws ValidationException {
        log.debug((Object)("merge account: " + oldUserReference + ", " + newUserReference + ")"));
        UserEdit olduser = null;
        try {
            String oldUserId = EntityReference.getIdFromRef((String)oldUserReference);
            String newuserId = EntityReference.getIdFromRef((String)newUserReference);
            SecurityAdvisor secAdvice = new SecurityAdvisor(){

                public SecurityAdvisor.SecurityAdvice isAllowed(String userId, String function, String reference) {
                    log.debug((Object)("isAllowed( " + userId + ", " + function + ", " + reference));
                    if ("user.upd.any".equals(function)) {
                        return SecurityAdvisor.SecurityAdvice.ALLOWED;
                    }
                    if ("realm.upd".equals(function)) {
                        return SecurityAdvisor.SecurityAdvice.ALLOWED;
                    }
                    if ("user.del".equals(function)) {
                        log.debug((Object)"advising user can delete users");
                        return SecurityAdvisor.SecurityAdvice.ALLOWED;
                    }
                    return SecurityAdvisor.SecurityAdvice.NOT_ALLOWED;
                }
            };
            this.securityService.pushAdvisor(secAdvice);
            log.debug((Object)("pushed security avisor: " + secAdvice));
            olduser = this.userDirectoryService.editUser(oldUserId);
            Set groups = this.authzGroupService.getAuthzGroupsIsAllowed(EntityReference.getIdFromRef((String)oldUserReference), "site.visit", null);
            Iterator it = groups.iterator();
            while (it.hasNext()) {
                AuthzGroup group = this.authzGroupService.getAuthzGroup((String)it.next());
                Member member = group.getMember(oldUserId);
                Member exisiting = group.getMember(newuserId);
                String preferedRole = member.getRole().getId();
                if (exisiting != null && this.groupProvider != null) {
                    preferedRole = this.groupProvider.preferredRole(preferedRole, exisiting.getRole().getId());
                }
                group.addMember(newuserId, preferedRole, true, false);
                group.removeMember(oldUserId);
                this.authzGroupService.save(group);
            }
            this.userDirectoryService.removeUser(olduser);
        }
        catch (UserNotDefinedException e) {
            e.printStackTrace();
        }
        catch (UserPermissionException e) {
            e.printStackTrace();
            if (olduser != null) {
                this.userDirectoryService.cancelEdit(olduser);
            }
        }
        catch (UserLockedException e) {
            e.printStackTrace();
        }
        catch (GroupNotDefinedException e) {
            e.printStackTrace();
        }
        catch (AuthzPermissionException e) {
            e.printStackTrace();
        }
        finally {
            SecurityAdvisor sa = this.securityService.popAdvisor();
            if (sa == null) {
                log.warn((Object)"Something cleared our advisor!");
            }
        }
    }

    public void deleteValidationAccount(ValidationAccount toDelete) {
        this.dao.delete(toDelete);
    }

    public void save(ValidationAccount toSave) {
        this.dao.save(toSave);
    }

    private void xmlToTemplate(Element xmlTemplate, String key) {
        String subject = xmlTemplate.getChildText("subject");
        String body = xmlTemplate.getChildText("message");
        String bodyHtml = xmlTemplate.getChildText("messagehtml");
        String locale = xmlTemplate.getChildText("locale");
        String versionString = xmlTemplate.getChildText("version");
        if (this.emailTemplateService.getEmailTemplate(key, new Locale(locale)) == null) {
            EmailTemplate template = new EmailTemplate();
            template.setSubject(subject);
            template.setMessage(body);
            if (bodyHtml != null) {
                String decodedHtml;
                try {
                    decodedHtml = URLDecoder.decode(bodyHtml, "utf8");
                }
                catch (UnsupportedEncodingException e) {
                    decodedHtml = bodyHtml;
                    e.printStackTrace();
                }
                template.setHtmlMessage(decodedHtml);
            }
            template.setLocale(locale);
            template.setKey(key);
            template.setVersion(Integer.valueOf(1));
            template.setOwner(ADMIN);
            template.setLastModified(new Date());
            this.emailTemplateService.saveTemplate(template);
            log.info((Object)(this + " user notification tempalte " + key + " added"));
        }
    }

    public void resendValidation(String token) {
        ValidationAccount account = this.getVaLidationAcountBytoken(token);
        if (account == null) {
            throw new IllegalArgumentException("no such account: " + token);
        }
        account.setValidationSent(new Date());
        account.setValidationsSent(Integer.valueOf(account.getValidationsSent() + 1));
        account.setStatus(ValidationAccount.STATUS_RESENT);
        this.save(account);
        ArrayList<String> userReferences = new ArrayList<String>();
        userReferences.add(this.userDirectoryService.userReference(account.getUserId()));
        HashMap<String, String> replacementValues = new HashMap<String, String>();
        replacementValues.put("validationToken", account.getValidationToken());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("tokenId", account.getValidationToken());
        String serverUrl = this.serverConfigurationService.getServerUrl();
        String url = serverUrl + "/accountvalidator/faces/validate?tokenId=" + account.getValidationToken();
        replacementValues.put("url", url);
        String userId = EntityReference.getIdFromRef((String)account.getUserId());
        String userDisplayName = "";
        String userEid = "";
        try {
            User u = this.userDirectoryService.getUser(userId);
            userDisplayName = u.getDisplayName();
            userEid = u.getEid();
            User added = u.getCreatedBy();
            replacementValues.put("addedBy", added.getDisplayName());
            replacementValues.put("addedByEmail", added.getEmail());
            replacementValues.put("displayName", userDisplayName);
            replacementValues.put("userEid", userEid);
            replacementValues.put("support.email", this.serverConfigurationService.getString("support.email"));
            replacementValues.put("institution", this.serverConfigurationService.getString("ui.institution"));
        }
        catch (UserNotDefinedException e) {
            e.printStackTrace();
        }
        Set groups = this.authzGroupService.getAuthzGroupsIsAllowed(userId, "site.visit", null);
        log.debug((Object)("got a list of: " + groups.size()));
        Iterator itg = groups.iterator();
        StringBuilder sb = new StringBuilder();
        int siteCount = 0;
        while (itg.hasNext()) {
            String groupRef = (String)itg.next();
            String siteId = this.developerHelperService.getLocationIdFromRef(groupRef);
            try {
                Site s = this.siteService.getSite(siteId);
                if (siteCount > 0) {
                    sb.append(", ");
                }
                log.debug((Object)("adding site: " + s.getTitle()));
                sb.append(s.getTitle());
                ++siteCount;
            }
            catch (IdUnusedException e) {
                e.printStackTrace();
            }
        }
        replacementValues.put("memberSites", sb.toString());
        String templateKey = this.getTemplateKey(account.getAccountStatus());
        this.emailTemplateService.sendRenderedMessages(templateKey, userReferences, replacementValues, this.serverConfigurationService.getString("support.email"), this.serverConfigurationService.getString("support.email"));
    }
}

