/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.accountvalidator.impl.jobs;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.sakaiproject.accountvalidator.logic.ValidationLogic;
import org.sakaiproject.accountvalidator.model.ValidationAccount;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserDirectoryService;

public class CheckAccountsJob
implements Job {
    private static Log log = LogFactory.getLog(CheckAccountsJob.class);
    private UserDirectoryService userDirectoryService;
    private ValidationLogic validationLogic;

    public void setUserDirectoryService(UserDirectoryService uds) {
        this.userDirectoryService = uds;
    }

    public void setValidationLogic(ValidationLogic vl) {
        this.validationLogic = vl;
    }

    public void execute(JobExecutionContext arg0) throws JobExecutionException {
        try {
            List users = this.userDirectoryService.getUsers();
            for (int i = 0; i < users.size(); ++i) {
                User u = (User)users.get(i);
                if (!"guest".equals(u.getType()) || this.validationLogic.isAccountValidated(u.getReference())) continue;
                log.info((Object)("found unvalidated account: " + u.getEid() + "(" + u.getId() + ")"));
                ValidationAccount va = this.validationLogic.createValidationAccount(u.getReference(), Integer.valueOf(3));
                log.info((Object)("sent validation token of " + va.getValidationToken()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

