/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.accountvalidator.impl.jobs;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.sakaiproject.accountvalidator.logic.ValidationLogic;
import org.sakaiproject.accountvalidator.model.ValidationAccount;
import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.api.AuthzGroupService;
import org.sakaiproject.authz.api.AuthzPermissionException;
import org.sakaiproject.authz.api.GroupNotDefinedException;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.emailtemplateservice.service.EmailTemplateService;
import org.sakaiproject.entitybroker.EntityReference;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.user.api.PreferencesService;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.user.api.UserEdit;
import org.sakaiproject.user.api.UserLockedException;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.sakaiproject.user.api.UserPermissionException;

public class CheckValidations
implements Job {
    private static Log log = LogFactory.getLog(CheckValidations.class);
    private ValidationLogic validationLogic;
    private UserDirectoryService userDirectoryService;
    private AuthzGroupService authzGroupService;
    private EmailTemplateService emailTemplateService;
    private ServerConfigurationService serverConfigurationService;
    public SiteService siteService;
    private SessionManager sessionManager;
    private PreferencesService preferencesService;
    private int maxDays = 90;

    public void setValidationLogic(ValidationLogic vl) {
        this.validationLogic = vl;
    }

    public void setUserDirectoryService(UserDirectoryService uds) {
        this.userDirectoryService = uds;
    }

    public void setAuthzGroupService(AuthzGroupService authzGroupService) {
        this.authzGroupService = authzGroupService;
    }

    public void setEmailTemplateService(EmailTemplateService emailTemplateService) {
        this.emailTemplateService = emailTemplateService;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void setPreferencesService(PreferencesService preferencesService) {
        this.preferencesService = preferencesService;
    }

    public void setMaxDays(int maxDays) {
        this.maxDays = maxDays;
    }

    public void execute(JobExecutionContext arg0) throws JobExecutionException {
        Session sakaiSession = this.sessionManager.getCurrentSession();
        sakaiSession.setUserId("admin");
        sakaiSession.setUserEid("admin");
        GregorianCalendar cal = new GregorianCalendar();
        String maxDaysLocalStr = this.serverConfigurationService.getString("accountValidator.maxDays", "" + this.maxDays);
        try {
            this.maxDays = Integer.parseInt(maxDaysLocalStr);
        }
        catch (Exception e) {
            // empty catch block
        }
        ((Calendar)cal).add(5, this.maxDays * -1);
        Date maxAge = cal.getTime();
        int maxAttempts = 10;
        String maxAttemptsStr = this.serverConfigurationService.getString("accountValidator.maxResendAttempts", "" + maxAttempts);
        try {
            maxAttempts = Integer.parseInt(maxAttemptsStr);
        }
        catch (Exception e) {
            // empty catch block
        }
        StringBuilder usedAccounts = new StringBuilder();
        ArrayList<String> oldAccounts = new ArrayList<String>();
        List list = this.validationLogic.getValidationAccountsByStatus(ValidationAccount.STATUS_SENT);
        List list2 = this.validationLogic.getValidationAccountsByStatus(ValidationAccount.STATUS_RESENT);
        if (list2 != null) {
            list.addAll(list2);
        }
        int loggedInAccounts = 0;
        int notLogedIn = 0;
        for (int i = 0; i < list.size(); ++i) {
            ValidationAccount account = (ValidationAccount)list.get(i);
            log.debug((Object)("account " + account.getUserId() + " created on  " + account.getValidationSent()));
            String userSiteId = this.siteService.getUserSiteId(account.getUserId());
            if (this.siteService.siteExists(userSiteId)) {
                log.info((Object)"looks like this user logged in!");
                ++loggedInAccounts;
                if (account.getValidationsSent() < maxAttempts && this.serverConfigurationService.getBoolean("accountValidator.resendValidations", true)) {
                    this.validationLogic.resendValidation(account.getValidationToken());
                } else if (account.getValidationSent().before(maxAge) || account.getValidationsSent() >= maxAttempts) {
                    account.setStatus(ValidationAccount.STATUS_EXPIRED);
                    cal = new GregorianCalendar();
                    account.setvalidationReceived(cal.getTime());
                    this.validationLogic.save(account);
                }
                usedAccounts.append(account.getUserId() + "\n");
                continue;
            }
            log.debug((Object)("realm: /site/~" + account.getUserId() + " does not seem to exist"));
            ++notLogedIn;
            if (!account.getValidationSent().before(maxAge)) continue;
            oldAccounts.add(account.getUserId());
        }
        log.info((Object)("users have logged in: " + loggedInAccounts + " not logged in: " + notLogedIn));
        log.info((Object)("we would delete: " + oldAccounts.size() + " accounts"));
        if (log.isDebugEnabled()) {
            log.debug((Object)("users:" + usedAccounts.toString()));
        }
        Map<String, List<String>> addedMap = this.buildAddedMap(oldAccounts);
        Set<Map.Entry<String, List<String>>> entrySet = addedMap.entrySet();
        for (Map.Entry<String, List<String>> entry : entrySet) {
            String creatorId = entry.getKey();
            try {
                User creator = this.userDirectoryService.getUser(creatorId);
                Locale locale = this.getUserLocale(creatorId);
                List<String> users = entry.getValue();
                StringBuilder userText = new StringBuilder();
                for (int i = 0; i < users.size(); ++i) {
                    try {
                        User u = this.userDirectoryService.getUser(users.get(i));
                        DateTime dt = new DateTime((Object)u.getCreatedDate());
                        DateTimeFormatter fmt = DateTimeFormat.longDate();
                        String str = fmt.withLocale(locale).print((ReadableInstant)dt);
                        userText.append(u.getEid() + " (" + str + ")\n");
                        this.removeCleaUpUser(u.getId());
                        continue;
                    }
                    catch (UserNotDefinedException e) {
                        ValidationAccount va = this.validationLogic.getVaLidationAcountByUserId(users.get(i));
                        this.validationLogic.deleteValidationAccount(va);
                    }
                }
                ArrayList<String> userReferences = new ArrayList<String>();
                userReferences.add(creator.getReference());
                HashMap<String, String> replacementValues = new HashMap<String, String>();
                replacementValues.put("userList", userText.toString());
                replacementValues.put("creatorName", creator.getDisplayName());
                replacementValues.put("deleteDays", Integer.valueOf(this.maxDays).toString());
                this.emailTemplateService.sendRenderedMessages("validation.deleted", userReferences, replacementValues, "help@vula.uct.ac.za", "Vula Help");
            }
            catch (UserNotDefinedException e) {
                e.printStackTrace();
            }
        }
    }

    private void removeCleaUpUser(String id) {
        try {
            Set groups = this.authzGroupService.getAuthzGroupsIsAllowed(EntityReference.getIdFromRef((String)id), "site.visit", null);
            Iterator it = groups.iterator();
            while (it.hasNext()) {
                AuthzGroup group = this.authzGroupService.getAuthzGroup((String)it.next());
                group.removeMember(id);
                this.authzGroupService.save(group);
            }
            UserEdit user = this.userDirectoryService.editUser(id);
            this.userDirectoryService.removeUser(user);
            ValidationAccount va = this.validationLogic.getVaLidationAcountByUserId(id);
            this.validationLogic.deleteValidationAccount(va);
        }
        catch (UserNotDefinedException e) {
            e.printStackTrace();
        }
        catch (UserPermissionException e) {
            e.printStackTrace();
        }
        catch (UserLockedException e) {
            e.printStackTrace();
        }
        catch (GroupNotDefinedException e) {
            e.printStackTrace();
        }
        catch (AuthzPermissionException e) {
            e.printStackTrace();
        }
    }

    private Map<String, List<String>> buildAddedMap(List<String> oldAccounts) {
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
        for (int i = 0; i < oldAccounts.size(); ++i) {
            try {
                List<String> l;
                User u = this.userDirectoryService.getUser(oldAccounts.get(i));
                String createdBy = u.getCreatedBy().getId();
                if (ret.containsKey(createdBy)) {
                    l = (List)ret.get(createdBy);
                    l.add(u.getId());
                    ret.put(createdBy, l);
                    continue;
                }
                l = new ArrayList();
                l.add(u.getId());
                ret.put(createdBy, l);
                continue;
            }
            catch (UserNotDefinedException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    protected Locale getUserLocale(String userId) {
        Locale loc = this.preferencesService.getLocale(userId);
        if (loc == null) {
            String lang = System.getProperty("user.language");
            String region = System.getProperty("user.region");
            if (region != null) {
                log.debug((Object)("getting system locale for: " + lang + "_" + region));
                loc = new Locale(lang, region);
            } else {
                log.debug((Object)("getting system locale for: " + lang));
                loc = new Locale(lang);
            }
        }
        return loc;
    }
}

