/**
 * $Id: PersistentTableName.java 10 2009-01-29 14:35:02Z azeckoski $
 * $URL: https://genericdao.googlecode.com/svn/tags/generic-dao-0.9.18/src/main/java/org/sakaiproject/genericdao/api/annotations/PersistentTableName.java $
 * PersistentTableName.java - genericdao - May 19, 2008 10:46:38 AM - azeckoski
 **************************************************************************
 * Copyright (c) 2008 Aaron Zeckoski
 * Licensed under the Apache License, Version 2.0
 * 
 * A copy of the Apache License has been included in this 
 * distribution and is available at: http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Aaron Zeckoski (azeckoski@gmail.com) (aaronz@vt.edu) (aaron@caret.cam.ac.uk)
 */

package org.sakaiproject.genericdao.api.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import javax.persistence.Table;


/**
 * Allows the persistent table name to be set to something specific rather than
 * defaulting to the autogenerated one based on the class name,
 * the value provided is the table name and should be less than 30 characters long<br/>
 * Example: MY_TABLE_NAME<br/>
 * Should be placed on the persistent class<br/>
 * Similar to the JPA {@link Table} annotation.
 * 
 * @author Aaron Zeckoski (azeckoski @ gmail.com)
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD, ElementType.FIELD})
public @interface PersistentTableName {
   String value();
}
