/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.chat2.tool;

import org.sakaiproject.chat2.model.ChatMessage;
import org.sakaiproject.chat2.tool.ChatTool;
import org.sakaiproject.time.api.Time;
import org.sakaiproject.time.cover.TimeService;
import org.sakaiproject.util.FormattedText;

public class DecoratedChatMessage {
    private ChatMessage chatMessage;
    private ChatTool chatTool;
    private Time messageTime;

    public DecoratedChatMessage(ChatTool chatTool, ChatMessage chatMessage) {
        this.chatTool = chatTool;
        this.chatMessage = chatMessage;
        if (chatMessage != null && chatMessage.getMessageDate() != null) {
            this.messageTime = TimeService.newTime((long)chatMessage.getMessageDate().getTime());
        }
    }

    public String getColor() {
        return this.chatTool.getColorMapper().getColor(this.chatMessage.getOwner());
    }

    public ChatMessage getChatMessage() {
        return this.chatMessage;
    }

    public String getDateTime() {
        return this.messageTime.toStringLocalFullZ();
    }

    public String getDate() {
        return this.messageTime.toStringLocalDate();
    }

    public String getTime() {
        return this.messageTime.toStringLocalTimeZ();
    }

    public String getId() {
        return this.messageTime.toString();
    }

    public String getRestrictedBody() {
        int actualLength;
        String message = FormattedText.convertFormattedTextToPlaintext((String)this.chatMessage.getBody());
        int maxLength = this.chatTool.lookupSynopticOptions().getChars();
        if (maxLength < (actualLength = message.length()) && maxLength >= 0) {
            message = message.substring(0, maxLength).concat("...");
        }
        return message;
    }

    public String getUnformattedBody() {
        return FormattedText.convertFormattedTextToPlaintext((String)this.chatMessage.getBody());
    }

    public boolean getCanRemoveMessage() {
        return this.chatTool.getCanRemoveMessage(this.chatMessage);
    }

    public String processActionDeleteMessage() {
        return this.chatTool.processActionDeleteMessageConfirm(this);
    }

    public String getOwner() {
        return this.chatTool.getMessageOwnerDisplayName(this.chatMessage);
    }

    public ChatTool getChatTool() {
        return this.chatTool;
    }
}

