/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.chat2.tool;

import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.sakaiproject.chat2.model.PresenceObserver;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.api.EventTrackingService;
import org.sakaiproject.presence.cover.PresenceService;
import org.sakaiproject.user.api.User;

public class PresenceObserverHelper
implements Observer {
    protected EventTrackingService m_eventTrackingService = null;
    private String m_resourcePattern;
    private String location;
    private PresenceObserver presenceObserver;

    public PresenceObserverHelper(PresenceObserver presenceObserver, String location) {
        this.presenceObserver = presenceObserver;
        this.location = location;
        this.m_resourcePattern = PresenceService.presenceReference((String)location);
        this.m_eventTrackingService = org.sakaiproject.event.cover.EventTrackingService.getInstance();
        this.m_eventTrackingService.addObserver((Observer)this);
    }

    protected void finalize() {
        this.m_eventTrackingService.deleteObserver((Observer)this);
    }

    public void endObservation() {
        this.m_eventTrackingService.deleteObserver((Observer)this);
    }

    public void updatePresence() {
        PresenceService.setPresence((String)this.location);
    }

    public void removePresence() {
        PresenceService.removePresence((String)this.location);
    }

    public List<User> getPresentUsers() {
        return PresenceService.getPresentUsers((String)this.location);
    }

    public String getLocation() {
        return this.location;
    }

    public boolean check(Object arg) {
        if (!(arg instanceof Event)) {
            return false;
        }
        Event event = (Event)arg;
        String key = event.getResource();
        String function = event.getEvent();
        if (!function.equals("pres.begin") && !function.equals("pres.end")) {
            return false;
        }
        return this.m_resourcePattern == null || key.equals(this.m_resourcePattern);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (!this.check(arg)) {
            return;
        }
        Event event = (Event)arg;
        if (event.getEvent().equals("pres.begin")) {
            this.presenceObserver.userJoined(this.location, "");
        } else {
            this.presenceObserver.userLeft(this.location, "");
        }
    }
}

