/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.chat2.tool;

import java.io.IOException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.faces.validator.ValidatorException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.chat2.model.ChatChannel;
import org.sakaiproject.chat2.model.ChatManager;
import org.sakaiproject.chat2.model.ChatMessage;
import org.sakaiproject.chat2.model.PresenceObserver;
import org.sakaiproject.chat2.model.RoomObserver;
import org.sakaiproject.chat2.tool.ChatDelivery;
import org.sakaiproject.chat2.tool.ColorMapper;
import org.sakaiproject.chat2.tool.DecoratedChatChannel;
import org.sakaiproject.chat2.tool.DecoratedChatMessage;
import org.sakaiproject.chat2.tool.DecoratedSynopticOptions;
import org.sakaiproject.chat2.tool.PresenceObserverHelper;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.courier.api.Delivery;
import org.sakaiproject.courier.cover.CourierService;
import org.sakaiproject.event.api.EventTrackingService;
import org.sakaiproject.event.api.UsageSession;
import org.sakaiproject.event.cover.UsageSessionService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.time.cover.TimeService;
import org.sakaiproject.tool.api.Placement;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.api.ToolManager;
import org.sakaiproject.tool.api.ToolSession;
import org.sakaiproject.tool.cover.SessionManager;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.sakaiproject.user.cover.UserDirectoryService;
import org.sakaiproject.util.DirectRefreshDelivery;
import org.sakaiproject.util.ResourceLoader;
import org.sakaiproject.util.Validator;
import org.sakaiproject.util.Web;

public class ChatTool
implements RoomObserver,
PresenceObserver {
    private static Log logger = LogFactory.getLog(ChatTool.class);
    private static final String IFRAME_ROOM_USERS = "Presence";
    private static final String PAGE_EDIT_A_ROOM = "editRoom";
    private static final String PAGE_LIST_ROOMS = "listRooms";
    private static final String PAGE_ENTER_ROOM = "room";
    private static final String PAGE_EDIT_ROOM = "editRoom";
    private static final String PAGE_DELETE_ROOM_CONFIRM = "deleteRoomConfirm";
    private static final String PAGE_DELETE_ROOM_MESSAGES_CONFIRM = "deleteRoomMessagesConfirm";
    private static final String PAGE_DELETE_MESSAGE_CONFIRM = "deleteMessageConfirm";
    private static final String PAGE_SYNOPTIC = "synoptic";
    private static final String PAGE_SYNOPTIC_OPTIONS = "synopticOptions";
    private static final String PERMISSION_ERROR = "perm_error";
    private static final String PRESENCE_PREPEND = "chat_room_";
    private static final String CHAT_CONTEXT_PRESENCE_PREFIX = "chat_site_";
    private static final int MESSAGEOPTIONS_NULL = -99;
    private static final int MESSAGEOPTIONS_ALL_MESSAGES = -1;
    private static final int MESSAGEOPTIONS_MESSAGES_BY_DATE = 0;
    private static final int MESSAGEOPTIONS_MESSAGES_BY_NUMBER = 1;
    private static final int MESSAGEOPTIONS_NO_MESSAGES = 2;
    private static final int DATETIME_DISPLAY_NONE = 0;
    private static final int DATETIME_DISPLAY_TIME = 1;
    private static final int DATETIME_DISPLAY_DATE = 2;
    private static final int DATETIME_DISPLAY_DATETIME = 3;
    private static final int DATETIME_DISPLAY_ID = 4;
    private static final String PARAM_CHANNEL = "channel";
    private static final String PARAM_DAYS = "days";
    private static final String PARAM_ITEMS = "items";
    private static final String PARAM_LENGTH = "length";
    private static final int DEFAULT_DAYS = 10;
    private static final int DEFAULT_ITEMS = 3;
    private static final int DEFAULT_LENGTH = 50;
    private ChatManager chatManager;
    private ToolManager toolManager;
    protected org.sakaiproject.courier.api.CourierService m_courierService = null;
    private DecoratedChatChannel currentChannel = null;
    private DecoratedChatChannel currentChannelEdit = null;
    private DecoratedChatMessage currentMessage = null;
    private DecoratedSynopticOptions currentSynopticOptions = null;
    private String newMessageText = "";
    private int viewOptions = 3;
    private int messageOptions = -99;
    private String sessionId = "";
    private String placementId = "";
    private ColorMapper colorMapper = new ColorMapper();
    private Site worksite = null;
    private String toolContext = null;
    private Map<String, PresenceObserverHelper> presenceChannelObservers = new ConcurrentHashMap();
    private Map<String, DecoratedChatChannel> channels = new ConcurrentHashMap();
    private static Map<String, ChatTool> tools = new ConcurrentHashMap();
    private ResourceLoader toolBundle;

    protected void setupTool() {
        this.m_courierService = CourierService.getInstance();
        Session session = SessionManager.getCurrentSession();
        this.sessionId = session.getId();
        Placement placement = this.getToolManager().getCurrentPlacement();
        this.placementId = placement.getId();
        this.getSiteChannels();
        ChatChannel defaultChannel = this.getChatManager().getDefaultChannel(placement.getContext(), placement.getId());
        this.setCurrentChannel(new DecoratedChatChannel(this, defaultChannel));
    }

    public String getEnterTool() {
        this.setupTool();
        String url = PAGE_ENTER_ROOM;
        if (this.currentChannel == null) {
            url = PAGE_LIST_ROOMS;
        }
        ExternalContext context = FacesContext.getCurrentInstance().getExternalContext();
        HttpServletRequest req = (HttpServletRequest)context.getRequest();
        req.setAttribute("sakai.request.native.url", null);
        this.setToolContext(req.getContextPath());
        req.setAttribute("sakai.request.native.url", (Object)"sakai.request.native.url");
        try {
            context.redirect(url);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to redirect to " + url, e);
        }
        return "";
    }

    public List<String> getUsersInCurrentChannel() {
        ExternalContext context = FacesContext.getCurrentInstance().getExternalContext();
        HttpServletRequest req = (HttpServletRequest)context.getRequest();
        String channelId = req.getParameter(PARAM_CHANNEL);
        if (channelId == null) {
            channelId = this.getCurrentChatChannelId();
        }
        ArrayList<String> userList = new ArrayList<String>();
        if (channelId == null) {
            return userList;
        }
        PresenceObserverHelper observer = (PresenceObserverHelper)this.presenceChannelObservers.get(channelId);
        if (observer == null) {
            return userList;
        }
        observer.updatePresence();
        List users = observer.getPresentUsers();
        if (users == null) {
            return userList;
        }
        String asName = null;
        String myUserId = null;
        try {
            String sessionUserId;
            UsageSession usageSession = UsageSessionService.getSession();
            if (usageSession != null && !(myUserId = usageSession.getUserId()).equals(sessionUserId = SessionManager.getCurrentSessionUserId())) {
                asName = UserDirectoryService.getUser((String)sessionUserId).getDisplayName();
            }
        }
        catch (Throwable usageSession) {
            // empty catch block
        }
        for (User u : users) {
            String displayName = u.getDisplayName();
            if (asName != null && u.getId().equals(myUserId)) {
                displayName = displayName + " (" + asName + ")";
            }
            userList.add(Web.escapeHtml((String)displayName));
        }
        return userList;
    }

    public void receivedMessage(String roomId, Object message) {
        DecoratedChatChannel channel = (DecoratedChatChannel)this.channels.get(roomId);
        if (channel != null) {
            String address = this.sessionId + roomId;
            if (SessionManager.getSession((String)this.sessionId) == null) {
                logger.debug((Object)("received msg expired session " + this.sessionId + " " + this.currentChannel));
                this.resetCurrentChannel(channel);
                this.m_courierService.clear(address);
            } else {
                this.m_courierService.deliver((Delivery)new ChatDelivery(address, "Monitor", message, this.placementId, false, this.getChatManager()));
            }
        }
    }

    public void roomDeleted(String roomId) {
        DecoratedChatChannel channel = (DecoratedChatChannel)this.channels.get(roomId);
        if (channel != null) {
            this.resetCurrentChannel(channel);
            this.m_courierService.clear(this.sessionId + roomId);
        }
    }

    public void userJoined(String location, String user) {
        this.m_courierService.deliver((Delivery)new DirectRefreshDelivery(this.sessionId + location, IFRAME_ROOM_USERS));
    }

    public void userLeft(String location, String user) {
        DecoratedChatChannel channel = (DecoratedChatChannel)this.channels.get(location);
        if (channel != null && SessionManager.getSession((String)this.sessionId) == null) {
            this.resetCurrentChannel(channel);
            this.m_courierService.clear(this.sessionId + location);
        } else {
            this.m_courierService.deliver((Delivery)new DirectRefreshDelivery(this.sessionId + location, IFRAME_ROOM_USERS));
        }
    }

    private void clearToolVars() {
    }

    protected boolean validateChannel(ChatChannel channel) {
        boolean validates = true;
        if (channel.getTitle() == null || channel.getTitle().length() == 0) {
            this.setErrorMessage("editRoomForm:title", "title_required", (Object[])new String[0]);
            validates = false;
        }
        if (channel.getTitle() != null && channel.getTitle().length() > 64) {
            this.setErrorMessage("editRoomForm:title", "title_too_long", (Object[])new String[]{Integer.toString(64)});
            validates = false;
        }
        if (channel.getDescription() != null && channel.getDescription().length() > 255) {
            this.setErrorMessage("editRoomForm:desc", "desc_too_long", (Object[])new String[]{Integer.toString(255)});
            validates = false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("chat start (" + channel.getStartDate() + ") and end (" + channel.getEndDate() + ") dates"));
        }
        if (channel.getStartDate() != null && channel.getEndDate() != null && channel.getStartDate().after(channel.getEndDate())) {
            this.setErrorMessage("editRoomForm:startDate", "custom_date_error_order", new Object[]{channel.getStartDate(), channel.getEndDate()});
            validates = false;
        }
        if (!validates) {
            this.setErrorMessage("validation_error", (Object[])new String[0]);
        }
        return validates;
    }

    public String processActionCancelChangeChannel() {
        this.clearToolVars();
        return PAGE_ENTER_ROOM;
    }

    public String processActionSetAsDefaultRoom(DecoratedChatChannel decoChannel) {
        ChatChannel channel = decoChannel.getChatChannel();
        channel.setPlacementDefaultChannel(true);
        this.getChatManager().makeDefaultContextChannel(channel, this.getToolManager().getCurrentPlacement().getId());
        return PAGE_LIST_ROOMS;
    }

    public String processActionAddRoom() {
        try {
            ChatChannel newChannel = this.getChatManager().createNewChannel(this.getContext(), "", false, true, this.getToolManager().getCurrentPlacement().getId());
            this.currentChannelEdit = new DecoratedChatChannel(this, newChannel, true);
            if (this.currentChannelEdit.getChatChannel().getFilterType().equals("SelectAllMessages") || this.currentChannelEdit.getChatChannel().getFilterType().equals("SelectMessagesByNumber") || this.currentChannelEdit.getChatChannel().getFilterType().equals("SelectMessagesByTime") || this.currentChannelEdit.getChatChannel().getFilterType().equals("SelectNoneMessages")) {
                this.currentChannelEdit.setFilterParamLast(this.currentChannelEdit.getChatChannel().getNumberParam());
                this.currentChannelEdit.setFilterParamPast(this.currentChannelEdit.getChatChannel().getTimeParam());
                this.currentChannelEdit.setFilterParamNone(0);
            }
            return "editRoom";
        }
        catch (PermissionException e) {
            this.setErrorMessage(PERMISSION_ERROR, (Object[])new String[]{"chat.new.channel"});
            return "";
        }
    }

    public String processActionPermissions() {
        ExternalContext context = FacesContext.getCurrentInstance().getExternalContext();
        ToolSession toolSession = SessionManager.getCurrentToolSession();
        try {
            String url = "sakai.permissions.helper.helper/tool?session.sakaiproject.permissions.description=" + Web.escapeUrl((String)this.getPermissionsMessage()) + "&session." + "sakaiproject.permissions.targetRef" + "=" + this.getWorksite().getReference() + "&session." + "sakaiproject.permissions.prefix" + "=" + this.getChatFunctionPrefix();
            if (toolSession != null) {
                ResourceLoader pRb = new ResourceLoader("permissions");
                HashMap pRbValues = new HashMap();
                for (Map.Entry entry : pRb.entrySet()) {
                    pRbValues.put(entry.getKey(), entry.getValue());
                }
                toolSession.setAttribute("permissionDescriptions", pRbValues);
            }
            context.redirect(url);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to redirect to helper", e);
        }
        return null;
    }

    public String processActionSynopticOptions() {
        DecoratedSynopticOptions dso = this.lookupSynopticOptions();
        this.setCurrentSynopticOptions(dso);
        return PAGE_SYNOPTIC_OPTIONS;
    }

    public String processActionSynopticOptionsSave() {
        DecoratedSynopticOptions dso = this.getCurrentSynopticOptions();
        Placement placement = this.getToolManager().getCurrentPlacement();
        if (placement != null) {
            placement.getPlacementConfig().setProperty(PARAM_DAYS, Integer.toString(dso.getDays()));
            placement.getPlacementConfig().setProperty(PARAM_ITEMS, Integer.toString(dso.getItems()));
            placement.getPlacementConfig().setProperty(PARAM_LENGTH, Integer.toString(dso.getChars()));
            placement.save();
        }
        this.setCurrentSynopticOptions(null);
        return PAGE_SYNOPTIC;
    }

    public String processActionSynopticOptionsCancel() {
        this.setCurrentSynopticOptions(null);
        return PAGE_SYNOPTIC;
    }

    public String processActionBackToRoom() {
        String filter;
        DecoratedChatChannel dChannel = this.getCurrentChannel();
        String string = filter = dChannel != null ? dChannel.getChatChannel().getFilterType() : "";
        if (filter.equals("SelectAllMessages")) {
            this.setMessageOptions(Integer.toString(-1));
        } else if (filter.equals("SelectMessagesByNumber")) {
            this.setMessageOptions(Integer.toString(1));
        } else if (filter.equals("SelectMessagesByTime")) {
            this.setMessageOptions(Integer.toString(0));
        } else if (filter.equals("SelectNoneMessages")) {
            this.setMessageOptions(Integer.toString(2));
        }
        return PAGE_ENTER_ROOM;
    }

    public String getChatFunctionPrefix() {
        return "chat.";
    }

    public String getPermissionsMessage() {
        return this.getMessageFromBundle("perm_description", new Object[]{this.getToolManager().getCurrentTool().getTitle(), this.getWorksite().getTitle()});
    }

    public String getDatesMessage() {
        String msg = null;
        if (this.currentChannel != null) {
            DateFormat df = DateFormat.getDateInstance(2);
            if (this.currentChannel.getStartDate() != null && this.currentChannel.getEndDate() != null) {
                msg = this.getMessageFromBundle("custom_date_display", new Object[]{TimeService.newTime((long)this.currentChannel.getStartDate().getTime()).toStringLocalDate(), TimeService.newTime((long)this.currentChannel.getEndDate().getTime()).toStringLocalDate()});
            } else if (this.currentChannel.getStartDate() != null) {
                msg = this.getMessageFromBundle("custom_date_display_start", new Object[]{TimeService.newTime((long)this.currentChannel.getStartDate().getTime()).toStringLocalDate(), ""});
            } else if (this.currentChannel.getEndDate() != null) {
                msg = this.getMessageFromBundle("custom_date_display_end", new Object[]{"", TimeService.newTime((long)this.currentChannel.getEndDate().getTime()).toStringLocalDate()});
            }
        }
        return msg;
    }

    public boolean isDatesRestricted() {
        boolean restricted = false;
        if (this.currentChannel != null) {
            Date end;
            Date today = new Date();
            Date start = this.currentChannel.getStartDate();
            if (start == null) {
                start = today;
            }
            if ((end = this.currentChannel.getEndDate()) == null) {
                end = today;
            }
            if (today.before(start) || today.after(end)) {
                restricted = true;
            }
        }
        return restricted;
    }

    public Site getWorksite() {
        if (this.worksite == null) {
            try {
                this.worksite = SiteService.getSite((String)this.getToolManager().getCurrentPlacement().getContext());
            }
            catch (IdUnusedException e) {
                throw new RuntimeException(e);
            }
        }
        return this.worksite;
    }

    protected String processActionEnterRoom(DecoratedChatChannel chatChannel) {
        this.setCurrentChannel(chatChannel);
        this.setMessageOptions(Integer.toString(-99));
        return PAGE_ENTER_ROOM;
    }

    public String processActionListRooms() {
        return PAGE_LIST_ROOMS;
    }

    protected String processActionEditRoom(DecoratedChatChannel chatChannel) {
        chatChannel.setFilterParamNone(0);
        chatChannel.setFilterParamLast(chatChannel.getChatChannel().getNumberParam());
        chatChannel.setFilterParamPast(chatChannel.getChatChannel().getTimeParam());
        this.setCurrentChannelEdit(chatChannel);
        return "editRoom";
    }

    public String processActionEditRoomSave() {
        DecoratedChatChannel dChannel = this.getCurrentChannelEdit();
        if (dChannel != null) {
            ChatChannel channel = dChannel.getChatChannel();
            boolean directEdit = dChannel.isDirectEdit();
            channel.setNumberParam(dChannel.getFilterParamLast());
            channel.setTimeParam(dChannel.getFilterParamPast());
            if (channel.getFilterType().equals("SelectMessagesByNumber")) {
                int pLast = dChannel.getFilterParamLast();
                if (pLast > 9999) {
                    pLast = 9999;
                } else if (pLast <= 0) {
                    pLast = 10;
                }
                channel.setFilterParam(pLast);
            } else if (channel.getFilterType().equals("SelectMessagesByTime")) {
                int pPast = dChannel.getFilterParamPast();
                if (pPast > 999) {
                    pPast = 999;
                } else if (pPast <= 0) {
                    pPast = 1;
                }
                channel.setFilterParam(pPast);
            } else if (channel.getFilterType().equals("SelectNoneMessages")) {
                channel.setFilterParam(0);
            }
            String retView = PAGE_LIST_ROOMS;
            retView = directEdit ? PAGE_ENTER_ROOM : PAGE_LIST_ROOMS;
            channel.setStartDate(dChannel.getStartDate());
            channel.setEndDate(dChannel.getEndDate());
            if (this.validateChannel(channel)) {
                try {
                    this.getChatManager().updateChannel(channel, true);
                    if (dChannel != null && dChannel.getChatChannel().getId().equals(channel.getId())) {
                        this.setCurrentChannel(new DecoratedChatChannel(this, channel));
                    }
                    this.setCurrentChannelEdit(null);
                }
                catch (PermissionException e) {
                    this.setErrorMessage(PERMISSION_ERROR, (Object[])new String[]{"chat.revise.channel"});
                    return "";
                }
            } else {
                retView = "";
            }
            return retView;
        }
        return "";
    }

    public String processActionEditRoomCancel() {
        DecoratedChatChannel dChannel = this.getCurrentChannelEdit();
        boolean directEdit = dChannel != null ? dChannel.isDirectEdit() : false;
        this.setCurrentChannelEdit(null);
        if (directEdit) {
            return PAGE_ENTER_ROOM;
        }
        return PAGE_LIST_ROOMS;
    }

    protected String processActionDeleteRoomConfirm(DecoratedChatChannel chatChannel) {
        this.setCurrentChannelEdit(chatChannel);
        return PAGE_DELETE_ROOM_CONFIRM;
    }

    public String processActionDeleteRoom() {
        try {
            this.getChatManager().deleteChannel(this.currentChannelEdit.getChatChannel());
            this.setCurrentChannelEdit(null);
            return PAGE_LIST_ROOMS;
        }
        catch (PermissionException e) {
            this.setErrorMessage(PERMISSION_ERROR, (Object[])new String[]{"chat.delete.channel"});
            return "";
        }
    }

    public String processActionDeleteRoomCancel() {
        this.setCurrentChannelEdit(null);
        return PAGE_LIST_ROOMS;
    }

    protected String processActionDeleteRoomMessagesConfirm(DecoratedChatChannel chatChannel) {
        this.setCurrentChannelEdit(chatChannel);
        return PAGE_DELETE_ROOM_MESSAGES_CONFIRM;
    }

    public String processActionDeleteRoomMessages() {
        try {
            this.getChatManager().deleteChannelMessages(this.currentChannelEdit.getChatChannel());
            this.setCurrentChannelEdit(null);
            return PAGE_LIST_ROOMS;
        }
        catch (PermissionException e) {
            this.setErrorMessage(PERMISSION_ERROR, (Object[])new String[]{"chat.delete.any"});
            return "";
        }
    }

    public String processActionDeleteRoomMessagesCancel() {
        this.setCurrentChannelEdit(null);
        return PAGE_LIST_ROOMS;
    }

    public String processActionDeleteMessage() {
        try {
            DecoratedChatMessage msg = this.getCurrentMessage();
            if (msg != null) {
                this.getChatManager().deleteMessage(msg.getChatMessage());
            }
            return PAGE_ENTER_ROOM;
        }
        catch (PermissionException e) {
            this.setErrorMessage(PERMISSION_ERROR, (Object[])new String[]{"chat.delete."});
            return "";
        }
    }

    protected String processActionDeleteMessageConfirm(DecoratedChatMessage message) {
        this.setCurrentMessage(message);
        return PAGE_DELETE_MESSAGE_CONFIRM;
    }

    public String processActionDeleteMessageCancel() {
        this.setCurrentMessage(null);
        return PAGE_ENTER_ROOM;
    }

    public String getCourierString() {
        StringBuilder courierString = new StringBuilder("/courier/");
        courierString.append(this.getCurrentChatChannelId());
        courierString.append("/");
        courierString.append(CHAT_CONTEXT_PRESENCE_PREFIX);
        courierString.append(this.getContext());
        courierString.append("?userId=");
        courierString.append(SessionManager.getCurrentSessionUserId());
        return courierString.toString();
    }

    public boolean getCanManageTool() {
        boolean any = this.getCanCreateChannel() || this.getCanEditChannel(null) || this.getCanRemoveChannel(null);
        return any;
    }

    public String getCurrentChatChannelId() {
        if (this.currentChannel == null) {
            return "";
        }
        return this.currentChannel.getChatChannel().getId();
    }

    public void setCurrentChatChannelId(String channelId) {
        ChatChannel newChannel = this.getChatManager().getChatChannel(channelId);
        if (newChannel != null) {
            this.setCurrentChannel(new DecoratedChatChannel(this, newChannel));
        }
    }

    public DecoratedChatChannel getCurrentChannel() {
        if (this.currentChannel == null) {
            this.setupTool();
        }
        return this.currentChannel;
    }

    public void setCurrentChannel(DecoratedChatChannel channel) {
        if (this.currentChannel != null && channel != null && this.currentChannel.getChatChannel().getId().equals(channel.getChatChannel().getId())) {
            return;
        }
        String channelId = null;
        if (channel != null) {
            ChatTool tool;
            channelId = channel.getChatChannel().getId();
            String address = this.sessionId + channelId;
            DecoratedChatChannel oldChannel = (DecoratedChatChannel)this.channels.get(channelId);
            if (oldChannel != null) {
                this.resetCurrentChannel(oldChannel);
            }
            if ((tool = (ChatTool)tools.remove(address)) != null) {
                tool.resetCurrentChannel(channel);
            }
        }
        this.currentChannel = channel;
        if (channel != null) {
            PresenceObserverHelper helper = new PresenceObserverHelper((PresenceObserver)this, channelId);
            this.presenceChannelObservers.put(channelId, helper);
            tools.put(this.sessionId + channelId, this);
            this.getChatManager().addRoomListener((RoomObserver)this, channelId);
            this.channels.put(channelId, channel);
            helper.updatePresence();
        }
    }

    protected void resetCurrentChannel(DecoratedChatChannel oldChannel) {
        String channelId = oldChannel.getChatChannel().getId();
        String address = this.sessionId + channelId;
        PresenceObserverHelper observer = (PresenceObserverHelper)this.presenceChannelObservers.get(channelId);
        if (observer != null) {
            observer.endObservation();
            observer.removePresence();
            this.getChatManager().removeRoomListener((RoomObserver)this, channelId);
        }
        this.m_courierService.clear(address);
        this.presenceChannelObservers.remove(channelId);
        this.channels.remove(channelId);
        tools.remove(address);
        this.currentChannel = null;
    }

    public DecoratedChatChannel getCurrentChannelEdit() {
        return this.currentChannelEdit;
    }

    public void setCurrentChannelEdit(DecoratedChatChannel currentChannelEdit) {
        this.currentChannelEdit = currentChannelEdit;
    }

    public DecoratedChatMessage getCurrentMessage() {
        String messageId;
        DecoratedChatMessage tmpCurrent = null;
        if (this.currentMessage == null && (messageId = (String)SessionManager.getCurrentToolSession().getAttribute("current_message")) != null) {
            ChatMessage message = this.getChatManager().getMessage(messageId);
            if (message == null) {
                return null;
            }
            tmpCurrent = new DecoratedChatMessage(this, message);
            return tmpCurrent;
        }
        return this.currentMessage;
    }

    public void setCurrentMessage(DecoratedChatMessage currentMessage) {
        this.currentMessage = currentMessage;
    }

    public DecoratedSynopticOptions lookupSynopticOptions() {
        DecoratedSynopticOptions dso = new DecoratedSynopticOptions();
        Placement placement = this.getToolManager().getCurrentPlacement();
        try {
            dso.setDays(Integer.parseInt(placement.getPlacementConfig().getProperty(PARAM_DAYS)));
        }
        catch (NumberFormatException e) {
            dso.setDays(10);
            logger.debug((Object)"Can't get tool property for synoptic chat.  Using default option");
        }
        try {
            dso.setItems(Integer.parseInt(placement.getPlacementConfig().getProperty(PARAM_ITEMS)));
        }
        catch (NumberFormatException e) {
            dso.setItems(3);
            logger.debug((Object)"Can't get tool property for synoptic chat.  Using default option");
        }
        try {
            dso.setChars(Integer.parseInt(placement.getPlacementConfig().getProperty(PARAM_LENGTH)));
        }
        catch (NumberFormatException e) {
            dso.setChars(50);
            logger.debug((Object)"Can't get tool property for synoptic chat.  Using default option");
        }
        return dso;
    }

    public DecoratedSynopticOptions getCurrentSynopticOptions() {
        return this.currentSynopticOptions;
    }

    public void setCurrentSynopticOptions(DecoratedSynopticOptions currentSynopticOptions) {
        this.currentSynopticOptions = currentSynopticOptions;
    }

    public List<SelectItem> getChatRoomsSelectItems() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        for (ChatChannel channel : this.getSiteChannels()) {
            items.add(this.createSelect((Object)channel.getId(), channel.getTitle()));
        }
        return items;
    }

    public List<DecoratedChatChannel> getChatChannels() {
        ArrayList<DecoratedChatChannel> items = new ArrayList<DecoratedChatChannel>();
        for (ChatChannel channel : this.getSiteChannels()) {
            items.add(new DecoratedChatChannel(this, channel));
        }
        return items;
    }

    public ChatManager getChatManager() {
        return this.chatManager;
    }

    public String getViewOptions() {
        return Integer.toString(this.viewOptions);
    }

    public void setViewOptions(String d) {
        this.viewOptions = Integer.parseInt(d);
    }

    protected int initMessageOptions() {
        int result = -1;
        DecoratedChatChannel dChannel = this.getCurrentChannel();
        if (dChannel != null && dChannel.getChatChannel().getFilterType().equals("SelectAllMessages")) {
            result = -1;
        } else if (dChannel != null && dChannel.getChatChannel().getFilterType().equals("SelectMessagesByNumber")) {
            result = 1;
        } else if (dChannel != null && dChannel.getChatChannel().getFilterType().equals("SelectMessagesByTime")) {
            result = 0;
        } else if (dChannel != null && dChannel.getChatChannel().getFilterType().equals("SelectNoneMessages")) {
            result = 2;
        }
        return result;
    }

    public String getMessageOptions() {
        if (this.messageOptions == -99) {
            this.messageOptions = this.initMessageOptions();
        }
        return Integer.toString(this.messageOptions);
    }

    public void setMessageOptions(String messageOptions) {
        this.messageOptions = Integer.parseInt(messageOptions);
    }

    public String getNewMessageText() {
        return this.newMessageText;
    }

    public void setNewMessageText(String newMessageText) {
        this.newMessageText = newMessageText;
    }

    public void setChatManager(ChatManager chatManager) {
        this.chatManager = chatManager;
    }

    public ToolManager getToolManager() {
        return this.toolManager;
    }

    public void setToolManager(ToolManager toolManager) {
        this.toolManager = toolManager;
    }

    public ColorMapper getColorMapper() {
        return this.colorMapper;
    }

    public void setColorMapper(ColorMapper colorMapper) {
        this.colorMapper = colorMapper;
    }

    public boolean getDisplayDate() {
        int val = Integer.parseInt(this.getViewOptions());
        return (val & 2) == 2;
    }

    public boolean getDisplayTime() {
        int val = Integer.parseInt(this.getViewOptions());
        return (val & 1) == 1;
    }

    public boolean getDisplayId() {
        int val = Integer.parseInt(this.getViewOptions());
        return (val & 4) == 4;
    }

    public boolean getCanRenderAllMessages() {
        DecoratedChatChannel dChannel = this.getCurrentChannel();
        return !this.getCanRenderMessageOptions() && dChannel != null && dChannel.getChatChannel().getFilterType().equals("SelectAllMessages") || this.getCanRenderMessageOptions() && this.messageOptions == -1;
    }

    public boolean getCanRenderDateMessages() {
        DecoratedChatChannel dChannel = this.getCurrentChannel();
        return !this.getCanRenderMessageOptions() && dChannel != null && dChannel.getChatChannel().getFilterType().equals("SelectMessagesByTime") || this.getCanRenderMessageOptions() && this.messageOptions == 0;
    }

    public boolean getCanRenderNumberMessages() {
        DecoratedChatChannel dChannel = this.getCurrentChannel();
        return !this.getCanRenderMessageOptions() && dChannel != null && dChannel.getChatChannel().getFilterType().equals("SelectMessagesByNumber") || this.getCanRenderMessageOptions() && this.messageOptions == 1;
    }

    public boolean getCanRenderNoMessages() {
        DecoratedChatChannel dChannel = this.getCurrentChannel();
        return !this.getCanRenderMessageOptions() && dChannel != null && dChannel.getChatChannel().getFilterType().equals("SelectNoneMessages") || this.getCanRenderMessageOptions() && this.messageOptions == 2;
    }

    public List<SelectItem> getMessageOptionsList() {
        int timeParam;
        ArrayList<SelectItem> messageOptions = new ArrayList<SelectItem>();
        DecoratedChatChannel dChannel = this.getCurrentChannel();
        int numberParam = dChannel != null ? dChannel.getChatChannel().getNumberParam() : 0;
        int n = timeParam = dChannel != null ? dChannel.getChatChannel().getTimeParam() : 0;
        if (this.getCanRenderMessageOptions()) {
            SelectItem item1 = new SelectItem((Object)Integer.toString(-1), this.getCustomOptionText("SelectMessagesByNumber", this.getChatManager().getMessagesMax()));
            SelectItem item2 = new SelectItem((Object)Integer.toString(1), this.getCustomOptionText("SelectMessagesByNumber", numberParam));
            SelectItem item3 = new SelectItem((Object)Integer.toString(0), this.getCustomOptionText("SelectMessagesByTime", timeParam));
            SelectItem item4 = new SelectItem((Object)Integer.toString(2), this.getCustomOptionText("SelectNoneMessages", 0));
            messageOptions.add(item1);
            messageOptions.add(item2);
            messageOptions.add(item3);
            messageOptions.add(item4);
        } else {
            String filter = dChannel != null ? dChannel.getChatChannel().getFilterType() : "";
            SelectItem item = null;
            if (filter.equals("SelectAllMessages")) {
                item = new SelectItem((Object)Integer.toString(-1), this.getCustomOptionText("SelectMessagesByNumber", this.getChatManager().getMessagesMax()));
            } else if (filter.equals("SelectMessagesByNumber")) {
                item = new SelectItem((Object)Integer.toString(1), this.getCustomOptionText("SelectMessagesByNumber", numberParam));
            } else if (filter.equals("SelectMessagesByTime")) {
                item = new SelectItem((Object)Integer.toString(0), this.getCustomOptionText("SelectMessagesByTime", timeParam));
            } else if (filter.equals("SelectNoneMessages")) {
                item = new SelectItem((Object)Integer.toString(2), this.getCustomOptionText("SelectNoneMessages", 0));
            }
            messageOptions.add(item);
        }
        return messageOptions;
    }

    public boolean getCanRenderMessageOptions() {
        DecoratedChatChannel dChannel = this.getCurrentChannel();
        return dChannel != null ? dChannel.getChatChannel().isEnableUserOverride() : false;
    }

    protected String getCustomOptionValue(String filterType) {
        int val = 0;
        if (filterType.equals("SelectMessagesByTime")) {
            val = 0;
        } else if (filterType.equals("SelectMessagesByNumber")) {
            val = 1;
        } else if (filterType.equals("SelectNoneMessages")) {
            val = 2;
        }
        return Integer.toString(val);
    }

    protected String getCustomOptionText(String filterType, int filterParam) {
        String result = this.getPastXDaysText(filterParam);
        if (filterType.equals("SelectMessagesByTime")) {
            result = this.getPastXDaysText(filterParam);
        } else if (filterType.equals("SelectMessagesByNumber")) {
            result = this.getPastXMessagesText(filterParam);
        } else if (filterType.equals("SelectNoneMessages")) {
            result = this.getNoMessagesText();
        }
        return result;
    }

    public boolean getSoundAlert() {
        return true;
    }

    protected int countChannelMessages(ChatChannel channel) {
        return this.getChatManager().countChannelMessages(channel);
    }

    public List<DecoratedChatMessage> getRoomMessages() {
        int x;
        Date xDaysOld = null;
        int maxMessages = 0;
        DecoratedChatChannel dChannel = this.getCurrentChannel();
        if (Integer.parseInt(this.getMessageOptions()) == 0) {
            x = dChannel != null ? dChannel.getChatChannel().getTimeParam() : 0;
            xDaysOld = this.getChatManager().calculateDateByOffset(x);
            maxMessages = this.getChatManager().getMessagesMax();
        } else if (Integer.parseInt(this.getMessageOptions()) == 1) {
            maxMessages = x = dChannel != null ? dChannel.getChatChannel().getNumberParam() : 0;
        } else if (Integer.parseInt(this.getMessageOptions()) == -1) {
            maxMessages = this.getChatManager().getMessagesMax();
        } else if (Integer.parseInt(this.getMessageOptions()) == 2) {
            maxMessages = 0;
        }
        EventTrackingService ets = (EventTrackingService)ComponentManager.get(EventTrackingService.class);
        if (ets != null && dChannel != null && dChannel.getChatChannel() != null) {
            ets.post(ets.newEvent("chat.read", dChannel.getChatChannel().getReference(), false));
        }
        return this.getMessages(this.getContext(), xDaysOld, maxMessages, true);
    }

    public int getRoomMessagesCount() {
        Date xDaysOld = null;
        DecoratedChatChannel dChannel = this.getCurrentChannel();
        if (Integer.parseInt(this.getMessageOptions()) == 0) {
            int x = dChannel != null ? dChannel.getChatChannel().getTimeParam() : 0;
            xDaysOld = this.getChatManager().calculateDateByOffset(x);
        }
        return this.getMessagesCount(this.getContext(), xDaysOld);
    }

    public List<DecoratedChatMessage> getSynopticMessages() {
        DecoratedSynopticOptions dso = this.lookupSynopticOptions();
        if (this.getChatManager() == null) {
            return null;
        }
        Date date = this.getChatManager().calculateDateByOffset(dso.getDays());
        return this.getMessages(this.getContext(), date, dso.getItems(), false);
    }

    protected List<DecoratedChatMessage> getMessages(String context, Date limitDate, int numMessages, boolean sortAsc) {
        if (numMessages > this.getChatManager().getMessagesMax()) {
            numMessages = this.getChatManager().getMessagesMax();
        }
        List messages = new ArrayList();
        try {
            ChatChannel channel = this.currentChannel == null ? null : this.currentChannel.getChatChannel();
            messages = this.getChatManager().getChannelMessages(channel, context, limitDate, 0, numMessages, sortAsc);
        }
        catch (PermissionException e) {
            this.setErrorMessage(PERMISSION_ERROR, (Object[])new String[]{"chat.read"});
        }
        ArrayList<DecoratedChatMessage> decoratedMessages = new ArrayList<DecoratedChatMessage>();
        for (ChatMessage message : messages) {
            DecoratedChatMessage decoratedMessage = new DecoratedChatMessage(this, message);
            decoratedMessages.add(decoratedMessage);
        }
        return decoratedMessages;
    }

    protected int getMessagesCount(String context, Date limitDate) {
        ChatChannel channel = this.currentChannel == null ? null : this.currentChannel.getChatChannel();
        return this.getChatManager().getChannelMessagesCount(channel, context, limitDate);
    }

    public boolean getCanRemoveMessage(ChatMessage message) {
        return this.getChatManager().getCanDelete(message);
    }

    public boolean getCanRemoveChannel(ChatChannel channel) {
        return this.getChatManager().getCanDelete(channel);
    }

    public boolean getCanRemoveChannelMessages(ChatChannel channel) {
        return this.getChatManager().getCanDeleteAnyMessage(channel.getContext());
    }

    public boolean getCanEditChannel(ChatChannel channel) {
        return this.getChatManager().getCanEdit(channel);
    }

    public boolean getCanCreateChannel() {
        return this.getChatManager().getCanCreateChannel(this.getContext());
    }

    public boolean getCanRead(ChatChannel channel) {
        return this.getChatManager().getCanReadMessage(channel);
    }

    public boolean getCanPost() {
        return this.getCurrentChannel() == null ? false : this.getChatManager().getCanPostMessage(this.getCurrentChannel().getChatChannel());
    }

    public boolean getMaintainer() {
        return this.getChatManager() == null ? false : this.getChatManager().isMaintainer(this.getContext());
    }

    public String getMessageOwnerDisplayName(ChatMessage message) {
        User sender = null;
        try {
            sender = UserDirectoryService.getUser((String)message.getOwner());
        }
        catch (UserNotDefinedException e) {
            logger.error((Object)e);
            return message.getOwner();
        }
        return sender.getDisplayName();
    }

    protected String getPastXDaysText(int x) {
        return this.getMessageFromBundle("past_x_days", new Object[]{x});
    }

    protected String getPastXMessagesText(int x) {
        return this.getMessageFromBundle("past_x_messages", new Object[]{x});
    }

    protected String getNoMessagesText() {
        return this.getMessageFromBundle("shownone");
    }

    protected String getAllMessagesText() {
        return this.getMessageFromBundle("allMessages");
    }

    public String getMessagesShownTotalText() {
        return this.getMessageFromBundle("messages_shown_total", new Object[]{"*SHOWN*", "*TOTAL*"});
    }

    public String getViewingChatRoomText() {
        String title = null;
        DecoratedChatChannel dChannel = this.getCurrentChannel();
        if (dChannel != null && dChannel.getChatChannel() != null) {
            title = dChannel.getChatChannel().getTitle();
        }
        return this.getMessageFromBundle("viewingChatRoomText", new Object[]{title});
    }

    private void setErrorMessage(String errorMsg, Object[] extras) {
        this.setErrorMessage(null, errorMsg, extras);
    }

    private void setErrorMessage(String field, String errorMsg, Object[] extras) {
        logger.debug((Object)("setErrorMessage(String " + errorMsg + ")"));
        FacesContext.getCurrentInstance().addMessage(field, new FacesMessage(this.getMessageFromBundle(errorMsg, extras)));
    }

    public String getServerUrl() {
        return ServerConfigurationService.getServerUrl();
    }

    public String getToolString() {
        return this.placementId;
    }

    protected String getContext() {
        return this.getToolManager().getCurrentPlacement().getContext();
    }

    public String getFramePlacementId() {
        return Validator.escapeJavascript((String)("Main" + this.getToolManager().getCurrentPlacement().getId()));
    }

    protected List<ChatChannel> getSiteChannels() {
        return this.getChatManager().getContextChannels(this.getContext(), this.getMessageFromBundle("default_new_channel_title"), this.getToolManager().getCurrentPlacement().getId());
    }

    public int getSiteChannelCount() {
        return this.getChatManager().getContextChannels(this.getContext(), this.getMessageFromBundle("default_new_channel_title"), this.getToolManager().getCurrentPlacement().getId()).size();
    }

    public SelectItem createSelect(Object id, String description) {
        SelectItem item = new SelectItem(id, description);
        return item;
    }

    public String getMessageFromBundle(String key, Object[] args) {
        return MessageFormat.format(this.getMessageFromBundle(key), args);
    }

    public String getMessageFromBundle(String key) {
        if (this.toolBundle == null) {
            String bundle = FacesContext.getCurrentInstance().getApplication().getMessageBundle();
            this.toolBundle = new ResourceLoader(bundle);
        }
        return this.toolBundle.getString(key);
    }

    public String getToolContext() {
        return this.toolContext;
    }

    public void setToolContext(String toolContext) {
        this.toolContext = toolContext;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void validatePositiveNumber(FacesContext context, UIComponent component, Object value) {
        if (value != null && (Integer)value < 0) {
            FacesMessage message = new FacesMessage(this.getMessageFromBundle("neg_num_error", null));
            message.setSeverity(FacesMessage.SEVERITY_WARN);
            throw new ValidatorException(message);
        }
    }

    public String getToolTitle() {
        return this.toolManager.getCurrentPlacement().getTitle();
    }

    public String getAccessibleOptionsLink() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageFromBundle("manage_tool"));
        sb.append("<span class=\"skip\">");
        sb.append(this.getToolTitle());
        sb.append("</span>");
        return sb.toString();
    }
}

