/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.chat2.tool;

import java.util.Date;
import org.apache.commons.lang.time.DateUtils;
import org.sakaiproject.chat2.model.ChatChannel;
import org.sakaiproject.chat2.tool.ChatTool;

public class DecoratedChatChannel {
    private ChatChannel chatChannel;
    private ChatTool chatTool;
    private int filterParamPast;
    private int filterParamLast;
    private int filterParamNone = 0;
    private boolean directEdit = false;
    private boolean newChannel = false;
    private Date startDate = null;
    private Date endDate = null;

    public DecoratedChatChannel(ChatTool chatTool, ChatChannel chatChannel) {
        this.chatTool = chatTool;
        this.chatChannel = chatChannel;
        if (chatChannel != null) {
            this.setStartDate(chatChannel.getStartDate());
            this.setEndDate(chatChannel.getEndDate());
        }
    }

    public DecoratedChatChannel(ChatTool chatTool, ChatChannel chatChannel, boolean newChannel) {
        this(chatTool, chatChannel);
        this.newChannel = newChannel;
    }

    public String processActionEnterRoom() {
        return this.chatTool.processActionEnterRoom(this);
    }

    public String processActionEditRoom() {
        this.directEdit = false;
        return this.chatTool.processActionEditRoom(this);
    }

    public String processActionEditRoomDirect() {
        this.directEdit = false;
        return this.chatTool.processActionEditRoom(this);
    }

    public String processActionDeleteRoom() {
        return this.chatTool.processActionDeleteRoomConfirm(this);
    }

    public String processActionDeleteRoomMessages() {
        return this.chatTool.processActionDeleteRoomMessagesConfirm(this);
    }

    public String processActionSetAsDefaultRoom() {
        return this.chatTool.processActionSetAsDefaultRoom(this);
    }

    public ChatChannel getChatChannel() {
        return this.chatChannel;
    }

    public ChatTool getChatTool() {
        return this.chatTool;
    }

    public boolean getCanDelete() {
        return this.chatTool.getCanRemoveChannel(this.chatChannel);
    }

    public boolean getCanDeleteMessages() {
        return this.chatTool.getCanRemoveChannelMessages(this.chatChannel);
    }

    public boolean getCanEdit() {
        return this.chatTool.getCanEditChannel(this.chatChannel);
    }

    public boolean getCanRead() {
        return this.chatTool.getCanRead(this.chatChannel);
    }

    public String getEnterChatText() {
        return this.chatTool.getMessageFromBundle("enter_the_chat_room", new Object[]{this.chatChannel.getTitle()});
    }

    public String getSetAsDefaultText() {
        return this.chatTool.getMessageFromBundle("set_as_default", new Object[]{this.chatChannel.getTitle()});
    }

    public int getFilterParamLast() {
        return this.filterParamLast;
    }

    public void setFilterParamLast(int filterParamLast) {
        this.filterParamLast = filterParamLast;
    }

    public int getFilterParamPast() {
        return this.filterParamPast;
    }

    public void setFilterParamPast(int filterParamPast) {
        this.filterParamPast = filterParamPast;
    }

    public int getFilterParamNone() {
        return this.filterParamNone;
    }

    public void setFilterParamNone(int filterParamNone) {
        this.filterParamNone = filterParamNone;
    }

    public boolean isDirectEdit() {
        return this.directEdit;
    }

    public void setDirectEdit(boolean directEdit) {
        this.directEdit = directEdit;
    }

    public boolean isNewChannel() {
        return this.newChannel;
    }

    public void setNewChannel(boolean newChannel) {
        this.newChannel = newChannel;
    }

    public int getNumberChannelMessages() {
        return this.chatTool.countChannelMessages(this.chatChannel);
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        if (startDate != null) {
            startDate = DateUtils.truncate((Date)startDate, (int)5);
        }
        this.startDate = startDate;
    }

    public Date getEndDate() {
        if (this.endDate != null) {
            this.endDate = DateUtils.truncate((Date)this.endDate, (int)5);
        }
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        if (endDate != null) {
            endDate = DateUtils.truncate((Date)endDate, (int)5);
            endDate = DateUtils.addSeconds((Date)endDate, (int)86398);
        }
        this.endDate = endDate;
    }
}

