/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.chat2.tool;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.chat2.model.ChatChannel;
import org.sakaiproject.chat2.model.ChatManager;
import org.sakaiproject.chat2.model.ChatMessage;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.courier.api.Expirable;
import org.sakaiproject.time.api.Time;
import org.sakaiproject.time.cover.TimeService;
import org.sakaiproject.user.api.ContextualUserDisplayService;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.sakaiproject.user.cover.UserDirectoryService;
import org.sakaiproject.util.BaseDelivery;
import org.sakaiproject.util.StringUtil;
import org.sakaiproject.util.Web;

public class ChatDelivery
extends BaseDelivery
implements Expirable {
    private static Log logger = LogFactory.getLog(ChatDelivery.class);
    protected Object m_message = null;
    protected ChatManager chatManager = null;
    protected boolean m_beepOnDelivery = false;
    protected String placementId = "";
    private ContextualUserDisplayService contextualUserDisplayService;
    private long created;
    private int ttl;

    public ChatDelivery(String address, String elementId, Object message, String placementId, boolean beepOnDelivery, ChatManager chatManager) {
        super(address, elementId);
        this.m_message = message;
        this.m_beepOnDelivery = beepOnDelivery;
        this.chatManager = chatManager;
        this.placementId = placementId;
        this.created = System.currentTimeMillis();
        this.ttl = ServerConfigurationService.getInt((String)"chat.delivery.ttl", (int)300);
    }

    public ChatMessage getMessage() {
        if (this.m_message instanceof String) {
            this.m_message = this.chatManager.getMessage((String)this.m_message);
        }
        if (this.m_message instanceof ChatMessage) {
            return (ChatMessage)this.m_message;
        }
        return null;
    }

    public void setMessage(Object message) {
        this.m_message = message;
    }

    public String compose() {
        ChatMessage message = null;
        if (this.m_message instanceof ChatMessage) {
            message = (ChatMessage)this.m_message;
        } else if (this.m_message instanceof String) {
            message = this.chatManager.getMessage((String)this.m_message);
        } else {
            return "";
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("compose() element: " + this.m_elementId + ", message: " + message.getId()));
        }
        User sender = null;
        try {
            sender = UserDirectoryService.getUser((String)message.getOwner());
        }
        catch (UserNotDefinedException e) {
            logger.error((Object)e);
        }
        User myself = UserDirectoryService.getCurrentUser();
        ChatChannel channel = message.getChatChannel();
        String retval = null;
        if (channel == null) {
            retval = "try { this.location.replace(addAuto(this.location));} catch (error) {alert(error);}";
        } else {
            String msgbody = Web.escapeJsQuoted((String)Web.escapeHtmlFormattedText((String)message.getBody()));
            msgbody = msgbody.replace('\n', ' ').replace('\r', ' ');
            Time messageTime = TimeService.newTime((long)message.getMessageDate().getTime());
            StringBuilder retvalBuf = new StringBuilder();
            retvalBuf.append("try { appendMessage('");
            String displayName = this.getUserDisplayName(sender, channel.getContext());
            retvalBuf.append(Web.escapeJsQuoted((String)Web.escapeHtml((String)displayName)));
            retvalBuf.append("', '");
            retvalBuf.append(sender.getId());
            retvalBuf.append("', '");
            retvalBuf.append(String.valueOf(this.chatManager.getCanDelete(message)));
            retvalBuf.append("', '");
            retvalBuf.append(messageTime.toStringLocalDate());
            retvalBuf.append("', '");
            retvalBuf.append(messageTime.toStringLocalTimeZ());
            retvalBuf.append("', '");
            retvalBuf.append(messageTime.toString());
            retvalBuf.append("', '");
            retvalBuf.append(msgbody);
            retvalBuf.append("','");
            retvalBuf.append(message.getId());
            retvalBuf.append("'); } catch (error) {alert(error);} ");
            retval = retvalBuf.toString();
        }
        if (this.m_beepOnDelivery && sender != null && sender.compareTo((Object)myself) != 0) {
            retval = retval + "beep = true;";
        }
        return retval;
    }

    public String toString() {
        return super.toString() + " : " + this.m_message;
    }

    public String getMessageId() {
        if (this.m_message instanceof String) {
            return (String)this.m_message;
        }
        if (this.m_message instanceof ChatMessage) {
            return ((ChatMessage)this.m_message).getId();
        }
        return "";
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ChatDelivery cob = (ChatDelivery)obj;
        return !StringUtil.different((String)cob.getMessageId(), (String)this.getMessageId());
    }

    private String getUserDisplayName(User u, String context) {
        this.contextualUserDisplayService = (ContextualUserDisplayService)ComponentManager.get((String)"org.sakaiproject.user.api.ContextualUserDisplayService");
        if (this.contextualUserDisplayService == null) {
            return u.getDisplayName();
        }
        String ret = this.contextualUserDisplayService.getUserDisplayName(u, "/site/" + context);
        if (ret == null) {
            ret = u.getDisplayName();
        }
        return ret;
    }

    public long getCreated() {
        return this.created;
    }

    public void setCreated(long created) {
        this.created = created;
    }

    public int getTtl() {
        return this.ttl;
    }
}

