/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.citation.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.citation.api.Citation;
import org.sakaiproject.citation.api.CitationCollection;
import org.sakaiproject.citation.api.Schema;
import org.sakaiproject.citation.impl.BaseCitationService;
import org.sakaiproject.db.api.SqlReader;
import org.sakaiproject.db.api.SqlService;
import org.sakaiproject.id.cover.IdManager;
import org.sakaiproject.thread_local.cover.ThreadLocalManager;
import org.sakaiproject.time.api.Time;
import org.sakaiproject.time.cover.TimeService;

public class DbCitationService
extends BaseCitationService {
    private static final int AUTO_FALSE = 3;
    private static final int AUTO_TRUE = 2;
    private static final int AUTO_UNKNOWN = 1;
    private static Log M_log = LogFactory.getLog(DbCitationService.class);
    protected static final Pattern MULTIVALUED_PATTERN = Pattern.compile("^(.*)\\t(\\d+)$");
    protected static final String PROP_SORT_ORDER = "sakai:sort_order";
    protected static final String PROP_MOST_RECENT_UPDATE = "sakai:most_recent_update";
    protected static final String PROP_ADDED = "sakai:added";
    protected static final String PROP_DISPLAYNAME = "sakai:displayname";
    protected static final String PROP_HAS_RIS_IDENTIFIER = "sakai:ris_identifier";
    protected static final String PROP_HAS_URL = "sakai:has_url";
    protected static final String PROP_HAS_PREFERRED_URL = "sakai:has_preferred_url";
    protected static final String PROP_MEDIATYPE = "sakai:mediatype";
    protected static final String PROP_URL_LABEL = "sakai:url_label";
    protected static final String PROP_URL_STRING = "sakai:url_string";
    protected static final String PROP_URL_ADD_PREFIX = "sakai:url_add_prefix";
    protected static final String PROPERTY_NAME_DELIMITOR = "\t";
    protected boolean m_autoDdl = false;
    protected String m_citationTableId = "CITATION_ID";
    protected String m_citationTableName = "CITATION_CITATION";
    protected String m_collectionTableId = "COLLECTION_ID";
    protected String m_collectionTableName = "CITATION_COLLECTION";
    protected String m_collectionOrderTableName = "CITATION_COLLECTION_ORDER";
    protected String m_schemaFieldTableId = "FIELD_ID";
    protected String m_schemaFieldTableName = "CITATION_SCHEMA_FIELD";
    protected String m_schemaTableId = "SCHEMA_ID";
    protected String m_schemaTableName = "CITATION_SCHEMA";
    protected SqlService m_sqlService = null;

    @Override
    public void init() {
        try {
            if (this.m_autoDdl) {
                this.m_sqlService.ddl(this.getClass().getClassLoader(), "sakai_citation");
                M_log.info((Object)("init(): tables: " + this.m_collectionTableName + ", " + this.m_citationTableName + ", " + this.m_schemaTableName + ", " + this.m_schemaFieldTableName));
            }
            super.init();
        }
        catch (Throwable t) {
            M_log.warn((Object)"init(): ", t);
        }
    }

    @Override
    public BaseCitationService.Storage newStorage() {
        return new DbCitationStorage();
    }

    public void setAutoDdl(String value) {
        this.m_autoDdl = new Boolean(value);
    }

    public void setSqlService(SqlService service) {
        this.m_sqlService = service;
    }

    private void errorCleanup(Connection conn, int wasCommit) {
        if (conn != null) {
            try {
                conn.rollback();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.restoreAutoCommit(conn, wasCommit);
            this.m_sqlService.returnConnection(conn);
        }
    }

    private int getAutoCommit(Connection conn) {
        try {
            boolean wasCommit = conn.getAutoCommit();
            return wasCommit ? 2 : 3;
        }
        catch (SQLException exception) {
            M_log.warn((Object)("restoreAutoCommit: " + exception));
            return 1;
        }
    }

    private void restoreAutoCommit(Connection conn, int wasCommit) {
        try {
            switch (wasCommit) {
                case 2: {
                    conn.setAutoCommit(true);
                    break;
                }
                case 3: {
                    conn.setAutoCommit(false);
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    M_log.warn((Object)("restoreAutoCommit: unknown commit type: " + wasCommit));
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            M_log.warn((Object)("restoreAutoCommit: " + throwable));
        }
    }

    protected String insertFields(String before, String[] fields, String after) {
        StringBuilder buf = new StringBuilder();
        buf.append(" (");
        buf.append(before);
        if (fields != null) {
            for (int i = 0; i < fields.length; ++i) {
                if (i == 0 && before == null) {
                    buf.append(fields[i]);
                    continue;
                }
                buf.append("," + fields[i]);
            }
        }
        if (after != null) {
            buf.append("," + after);
        }
        buf.append(")");
        return buf.toString();
    }

    public class TripleReader
    implements SqlReader {
        public Object readSqlResultRecord(ResultSet result) {
            Triple triple = null;
            String citationId = null;
            String name = null;
            String value = null;
            try {
                citationId = result.getString(1);
                name = result.getString(2);
                value = result.getString(3);
                triple = new Triple(citationId, name, value);
            }
            catch (SQLException e) {
                M_log.debug((Object)("TripleReader: problem reading triple from result: citationId(" + citationId + ") name(" + name + ") value(" + value + ")"));
                return null;
            }
            return triple;
        }
    }

    public class Triple {
        protected String m_id;
        protected String m_name;
        protected Object m_value;

        public Triple(String id, String name, String value) {
            this.m_id = id;
            this.m_name = name;
            this.m_value = value;
        }

        public String getId() {
            return this.m_id;
        }

        public String getName() {
            return this.m_name;
        }

        public Object getValue() {
            return this.m_value;
        }

        public boolean isValid() {
            return this.m_id != null && this.m_name != null && this.m_value != null;
        }

        public void setId(String id) {
            this.m_id = id;
        }

        public void setName(String name) {
            this.m_name = name;
        }

        public void setValue(Object value) {
            this.m_value = value;
        }

        public String toString() {
            return "[triple id = " + (this.m_id == null ? "null" : this.m_id) + " name = " + (this.m_name == null ? "null" : this.m_name) + " value = " + (this.m_value == null ? "null" : this.m_value.toString() + "]");
        }
    }

    public class DbCitationStorage
    implements BaseCitationService.Storage {
        @Override
        public Citation addCitation(String mediatype) {
            Citation citation = this.createCitation(mediatype);
            return citation;
        }

        @Override
        public CitationCollection addCollection(Map attributes, List citations) {
            CitationCollection collection = this.createCollection(attributes, citations);
            return collection;
        }

        @Override
        public Schema addSchema(Schema schema) {
            schema = this.createSchema(schema);
            return schema;
        }

        @Override
        public boolean checkCitation(String citationId) {
            boolean check = this.validCitation(citationId);
            return check;
        }

        @Override
        public boolean checkCollection(String collectionId) {
            boolean check = this.validCollection(collectionId);
            return check;
        }

        @Override
        public boolean checkSchema(String schemaId) {
            boolean check = this.validSchema(schemaId);
            return check;
        }

        @Override
        public void close() {
        }

        @Override
        public CitationCollection copyAll(String collectionId) {
            CitationCollection copy = this.duplicateAll(collectionId);
            return copy;
        }

        @Override
        public Citation getCitation(String citationId) {
            Citation citation = this.retrieveCitation(citationId);
            return citation;
        }

        @Override
        public CitationCollection getCollection(String collectionId) {
            CitationCollection collection = this.retrieveCollection(collectionId);
            return collection;
        }

        @Override
        public Schema getSchema(String schemaId) {
            BaseCitationService.BasicSchema schema = (BaseCitationService.BasicSchema)ThreadLocalManager.get((String)schemaId);
            schema = schema == null ? (BaseCitationService.BasicSchema)this.retrieveSchema(schemaId) : new BaseCitationService.BasicSchema((BaseCitationService)DbCitationService.this, schema);
            return schema;
        }

        @Override
        public List getSchemas() {
            Vector<BaseCitationService.BasicSchema> schemas = (Vector<BaseCitationService.BasicSchema>)ThreadLocalManager.get((String)"DbCitationStorage.getSchemas");
            if (schemas == null) {
                schemas = this.retrieveSchemas();
            } else {
                Vector<BaseCitationService.BasicSchema> rv = new Vector<BaseCitationService.BasicSchema>();
                for (Schema schema : schemas) {
                    rv.add(new BaseCitationService.BasicSchema((BaseCitationService)DbCitationService.this, schema));
                }
                schemas = rv;
            }
            return schemas;
        }

        @Override
        public List listSchemas() {
            List schemaIds = (Vector)ThreadLocalManager.get((String)"DbCitationStorage.listSchemas");
            schemaIds = schemaIds == null ? this.retrieveSchemaList() : new Vector(schemaIds);
            return schemaIds;
        }

        @Override
        public void open() {
        }

        @Override
        public void putSchemas(Collection schemas) {
            this.insertSchemas(schemas);
        }

        @Override
        public void removeCitation(Citation edit) {
            this.deleteCitation(edit);
        }

        @Override
        public void removeCollection(CitationCollection edit) {
            this.deleteCollection(edit);
        }

        @Override
        public void removeSchema(Schema schema) {
            this.deleteSchema(schema);
        }

        @Override
        public void saveCitation(Citation edit) {
            this.commitCitation(edit);
        }

        @Override
        public void saveCollection(CitationCollection collection) {
            this.commitCollection(collection);
        }

        @Override
        public void updateSchema(Schema schema) {
            this.reviseSchema(schema);
        }

        @Override
        public void updateSchemas(Collection schemas) {
            this.reviseSchemas(schemas);
        }

        protected void commitCitation(Citation citation) {
            String displayName;
            this.deleteCitation(citation);
            String statement = "insert into " + DbCitationService.this.m_citationTableName + " (" + DbCitationService.this.m_citationTableId + ", PROPERTY_NAME, PROPERTY_VALUE) values ( ?, ?, ? )";
            String citationId = citation.getId();
            boolean ok = true;
            Object[] fields = new Object[3];
            fields[0] = citationId;
            if (citation.getSchema() != null) {
                fields[1] = DbCitationService.PROP_MEDIATYPE;
                fields[2] = citation.getSchema().getIdentifier();
                ok = DbCitationService.this.m_sqlService.dbWrite(statement, fields);
            }
            if ((displayName = citation.getDisplayName()) != null) {
                fields[1] = DbCitationService.PROP_DISPLAYNAME;
                fields[2] = displayName.trim();
                ok = DbCitationService.this.m_sqlService.dbWrite(statement, fields);
            }
            if (citation.isAdded()) {
                fields[1] = DbCitationService.PROP_ADDED;
                fields[2] = Boolean.TRUE.toString();
                ok = DbCitationService.this.m_sqlService.dbWrite(statement, fields);
            }
            List names = citation.listCitationProperties();
            for (String name : names) {
                Object value = citation.getCitationProperty(name, false);
                if (value instanceof List) {
                    List list = (List)value;
                    for (int i = 0; i < list.size(); ++i) {
                        Object item = list.get(i);
                        fields[1] = name + DbCitationService.PROPERTY_NAME_DELIMITOR + i;
                        fields[2] = item;
                        ok = DbCitationService.this.m_sqlService.dbWrite(statement, fields);
                    }
                    continue;
                }
                if (value instanceof String) {
                    fields[1] = name;
                    fields[2] = value;
                    ok = DbCitationService.this.m_sqlService.dbWrite(statement, fields);
                    continue;
                }
                M_log.debug((Object)("DbCitationStorage.saveCitation value not List or String: " + value.getClass().getCanonicalName() + " " + value));
                fields[1] = name;
                fields[2] = value;
                ok = DbCitationService.this.m_sqlService.dbWrite(statement, fields);
            }
            int urlCount = 0;
            Map urls = ((BaseCitationService.BasicCitation)citation).m_urls;
            if (((BaseCitationService.BasicCitation)citation).m_urls != null) {
                for (Map.Entry entry : ((BaseCitationService.BasicCitation)citation).m_urls.entrySet()) {
                    BaseCitationService.UrlWrapper wrapper = (BaseCitationService.UrlWrapper)entry.getValue();
                    fields[1] = "sakai:has_url\t" + urlCount;
                    fields[2] = entry.getKey();
                    ok = DbCitationService.this.m_sqlService.dbWrite(statement, fields);
                    this.commitUrl((String)entry.getKey(), wrapper.getLabel(), wrapper.getUrl(), wrapper.addPrefix());
                    ++urlCount;
                }
            }
            if (citation.hasPreferredUrl()) {
                fields[1] = DbCitationService.PROP_HAS_PREFERRED_URL;
                fields[2] = citation.getPreferredUrlId();
                ok = DbCitationService.this.m_sqlService.dbWrite(statement, fields);
            }
        }

        protected void commitCollection(CitationCollection collection) {
            this.deleteCollection(collection);
            String statement = "insert into " + DbCitationService.this.m_collectionTableName + " (" + DbCitationService.this.m_collectionTableId + ",PROPERTY_NAME,PROPERTY_VALUE) values ( ?, ?, ? )";
            String orderStatement = "insert into " + DbCitationService.this.m_collectionOrderTableName + " VALUES(?,?,?)";
            boolean ok = true;
            String collectionId = collection.getId();
            Object[] fields = new Object[3];
            fields[0] = collectionId;
            Object[] orderFields = new Object[3];
            orderFields[0] = collectionId;
            List members = collection.getCitations();
            for (Citation citation : members) {
                DbCitationService.this.save(citation);
                orderFields[1] = citation.getId();
                orderFields[2] = citation.getPosition();
                ok = DbCitationService.this.m_sqlService.dbWrite(orderStatement, orderFields);
            }
            long mostRecentUpdate = TimeService.newTime().getTime();
            fields[1] = DbCitationService.PROP_MOST_RECENT_UPDATE;
            fields[2] = Long.toString(mostRecentUpdate);
            ok = DbCitationService.this.m_sqlService.dbWrite(statement, fields);
            fields[1] = DbCitationService.PROP_SORT_ORDER;
            fields[2] = collection.getSort();
            ok = DbCitationService.this.m_sqlService.dbWrite(statement, fields);
        }

        protected void commitUrl(String id, String label, String url, boolean addPrefix) {
            this.deleteUrl(id);
            String statement = "insert into " + DbCitationService.this.m_citationTableName + " (" + DbCitationService.this.m_citationTableId + ", PROPERTY_NAME, PROPERTY_VALUE) values ( ?, ?, ? )";
            boolean ok = true;
            Object[] fields = new Object[]{id, DbCitationService.PROP_URL_LABEL, label};
            ok = DbCitationService.this.m_sqlService.dbWrite(statement, fields);
            fields[1] = DbCitationService.PROP_URL_STRING;
            fields[2] = url;
            ok = DbCitationService.this.m_sqlService.dbWrite(statement, fields);
            fields[1] = DbCitationService.PROP_URL_ADD_PREFIX;
            fields[2] = addPrefix ? "y" : "n";
            ok = DbCitationService.this.m_sqlService.dbWrite(statement, fields);
        }

        protected Citation createCitation(String mediatype) {
            BaseCitationService.BasicCitation edit = new BaseCitationService.BasicCitation((BaseCitationService)DbCitationService.this, mediatype);
            String statement = "insert into " + DbCitationService.this.m_citationTableName + " (" + DbCitationService.this.m_citationTableId + ", PROPERTY_NAME, PROPERTY_VALUE) values ( ?, ?, ? )";
            String citationId = edit.getId();
            Object[] fields = new Object[]{citationId, DbCitationService.PROP_MEDIATYPE, edit.getSchema().getIdentifier()};
            boolean ok = DbCitationService.this.m_sqlService.dbWrite(statement, fields);
            List names = edit.listCitationProperties();
            boolean first = true;
            for (String name : names) {
                Object value = edit.getCitationProperty(name, false);
                fields[1] = name;
                fields[2] = value;
                ok = DbCitationService.this.m_sqlService.dbWrite(statement, fields);
            }
            return edit;
        }

        protected CitationCollection createCollection(Map attributes, List citations) {
            BaseCitationService.BasicCitationCollection edit = new BaseCitationService.BasicCitationCollection(DbCitationService.this, attributes, citations);
            String statement = "insert into " + DbCitationService.this.m_collectionTableName + " (" + DbCitationService.this.m_collectionTableId + ",PROPERTY_NAME,PROPERTY_VALUE) values ( ?, ?, ? )";
            Object[] fields = new Object[3];
            fields[0] = edit.getId();
            boolean ok = true;
            List members = edit.getCitations();
            for (Citation citation : members) {
                if (citation instanceof BaseCitationService.BasicCitation && ((BaseCitationService.BasicCitation)citation).isTemporary()) {
                    ((BaseCitationService.BasicCitation)citation).m_id = IdManager.createUuid();
                    ((BaseCitationService.BasicCitation)citation).m_temporary = false;
                    ((BaseCitationService.BasicCitation)citation).m_serialNumber = null;
                }
                this.commitCitation(citation);
            }
            edit.m_mostRecentUpdate = TimeService.newTime().getTime();
            fields[1] = DbCitationService.PROP_MOST_RECENT_UPDATE;
            fields[2] = Long.toString(edit.m_mostRecentUpdate);
            ok = DbCitationService.this.m_sqlService.dbWrite(statement, fields);
            return edit;
        }

        protected Schema createSchema(Schema schema) {
            String statement = "insert into " + DbCitationService.this.m_schemaTableName + " (" + DbCitationService.this.m_schemaTableId + ",PROPERTY_NAME,PROPERTY_VALUE) values ( ?, ?, ? )";
            String schemaId = schema.getIdentifier();
            boolean ok = true;
            Object[] fields = new Object[3];
            fields[0] = schemaId;
            fields[1] = "sakai:hasField";
            List schemaFields = schema.getFields();
            for (int i = 0; i < schemaFields.size(); ++i) {
                Schema.Field field = (Schema.Field)schemaFields.get(i);
                if (field instanceof BaseCitationService.BasicField) {
                    ((BaseCitationService.BasicField)field).setOrder(i);
                }
                this.insertSchemaField(field, schemaId);
                fields[2] = field.getIdentifier();
                ok = DbCitationService.this.m_sqlService.dbWrite(statement, fields);
            }
            for (String abbrev : schema.getNamespaceAbbreviations()) {
                String namespaceUri = schema.getNamespaceUri(abbrev);
                if (abbrev == null || namespaceUri == null) continue;
                fields[0] = schemaId;
                fields[1] = "sakai:hasNamespace";
                fields[2] = namespaceUri;
                ok = DbCitationService.this.m_sqlService.dbWrite(statement, fields);
                fields[0] = namespaceUri;
                fields[1] = "sakai:hasAbbreviation";
                fields[2] = abbrev;
                ok = DbCitationService.this.m_sqlService.dbWrite(statement, fields);
            }
            if (schema.getNamespaceAbbrev() != null && !"".equals(schema.getNamespaceAbbrev().trim())) {
                fields[0] = schemaId;
                fields[1] = "sakai:namespace";
                fields[2] = schema.getNamespaceAbbrev();
                ok = DbCitationService.this.m_sqlService.dbWrite(statement, fields);
            }
            return schema;
        }

        protected void deleteCitation(Citation edit) {
            String statement = "delete from " + DbCitationService.this.m_citationTableName + " where (" + DbCitationService.this.m_citationTableId + " = ?)";
            Object[] fields = new Object[]{edit.getId()};
            boolean ok = DbCitationService.this.m_sqlService.dbWrite(statement, fields);
        }

        protected void deleteCollection(CitationCollection edit) {
            String statement = "delete from " + DbCitationService.this.m_collectionTableName + " where (" + DbCitationService.this.m_collectionTableId + " = ?)";
            Object[] fields = new Object[]{edit.getId()};
            boolean ok = DbCitationService.this.m_sqlService.dbWrite(statement, fields);
            statement = "delete from " + DbCitationService.this.m_collectionOrderTableName + " where (" + DbCitationService.this.m_collectionTableId + " = ?)";
            ok = DbCitationService.this.m_sqlService.dbWrite(statement, new Object[]{edit.getId()});
        }

        protected void deleteSchema(Schema schema) {
            String statement = "delete from " + DbCitationService.this.m_schemaTableName + " where (" + DbCitationService.this.m_schemaTableId + " = ?)";
            Object[] fields = new Object[]{schema.getIdentifier()};
            boolean ok = DbCitationService.this.m_sqlService.dbWrite(statement, fields);
            if (ok) {
                String statement2 = "delete from " + DbCitationService.this.m_schemaFieldTableName + " where (" + DbCitationService.this.m_schemaTableId + " = ?)";
                ok = DbCitationService.this.m_sqlService.dbWrite(statement2, fields);
            }
        }

        protected void deleteUrl(String id) {
            String statement = "delete from " + DbCitationService.this.m_citationTableName + " where (" + DbCitationService.this.m_citationTableId + " = ?)";
            Object[] fields = new Object[]{id};
            boolean ok = DbCitationService.this.m_sqlService.dbWrite(statement, fields);
        }

        protected CitationCollection duplicateAll(String collectionId) {
            CitationCollection original = this.retrieveCollection(collectionId);
            BaseCitationService.BasicCitationCollection copy = null;
            if (original != null) {
                copy = new BaseCitationService.BasicCitationCollection(DbCitationService.this);
                for (Citation citation : original) {
                    BaseCitationService.BasicCitation newCite = new BaseCitationService.BasicCitation((BaseCitationService)DbCitationService.this, citation.getSchema().getIdentifier());
                    newCite.copy(citation);
                    copy.add(newCite);
                }
                this.commitCollection(copy);
            }
            return copy;
        }

        protected boolean getAdded(String citationId) {
            String statement = "select PROPERTY_VALUE from " + DbCitationService.this.m_citationTableName + " where (CITATION_ID = ? and PROPERTY_NAME = ?)";
            Object[] fields = new Object[]{citationId, DbCitationService.PROP_ADDED};
            List list = DbCitationService.this.m_sqlService.dbRead(statement, fields, null);
            return !list.isEmpty();
        }

        protected String getMediatype(String citationId) {
            String statement = "select PROPERTY_VALUE from " + DbCitationService.this.m_citationTableName + " where (CITATION_ID = ? and PROPERTY_NAME = ?)";
            Object[] fields = new Object[]{citationId, DbCitationService.PROP_MEDIATYPE};
            List list = DbCitationService.this.m_sqlService.dbRead(statement, fields, null);
            String rv = "unknown";
            if (!list.isEmpty()) {
                rv = (String)list.get(0);
            }
            return rv;
        }

        protected void insertSchemaField(Schema.Field field, String schemaId) {
            String risIdentifier;
            String statement = "insert into " + DbCitationService.this.m_schemaFieldTableName + " (" + DbCitationService.this.m_schemaTableId + "," + DbCitationService.this.m_schemaFieldTableId + ",PROPERTY_NAME,PROPERTY_VALUE) values ( ?, ?, ?, ? )";
            boolean ok = true;
            Object[] fields = new Object[4];
            fields[0] = schemaId;
            fields[1] = field.getIdentifier();
            if (field instanceof BaseCitationService.BasicField) {
                int order = ((BaseCitationService.BasicField)field).getOrder();
                fields[2] = "sakai:hasOrder";
                fields[3] = new Integer(order).toString();
                ok = DbCitationService.this.m_sqlService.dbWrite(statement, fields);
            }
            if (field.getNamespaceAbbreviation() != null && !"".equals(field.getNamespaceAbbreviation().trim())) {
                fields[2] = "sakai:namespace";
                fields[3] = field.getNamespaceAbbreviation();
                ok = DbCitationService.this.m_sqlService.dbWrite(statement, fields);
            }
            if (field.getLabel() != null && !"".equals(field.getLabel().trim())) {
                fields[2] = "sakai:label";
                fields[3] = field.getLabel();
                ok = DbCitationService.this.m_sqlService.dbWrite(statement, fields);
            }
            if (field.getDescription() != null && !"".equals(field.getDescription().trim())) {
                fields[2] = "sakai:description";
                fields[3] = field.getDescription();
                ok = DbCitationService.this.m_sqlService.dbWrite(statement, fields);
            }
            fields[2] = "sakai:required";
            fields[3] = new Boolean(field.isRequired()).toString();
            ok = DbCitationService.this.m_sqlService.dbWrite(statement, fields);
            fields[2] = "sakai:minCardinality";
            fields[3] = new Integer(field.getMinCardinality()).toString();
            ok = DbCitationService.this.m_sqlService.dbWrite(statement, fields);
            fields[2] = "sakai:maxCardinality";
            fields[3] = new Integer(field.getMaxCardinality()).toString();
            ok = DbCitationService.this.m_sqlService.dbWrite(statement, fields);
            if (field.getDefaultValue() != null) {
                fields[2] = "sakai:defaultValue";
                fields[3] = field.getDefaultValue().toString();
                ok = DbCitationService.this.m_sqlService.dbWrite(statement, fields);
            }
            if (field.getValueType() != null && !"".equals(field.getValueType().trim())) {
                fields[2] = "sakai:valueType";
                fields[3] = field.getValueType();
                ok = DbCitationService.this.m_sqlService.dbWrite(statement, fields);
            }
            if ((risIdentifier = field.getIdentifier("RIS")) != null && !risIdentifier.trim().equals("")) {
                fields[2] = DbCitationService.PROP_HAS_RIS_IDENTIFIER;
                fields[3] = risIdentifier;
                ok = DbCitationService.this.m_sqlService.dbWrite(statement, fields);
            }
        }

        protected void insertSchemas(Collection schemas) {
            for (Schema schema : schemas) {
                this.createSchema(schema);
            }
        }

        protected Citation retrieveCitation(String citationId) {
            String schemaId = this.getMediatype(citationId);
            boolean added = this.getAdded(citationId);
            Schema schema = this.retrieveSchema(schemaId);
            BaseCitationService.BasicCitation edit = new BaseCitationService.BasicCitation((BaseCitationService)DbCitationService.this, citationId, schema);
            edit.setAdded(added);
            String statement = "select CITATION_ID, PROPERTY_NAME, PROPERTY_VALUE from " + DbCitationService.this.m_citationTableName + " where (CITATION_ID = ?)  order by PROPERTY_NAME";
            Object[] fields = new Object[]{citationId};
            List triples = DbCitationService.this.m_sqlService.dbRead(statement, fields, (SqlReader)new TripleReader());
            for (Triple triple : triples) {
                if (!triple.isValid()) continue;
                String name = triple.getName();
                String order = "0";
                Matcher matcher = MULTIVALUED_PATTERN.matcher(name);
                if (matcher.matches()) {
                    name = matcher.group(1);
                    order = matcher.group(2);
                }
                if (DbCitationService.PROP_HAS_URL.equals(name)) {
                    String id = (String)triple.getValue();
                    fields[0] = id;
                    List urlfields = DbCitationService.this.m_sqlService.dbRead(statement, fields, (SqlReader)new TripleReader());
                    String label = null;
                    String url = null;
                    boolean addPrefix = false;
                    for (Triple urlField : urlfields) {
                        if (DbCitationService.PROP_URL_LABEL.equals(urlField.getName())) {
                            label = (String)urlField.getValue();
                            continue;
                        }
                        if (DbCitationService.PROP_URL_STRING.equals(urlField.getName())) {
                            url = (String)urlField.getValue();
                            continue;
                        }
                        if (!DbCitationService.PROP_URL_ADD_PREFIX.equals(urlField.getName())) continue;
                        String enabled = (String)urlField.getValue();
                        addPrefix = "y".equals(enabled);
                    }
                    edit.m_urls.put(id, new BaseCitationService.UrlWrapper(DbCitationService.this, label, url, addPrefix));
                    continue;
                }
                if (DbCitationService.PROP_HAS_PREFERRED_URL.equals(name)) {
                    edit.m_preferredUrl = (String)triple.getValue();
                    continue;
                }
                if (DbCitationService.PROP_DISPLAYNAME.equals(name.trim())) {
                    edit.setDisplayName(triple.getValue().toString());
                    continue;
                }
                if (DbCitationService.PROP_MEDIATYPE.equals(name) || DbCitationService.PROP_ADDED.equals(name)) continue;
                edit.setCitationProperty(name, triple.getValue());
            }
            return edit;
        }

        protected CitationCollection retrieveCollection(String collectionId) {
            String statement = "select COLLECTION_ID, PROPERTY_NAME, PROPERTY_VALUE from " + DbCitationService.this.m_collectionTableName + " where (COLLECTION_ID = ?)";
            BaseCitationService.BasicCitationCollection edit = new BaseCitationService.BasicCitationCollection((BaseCitationService)DbCitationService.this, collectionId);
            Object[] fields = new Object[]{collectionId};
            List triples = DbCitationService.this.m_sqlService.dbRead(statement, fields, (SqlReader)new TripleReader());
            int position = 1;
            for (Triple triple : triples) {
                if (!triple.isValid()) continue;
                if (triple.getName().startsWith("sakai:hasCitation")) {
                    DbCitationService.this.m_sqlService.dbWrite("INSERT INTO " + DbCitationService.this.m_collectionOrderTableName + " VALUES(?,?,?)", new Object[]{collectionId, (String)triple.getValue(), position});
                    ++position;
                    DbCitationService.this.m_sqlService.dbWrite("DELETE FROM " + DbCitationService.this.m_collectionTableName + " WHERE " + DbCitationService.this.m_collectionTableId + " = ? AND PROPERTY_NAME = '" + "sakai:hasCitation" + "' AND PROPERTY_VALUE LIKE ?", new Object[]{collectionId, (String)triple.getValue()});
                    continue;
                }
                if (triple.getName().equals(DbCitationService.PROP_MOST_RECENT_UPDATE)) {
                    try {
                        edit.m_mostRecentUpdate = Long.parseLong(triple.getValue().toString());
                    }
                    catch (Exception e) {}
                    continue;
                }
                if (!triple.getName().equals(DbCitationService.PROP_SORT_ORDER)) continue;
                try {
                    edit.setSort(triple.getValue().toString(), true);
                }
                catch (Exception e) {}
            }
            String orderStatement = "select * from " + DbCitationService.this.m_collectionOrderTableName + " where (COLLECTION_ID = ?) ORDER BY LOCATION";
            List orderTriples = DbCitationService.this.m_sqlService.dbRead(orderStatement, new Object[]{collectionId}, (SqlReader)new TripleReader());
            for (Triple orderTriple : orderTriples) {
                Citation citation = this.retrieveCitation(orderTriple.getName());
                citation.setPosition(Integer.parseInt((String)orderTriple.getValue()));
                edit.add(citation);
            }
            return edit;
        }

        protected Schema retrieveSchema(String schemaId) {
            BaseCitationService.BasicSchema schema = (BaseCitationService.BasicSchema)ThreadLocalManager.get((String)schemaId);
            if (schema == null) {
                Object[] fields;
                String statement = "select SCHEMA_ID, PROPERTY_NAME, PROPERTY_VALUE from " + DbCitationService.this.m_schemaTableName + " where (SCHEMA_ID = ?)";
                List triples = DbCitationService.this.m_sqlService.dbRead(statement, fields = new Object[]{schemaId}, (SqlReader)new TripleReader());
                if (triples.isEmpty()) {
                    schema = "unknown".equalsIgnoreCase(schemaId) ? new BaseCitationService.BasicSchema((BaseCitationService)DbCitationService.this, "unknown") : (BaseCitationService.BasicSchema)this.retrieveSchema("unknown");
                } else {
                    schema = new BaseCitationService.BasicSchema((BaseCitationService)DbCitationService.this, schemaId);
                    for (Triple triple : triples) {
                        if (!triple.isValid() || !triple.getName().equals("sakai:hasField")) continue;
                        String fieldId = (String)triple.getValue();
                        BaseCitationService.BasicField field = this.retrieveSchemaField(schemaId, fieldId);
                        schema.addField(field);
                    }
                    schema.sortFields();
                    ThreadLocalManager.set((String)schema.getIdentifier(), (Object)new BaseCitationService.BasicSchema((BaseCitationService)DbCitationService.this, schema));
                }
            } else {
                schema = new BaseCitationService.BasicSchema((BaseCitationService)DbCitationService.this, schema);
            }
            return schema;
        }

        protected BaseCitationService.BasicField retrieveSchemaField(String schemaId, String fieldId) {
            String risIdentifier;
            String defaultValue;
            String description;
            String label;
            String namespace;
            String statement = "select FIELD_ID, PROPERTY_NAME, PROPERTY_VALUE from " + DbCitationService.this.m_schemaFieldTableName + " where (SCHEMA_ID = ? and FIELD_ID = ?)";
            Object[] fields = new Object[]{schemaId, fieldId};
            Hashtable<String, Object> values = new Hashtable<String, Object>();
            List triples = DbCitationService.this.m_sqlService.dbRead(statement, fields, (SqlReader)new TripleReader());
            for (Triple triple : triples) {
                if (!triple.isValid()) continue;
                values.put(triple.getName(), triple.getValue());
            }
            String valueType = (String)values.remove("sakai:valueType");
            String required = (String)values.remove("sakai:required");
            boolean isRequired = Boolean.TRUE.toString().equalsIgnoreCase(required);
            String maxCardinality = (String)values.remove("sakai:maxCardinality");
            int max = 1;
            if (maxCardinality != null) {
                max = new Integer(maxCardinality);
            }
            String minCardinality = (String)values.remove("sakai:minCardinality");
            int min = 0;
            if (minCardinality != null) {
                min = new Integer(minCardinality);
            }
            BaseCitationService.BasicField field = new BaseCitationService.BasicField(DbCitationService.this, fieldId, valueType, true, isRequired, min, max);
            String order = (String)values.remove("sakai:hasOrder");
            if (order != null) {
                try {
                    Integer o = new Integer(order);
                    field.setOrder(o);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if ((namespace = (String)values.remove("sakai:namespace")) != null) {
                field.setNamespaceAbbreviation(namespace);
            }
            if ((label = (String)values.remove("sakai:label")) != null) {
                field.setLabel(label);
            }
            if ((description = (String)values.remove("sakai:description")) != null) {
                field.setDescription(description);
            }
            if ((defaultValue = (String)values.remove("sakai:defaultValue")) != null) {
                if (String.class.getName().equalsIgnoreCase(valueType)) {
                    field.setDefaultValue(defaultValue);
                } else if (Integer.class.getName().equalsIgnoreCase(valueType)) {
                    field.setDefaultValue(new Integer(defaultValue));
                } else if (Boolean.class.getName().equalsIgnoreCase(valueType)) {
                    field.setDefaultValue(new Boolean(defaultValue));
                } else if (Time.class.getName().equalsIgnoreCase(valueType)) {
                    field.setDefaultValue(TimeService.newTime((long)new Integer(defaultValue).longValue()));
                }
            }
            if ((risIdentifier = (String)values.remove(DbCitationService.PROP_HAS_RIS_IDENTIFIER)) != null) {
                field.setIdentifier("RIS", risIdentifier);
            }
            return field;
        }

        protected List retrieveSchemaList() {
            List schemaIds = (List)ThreadLocalManager.get((String)"DbCitationStorage.listSchemas");
            if (schemaIds == null) {
                String statement = "select distinct SCHEMA_ID from " + DbCitationService.this.m_schemaTableName + " order by SCHEMA_ID";
                schemaIds = DbCitationService.this.m_sqlService.dbRead(statement, null, null);
                ThreadLocalManager.set((String)"DbCitationStorage.listSchemas", (Object)schemaIds);
            }
            return new Vector(schemaIds);
        }

        protected List retrieveSchemas() {
            Vector<Schema> schemas = (Vector<Schema>)ThreadLocalManager.get((String)"DbCitationStorage.getSchemas");
            if (schemas == null) {
                String statement = "select SCHEMA_ID, PROPERTY_NAME, PROPERTY_VALUE from " + DbCitationService.this.m_schemaTableName + " order by SCHEMA_ID";
                List triples = DbCitationService.this.m_sqlService.dbRead(statement, null, (SqlReader)new TripleReader());
                schemas = new Vector();
                Schema schema = null;
                String schemaId = "";
                for (Triple triple : triples) {
                    if (!triple.isValid()) continue;
                    if (!schemaId.equals(triple.getId())) {
                        schemaId = triple.getId();
                        schema = new BaseCitationService.BasicSchema((BaseCitationService)DbCitationService.this, schemaId);
                        schemas.add(schema);
                    }
                    if (!triple.getName().equals("sakai:hasField")) continue;
                    String string = (String)triple.getValue();
                    BaseCitationService.BasicField field = this.retrieveSchemaField(schemaId, string);
                    schema.addField(field);
                }
                for (BaseCitationService.BasicSchema basicSchema : schemas) {
                    basicSchema.sortFields();
                }
                ThreadLocalManager.set((String)"DbCitationStorage.getSchemas", schemas);
            }
            Vector<Schema> rv = new Vector<Schema>();
            for (Schema schema : schemas) {
                rv.add(new BaseCitationService.BasicSchema((BaseCitationService)DbCitationService.this, schema));
            }
            schemas = rv;
            return schemas;
        }

        protected void reviseSchema(Schema schema) {
            this.deleteSchema(schema);
            this.createSchema(schema);
        }

        protected void reviseSchemas(Collection schemas) {
            for (Schema schema : schemas) {
                this.reviseSchema(schema);
            }
        }

        protected boolean validCitation(String citationId) {
            String statement = "select " + DbCitationService.this.m_citationTableId + " from " + DbCitationService.this.m_citationTableName + " where ( " + DbCitationService.this.m_citationTableId + " = ? )";
            Object[] fields = new Object[]{citationId};
            List rows = DbCitationService.this.m_sqlService.dbRead(statement, fields, null);
            boolean found = !rows.isEmpty();
            return found;
        }

        protected boolean validCollection(String collectionId) {
            String statement = "select " + DbCitationService.this.m_collectionTableId + " from " + DbCitationService.this.m_collectionTableName + " where (" + DbCitationService.this.m_collectionTableId + " = ?)";
            Object[] fields = new Object[]{collectionId};
            List rows = DbCitationService.this.m_sqlService.dbRead(statement, fields, null);
            boolean found = !rows.isEmpty();
            return found;
        }

        protected boolean validSchema(String schemaId) {
            String statement = "select " + DbCitationService.this.m_schemaTableId + " from " + DbCitationService.this.m_schemaTableName + " where (" + DbCitationService.this.m_schemaTableId + " = ?)";
            Object[] fields = new Object[]{schemaId};
            List rows = DbCitationService.this.m_sqlService.dbRead(statement, fields, null);
            boolean found = !rows.isEmpty();
            return found;
        }

        @Override
        public long mostRecentUpdate(String collectionId) {
            String statement = "select PROPERTY_VALUE from " + DbCitationService.this.m_collectionTableName + " where (COLLECTION_ID = ? and PROPERTY_NAME = ?)";
            Object[] fields = new Object[]{collectionId, DbCitationService.PROP_MOST_RECENT_UPDATE};
            List list = DbCitationService.this.m_sqlService.dbRead(statement, fields, null);
            long time = 0L;
            if (list != null && !list.isEmpty()) {
                try {
                    time = Long.parseLong(list.get(0).toString());
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return time;
        }
    }
}

