/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.citation.impl.openurl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.citation.impl.openurl.ContextObject;
import org.sakaiproject.citation.impl.openurl.ContextObjectEntity;
import org.sakaiproject.citation.impl.openurl.Format;
import org.sakaiproject.citation.impl.openurl.URLBuilder;
import org.sakaiproject.citation.impl.openurl.Utils;

public class KEVFormat
implements Format {
    private static final Log log = LogFactory.getLog(KEVFormat.class);
    private static List<EntityFormatter> entityFormatters = new ArrayList<EntityFormatter>();
    public static String FORMAT_ID = "info:ofi/fmt:kev:mtx:ctx";

    @Override
    public boolean canHandle(String format) {
        return FORMAT_ID.equals(format);
    }

    @Override
    public ContextObject parse(String data) {
        if (data == null) {
            return null;
        }
        Map<String, String[]> source = Utils.split(data);
        String encoding = Utils.getValue(source, "ctx_enc");
        if (encoding == null) {
            encoding = "UTF-8";
        } else if (encoding.startsWith("info:ofi/enc:")) {
            encoding = encoding.substring("info:ofi/enc:".length());
        }
        try {
            source = Utils.decode(source, encoding);
        }
        catch (IllegalArgumentException iae) {
            log.warn((Object)("Specified decoding failed. " + iae.getMessage()));
            source = Utils.decode(source, "UTF-8");
        }
        ContextObject contextObject = new ContextObject();
        for (Map.Entry<String, String[]> entry : source.entrySet()) {
            String key = entry.getKey();
            block3: for (String value : entry.getValue()) {
                if (key == null || key.length() < 1) {
                    log.debug((Object)("Ignoring empty key with value: " + value));
                    continue;
                }
                if (key.equals("ctx_ver")) {
                    if ("Z39.88-2004".equals(value)) {
                        log.warn((Object)"Context object doesn't match required version, continuing anyway.");
                    }
                } else if (key.equals("ctx_tim") || key.equals("ctx_id")) {
                    // empty if block
                }
                for (EntityFormatter parser : entityFormatters) {
                    if (!parser.canParse(key)) continue;
                    parser.parse(contextObject, key, value);
                    continue block3;
                }
            }
        }
        return contextObject;
    }

    @Override
    public String encode(ContextObject contextObject) {
        StringBuilder output = new StringBuilder();
        output.append("&ctx_id=Z39.88-2004");
        output.append("&ctx_enc=UTF-8");
        for (EntityFormatter encoder : entityFormatters) {
            String coEncoded = encoder.encode(contextObject);
            if (coEncoded == null || coEncoded.length() <= 0) continue;
            output.append('&');
            output.append(coEncoded);
        }
        return output.toString();
    }

    static {
        entityFormatters.add(new EntityFormatter("rfe", ContextObject.Entity.REFERRING_ENTITY));
        entityFormatters.add(new EntityFormatter("rft", ContextObject.Entity.REFERENT));
        entityFormatters.add(new EntityFormatter("req", ContextObject.Entity.REQUESTOR));
        entityFormatters.add(new EntityFormatter("svc", ContextObject.Entity.SERVICE_TYPE));
        entityFormatters.add(new EntityFormatter("res", ContextObject.Entity.RESOLVER));
        entityFormatters.add(new EntityFormatter("rfr", ContextObject.Entity.REFERRER));
    }

    private static class EntityFormatter {
        private static final String DAT_SUFFIX = "_dat";
        private static final String REF_SUFFIX = "_ref";
        private static final String REF_FMT_SUFFIX = "_ref_fmt";
        private static final String VAL_FMT_SUFFIX = "_val_fmt";
        private static final String ID_SUFFIX = "_id";
        private String prefix;
        private ContextObject.Entity type;

        public EntityFormatter(String prefix, ContextObject.Entity type) {
            this.type = type;
            this.prefix = prefix;
        }

        public boolean canParse(String key) {
            return key.startsWith(this.prefix);
        }

        public void parse(ContextObject co, String key, String value) {
            String keyTail = key.substring(this.prefix.length());
            ContextObjectEntity entity = co.getEntities().get((Object)this.type);
            if (entity == null) {
                entity = new ContextObjectEntity();
                co.getEntities().put(this.type, entity);
            }
            if (keyTail.equals(ID_SUFFIX)) {
                entity.addId(value);
            } else if (keyTail.equals(VAL_FMT_SUFFIX)) {
                entity.setFormat(value);
            } else if (keyTail.equals(REF_FMT_SUFFIX)) {
                entity.setRefFormat(value);
            } else if (keyTail.equals(REF_SUFFIX)) {
                entity.setRef(value);
            } else if (keyTail.equals(DAT_SUFFIX)) {
                entity.setData(value);
            } else if (keyTail.startsWith(".")) {
                String metaKey = keyTail.substring(1);
                if (metaKey.length() > 0) {
                    entity.addValue(metaKey, value);
                }
            } else {
                log.debug((Object)("Ignoring unreconised key: " + key));
            }
        }

        public String encode(ContextObject co) {
            ContextObjectEntity entity = co.getEntities().get((Object)this.type);
            if (entity == null) {
                return "";
            }
            URLBuilder output = new URLBuilder("UTF-8");
            for (String string : entity.getIds()) {
                this.addKEV(output, ID_SUFFIX, string);
            }
            this.addKEV(output, VAL_FMT_SUFFIX, entity.getFormat());
            this.addKEV(output, REF_FMT_SUFFIX, entity.getRefFormat());
            this.addKEV(output, REF_SUFFIX, entity.getRef());
            this.addKEV(output, DAT_SUFFIX, entity.getData());
            for (Map.Entry entry : entity.getValues().entrySet()) {
                for (String entryValue : (List)entry.getValue()) {
                    this.addKEV(output, "." + (String)entry.getKey(), entryValue);
                }
            }
            return output.toString();
        }

        public void addKEV(URLBuilder output, String key, Object value) {
            if (value != null) {
                output.append(this.prefix + key, value.toString());
            }
        }
    }
}

