/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.citation.impl;

import edu.indiana.lib.twinpeaks.util.SessionContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osid.OsidContext;
import org.osid.OsidException;
import org.osid.repository.Asset;
import org.osid.repository.AssetIterator;
import org.osid.repository.Repository;
import org.osid.repository.RepositoryException;
import org.osid.repository.RepositoryIterator;
import org.osid.repository.RepositoryManager;
import org.osid.shared.ObjectIterator;
import org.osid.shared.SharedException;
import org.osid.shared.Type;
import org.osid.shared.TypeIterator;
import org.sakaibrary.xserver.session.MetasearchSessionManager;
import org.sakaiproject.authz.api.SecurityAdvisor;
import org.sakaiproject.authz.cover.SecurityService;
import org.sakaiproject.citation.api.ActiveSearch;
import org.sakaiproject.citation.api.Citation;
import org.sakaiproject.citation.api.CitationCollection;
import org.sakaiproject.citation.api.CitationIterator;
import org.sakaiproject.citation.api.ConfigurationService;
import org.sakaiproject.citation.api.SearchCategory;
import org.sakaiproject.citation.api.SearchDatabase;
import org.sakaiproject.citation.api.SearchDatabaseHierarchy;
import org.sakaiproject.citation.api.SearchManager;
import org.sakaiproject.citation.cover.CitationService;
import org.sakaiproject.citation.impl.SakaiOsidLoader;
import org.sakaiproject.citation.util.api.OsidConfigurationException;
import org.sakaiproject.citation.util.api.SearchCancelException;
import org.sakaiproject.citation.util.api.SearchException;
import org.sakaiproject.citation.util.api.SearchQuery;
import org.sakaiproject.citation.util.impl.CQLSearchQuery;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.content.cover.ContentHostingService;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.cover.EntityManager;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.ServerOverloadException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.memory.api.Cache;
import org.sakaiproject.memory.api.MemoryService;
import org.sakaiproject.time.cover.TimeService;
import org.sakaiproject.tool.api.SessionManager;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class BaseSearchManager
implements SearchManager,
Observer {
    protected static int MAX_DUPLICATES = 10;
    private static Log m_log = LogFactory.getLog(BaseSearchManager.class);
    public static final String SAKAI_SESSION = "sakai.session.key";
    public static final String SAKAI_KEY = "sakai.key";
    public static final String SAKAI_HOST = "sakai.host";
    public static final String SERVLET_NAME = "sakai-citations-servlet";
    public static final String WINDOW_PREFIX = "WebLearn Solo - ";
    protected static BasicType categoryAssetType;
    protected static BasicType databaseAssetType;
    protected static BasicType searchType;
    protected static BasicType repositoryType;
    protected Map<String, String> hierarchyMap = new HashMap<String, String>();
    protected SortedSet<String> updatableResources = Collections.synchronizedSortedSet(new TreeSet());
    private static Random m_generator;
    protected SessionManager m_sessionManager = null;
    protected ConfigurationService m_configService = null;
    protected ServerConfigurationService serverConfigurationService = null;
    protected String databaseHierarchyResourceRef;
    private MemoryService memoryService;
    private Cache sessionContextCache;
    private Cache metasearchSessionManagerCache;

    public void setSessionManager(SessionManager sessionManager) {
        this.m_sessionManager = sessionManager;
    }

    public void setConfigurationService(ConfigurationService configService) {
        this.m_configService = configService;
    }

    public void destroy() {
        m_log.info((Object)"BaseSearchManager.destroy()");
    }

    public ActiveSearch doNextPage(ActiveSearch search) throws SearchException {
        boolean moreResults;
        boolean done;
        Repository repository;
        block21: {
            repository = ((BasicSearch)search).getRepository();
            AssetIterator assetIterator = ((BasicSearch)search).getAssetIterator();
            int last = search.getLastRecordIndex();
            CitationCollection citations = search.getSearchResults();
            if (citations == null) {
                citations = CitationService.getTemporaryCollection();
                ((BasicSearch)search).setSearchResults(citations);
            }
            Set duplicateCheck = ((BasicSearch)search).getDuplicateCheck();
            int duplicateCount = 0;
            done = false;
            moreResults = false;
            try {
                moreResults = assetIterator.hasNextAsset();
                while (!done && moreResults) {
                    block20: {
                        try {
                            Asset asset = assetIterator.nextAsset();
                            Citation citation = CitationService.getTemporaryCitation((Asset)asset);
                            String dupCheckCriteria = citation.hasPreferredUrl() ? citation.getPrimaryUrl() : citation.getOpenurlParameters();
                            m_log.debug((Object)("DUP CHECK: " + dupCheckCriteria));
                            if (((BasicSearch)search).isDuplicateCheckEnabled() && duplicateCheck.contains(dupCheckCriteria)) {
                                m_log.debug((Object)("Duplicate #" + (duplicateCount + 1) + " found"));
                                if (duplicateCount++ >= MAX_DUPLICATES) {
                                    ((BasicSearch)search).setDuplicateCheckEnabled(false);
                                }
                                moreResults = assetIterator.hasNextAsset();
                                continue;
                            }
                            ((BasicSearch)search).m_pageOrder.add(citation.getId());
                            citations.add(citation);
                            duplicateCheck.add(dupCheckCriteria);
                            duplicateCount = 0;
                            done = citations.size() >= last;
                        }
                        catch (RepositoryException re) {
                            if (re.getMessage().equals("Metasearch session has timed out. Please restart your search session.") || re.getMessage().equals("Metasearch error has occured. Please contact your site's support team.") || re.getMessage().equals("Iterator has no more elements ") || re.getMessage().equals("Operation failed ")) {
                                search.setLastPage(true);
                                m_log.warn((Object)("doNextPage -- RepositoryException nextAsset(): " + re.getMessage()));
                                String message = this.getSearchStatusMessage(repository);
                                if (message == null) {
                                    throw new SearchException(re.getMessage());
                                }
                                throw new SearchException(message);
                            }
                            if (!re.getMessage().equals("An Asset is available, but has not yet been fetched.")) break block20;
                            try {
                                Thread.sleep(2500L);
                            }
                            catch (InterruptedException ie) {
                                search.setLastPage(true);
                                m_log.warn((Object)"doNextPage -- InterruptedException nextAsset(): ", (Throwable)ie);
                                String message = this.getSearchStatusMessage(repository);
                                throw new SearchException(message);
                            }
                        }
                    }
                    moreResults = assetIterator.hasNextAsset();
                }
            }
            catch (RepositoryException re) {
                if (!re.getMessage().equals("Metasearch session has timed out. Please restart your search session.") && !re.getMessage().equals("Metasearch error has occured. Please contact your site's support team.")) break block21;
                search.setLastPage(true);
                m_log.warn((Object)("doNextPage -- RepositoryException hasNextAsset(): " + re.getMessage()));
                String message = this.getSearchStatusMessage(repository);
                throw new SearchException(message);
            }
        }
        Type statusType = this.getPropertyType(repository);
        org.osid.shared.Properties statusProperties = null;
        try {
            statusProperties = repository.getPropertiesByType(statusType);
        }
        catch (RepositoryException re) {
            search.setLastPage(true);
            String message = this.getSearchStatusMessage(repository);
            throw new SearchException(message);
        }
        Integer numRecordsFound = null;
        Integer numRecordsFetched = null;
        Integer numRecordsMerged = null;
        try {
            numRecordsFound = (Integer)statusProperties.getProperty((Serializable)((Object)"numRecordsFound"));
            numRecordsFetched = (Integer)statusProperties.getProperty((Serializable)((Object)"numRecordsFetched"));
            numRecordsMerged = (Integer)statusProperties.getProperty((Serializable)((Object)"numRecordsMerged"));
        }
        catch (SharedException se) {
            search.setLastPage(true);
            String message = this.getSearchStatusMessage(repository);
            throw new SearchException(message);
        }
        search.setNumRecordsFound(numRecordsFound);
        search.setNumRecordsFetched(numRecordsFetched);
        search.setNumRecordsMerged(numRecordsMerged);
        search.setNewSearch(false);
        search.setFirstPage(false);
        if (!moreResults) {
            search.setLastPage(true);
        } else if (done) {
            search.setLastPage(false);
        } else {
            search.setLastPage(true);
        }
        return search;
    }

    public ActiveSearch doPrevPage(ActiveSearch search) throws SearchException {
        return search;
    }

    public ActiveSearch doSearch(ActiveSearch search) throws SearchException, SearchCancelException {
        Integer pageSize = search.getPageSize();
        Integer startRecord = search.getStartRecord();
        String sortBy = search.getSortBy();
        String guid = search.getSearchId();
        String[] searchDbs = search.getDatabaseIds();
        SearchDatabaseHierarchy hierarchy = this.getSearchHierarchy();
        if (hierarchy == null) {
            throw new SearchException("ERROR: No appropriate database hierarchy available");
        }
        Repository repository = hierarchy.getRepository();
        String cqlQuery = null;
        CQLSearchQuery cqlSearch = new CQLSearchQuery();
        cqlQuery = search.getSearchType().equalsIgnoreCase("basic") ? cqlSearch.getCQLSearchQueryString(search.getBasicQuery()) : cqlSearch.getCQLSearchQueryString(search.getAdvancedQuery());
        m_log.debug((Object)("CQL query: " + cqlQuery));
        try {
            boolean moreResults;
            boolean done;
            AssetIterator assetIterator;
            block22: {
                if (cqlQuery == null) {
                    throw new SearchException("ERROR: could not properly convert search criteria to CQL.");
                }
                Properties properties = new Properties();
                properties.put("guid", guid);
                properties.put("baseUrl", this.m_configService.getSiteConfigMetasearchBaseUrl());
                properties.put("username", this.m_configService.getSiteConfigMetasearchUsername());
                properties.put("password", this.m_configService.getSiteConfigMetasearchPassword());
                properties.put("sortBy", sortBy);
                properties.put("pageSize", pageSize);
                properties.put("startRecord", startRecord);
                ArrayList<String> databaseIds = new ArrayList<String>();
                for (String databaseId : searchDbs) {
                    databaseIds.add(databaseId);
                }
                properties.put("databaseIds", databaseIds);
                BasicSearchProperties searchProperties = new BasicSearchProperties(properties);
                Type searchType = this.getSearchType(repository);
                assetIterator = repository.getAssetsBySearch((Serializable)((Object)cqlQuery), searchType, (org.osid.shared.Properties)searchProperties);
                CitationCollection citations = search.getSearchResults();
                if (citations == null) {
                    citations = CitationService.getTemporaryCollection();
                    ((BasicSearch)search).setSearchResults(citations);
                }
                Set duplicateCheck = ((BasicSearch)search).getDuplicateCheck();
                int duplicateCount = 0;
                int assetsRetrieved = 0;
                done = false;
                moreResults = false;
                try {
                    moreResults = assetIterator.hasNextAsset();
                    while (!done && moreResults) {
                        block21: {
                            try {
                                Asset asset = assetIterator.nextAsset();
                                Citation citation = CitationService.getTemporaryCitation((Asset)asset);
                                String dupCheckCriteria = citation.hasPreferredUrl() ? citation.getPrimaryUrl() : citation.getOpenurlParameters();
                                m_log.debug((Object)("DUP CHECK: " + dupCheckCriteria));
                                if (((BasicSearch)search).isDuplicateCheckEnabled() && duplicateCheck.contains(dupCheckCriteria)) {
                                    m_log.debug((Object)("Duplicate #" + (duplicateCount + 1) + " found"));
                                    if (duplicateCount++ >= MAX_DUPLICATES) {
                                        ((BasicSearch)search).setDuplicateCheckEnabled(false);
                                    }
                                    moreResults = assetIterator.hasNextAsset();
                                    continue;
                                }
                                ((BasicSearch)search).m_pageOrder.add(citation.getId());
                                citations.add(citation);
                                duplicateCheck.add(dupCheckCriteria);
                                duplicateCount = 0;
                                if (++assetsRetrieved >= pageSize) {
                                    done = true;
                                }
                            }
                            catch (RepositoryException re) {
                                if (re.getMessage().equals("Metasearch session has timed out. Please restart your search session.") || re.getMessage().equals("Metasearch error has occured. Please contact your site's support team.") || re.getMessage().equals("Iterator has no more elements ") || re.getMessage().equals("Operation failed ")) {
                                    search.setLastPage(true);
                                    search.resetSearch();
                                    String message = this.getSearchStatusMessage(repository);
                                    m_log.warn((Object)("doSearch -- RepositoryException nextAsset(): " + re.getMessage()));
                                    throw new SearchException(message);
                                }
                                if (!re.getMessage().equals("An Asset is available, but has not yet been fetched.")) break block21;
                                try {
                                    Thread.sleep(2500L);
                                }
                                catch (InterruptedException ie) {
                                    throw new SearchCancelException();
                                }
                            }
                        }
                        moreResults = assetIterator.hasNextAsset();
                    }
                }
                catch (RepositoryException re) {
                    if (!re.getMessage().equals("Metasearch session has timed out. Please restart your search session.") && !re.getMessage().equals("Metasearch error has occured. Please contact your site's support team.")) break block22;
                    search.setLastPage(true);
                    String message = this.getSearchStatusMessage(repository);
                    m_log.warn((Object)("doSearch -- RepositoryException hasNextAsset(): " + re.getMessage()));
                    throw new SearchException(message);
                }
            }
            Type statusType = this.getPropertyType(repository);
            org.osid.shared.Properties statusProperties = repository.getPropertiesByType(statusType);
            Integer numRecordsFound = null;
            Integer numRecordsFetched = null;
            Integer numRecordsMerged = null;
            try {
                numRecordsFetched = (Integer)statusProperties.getProperty((Serializable)((Object)"numRecordsFetched"));
                numRecordsFound = (Integer)statusProperties.getProperty((Serializable)((Object)"numRecordsFound"));
                numRecordsMerged = (Integer)statusProperties.getProperty((Serializable)((Object)"numRecordsMerged"));
            }
            catch (SharedException se) {
                search.setLastPage(true);
                String message = this.getSearchStatusMessage(repository);
                throw new SearchException(message);
            }
            search.setNumRecordsFound(numRecordsFound);
            search.setNumRecordsFetched(numRecordsFetched);
            search.setNumRecordsMerged(numRecordsMerged);
            search.setNewSearch(false);
            search.setFirstPage(false);
            if (!moreResults) {
                search.setLastPage(true);
            } else {
                search.setLastPage(!done);
            }
            ((BasicSearch)search).setRepository(repository);
            ((BasicSearch)search).setAssetIterator(assetIterator);
            return search;
        }
        catch (RepositoryException re) {
            m_log.warn((Object)("doSearch -- RepositoryException: " + re.getMessage()));
            throw new SearchException(re.getMessage());
        }
    }

    protected String newSearchId() {
        return this.m_sessionManager.getCurrentSession().getId();
    }

    protected Type getPropertyType(Repository repository) throws SearchException {
        TypeIterator propertyTypes = null;
        Type propertyType = null;
        try {
            propertyTypes = repository.getPropertyTypes();
            while (propertyTypes.hasNextType()) {
                Type tempType = propertyTypes.nextType();
                if (!tempType.getAuthority().equals("sakaibrary") || !tempType.getDomain().equals("properties") || !tempType.getKeyword().equals("metasearchStatus")) continue;
                propertyType = tempType;
                break;
            }
        }
        catch (OsidException oe) {
            m_log.warn((Object)("getPropertyType -- OsidException: " + oe.getMessage()));
            throw new SearchException("ERROR in getting search types: " + oe.getMessage());
        }
        return propertyType;
    }

    protected Type getCategoryType(Repository repository) throws SearchException {
        TypeIterator assetTypes = null;
        try {
            assetTypes = repository.getAssetTypes();
            while (assetTypes.hasNextType()) {
                Type tempType = assetTypes.nextType();
                if (!tempType.isEqual((Type)categoryAssetType)) continue;
                return tempType;
            }
        }
        catch (OsidException oe) {
            m_log.warn((Object)"getCategoryType -- OsidException: ", (Throwable)oe);
            throw new SearchException("ERROR in getting category type: " + oe.getMessage());
        }
        return null;
    }

    protected Type getSearchType(Repository repository) throws SearchException {
        TypeIterator searchTypes = null;
        try {
            searchTypes = repository.getSearchTypes();
            while (searchTypes.hasNextType()) {
                Type tempType = searchTypes.nextType();
                if (!tempType.isEqual((Type)searchType)) continue;
                return tempType;
            }
        }
        catch (OsidException oe) {
            m_log.warn((Object)"getSearchType -- OsidException: ", (Throwable)oe);
            throw new SearchException("ERROR in getting search types: " + oe.getMessage());
        }
        return null;
    }

    protected String getSearchStatusMessage(Repository repository) throws SearchException {
        BasicType statusType = new BasicType("sakaibrary", "properties", "metasearchStatus");
        String message = null;
        try {
            org.osid.shared.Properties statusProperties = repository.getPropertiesByType((Type)statusType);
            message = (String)((Object)statusProperties.getProperty((Serializable)((Object)"statusMessage")));
        }
        catch (RepositoryException e) {
            m_log.warn((Object)("getSearchStatusMessage RepositoryException getting properties " + e.getMessage()));
        }
        catch (SharedException e) {
            m_log.warn((Object)("getSearchStatusMessage SharedException getting property " + e.getMessage()));
        }
        return message;
    }

    public void init() {
        this.sessionContextCache = this.memoryService.getCache("org.sakaiproject.citation.api.SearchManager.sessionContextCache");
        SessionContext.setCache((Cache)this.sessionContextCache);
        this.metasearchSessionManagerCache = this.memoryService.getCache("org.sakaiproject.citation.api.SearchManager.metasearchSessionManagerCache");
        MetasearchSessionManager.setCache((Cache)this.metasearchSessionManagerCache);
        m_log.info((Object)"BaseSearchManager.init()");
        EventTrackingService.addObserver((Observer)this);
        long seed = TimeService.newTime().getTime();
        m_generator = new Random(seed);
        this.setupTypes();
        String configFolderRef = this.m_configService.getConfigFolderReference();
        Collection hierarchyIds = this.m_configService.getAllCategoryXml();
        for (String hierarchyId : hierarchyIds) {
            this.updateHierarchy(configFolderRef + hierarchyId);
            this.updatableResources.add(configFolderRef + hierarchyId);
        }
    }

    protected void setupTypes() {
        categoryAssetType = new BasicType("sakaibrary", "asset", "category");
        databaseAssetType = new BasicType("sakaibrary", "asset", "database");
        searchType = new BasicType("sakaibrary", "search", "asynchMetasearch");
        repositoryType = new BasicType("sakaibrary", "repository", "metasearch");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchDatabaseHierarchy getSearchHierarchy() throws SearchException {
        block6: {
            try {
                String xmlContent;
                String configFolderRef = this.m_configService.getConfigFolderReference();
                String hierarchyXml = this.m_configService.getDatabaseHierarchyXml();
                if (this.isNull(configFolderRef) || this.isNull(hierarchyXml)) break block6;
                String hierarchyRef = configFolderRef + hierarchyXml;
                m_log.debug((Object)("Looking for hierarchy: " + hierarchyRef));
                BaseSearchManager baseSearchManager = this;
                synchronized (baseSearchManager) {
                    xmlContent = this.hierarchyMap.get(hierarchyRef);
                    if (xmlContent == null) {
                        return null;
                    }
                }
                BasicSearchDatabaseHierarchy hierarchy = new BasicSearchDatabaseHierarchy(xmlContent);
                return hierarchy.isConfigured() ? hierarchy : null;
            }
            catch (OsidConfigurationException exception) {
                m_log.warn((Object)("Failed to get configuration details: " + (Object)((Object)exception)));
            }
        }
        return null;
    }

    public synchronized void updateHierarchy(String databaseXmlReference) {
        try {
            String xmlContent = this.getResourceContent(databaseXmlReference);
            if (xmlContent != null) {
                this.hierarchyMap.put(databaseXmlReference, xmlContent);
            }
        }
        catch (Exception exception) {
            m_log.warn((Object)("Failed to load " + databaseXmlReference + " (no changes made): " + exception));
        }
    }

    public ActiveSearch newSearch() {
        return new BasicSearch();
    }

    public ActiveSearch newSearch(CitationCollection savedResults) {
        return new BasicSearch(savedResults);
    }

    protected boolean paramIsEmpty(String param) {
        return param.trim().equals("");
    }

    public String getGoogleScholarUrl(String resourceId) {
        String serverUrl = this.serverConfigurationService.getServerUrl();
        try {
            return this.m_configService.getSiteConfigGoogleBaseUrl() + "?sciui=2&as_sdt=0,15&" + "linkurl_base=" + URLEncoder.encode(serverUrl + "/" + SERVLET_NAME + "/" + resourceId + "?" + SAKAI_SESSION + "=nada&", "UTF-8") + "&linkurl_id=" + URLEncoder.encode(this.m_configService.getSiteConfigSakaiServerKey(), "UTF-8");
        }
        catch (Exception e) {
            m_log.warn((Object)"getGoogleScholarUrl encoding failed", (Throwable)e);
            return null;
        }
    }

    public String getSaveciteUrl(String resourceId, String saveciteClientId) {
        StringBuilder buf = new StringBuilder();
        String serverUrl = this.serverConfigurationService.getServerUrl();
        buf.append(serverUrl);
        buf.append("/");
        buf.append(SERVLET_NAME);
        buf.append("/");
        buf.append(resourceId);
        buf.append('?');
        buf.append(SAKAI_SESSION);
        buf.append("=nada&client=");
        buf.append(saveciteClientId);
        return buf.toString();
    }

    public String getExternalSearchWindowName(String resourceId) {
        String serverUrl = this.serverConfigurationService.getServerUrl() + "/" + SERVLET_NAME + "/" + resourceId;
        try {
            String encodedUrl = URLEncoder.encode(serverUrl, "UTF-8");
            return WINDOW_PREFIX + encodedUrl;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Does anywhere not have UTF-8?", e);
        }
    }

    public ServerConfigurationService getServerConfigurationService() {
        return this.serverConfigurationService;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable arg0, Object arg1) {
        Event event;
        if (arg1 instanceof Event && (event = (Event)arg1).getModify()) {
            String refstr = event.getResource();
            BaseSearchManager baseSearchManager = this;
            synchronized (baseSearchManager) {
                if (this.updatableResources.contains(refstr)) {
                    m_log.debug((Object)("Updating configuration from " + refstr));
                    this.updateHierarchy(refstr);
                }
            }
        }
    }

    protected SecurityAdvisor enableSecurityAdvisor() {
        SecurityAdvisor advisor = new SecurityAdvisor(){

            public SecurityAdvisor.SecurityAdvice isAllowed(String userId, String function, String reference) {
                return SecurityAdvisor.SecurityAdvice.ALLOWED;
            }
        };
        SecurityService.pushAdvisor((SecurityAdvisor)advisor);
        return advisor;
    }

    public String getResourceContent(ContentResource resource) throws IOException, ServerOverloadException {
        int count;
        InputStream input = resource.streamContent();
        StringBuilder content = new StringBuilder();
        byte[] bytesIn = new byte[8192];
        while ((count = input.read(bytesIn)) != -1) {
            content.append(new String(bytesIn, 0, count, "UTF-8"));
        }
        return content.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResourceContent(String resourceReference) throws IOException, IdUnusedException, PermissionException, ServerOverloadException, TypeException {
        String content;
        block10: {
            boolean found;
            content = null;
            Reference reference = EntityManager.newReference((String)resourceReference);
            if (reference == null) {
                return null;
            }
            SecurityAdvisor pushed = this.enableSecurityAdvisor();
            try {
                ContentResource resource = ContentHostingService.getResource((String)reference.getId());
                if (resource != null) {
                    content = this.getResourceContent(resource);
                }
                if (pushed == null) break block10;
                found = false;
            }
            catch (Exception e) {
                boolean found2;
                try {
                    m_log.warn((Object)("getReourceContent() " + e));
                    if (pushed == null) break block10;
                    found2 = false;
                }
                catch (Throwable throwable) {
                    if (pushed != null) {
                        boolean found3 = false;
                        while (SecurityService.hasAdvisors() && !found3) {
                            SecurityAdvisor popped = SecurityService.popAdvisor();
                            found3 = popped == pushed;
                        }
                    }
                    throw throwable;
                }
                while (SecurityService.hasAdvisors() && !found2) {
                    SecurityAdvisor popped = SecurityService.popAdvisor();
                    found2 = popped == pushed;
                }
            }
            while (SecurityService.hasAdvisors() && !found) {
                SecurityAdvisor popped = SecurityService.popAdvisor();
                found = popped == pushed;
            }
        }
        return content;
    }

    private boolean isNull(String string) {
        return string == null || string.trim().equals("");
    }

    public MemoryService getMemoryService() {
        return this.memoryService;
    }

    public void setMemoryService(MemoryService memoryService) {
        this.memoryService = memoryService;
    }

    public class BasicSearchDatabaseHierarchy
    extends DefaultHandler
    implements SearchDatabaseHierarchy {
        protected String repositoryPkgName;
        protected List<String> groups;
        protected BasicSearchCategory rootCategory;
        protected Map<String, SearchDatabase> databaseMap;
        protected Map<String, SearchCategory> categoryMap;
        protected SearchCategory defaultCategory;
        protected boolean isConfigured;
        protected StringBuilder textBuffer;
        protected boolean recommendedDatabaseFlag;
        protected int hierarchyDepth;
        protected Stack<BasicSearchCategory> categoryStack;
        protected BasicSearchDatabase currentDatabase;
        protected String currentDatabaseId;

        public BasicSearchDatabaseHierarchy(String xmlContent) {
            if (BaseSearchManager.this.m_configService == null) {
                m_log.warn((Object)"BasicSearchDatabaseHierarchy() m_configService is null - components.xml injection did not work... getting instance from cover");
                BaseSearchManager.this.m_configService = org.sakaiproject.citation.cover.ConfigurationService.getInstance();
            }
            this.isConfigured = false;
            try {
                this.repositoryPkgName = BaseSearchManager.this.m_configService.getSiteConfigOsidPackageName();
                if (BaseSearchManager.this.isNull(this.repositoryPkgName)) {
                    return;
                }
                this.groups = BaseSearchManager.this.m_configService.getGroupIds();
                this.recommendedDatabaseFlag = false;
                this.hierarchyDepth = 0;
                this.databaseMap = new Hashtable<String, SearchDatabase>();
                this.categoryMap = new Hashtable<String, SearchCategory>();
                this.categoryStack = new Stack();
                this.parseXML(xmlContent);
            }
            catch (Exception exception) {
                m_log.warn((Object)"Exception seen in BasicSearchDatabaseHierarchy() constructor", (Throwable)exception);
            }
        }

        protected void parseXML(String xmlContent) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            InputSource source = new InputSource(new StringReader(xmlContent));
            try {
                SAXParser saxParser = factory.newSAXParser();
                saxParser.parse(source, (DefaultHandler)this);
                m_log.debug((Object)("After parse, categories found = " + this.categoryMap.size()));
                this.isConfigured = this.categoryMap.size() > 0;
            }
            catch (SAXParseException spe) {
                Exception x = spe;
                if (spe.getException() != null) {
                    x = spe.getException();
                }
                m_log.warn((Object)("parseXML() parsing exception: " + spe.getMessage() + " - xml line " + spe.getLineNumber() + ", uri " + spe.getSystemId()), (Throwable)x);
                this.isConfigured = false;
            }
            catch (SAXException sxe) {
                Exception x = sxe;
                if (sxe.getException() != null) {
                    x = sxe.getException();
                }
                m_log.warn((Object)("parseXML() SAX exception: " + sxe.getMessage()), (Throwable)x);
                this.isConfigured = false;
            }
            catch (ParserConfigurationException pce) {
                m_log.warn((Object)"parseXML() SAX parser cannot be built with specified options");
                this.isConfigured = false;
            }
            catch (IOException ioe) {
                m_log.warn((Object)"parseXML() IO exception", (Throwable)ioe);
                this.isConfigured = false;
            }
            catch (Throwable t) {
                m_log.warn((Object)"parseXML() exception", t);
                this.isConfigured = false;
            }
        }

        protected void setDefaultCategory(SearchCategory defaultCategory) {
            if (defaultCategory != null) {
                this.defaultCategory = defaultCategory;
            } else {
                m_log.warn((Object)"BasicSearchDatabaseHierarchy.setDefaultCategory() was passed a null SearchCategory to set");
            }
        }

        protected void addTopLevelCategory(SearchCategory topLevelCategory) {
            if (topLevelCategory != null) {
                if (this.rootCategory == null) {
                    this.rootCategory = new BasicSearchCategory("root", "!root");
                }
                this.rootCategory.addSubcategory(topLevelCategory);
            } else {
                m_log.warn((Object)"BasicSearchDatabaseHierarchy.addTopLevelCategory() was passed a null SearchCategory to add");
            }
        }

        @Override
        public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
            String eName = sName;
            if (eName.equals("")) {
                eName = qName;
            }
            if (eName.equals("category")) {
                BasicSearchCategory newCategory = new BasicSearchCategory(attrs.getValue("name"), attrs.getValue("id"));
                if (attrs.getValue("default") != null) {
                    newCategory.setDefault(true);
                }
                this.categoryStack.push(newCategory);
            } else if (eName.equals("database")) {
                this.currentDatabase = new BasicSearchDatabase(attrs.getValue("name"), attrs.getValue("id"));
            } else if (eName.equals("category_database") && attrs.getValue("recommended") != null) {
                this.recommendedDatabaseFlag = true;
            }
        }

        @Override
        public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
            String eName = sName;
            if (eName.equals("")) {
                eName = qName;
            }
            this.parseData(eName);
        }

        @Override
        public void characters(char[] buf, int offset, int len) throws SAXException {
            String s = new String(buf, offset, len);
            if (this.textBuffer == null) {
                this.textBuffer = new StringBuilder(s);
            } else {
                this.textBuffer.append(s);
            }
        }

        protected String getAttribute(Attributes attrs, String attrName) {
            if (attrs != null) {
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String name = attrs.getLocalName(i);
                    if (name.equals("")) {
                        name = attrs.getQName(i);
                    }
                    if (!name.equals(attrName)) continue;
                    return attrs.getValue(i);
                }
            }
            return null;
        }

        protected void parseData(String endElement) {
            String text = null;
            if (this.textBuffer != null) {
                text = this.textBuffer.toString().trim();
            }
            if (endElement.equals("category_description")) {
                BasicSearchCategory temp = this.categoryStack.pop();
                temp.updateDescription(text);
                this.categoryStack.push(temp);
            } else if (endElement.equals("category")) {
                if (!this.categoryStack.peek().isDefault()) {
                    this.categoryMap.put(this.categoryStack.peek().getId(), this.categoryStack.peek());
                    if (this.categoryStack.size() == 1) {
                        this.addTopLevelCategory(this.categoryStack.pop());
                    } else {
                        if (this.hierarchyDepth < this.categoryStack.size()) {
                            this.hierarchyDepth = this.categoryStack.size();
                        }
                        BasicSearchCategory subcategory = this.categoryStack.pop();
                        BasicSearchCategory parentCategory = this.categoryStack.pop();
                        parentCategory.addSubcategory(subcategory);
                        this.categoryStack.push(parentCategory);
                    }
                } else {
                    this.defaultCategory = this.categoryStack.pop();
                }
            } else if (endElement.equals("id")) {
                this.currentDatabaseId = text;
                if (this.recommendedDatabaseFlag) {
                    this.recommendedDatabaseFlag = false;
                    BasicSearchCategory temp = this.categoryStack.pop();
                    temp.addRecommendedDatabase(text);
                    this.categoryStack.push(temp);
                } else {
                    BasicSearchCategory temp = this.categoryStack.pop();
                    temp.addDatabase(text);
                    this.categoryStack.push(temp);
                }
            } else if (endElement.equals("alt_name")) {
                this.currentDatabase = new BasicSearchDatabase(text, this.currentDatabaseId);
            } else if (endElement.equals("alt_description")) {
                this.currentDatabase.updateDescription(text);
            } else if (endElement.equals("category_database")) {
                if (this.currentDatabase != null) {
                    BasicSearchCategory temp = this.categoryStack.pop();
                    temp.addAlternateDatabase(this.currentDatabase);
                    this.categoryStack.push(temp);
                    this.currentDatabase = null;
                }
            } else if (endElement.equals("database_description")) {
                this.currentDatabase.updateDescription(text);
            } else if (endElement.equals("database_group")) {
                this.currentDatabase.addGroup(text);
            } else if (endElement.equals("database")) {
                this.databaseMap.put(this.currentDatabase.getId(), this.currentDatabase);
                this.currentDatabase = null;
            }
            this.textBuffer = null;
        }

        public SearchCategory getCategory(String categoryId) {
            if (categoryId.equals(this.defaultCategory.getId())) {
                return this.defaultCategory;
            }
            return this.categoryMap.get(categoryId);
        }

        public int getNumLevels() {
            return this.hierarchyDepth;
        }

        public int getNumMaxSearchableDb() {
            int number = BaseSearchManager.this.m_configService.getSiteConfigMaximumSearchableDBs();
            m_log.debug((Object)("getNumMaxSearchableDb() returns " + number));
            return number;
        }

        public List<SearchCategory> getCategoryListing() {
            ArrayList<SearchCategory> categoryListing = new ArrayList<SearchCategory>();
            categoryListing.add(this.rootCategory);
            for (int i = 0; i <= this.categoryMap.size(); ++i) {
                SearchCategory category = (SearchCategory)categoryListing.get(i);
                if (!category.hasSubCategories()) continue;
                for (SearchCategory cat : category.getSubCategories()) {
                    categoryListing.add(cat);
                }
            }
            return categoryListing;
        }

        public Repository getRepository() {
            Repository repository = null;
            RepositoryManager repositoryManager = null;
            try {
                repositoryManager = (RepositoryManager)SakaiOsidLoader.getManager("org.osid.repository.RepositoryManager", this.repositoryPkgName, new OsidContext(), null);
                RepositoryIterator rit = null;
                if (repositoryManager == null) {
                    m_log.warn((Object)"getRepository() failed getting RepositoryManager from SakaiOsidLoader");
                } else {
                    rit = repositoryManager.getRepositoriesByType((Type)repositoryType);
                }
                if (rit == null) {
                    m_log.warn((Object)"getRepository() failed getting RepositoryIterator of type sakaibrary/repository/metasearch from RepositoryManager");
                    return null;
                }
                repository = rit.nextRepository();
                String extendedId = BaseSearchManager.this.m_configService.getSiteConfigExtendedRepositoryId();
                if (extendedId != null && extendedId.length() > 0) {
                    while (repository != null) {
                        m_log.debug((Object)("Matching Repositories? " + repository.getId().getIdString() + " VS " + extendedId));
                        if (repository.getId().getIdString().equals(extendedId)) break;
                        repository = rit.nextRepository();
                    }
                }
                if (repository == null) {
                    m_log.warn((Object)"getRepository() failed getting repository from RepositoryIterator");
                }
            }
            catch (OsidException oe) {
                m_log.warn((Object)"getRepository threw OsidException: ", (Throwable)oe);
            }
            return repository;
        }

        public SearchCategory getDefaultCategory() {
            return this.defaultCategory;
        }

        public boolean isSearchableDatabase(String databaseId) {
            return this.databaseMap.containsKey(databaseId);
        }

        public boolean isConfigured() {
            return this.isConfigured;
        }

        public class BasicSearchDatabase
        implements SearchDatabase {
            private String id;
            private String displayName;
            private String description;
            private List<String> groups;

            protected BasicSearchDatabase(String name, String id) {
                this.displayName = name;
                this.id = id;
                this.description = null;
            }

            protected void updateDescription(String description) {
                this.description = description;
            }

            protected void addGroup(String groupId) {
                if (groupId != null) {
                    if (this.groups == null) {
                        this.groups = new Vector<String>();
                    }
                    this.groups.add(groupId);
                } else {
                    m_log.warn((Object)"BasicSearchDatabase.addGroup() was passed a null groupId to add");
                }
            }

            public String getDescription() {
                return this.description;
            }

            public String getDisplayName() {
                return this.displayName;
            }

            public String getId() {
                return this.id;
            }

            public boolean isGroupMember(String groupId) {
                return this.groups.contains(groupId);
            }
        }

        public class BasicSearchCategory
        implements SearchCategory {
            private String id;
            private String displayName;
            private String description;
            private boolean defaultStatus;
            private List<SearchCategory> subcategoryList;
            private List<String> databaseList;
            private List<String> recommendedDatabases;
            private Map<String, SearchDatabase> altDatabases;

            protected BasicSearchCategory(String name, String id) {
                this.id = id;
                this.displayName = name;
                this.description = null;
                this.defaultStatus = false;
            }

            protected void updateDescription(String description) {
                this.description = description;
            }

            protected void addSubcategory(SearchCategory subcategory) {
                if (subcategory != null) {
                    if (this.subcategoryList == null) {
                        this.subcategoryList = new Vector<SearchCategory>();
                    }
                    this.subcategoryList.add(subcategory);
                } else {
                    m_log.warn((Object)"BasicSearchCategory.addSubCategory() was passed a null subcategory to add");
                }
            }

            protected void addDatabase(String databaseId) {
                if (databaseId != null) {
                    if (this.databaseList == null) {
                        this.databaseList = new Vector<String>();
                    }
                    this.databaseList.add(databaseId);
                } else {
                    m_log.warn((Object)"BasicSearchCategory.addDatabase() was passed a null databaseId to add");
                }
            }

            protected void addRecommendedDatabase(String databaseId) {
                if (databaseId != null) {
                    if (this.recommendedDatabases == null) {
                        this.recommendedDatabases = new Vector<String>();
                    }
                    this.recommendedDatabases.add(databaseId);
                    if (this.databaseList == null) {
                        this.databaseList = new Vector<String>();
                    }
                    if (!this.databaseList.contains(databaseId)) {
                        this.databaseList.add(databaseId);
                    }
                } else {
                    m_log.warn((Object)"BasicSearchCategory.addRecommendedDatabase() was passed a null databaseId to add");
                }
            }

            protected void addAlternateDatabase(SearchDatabase altDatabase) {
                if (altDatabase != null) {
                    if (this.altDatabases == null) {
                        this.altDatabases = new Hashtable<String, SearchDatabase>();
                    }
                    this.altDatabases.put(altDatabase.getId(), altDatabase);
                    if (!this.databaseList.contains(altDatabase.getId())) {
                        this.databaseList.add(altDatabase.getId());
                    }
                } else {
                    m_log.warn((Object)"BasicSearchCategory.addAlternateDatabase() was passed a null SearchDatabase to add");
                }
            }

            protected void setDefault(boolean value) {
                this.defaultStatus = value;
            }

            protected boolean isDefault() {
                return this.defaultStatus;
            }

            public boolean hasDatabases() {
                return this.databaseList != null && !this.databaseList.isEmpty();
            }

            public List<SearchDatabase> getDatabases() {
                Vector<SearchDatabase> databases = new Vector<SearchDatabase>();
                if (!this.hasDatabases()) {
                    m_log.warn((Object)("Search Library Resources Category: '" + this.displayName + "' contains no databases."));
                } else {
                    block0: for (int i = 0; i < this.databaseList.size(); ++i) {
                        String databaseId = this.databaseList.get(i);
                        SearchDatabase database = this.altDatabases != null && this.altDatabases.containsKey(databaseId) ? this.altDatabases.get(databaseId) : BasicSearchDatabaseHierarchy.this.databaseMap.get(databaseId);
                        if (database == null) {
                            m_log.warn((Object)("Unidentified Search Libary Resources database: '" + databaseId + "' in category: " + this.displayName));
                            continue;
                        }
                        for (String groupId : BasicSearchDatabaseHierarchy.this.groups) {
                            if (!database.isGroupMember(groupId)) continue;
                            databases.add(database);
                            continue block0;
                        }
                    }
                }
                return databases;
            }

            public String getDescription() {
                return this.description;
            }

            public String getDisplayName() {
                return this.displayName;
            }

            public String getId() {
                return this.id;
            }

            public boolean hasSubCategories() {
                return this.subcategoryList != null && !this.subcategoryList.isEmpty();
            }

            public List<SearchCategory> getSubCategories() {
                return this.subcategoryList;
            }

            public boolean isDatabaseRecommended(String databaseId) {
                return this.recommendedDatabases.contains(databaseId);
            }
        }
    }

    public class BasicType
    extends Type {
        protected BasicType(String authority, String domain, String keyword) {
            super(authority, domain, keyword);
        }

        public BasicType(String authority, String domain, String keyword, String description) {
            super(authority, domain, keyword, description);
        }
    }

    public class BasicSearchProperties
    implements org.osid.shared.Properties {
        protected List keys;
        protected Properties properties;
        protected Type type;

        public BasicSearchProperties(Properties properties) {
            this.type = new BasicType("sakaibrary", "properties", "asynchMetasearch");
            this.keys = new Vector();
            this.properties = properties;
            Enumeration<Object> keyNames = properties.keys();
            while (keyNames.hasMoreElements()) {
                this.keys.add((Serializable)keyNames.nextElement());
            }
        }

        public ObjectIterator getKeys() throws SharedException {
            return new BasicObjectIterator(this.keys);
        }

        public Serializable getProperty(Serializable key) throws SharedException {
            return (Serializable)this.properties.get(key);
        }

        public Type getType() throws SharedException {
            return this.type;
        }
    }

    public class BasicSearch
    implements ActiveSearch {
        protected List m_assets;
        protected List m_pageOrder;
        protected Set m_duplicateCheck;
        protected boolean m_duplicateCheckEnabled;
        protected boolean m_firstPage;
        protected String m_searchId;
        protected String m_searchType;
        protected boolean m_lastPage;
        protected boolean m_newSearch;
        protected Integer m_pageSize;
        protected Integer m_startRecord;
        protected String[] m_databaseIds;
        protected AssetIterator m_assetIterator;
        protected Integer m_numRecordsFetched;
        protected Integer m_numRecordsFound;
        protected Integer m_numRecordsMerged;
        protected Repository m_repository;
        protected String m_repositoryId;
        protected String m_repositoryName;
        protected SearchQuery m_basicQuery;
        protected SearchQuery m_advancedQuery;
        protected String m_sortBy;
        protected CitationCollection m_searchResults;
        protected CitationCollection m_savedResults;
        protected CitationIterator m_resultsIterator;
        protected Map m_index;
        protected int m_lastPageViewed = -1;
        protected CitationIterator m_searchIterator;
        protected int start = 1;
        protected int end = 10;
        protected int m_viewPageSize = 10;
        protected String statusMessage = null;
        protected Thread m_searchThread;

        public BasicSearch() {
            this.m_searchId = BaseSearchManager.this.newSearchId();
            this.m_searchType = null;
            this.m_assets = new Vector();
            this.m_pageOrder = new Vector();
            this.m_index = new Hashtable();
            this.m_duplicateCheck = new TreeSet();
            this.m_duplicateCheckEnabled = true;
            this.m_savedResults = CitationService.getTemporaryCollection();
            this.m_newSearch = true;
            this.m_firstPage = true;
            this.m_lastPage = false;
            this.m_pageSize = new Integer(10);
            this.m_startRecord = new Integer(1);
            this.m_sortBy = "rank";
            this.m_databaseIds = null;
        }

        public BasicSearch(CitationCollection searchResults) {
            this.m_searchId = BaseSearchManager.this.newSearchId();
            this.m_assets = new Vector();
            this.m_pageOrder = new Vector();
            this.m_index = new Hashtable();
            this.m_duplicateCheck = new TreeSet();
            this.m_duplicateCheckEnabled = true;
            this.m_savedResults = CitationService.getTemporaryCollection();
            this.m_newSearch = true;
            this.m_firstPage = true;
            this.m_lastPage = false;
            this.m_pageSize = new Integer(10);
            this.m_startRecord = new Integer(1);
            this.m_sortBy = "rank";
            this.m_databaseIds = null;
        }

        protected AssetIterator getAssetIterator() {
            return this.m_assetIterator;
        }

        public List getAssets() {
            return this.m_assets;
        }

        public String getSearchId() {
            return this.m_searchId;
        }

        public Integer getNumRecordsFetched() {
            return this.m_numRecordsFetched;
        }

        public Integer getNumRecordsFound() {
            return this.m_numRecordsFound;
        }

        public Integer getNumRecordsMerged() {
            return this.m_numRecordsMerged;
        }

        protected void setPageLimits(int page) throws SearchException {
        }

        public List viewPage(int page) throws SearchException, SearchCancelException {
            Vector<Citation> citations = new Vector<Citation>();
            boolean searchPerformed = false;
            if (page < 0) {
                page = 0;
            }
            int oldStart = this.start;
            int oldEnd = this.end;
            this.start = page * this.m_viewPageSize;
            this.end = this.start + this.m_viewPageSize;
            if (this.start > this.m_pageOrder.size() + 1) {
                throw new SearchException("Request beyond next page");
            }
            if (this.m_pageOrder.isEmpty()) {
                BaseSearchManager.this.doSearch(this);
                searchPerformed = true;
            } else if (this.end > this.m_pageOrder.size()) {
                try {
                    BaseSearchManager.this.doNextPage(this);
                    searchPerformed = true;
                }
                catch (SearchException e) {
                    this.start = oldStart;
                    this.end = oldEnd;
                    this.setStatusMessage(this.m_repository);
                    throw new SearchException(e.getMessage());
                }
            }
            m_log.debug((Object)(">>> viewPage() new page is " + page + ", last page is " + this.m_lastPageViewed));
            m_log.debug((Object)(">>> viewPage() was a search done? " + searchPerformed));
            m_log.debug((Object)(">>> viewPage() did we find the last page? " + this.isLastPage()));
            m_log.debug((Object)(">>> viewPage() records found = " + this.getNumRecordsFetched() + ", records rendered = " + this.m_pageOrder.size()));
            if (page < this.m_lastPageViewed) {
                this.setLastPage(false);
            }
            if (page < this.m_lastPageViewed || !searchPerformed || searchPerformed && !this.isLastPage()) {
                int estimatedHits = this.getNumRecordsFound();
                int hitsRendered = this.m_pageOrder.size();
                int pageHits = page == 0 ? this.m_viewPageSize : (page + 1) * this.m_viewPageSize;
                m_log.debug((Object)(">>> viewPage() estimate (" + estimatedHits + ") <= page size (in hits) (" + pageHits + ") ? " + (estimatedHits <= pageHits)));
                m_log.debug((Object)(">>> viewPage() records rendered (" + hitsRendered + ") < page size (in hits) (" + pageHits + ") ? " + (hitsRendered < pageHits)));
                if (estimatedHits <= pageHits || hitsRendered < pageHits) {
                    this.setLastPage(true);
                }
            }
            if (this.end > this.m_pageOrder.size()) {
                this.end = this.m_pageOrder.size();
            }
            Citation citation = null;
            for (int i = this.start; i < this.end; ++i) {
                String id = (String)this.m_pageOrder.get(i);
                try {
                    citation = this.m_searchResults.getCitation(id);
                    citations.add(citation);
                    continue;
                }
                catch (IdUnusedException e) {
                    m_log.warn((Object)("BasicSearch.getPage() unable to retrieve ciataion: " + id));
                }
            }
            this.m_lastPageViewed = page;
            return citations;
        }

        protected void setStatusMessage(Repository repository) {
            try {
                this.statusMessage = BaseSearchManager.this.getSearchStatusMessage(repository);
            }
            catch (SearchException e) {
                this.statusMessage = e.getMessage();
            }
        }

        public void setStatusMessage(String msg) {
            this.statusMessage = msg;
        }

        public void setStatusMessage() {
            this.statusMessage = null;
        }

        public String getStatusMessage() {
            return this.statusMessage;
        }

        public void setDatabaseIds(String[] databaseIds) {
            this.m_databaseIds = databaseIds;
        }

        public String[] getDatabaseIds() {
            return this.m_databaseIds;
        }

        public Integer getPageSize() {
            return this.m_pageSize;
        }

        public Repository getRepository() {
            return this.m_repository;
        }

        public String getRepositoryId() {
            return this.m_repositoryId;
        }

        public String getRepositoryName() {
            return this.m_repositoryName;
        }

        public SearchQuery getBasicQuery() {
            return this.m_basicQuery;
        }

        public String getSortBy() {
            return this.m_sortBy.toLowerCase();
        }

        public Integer getStartRecord() {
            if (this.m_startRecord < 1) {
                this.m_startRecord = new Integer(1);
            }
            return this.m_startRecord;
        }

        public boolean isFirstPage() {
            return this.m_firstPage;
        }

        public boolean isLastPage() {
            return this.m_lastPage;
        }

        public boolean isNewSearch() {
            return this.m_newSearch;
        }

        public void setAssetIterator(AssetIterator assetIterator) {
            this.m_assetIterator = assetIterator;
        }

        public void setAssets(List assets) {
            this.m_assets = assets;
        }

        public void setFirstPage(boolean firstPage) {
            this.m_firstPage = firstPage;
        }

        public void setGuid(String guid) {
            this.m_searchId = guid;
        }

        public void setLastPage(boolean lastPage) {
            this.m_lastPage = lastPage;
        }

        public void setNewSearch(boolean newSearch) {
            this.m_newSearch = newSearch;
        }

        public void setNumRecordsFetched(Integer numRecordsFetched) {
            this.m_numRecordsFetched = numRecordsFetched;
        }

        public void setNumRecordsFound(Integer numRecordsFound) {
            this.m_numRecordsFound = numRecordsFound;
        }

        public void setNumRecordsMerged(Integer numRecordsMerged) {
            this.m_numRecordsMerged = numRecordsMerged;
        }

        public void setPageSize(Integer pageSize) {
            this.m_pageSize = pageSize == null || pageSize < 1 ? new Integer(10) : pageSize;
        }

        public void setPageSize(String pageSize) {
            if (pageSize == null || pageSize.trim().equals("")) {
                this.m_pageSize = new Integer(10);
            } else {
                try {
                    this.m_pageSize = new Integer(pageSize);
                }
                catch (NumberFormatException e) {
                    this.m_pageSize = new Integer(10);
                }
            }
        }

        public void setRepository(Repository repository) {
            this.m_repository = repository;
        }

        public void setRepositoryId(String repositoryId) {
            this.m_repositoryId = repositoryId;
        }

        public void setRepositoryName(String repositoryName) {
            this.m_repositoryName = repositoryName;
        }

        public void setBasicQuery(SearchQuery basicQuery) {
            this.m_basicQuery = basicQuery;
        }

        public void setSortBy(String sortBy) {
            this.m_sortBy = sortBy;
        }

        public void setStartRecord(Integer startRecord) {
            this.m_startRecord = startRecord < 1 ? new Integer(1) : startRecord;
        }

        public CitationCollection getSearchResults() {
            return this.m_searchResults;
        }

        public void setSearchResults(CitationCollection searchResults) {
            this.m_searchResults = searchResults;
        }

        public void setStartRecord(String startRecord) {
            if (startRecord == null || startRecord.trim().equals("")) {
                this.m_startRecord = new Integer(1);
            } else {
                try {
                    this.m_startRecord = new Integer(startRecord);
                }
                catch (NumberFormatException e) {
                    this.m_startRecord = new Integer(1);
                }
            }
        }

        public Map getIndex() {
            return this.m_index;
        }

        public void setIndex(Map index) {
            this.m_index = new Hashtable(index);
        }

        public Set getDuplicateCheck() {
            if (this.m_duplicateCheck == null) {
                this.m_duplicateCheck = new TreeSet();
            }
            return this.m_duplicateCheck;
        }

        public boolean isDuplicateCheckEnabled() {
            return this.m_duplicateCheckEnabled;
        }

        public void setDuplicateCheckEnabled(boolean state) {
            this.m_duplicateCheckEnabled = state;
        }

        public void prepareForNextPage() {
            for (Citation citation : this.m_searchResults.getCitations()) {
                if (this.m_pageOrder.contains(citation.getId())) continue;
                this.m_pageOrder.add(citation.getId());
            }
            this.m_savedResults.addAll(this.m_searchResults);
            this.m_searchResults.clear();
        }

        public int getViewPageNumber() {
            return this.m_lastPageViewed;
        }

        public int getViewPageSize() {
            return this.m_viewPageSize;
        }

        public List viewPage() throws SearchException, SearchCancelException {
            return this.viewPage(0);
        }

        public int getFirstRecordIndex() {
            return this.start;
        }

        public int getLastRecordIndex() {
            return this.end;
        }

        public void setViewPageSize(int size) {
            this.m_viewPageSize = size;
        }

        public String getSearchType() {
            return this.m_searchType;
        }

        public void setSearchType(String searchType) {
            this.m_searchType = searchType;
        }

        public SearchQuery getAdvancedQuery() {
            return this.m_advancedQuery;
        }

        public void setAdvancedQuery(SearchQuery advancedQuery) {
            this.m_advancedQuery = advancedQuery;
        }

        public Thread getSearchThread() {
            return this.m_searchThread;
        }

        public void setSearchThread(Thread searchThread) {
            this.m_searchThread = searchThread;
        }

        public void resetSearch() {
            this.m_pageOrder.clear();
            this.m_searchResults.clear();
        }
    }

    public class BasicObjectIterator
    implements ObjectIterator {
        protected int i = 0;
        protected Vector vector = new Vector();

        public BasicObjectIterator(List keys) throws SharedException {
            this.vector = new Vector(keys);
        }

        public boolean hasNextObject() throws SharedException {
            return this.i < this.vector.size();
        }

        public Serializable nextObject() throws SharedException {
            if (this.i < this.vector.size()) {
                return (Serializable)this.vector.elementAt(this.i++);
            }
            throw new SharedException("Iterator has no more elements ");
        }
    }
}

