/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.citation.impl;

import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.sakaiproject.citation.api.Citation;
import org.sakaiproject.citation.api.CitationCollection;
import org.sakaiproject.citation.api.Schema;
import org.sakaiproject.citation.impl.BaseCitationService;

public class BasicCitationService
extends BaseCitationService {
    @Override
    public BaseCitationService.Storage newStorage() {
        return new BasicCitationStorage();
    }

    public class BasicCitationStorage
    implements BaseCitationService.Storage {
        protected Map m_collections = new Hashtable();
        protected Map m_citations = new Hashtable();
        protected Map m_schemas = new Hashtable();

        @Override
        public void open() {
        }

        @Override
        public void close() {
            this.m_collections.clear();
            this.m_collections = null;
            this.m_citations.clear();
            this.m_citations = null;
            this.m_schemas.clear();
            this.m_schemas = null;
        }

        @Override
        public Citation getCitation(String citationId) {
            return (Citation)this.m_citations.get(citationId);
        }

        @Override
        public CitationCollection getCollection(String collectionId) {
            return (CitationCollection)this.m_collections.get(collectionId);
        }

        @Override
        public Schema getSchema(String schemaId) {
            return (Schema)this.m_schemas.get(schemaId);
        }

        public Collection getSchemaNames() {
            return this.m_schemas.keySet();
        }

        @Override
        public List getSchemas() {
            Vector<BaseCitationService.BasicSchema> list = new Vector<BaseCitationService.BasicSchema>();
            for (String key : this.m_schemas.keySet()) {
                Schema schema = (Schema)this.m_schemas.get(key);
                list.add(new BaseCitationService.BasicSchema((BaseCitationService)BasicCitationService.this, schema));
            }
            return list;
        }

        @Override
        public Schema addSchema(Schema schema) {
            this.m_schemas.put(schema.getIdentifier(), schema);
            return schema;
        }

        @Override
        public void putSchemas(Collection schemas) {
            for (Object obj : schemas) {
                if (!(obj instanceof Schema)) continue;
                this.m_schemas.put(((Schema)obj).getIdentifier(), obj);
            }
        }

        @Override
        public boolean checkCitation(String citationId) {
            return this.m_citations.containsKey(citationId);
        }

        @Override
        public boolean checkCollection(String collectionId) {
            return this.m_collections.containsKey(collectionId);
        }

        @Override
        public boolean checkSchema(String schemaId) {
            return this.m_schemas.containsKey(schemaId);
        }

        @Override
        public List listSchemas() {
            Set names = this.m_schemas.keySet();
            return new Vector(names);
        }

        @Override
        public CitationCollection addCollection(Map attributes, List citations) {
            BaseCitationService.BasicCitationCollection edit = new BaseCitationService.BasicCitationCollection(BasicCitationService.this, attributes, citations);
            this.m_collections.put(edit.getId(), edit);
            return edit;
        }

        @Override
        public void removeCitation(Citation edit) {
            this.m_citations.remove(edit.getId());
        }

        @Override
        public void removeCollection(CitationCollection edit) {
            this.m_collections.remove(edit.getId());
        }

        @Override
        public void updateSchema(Schema schema) {
            this.m_schemas.put(schema.getIdentifier(), schema);
        }

        @Override
        public void updateSchemas(Collection schemas) {
            for (Schema schema : schemas) {
                this.m_schemas.put(schema.getIdentifier(), schema);
            }
        }

        @Override
        public void saveCitation(Citation edit) {
            this.m_citations.put(edit.getId(), edit);
        }

        @Override
        public void saveCollection(CitationCollection collection) {
            this.m_collections.put(collection.getId(), collection);
        }

        @Override
        public Citation addCitation(String mediatype) {
            BaseCitationService.BasicCitation citation = new BaseCitationService.BasicCitation((BaseCitationService)BasicCitationService.this, mediatype);
            this.m_citations.put(citation.getId(), citation);
            return citation;
        }

        @Override
        public void removeSchema(Schema schema) {
            this.m_schemas.remove(schema.getIdentifier());
        }

        @Override
        public CitationCollection copyAll(String collectionId) {
            CitationCollection original = (CitationCollection)this.m_collections.get(collectionId);
            BaseCitationService.BasicCitationCollection copy = null;
            if (original != null) {
                copy = new BaseCitationService.BasicCitationCollection(BasicCitationService.this);
                for (Citation citation : original) {
                    BaseCitationService.BasicCitation newCite = new BaseCitationService.BasicCitation(BasicCitationService.this);
                    newCite.copy(citation);
                    copy.add(newCite);
                    this.m_citations.put(newCite.getId(), newCite);
                }
                this.m_collections.put(copy.getId(), copy);
            }
            return copy;
        }

        @Override
        public long mostRecentUpdate(String collectionId) {
            return 0L;
        }
    }
}

