/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.citation.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.citation.api.Citation;
import org.sakaiproject.citation.api.CitationCollection;
import org.sakaiproject.citation.api.Schema;
import org.sakaiproject.citation.cover.CitationService;
import org.sakaiproject.citation.cover.ConfigurationService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.content.cover.ContentHostingService;
import org.sakaiproject.entity.api.EntityAccessOverloadException;
import org.sakaiproject.entity.api.EntityCopyrightException;
import org.sakaiproject.entity.api.EntityNotDefinedException;
import org.sakaiproject.entity.api.EntityPermissionException;
import org.sakaiproject.entity.api.HttpAccess;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.ServerOverloadException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.util.ResourceLoader;
import org.sakaiproject.util.Validator;

public class CitationListAccessServlet
implements HttpAccess {
    public static final String LIST_TEMPLATE = "/vm/citationList.vm";
    protected static ResourceLoader rb = new ResourceLoader("citations");
    private static Log m_log = LogFactory.getLog(CitationListAccessServlet.class);

    public void handleAccess(HttpServletRequest req, HttpServletResponse res, Reference ref, Collection copyrightAcceptedRefs) throws EntityPermissionException, EntityNotDefinedException, EntityAccessOverloadException, EntityCopyrightException {
        String subtype = ref.getSubType();
        if ("export_ris_sel".equals(subtype) || "export_ris_all".equals(subtype)) {
            this.handleExportRequest(req, res, ref, "RIS", subtype);
        } else if ("list".equals(subtype)) {
            this.handleViewRequest(req, res, ref);
        } else {
            throw new EntityNotDefinedException(ref.getReference());
        }
        Event e = EventTrackingService.newEvent((String)ContentHostingService.EVENT_RESOURCE_READ, (String)("/content" + ref.getId()), (boolean)false);
        EventTrackingService.post((Event)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleExportRequest(HttpServletRequest req, HttpServletResponse res, Reference ref, String format, String subtype) throws EntityNotDefinedException, EntityAccessOverloadException, EntityPermissionException {
        if (!ContentHostingService.allowGetResource((String)req.getParameter("resourceId"))) {
            String url = req.getRequestURL().toString();
            String user = "";
            if (req.getUserPrincipal() != null) {
                user = req.getUserPrincipal().getName();
            }
            throw new EntityPermissionException(user, ContentHostingService.EVENT_RESOURCE_READ, ref.getReference());
        }
        String fileName = req.getParameter("resourceDisplayName");
        if (fileName == null || fileName.trim().equals("")) {
            fileName = rb.getString("export.default.filename");
        }
        if ("RIS".equals(format)) {
            String citationCollectionId = req.getParameter("citationCollectionId");
            ArrayList<String> citationIds = new ArrayList<String>();
            CitationCollection collection = null;
            try {
                collection = CitationService.getCollection((String)citationCollectionId);
            }
            catch (IdUnusedException e) {
                throw new EntityNotDefinedException(ref.getReference());
            }
            if ("export_ris_sel".equals(subtype)) {
                String[] paramCitationIds = req.getParameterValues("citationId");
                if (paramCitationIds == null || paramCitationIds.length < 1) {
                    try {
                        res.sendError(400, rb.getString("export.none_selected"));
                    }
                    catch (IOException e) {
                        m_log.warn((Object)("export-selected request received with not citations selected. citationCollectionId: " + citationCollectionId));
                    }
                    return;
                }
                citationIds.addAll(Arrays.asList(paramCitationIds));
                fileName = rb.getFormattedMessage("export.filename.selected.ris", new Object[]{fileName});
            } else {
                List citations = collection.getCitations();
                if (citations == null || citations.size() < 1) {
                    try {
                        res.sendError(204, rb.getString("export.empty_collection"));
                    }
                    catch (IOException e) {
                        m_log.warn((Object)("export-all request received for empty citation collection. citationCollectionId: " + citationCollectionId));
                    }
                    return;
                }
                for (Citation citation : citations) {
                    citationIds.add(citation.getId());
                }
                fileName = rb.getFormattedMessage("export.filename.all.ris", new Object[]{fileName});
            }
            StringBuilder buffer = new StringBuilder(4096);
            try {
                collection.exportRis(buffer, citationIds);
            }
            catch (IOException e) {
                throw new EntityAccessOverloadException(ref.getReference());
            }
            res.addHeader("Content-disposition", "attachment; filename=\"" + fileName + "\"");
            res.setContentType("application/x-Research-Info-Systems");
            res.setContentLength(buffer.length());
            if (buffer.length() > 0) {
                res.setBufferSize(buffer.length());
            }
            ServletOutputStream out = null;
            try {
                out = res.getOutputStream();
                if (buffer.length() > 0) {
                    out.write(buffer.toString().getBytes());
                }
                out.flush();
                out.close();
            }
            catch (Throwable ignore) {
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable ignore) {}
                }
            }
        }
    }

    protected void handleViewRequest(HttpServletRequest req, HttpServletResponse res, Reference ref) throws EntityPermissionException, EntityAccessOverloadException, EntityNotDefinedException {
        try {
            ContentResource resource = ContentHostingService.getResource((String)ref.getId());
            if (!"org.sakaiproject.citation.impl.CitationList".equals(resource.getResourceType())) {
                throw new EntityNotDefinedException("Couldn't find citation list");
            }
            if (resource.getContentLength() > 1024L) {
                throw new EntityAccessOverloadException(ref.getId());
            }
            ResourceProperties properties = resource.getProperties();
            String title = properties.getProperty("DAV:displayname");
            String description = properties.getProperty("CHEF:description");
            String citationCollectionId = new String(resource.getContent());
            CitationCollection collection = CitationService.getCollection((String)citationCollectionId);
            res.setContentType("text/html; charset=UTF-8");
            PrintWriter out = res.getWriter();
            out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\" xml:lang=\"en\">\n<head>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\n<title>" + rb.getString("list.title") + ": " + Validator.escapeHtml((String)title) + "</title>\n" + "<link href=\"/library/skin/tool_base.css\" type=\"text/css\" rel=\"stylesheet\" media=\"all\" />\n" + "<link href=\"/library/skin/default/tool.css\" type=\"text/css\" rel=\"stylesheet\" media=\"all\" />\n" + "<script type=\"text/javascript\" src=\"/library/js/jquery.js\"></script>\n" + "<script type=\"text/javascript\" src=\"/sakai-citations-tool/js/citationscript.js\"></script>\n" + "</head>\n<body>");
            List citations = collection.getCitations();
            out.println("<div class=\"portletBody\">\n\t<div class=\"indnt1\">");
            out.println("\t<h3>" + rb.getString("list.title") + ": " + Validator.escapeHtml((String)title) + "</h3>");
            if (description != null && !description.trim().equals("")) {
                out.println("\t<p>" + description + "</p>");
            }
            if (citations.size() > 0) {
                Object[] args = new Object[]{ConfigurationService.getSiteConfigOpenUrlLabel()};
                out.println("\t<p class=\"instruction\">" + rb.getFormattedMessage("cite.subtitle", args) + "</p>");
            }
            out.println("\t<table class=\"listHier lines nolines\" summary=\"citations table\" cellpadding=\"0\" cellspacing=\"0\">");
            out.println("\t<tbody>");
            out.println("\t<tr><th colspan=\"2\">");
            out.println("\t\t<div class=\"viewNav\" style=\"padding: 0pt;\"><strong>" + rb.getString("listing.title") + "</strong> (" + collection.size() + ")");
            out.println("\t\t</div>");
            out.println("\t</th></tr>");
            if (citations.size() > 0) {
                out.println("\t<tr class=\"exclude\"><td colspan=\"2\">");
                out.println("\t\t<div class=\"itemAction\">");
                out.println("\t\t\t<a href=\"#\" onclick=\"showAllDetails( '" + rb.getString("link.hide.results") + "' ); return false;\">" + rb.getString("link.show.readonly") + "</a> |");
                out.println("\t\t\t<a href=\"#\" onclick=\"hideAllDetails( '" + rb.getString("link.show.readonly") + "' ); return false;\">" + rb.getString("link.hide.results") + "</a>");
                out.println("\t\t</div>\n\t</td></tr>");
            }
            for (Citation citation : citations) {
                String escapedId = citation.getId().replace('-', 'x');
                out.println("\t\t<tr>");
                out.println("\t\t\t<td class=\"attach\">");
                out.println("\t\t\t\t<img onclick=\"toggleDetails( '" + escapedId + "', '" + rb.getString("link.show.readonly") + "', '" + rb.getString("link.hide.results") + "' );\"");
                out.println("\t\t\t\tid=\"toggle_" + escapedId + "\" class=\"toggleIcon\"");
                out.println("\t\t\t\tstyle=\"cursor: pointer;\" src=\"/library/image/sakai/expand.gif?panel=Main\"");
                out.println("\t\t\t\talt=\"" + rb.getString("link.show.readonly") + "\" align=\"top\"");
                out.println("\t\t\t\tborder=\"0\" height=\"13\" width=\"13\" />");
                out.println("\t\t\t</td>");
                String href = citation.hasPreferredUrl() ? citation.getCustomUrl(citation.getPreferredUrlId()) : citation.getOpenurl();
                out.println("\t\t<td headers=\"details\">");
                out.println("\t\t\t<a href=\"" + Validator.escapeHtml((String)href) + "\" target=\"_blank\">" + Validator.escapeHtml((String)((String)citation.getCitationProperty("title", true))) + "</a><br />");
                out.println("\t\t\t\t" + Validator.escapeHtml((String)citation.getCreator()));
                out.println("\t\t\t\t" + Validator.escapeHtml((String)citation.getSource()));
                out.println("\t\t\t<div class=\"itemAction\">");
                if (citation.hasCustomUrls()) {
                    List customUrlIds = citation.getCustomUrlIds();
                    for (String urlId : customUrlIds) {
                        if (citation.hasPreferredUrl() && (!citation.hasPreferredUrl() || citation.getPreferredUrlId().equals(urlId))) continue;
                        String urlLabel = citation.getCustomUrlLabel(urlId) == null || citation.getCustomUrlLabel(urlId).trim().equals("") ? rb.getString("nullUrlLabel.view") : Validator.escapeHtml((String)citation.getCustomUrlLabel(urlId));
                        out.println("\t\t\t\t<a href=\"" + Validator.escapeHtml((String)citation.getCustomUrl(urlId)) + "\" target=\"_blank\">" + urlLabel + "</a>");
                        out.println("\t\t\t\t |");
                    }
                } else {
                    out.println("\t\t\t\t<a href=\"" + citation.getOpenurl() + "\" target=\"_blank\">" + ConfigurationService.getSiteConfigOpenUrlLabel() + "</a>");
                }
                out.println("\t\t\t\t<span class=\"Z3988\" title=\"" + citation.getOpenurlParameters().substring(1).replace("&", "&amp;") + "\"></span>");
                out.println("\t\t\t</div>");
                out.println("\t\t<div id=\"details_" + escapedId + "\" class=\"citationDetails\" style=\"display: none;\">");
                out.println("\t\t\t<table class=\"listHier lines nolines\" style=\"margin-left: 2em;\" cellpadding=\"0\" cellspacing=\"0\">");
                Schema schema = citation.getSchema();
                if (schema == null) {
                    m_log.warn((Object)("CLAS.handleViewRequest() Schema is null: " + citation));
                    continue;
                }
                List fields = schema.getFields();
                for (Schema.Field field : fields) {
                    if (field.isMultivalued()) {
                        if ("creator".equals(field.getIdentifier())) continue;
                        List values = (List)citation.getCitationProperty(field.getIdentifier(), false);
                        Iterator valueIt = values.iterator();
                        boolean first = true;
                        while (valueIt.hasNext()) {
                            String value = (String)valueIt.next();
                            if (value != null && !value.trim().equals("")) {
                                if (first) {
                                    String label = rb.getString(schema.getIdentifier() + "." + field.getIdentifier(), field.getIdentifier());
                                    out.println("\t\t\t\t<tr>\n\t\t\t\t\t<td class=\"attach\"><strong>" + label + "</strong></td>\n\t\t\t\t\t<td>" + Validator.escapeHtml((String)value) + "</td>\n\t\t\t\t</tr>");
                                } else {
                                    out.println("\t\t\t\t<tr>\n\t\t\t\t\t<td class=\"attach\">&nbsp;</td>\n\t\t\t\t\t<td>" + Validator.escapeHtml((String)value) + "</td>\n\t\t\t\t</tr>\n");
                                }
                            }
                            first = false;
                        }
                        continue;
                    }
                    String value = (String)citation.getCitationProperty(field.getIdentifier(), true);
                    if (value == null || value.trim().equals("")) continue;
                    String label = rb.getString(schema.getIdentifier() + "." + field.getIdentifier(), field.getIdentifier());
                    if ("title".equals(field.getIdentifier())) continue;
                    out.println("\t\t\t\t<tr>\n\t\t\t\t\t<td class=\"attach\"><strong>" + label + "</strong></td>\n\t\t\t\t\t<td>" + Validator.escapeHtml((String)value) + "</td>\n\t\t\t\t</tr>");
                }
                out.println("\t\t\t</table>");
                out.println("\t\t</div>");
                out.println("\t\t</td>");
                out.println("\t\t</tr>");
            }
            if (citations.size() > 0) {
                out.println("\t<tr class=\"exclude\"><td colspan=\"2\">");
                out.println("\t\t<div class=\"itemAction\">");
                out.println("\t\t\t<a href=\"#\" onclick=\"showAllDetails( '" + rb.getString("link.hide.results") + "' ); return false;\">" + rb.getString("link.show.readonly") + "</a> |");
                out.println("\t\t\t<a href=\"#\" onclick=\"hideAllDetails( '" + rb.getString("link.show.readonly") + "' ); return false;\">" + rb.getString("link.hide.results") + "</a>");
                out.println("\t\t</div>\n\t</td></tr>");
                out.println("\t<tr><th colspan=\"2\">");
                out.println("\t\t<div class=\"viewNav\" style=\"padding: 0pt;\"><strong>" + rb.getString("listing.title") + "</strong> (" + collection.size() + ")");
                out.println("\t\t</div>");
                out.println("\t</th></tr>");
                out.println("\t</tbody>");
                out.println("\t</table>");
                out.println("</div></div>");
                out.println("</body></html>");
            }
        }
        catch (IOException e) {
            throw new EntityAccessOverloadException(ref.getReference());
        }
        catch (ServerOverloadException e) {
            throw new EntityAccessOverloadException(ref.getReference());
        }
        catch (IdUnusedException e) {
            throw new EntityNotDefinedException(ref.getReference());
        }
        catch (PermissionException e) {
            throw new EntityPermissionException(e.getUser(), ContentHostingService.EVENT_RESOURCE_READ, ref.getReference());
        }
        catch (TypeException e) {
            throw new EntityNotDefinedException(ref.getReference());
        }
    }
}

