/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.citation.impl.openurl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.TreeBidiMap;
import org.sakaiproject.citation.api.Citation;
import org.sakaiproject.citation.api.CitationService;
import org.sakaiproject.citation.impl.openurl.AbstractConverter;
import org.sakaiproject.citation.impl.openurl.ContextObjectEntity;
import org.sakaiproject.citation.impl.openurl.Utils;

public class GenericConverter
extends AbstractConverter {
    private CitationService citationService;
    private static BidiMap conversion = new TreeBidiMap();
    private static Collection<Genre> genreConversion;

    public void setCitationService(CitationService citationService) {
        this.citationService = citationService;
    }

    @Override
    protected String getOpenUrlKey(String citationKey) {
        return (String)conversion.get((Object)citationKey);
    }

    @Override
    protected String getCitationsKey(String openUrlKey) {
        return (String)conversion.getKey((Object)openUrlKey);
    }

    @Override
    public boolean canConvertOpenUrl(String format) {
        return true;
    }

    @Override
    public boolean canConvertCitation(String type) {
        return true;
    }

    @Override
    public ContextObjectEntity convert(Citation citation) {
        Object value;
        Map props = citation.getCitationProperties();
        ContextObjectEntity entity = new ContextObjectEntity();
        this.convertSimple(props, entity);
        String schema = citation.getSchema().getIdentifier();
        for (Genre genre : genreConversion) {
            if (!genre.citationScheme.equals(schema)) continue;
            entity.setFormat(genre.openUrlId);
            entity.addValue("genre", genre.openUrlGenre);
            break;
        }
        if (citation.hasCitationProperty("isbn")) {
            value = citation.getCitationProperty("isbn", false);
            this.addId(entity, value, "urn:ISBN:");
        }
        if (citation.hasCitationProperty("doi")) {
            value = citation.getCitationProperty("doi", false);
            this.addId(entity, value, "info:doi/");
        }
        return entity;
    }

    @Override
    public Citation convert(ContextObjectEntity entity) {
        String author;
        List<String> genres;
        Map<String, List<String>> values = entity.getValues();
        Genre destGenre = null;
        if (values.containsKey("genre") && !(genres = values.get("genre")).isEmpty()) {
            String openUrlGenre = genres.get(0);
            for (Genre genre : genreConversion) {
                if (!genre.openUrlGenre.equals(openUrlGenre)) continue;
                destGenre = genre;
                break;
            }
        }
        Citation citation = this.citationService.addCitation(destGenre != null ? destGenre.citationScheme : "unknown");
        for (String id : entity.getIds()) {
            if (id.startsWith("urn:ISBN:")) {
                String isbn = id.substring("urn:ISBN:".length());
                if (isbn.length() <= 0) continue;
                citation.setCitationProperty("isnIdentifier", (Object)isbn);
                continue;
            }
            if (id.startsWith("info:doi/")) {
                String doi = id.substring("info:doi/".length());
                if (doi.length() <= 0) continue;
                citation.setCitationProperty("doi", (Object)doi);
                continue;
            }
            if (id.startsWith("ISSN:")) {
                String issn = id.substring("ISSN:".length());
                if (issn.length() <= 0) continue;
                citation.setCitationProperty("isnIdentifier", (Object)issn);
                continue;
            }
            citation.setCitationProperty("otherIds", (Object)id);
        }
        this.convertSimple(values, citation);
        this.convertSingle(values, citation, "atitle", "title");
        this.convertSingle(values, citation, "btitle", "title");
        this.convertSingle(values, citation, "issn", "isnIdentifier");
        this.convertSingle(values, citation, "isbn", "isnIdentifier");
        if (destGenre != null) {
            if ("info:ofi/fmt:kev:mtx:journal".equals(destGenre.openUrlId)) {
                this.convertSingle(values, citation, "title", "sourceTitle");
                if ("journal".equals(destGenre.openUrlGenre)) {
                    this.convertSingle(values, citation, "jtitle", "title");
                    citation.setCitationProperty("sourceTitle", null);
                }
            }
            if ("info:ofi/fmt:kev:mtx:book".equals(destGenre.openUrlId)) {
                this.convertSingle(values, citation, "title", "title");
            }
        }
        if ((author = Utils.lookForAuthor(values)) != null) {
            citation.setCitationProperty("creator", (Object)author);
        }
        return citation;
    }

    private boolean convertSingle(Map<String, List<String>> values, Citation citation, String srcProp, String destProp) {
        String value;
        List<String> valueList = values.get(srcProp);
        if (valueList != null && !valueList.isEmpty() && !citation.hasCitationProperty(destProp) && (value = valueList.get(0)) != null && value.length() > 0) {
            citation.setCitationProperty(destProp, (Object)value);
            return true;
        }
        return false;
    }

    static {
        conversion.put((Object)"creator", (Object)"au");
        conversion.put((Object)"publisher", (Object)"pub");
        conversion.put((Object)"publicationLocation", (Object)"place");
        conversion.put((Object)"edition", (Object)"edition");
        conversion.put((Object)"sourceTitle", (Object)"jtitle");
        conversion.put((Object)"volume", (Object)"volume");
        conversion.put((Object)"issue", (Object)"issue");
        conversion.put((Object)"startPage", (Object)"spage");
        conversion.put((Object)"endPage", (Object)"epage");
        conversion.put((Object)"pages", (Object)"pages");
        conversion.put((Object)"date", (Object)"date");
        conversion.put((Object)"isnIdentifier", (Object)"issn");
        genreConversion = new ArrayList<Genre>();
        genreConversion.add(new Genre("info:ofi/fmt:kev:mtx:journal", "journal", "article"));
        genreConversion.add(new Genre("info:ofi/fmt:kev:mtx:journal", "issue", "article"));
        genreConversion.add(new Genre("info:ofi/fmt:kev:mtx:journal", "article", "article"));
        genreConversion.add(new Genre("info:ofi/fmt:kev:mtx:journal", "proceeding", "proceeding"));
        genreConversion.add(new Genre("info:ofi/fmt:kev:mtx:journal", "conference", "proceeding"));
        genreConversion.add(new Genre("info:ofi/fmt:kev:mtx:journal", "report", "report"));
        genreConversion.add(new Genre("info:ofi/fmt:kev:mtx:journal", "document", "report"));
        genreConversion.add(new Genre("info:ofi/fmt:kev:mtx:book", "book", "book"));
        genreConversion.add(new Genre("info:ofi/fmt:kev:mtx:book", "bookitem", "chapter"));
        genreConversion.add(new Genre("info:ofi/fmt:kev:mtx:book", "book", "book"));
        genreConversion.add(new Genre("info:ofi/fmt:kev:mtx:book", "proceeding", "proceeding"));
        genreConversion.add(new Genre("info:ofi/fmt:kev:mtx:book", "conference", "proceeding"));
        genreConversion.add(new Genre("info:ofi/fmt:kev:mtx:book", "report", "report"));
        genreConversion.add(new Genre("info:ofi/fmt:kev:mtx:book", "document", "report"));
    }

    private static class Genre {
        String openUrlId;
        String openUrlGenre;
        String citationScheme;

        private Genre(String openUrlId, String openUrlGenre, String citationScheme) {
            this.openUrlId = openUrlId;
            this.openUrlGenre = openUrlGenre;
            this.citationScheme = citationScheme;
        }
    }
}

