/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.citation.impl.openurl;

import java.io.BufferedReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.sakaiproject.citation.impl.openurl.KEVFormat;
import org.sakaiproject.citation.impl.openurl.RawContextObject;
import org.sakaiproject.citation.impl.openurl.Transport;
import org.sakaiproject.citation.impl.openurl.URLBuilder;
import org.sakaiproject.citation.impl.openurl.Utils;

public class InlineHttpTransport
implements Transport {
    @Override
    public RawContextObject parse(HttpServletRequest request) {
        String format;
        String timestamp;
        Map<String, String[]> parameters;
        String source = null;
        if ("GET".equals(request.getMethod())) {
            parameters = request.getParameterMap();
            source = request.getQueryString();
        } else if ("POST".equals(request.getMethod())) {
            source = this.readBody(request);
            parameters = Utils.decode(Utils.split(source), "UTF-8");
        } else {
            throw new IllegalArgumentException("Only POST and GET supported.");
        }
        String version = Utils.getValue(parameters, "url_ver");
        if (version == null || !version.equals("Z39.88-2004")) {
            // empty if block
        }
        if ((timestamp = Utils.getValue(parameters, "url_tim")) != null) {
            // empty if block
        }
        if ((format = Utils.getValue(parameters, "url_ctx_fmt")) == null || !KEVFormat.FORMAT_ID.equals(format)) {
            // empty if block
        }
        RawContextObject raw = new RawContextObject(KEVFormat.FORMAT_ID, source);
        return raw;
    }

    @Override
    public String encode(String content) {
        URLBuilder url = new URLBuilder("UTF-8");
        return url.append("url_ver", "Z39.88-2004").append("url_tim", this.currentTime(DateTimeType.DATE)).append("url_ctx_fmt", KEVFormat.FORMAT_ID).append(content).toString();
    }

    public String currentTime(DateTimeType type) {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        return type.getFormat().format(cal.getTime());
    }

    private String readBody(HttpServletRequest request) {
        try {
            BufferedReader reader = request.getReader();
            String line = null;
            StringBuilder lines = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                lines.append(line);
            }
            return lines.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException();
        }
    }

    public static enum DateTimeType {
        DATE("yyyy-MM-dd"),
        DATETIME("yyyy-MM-ddTHH:mm:ssZ");

        private String format;

        private DateTimeType(String format) {
            this.format = format;
        }

        public SimpleDateFormat getFormat() {
            return new SimpleDateFormat(this.format);
        }
    }
}

