/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.citation.impl.openurl;

import java.util.List;
import java.util.Map;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.TreeBidiMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.citation.api.Citation;
import org.sakaiproject.citation.api.CitationService;
import org.sakaiproject.citation.impl.openurl.AbstractConverter;
import org.sakaiproject.citation.impl.openurl.ContextObjectEntity;
import org.sakaiproject.citation.impl.openurl.Utils;

public class JournalConverter
extends AbstractConverter {
    private static final Log log = LogFactory.getLog(JournalConverter.class);
    public static final String ID = "info:ofi/fmt:kev:mtx:journal";
    private CitationService citationService;
    private static BidiMap conversion = new TreeBidiMap();

    public void setCitationService(CitationService citationService) {
        this.citationService = citationService;
    }

    @Override
    protected String getCitationsKey(String openUrlKey) {
        return (String)conversion.getKey((Object)openUrlKey);
    }

    @Override
    protected String getOpenUrlKey(String citationsKey) {
        return (String)conversion.get((Object)citationsKey);
    }

    @Override
    public boolean canConvertOpenUrl(String format) {
        return ID.equals(format);
    }

    @Override
    public boolean canConvertCitation(String type) {
        return "journal".equals(type);
    }

    @Override
    public ContextObjectEntity convert(Citation citation) {
        Map props = citation.getCitationProperties();
        ContextObjectEntity entity = new ContextObjectEntity();
        entity.addValue("genre", "journal");
        this.convertSimple(props, entity);
        if (citation.hasCitationProperty("doi")) {
            Object value = citation.getCitationProperty("doi", false);
            this.addId(entity, value, "info:doi/");
        }
        return entity;
    }

    @Override
    public Citation convert(ContextObjectEntity entity) {
        Map<String, List<String>> values = entity.getValues();
        String genre = null;
        List<String> genres = values.get("genre");
        if (genres != null) {
            genre = genres.get(0);
        }
        if (genre == null) {
            genre = "article";
        }
        Citation citation = this.citationService.addCitation(genre);
        for (String id : entity.getIds()) {
            if (id.startsWith("ISSN:")) {
                String isbn = id.substring("ISSN:".length());
                if (isbn.length() <= 0) continue;
                citation.setCitationProperty("isnIdentifier", (Object)isbn);
                continue;
            }
            if (id.startsWith("info:doi/")) {
                String doi = id.substring("info:doi/".length());
                if (doi.length() <= 0) continue;
                citation.setCitationProperty("info:doi/", (Object)doi);
                continue;
            }
            citation.setCitationProperty("otherIds", (Object)id);
        }
        this.convertSimple(values, citation);
        String author = Utils.lookForAuthor(values);
        if (author != null) {
            citation.setCitationProperty("creator", (Object)author);
        }
        return citation;
    }

    static {
        conversion.put((Object)"creator", (Object)"au");
        conversion.put((Object)"title", (Object)"atitle");
        conversion.put((Object)"sourceTitle", (Object)"jtitle");
        conversion.put((Object)"date", (Object)"date");
        conversion.put((Object)"volume", (Object)"volume");
        conversion.put((Object)"issue", (Object)"issue");
        conversion.put((Object)"startPage", (Object)"spage");
        conversion.put((Object)"endPage", (Object)"epage");
        conversion.put((Object)"pages", (Object)"pages");
        conversion.put((Object)"isnIdentifier", (Object)"issn");
    }
}

