/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.citation.impl.openurl;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class URLBuilder {
    private static final String SEPERATOR = "&";
    private static final String KEY_VALUE_SEP = "=";
    private StringBuilder url;
    private String encoding;

    public URLBuilder(String encoding) {
        this.encoding = encoding;
        this.url = new StringBuilder();
    }

    public URLBuilder append(String key, String value) {
        if (this.url.length() > 0) {
            this.url.append(SEPERATOR);
        }
        this.url.append(key);
        this.url.append(KEY_VALUE_SEP);
        try {
            this.url.append(URLEncoder.encode(value, this.encoding));
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
        return this;
    }

    public URLBuilder append(String data) {
        if (this.url.length() > 0 && !data.startsWith(SEPERATOR)) {
            this.url.append(SEPERATOR);
        }
        this.url.append(data);
        return this;
    }

    public int length() {
        return this.url.length();
    }

    public String toString() {
        return this.url.toString();
    }
}

