/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.citation.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osid.repository.Asset;
import org.osid.repository.Part;
import org.osid.repository.PartIterator;
import org.osid.repository.Record;
import org.osid.repository.RecordIterator;
import org.osid.repository.RepositoryException;
import org.sakaiproject.citation.api.ActiveSearch;
import org.sakaiproject.citation.api.Citation;
import org.sakaiproject.citation.api.CitationCollection;
import org.sakaiproject.citation.api.CitationIterator;
import org.sakaiproject.citation.api.CitationService;
import org.sakaiproject.citation.api.ConfigurationService;
import org.sakaiproject.citation.api.Schema;
import org.sakaiproject.citation.impl.CitationListAccessServlet;
import org.sakaiproject.citation.impl.openurl.ContextObject;
import org.sakaiproject.citation.impl.openurl.OpenURLServiceImpl;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.content.api.ContentEntity;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.content.api.ContentResourceEdit;
import org.sakaiproject.content.api.ResourceToolAction;
import org.sakaiproject.content.api.ResourceType;
import org.sakaiproject.content.api.ResourceTypeRegistry;
import org.sakaiproject.content.util.BaseInteractionAction;
import org.sakaiproject.content.util.BaseResourceAction;
import org.sakaiproject.content.util.BaseServiceLevelAction;
import org.sakaiproject.content.util.BasicResourceType;
import org.sakaiproject.content.util.BasicSiteSelectableResourceType;
import org.sakaiproject.entity.api.Entity;
import org.sakaiproject.entity.api.EntityManager;
import org.sakaiproject.entity.api.EntityProducer;
import org.sakaiproject.entity.api.HttpAccess;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.InUseException;
import org.sakaiproject.exception.OverQuotaException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.ServerOverloadException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.id.api.IdManager;
import org.sakaiproject.javax.Filter;
import org.sakaiproject.time.cover.TimeService;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.util.ResourceLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class BaseCitationService
implements CitationService {
    protected boolean attemptToMatchSchema = false;
    protected static final List<String> AUTHOR_AS_KEY = new Vector<String>();
    protected static final List<String> YEAR_AS_KEY;
    protected static final List<String> TITLE_AS_KEY;
    public static final Map<String, String> GS_TAGS;
    public static ResourceLoader rb;
    private static Log M_log;
    protected static final String PROPERTY_DEFAULTVALUE = "sakai:defaultValue";
    protected static final String PROPERTY_DESCRIPTION = "sakai:description";
    protected static final String PROPERTY_HAS_ABBREVIATION = "sakai:hasAbbreviation";
    protected static final String PROPERTY_HAS_CITATION = "sakai:hasCitation";
    protected static final String PROPERTY_HAS_FIELD = "sakai:hasField";
    protected static final String PROPERTY_HAS_NAMESPACE = "sakai:hasNamespace";
    protected static final String PROPERTY_HAS_ORDER = "sakai:hasOrder";
    protected static final String PROPERTY_HAS_SCHEMA = "sakai:hasSchema";
    protected static final String PROPERTY_LABEL = "sakai:label";
    protected static final String PROPERTY_MAXCARDINALITY = "sakai:maxCardinality";
    protected static final String PROPERTY_MINCARDINALITY = "sakai:minCardinality";
    protected static final String PROPERTY_NAMESPACE = "sakai:namespace";
    protected static final String PROPERTY_REQUIRED = "sakai:required";
    protected static final String PROPERTY_VALUETYPE = "sakai:valueType";
    public static final String SCHEMA_PREFIX = "schema.";
    protected static AtomicInteger m_nextSerialNumber;
    protected static final String RIS_DELIM = "  - ";
    protected static final Map m_RISType;
    protected static final Map m_RISTypeInverse;
    protected static final Map m_RISNoteFields;
    protected static final Set m_RISSpecialFields;
    protected ConfigurationService m_configService = null;
    protected ServerConfigurationService m_serverConfigurationService = null;
    protected ContentHostingService m_contentHostingService = null;
    protected EntityManager m_entityManager = null;
    protected IdManager m_idManager = null;
    protected OpenURLServiceImpl m_openURLService;
    protected String m_defaultSchema;
    protected Storage m_storage = null;
    protected String m_relativeAccessPoint;
    protected ResourceTypeRegistry m_resourceTypeRegistry;
    public static final String PROP_TEMPORARY_CITATION_LIST = "citations.temporary_citation_list";

    public static String escapeFieldName(String original) {
        if (original == null) {
            return "";
        }
        original = original.trim();
        try {
            byte[] bytes = original.getBytes("UTF-8");
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < bytes.length; ++i) {
                byte b = bytes[i];
                if (":&%~!@#$^*()+=\"'`<>,/? ".indexOf((char)b) != -1) {
                    buf.append('_');
                    continue;
                }
                buf.append((char)b);
            }
            String rv = buf.toString();
            return rv;
        }
        catch (Exception e) {
            M_log.warn((Object)"BaseCitationService.escapeFieldName: ", (Throwable)e);
            return original;
        }
    }

    public void setResourceTypeRegistry(ResourceTypeRegistry registry) {
        this.m_resourceTypeRegistry = registry;
    }

    public void setOpenURLService(OpenURLServiceImpl openURLServiceImpl) {
        this.m_openURLService = openURLServiceImpl;
    }

    public ResourceTypeRegistry getResourceTypeRegistry() {
        return this.m_resourceTypeRegistry;
    }

    public boolean allowAddCitationList(String contentCollectionId) {
        return this.m_contentHostingService.allowAddResource(contentCollectionId + "testing");
    }

    public boolean allowReviseCitationList(String contentResourceId) {
        boolean allowed = this.m_contentHostingService.allowUpdateResource(contentResourceId);
        if (!allowed) {
            try {
                ResourceProperties props = this.m_contentHostingService.getProperties(contentResourceId);
                String temp_res = props.getProperty(PROP_TEMPORARY_CITATION_LIST);
                String creator = props.getProperty("CHEF:creator");
                String contentCollectionId = this.m_contentHostingService.getContainingCollectionId(contentResourceId);
                SessionManager sessionManager = (SessionManager)ComponentManager.get((String)"org.sakaiproject.tool.api.SessionManager");
                String currentUser = sessionManager.getCurrentSessionUserId();
                allowed = this.allowAddCitationList(contentCollectionId) && temp_res != null && currentUser.equals(creator);
            }
            catch (PermissionException permissionException) {
            }
            catch (IdUnusedException idUnusedException) {
                // empty catch block
            }
        }
        return allowed;
    }

    public boolean allowRemoveCitationList(String contentResourceId) {
        boolean allowed = this.m_contentHostingService.allowUpdateResource(contentResourceId);
        if (!allowed) {
            try {
                ResourceProperties props = this.m_contentHostingService.getProperties(contentResourceId);
                String temp_res = props.getProperty(PROP_TEMPORARY_CITATION_LIST);
                String creator = props.getProperty("CHEF:creator");
                String contentCollectionId = this.m_contentHostingService.getContainingCollectionId(contentResourceId);
                SessionManager sessionManager = (SessionManager)ComponentManager.get((String)"org.sakaiproject.tool.api.SessionManager");
                String currentUser = sessionManager.getCurrentSessionUserId();
                allowed = this.allowAddCitationList(contentCollectionId) && temp_res != null && currentUser.equals(creator);
            }
            catch (PermissionException permissionException) {
            }
            catch (IdUnusedException idUnusedException) {
                // empty catch block
            }
        }
        return allowed;
    }

    public Citation addCitation(String mediatype) {
        if (mediatype != null && mediatype.equalsIgnoreCase("proceeding")) {
            mediatype = "proceed";
        }
        Citation edit = this.m_storage.addCitation(mediatype);
        return edit;
    }

    public CitationCollection addCollection() {
        CitationCollection edit = this.m_storage.addCollection(null, null);
        return edit;
    }

    public String archive(String siteId, Document doc, Stack stack, String archivePath, List attachments) {
        return null;
    }

    public CitationCollection copyAll(String collectionId) {
        return this.m_storage.copyAll(collectionId);
    }

    public void destroy() {
        if (this.m_storage != null) {
            this.m_storage.close();
            this.m_storage = null;
        }
    }

    protected String getAccessPoint(boolean relative) {
        return (relative ? "" : this.m_serverConfigurationService.getAccessUrl()) + this.m_relativeAccessPoint;
    }

    public CitationCollection getCollection(String collectionId) throws IdUnusedException {
        CitationCollection edit = this.m_storage.getCollection(collectionId);
        if (edit == null) {
            throw new IdUnusedException(collectionId);
        }
        return edit;
    }

    public Schema getDefaultSchema() {
        Schema rv = null;
        if (this.m_defaultSchema != null) {
            rv = this.m_storage.getSchema(this.m_defaultSchema);
        }
        return rv;
    }

    public Entity getEntity(Reference ref) {
        CitationCollection entity = null;
        if ("sakai:citation".equals(ref.getType())) {
            if ("export_ris_sel".equals(ref.getSubType()) || "export_ris_all".equals(ref.getSubType())) {
                String reference;
                String id = ref.getId();
                if ((id == null || id.trim().equals("")) && (reference = ref.getReference()) != null && reference.startsWith("/citation")) {
                    id = reference.substring("/citation".length(), reference.length());
                }
                if (id != null && !id.trim().equals("")) {
                    entity = this.m_storage.getCollection(id);
                }
            } else if ("list".equals(ref.getSubType())) {
                String id = ref.getId();
                if (id == null || id.trim().equals("")) {
                    String reference = ref.getReference();
                    if (reference.startsWith("/citation")) {
                        reference = reference.substring("/citation".length(), reference.length());
                    }
                    if (reference.startsWith("/content")) {
                        id = reference.substring("/content".length(), reference.length());
                    }
                }
                if (id != null && !id.trim().equals("")) {
                    try {
                        entity = this.m_contentHostingService.getResource(id);
                    }
                    catch (PermissionException e) {
                        M_log.warn((Object)("getEntity(" + id + ") "), (Throwable)e);
                    }
                    catch (IdUnusedException e) {
                        M_log.warn((Object)("getEntity(" + id + ") "), (Throwable)e);
                    }
                    catch (TypeException e) {
                        M_log.warn((Object)("getEntity(" + id + ") "), (Throwable)e);
                    }
                }
            }
        }
        return entity;
    }

    public Collection getEntityAuthzGroups(Reference ref, String userId) {
        Collection azGroups = null;
        if (ref != null && ref.getReference() != null && ref.getReference().startsWith("/citation/content/")) {
            String altRef = ref.getReference().substring("/citation".length());
            azGroups = this.m_contentHostingService.getEntityAuthzGroups(this.m_entityManager.newReference(altRef), userId);
        }
        return azGroups;
    }

    public String getEntityDescription(Reference ref) {
        return null;
    }

    public ResourceProperties getEntityResourceProperties(Reference ref) {
        return null;
    }

    public String getEntityUrl(Reference ref) {
        return null;
    }

    public HttpAccess getHttpAccess() {
        return new CitationListAccessServlet();
    }

    public String getLabel() {
        return null;
    }

    public Set getMultivalued() {
        TreeSet<String> multivalued = new TreeSet<String>();
        for (Schema schema : this.m_storage.getSchemas()) {
            for (Schema.Field field : schema.getFields()) {
                if (field.getMaxCardinality() <= 1) continue;
                multivalued.add(field.getIdentifier());
            }
        }
        return multivalued;
    }

    public Set getMultivalued(String type) {
        TreeSet<String> multivalued = new TreeSet<String>();
        Schema schema = this.m_storage.getSchema(type);
        for (Schema.Field field : schema.getFields()) {
            if (field.getMaxCardinality() <= 1) continue;
            multivalued.add(field.getIdentifier());
        }
        return multivalued;
    }

    public Schema getSchema(String name) {
        Schema schema = this.m_storage.getSchema(name);
        return schema;
    }

    public List getSchemas() {
        Vector schemas = new Vector(this.m_storage.getSchemas());
        return schemas;
    }

    protected Set getSynonyms(String mediatype) {
        TreeSet<String> synonyms = new TreeSet<String>();
        if (mediatype.equalsIgnoreCase("article")) {
            synonyms.add("article");
            synonyms.add("journal article");
            synonyms.add("journal");
            synonyms.add("periodical");
            synonyms.add("newspaper article");
            synonyms.add("magazine article");
            synonyms.add("editorial");
            synonyms.add("peer reviewed article");
            synonyms.add("peer reviewed journal article");
            synonyms.add("book review");
            synonyms.add("review");
            synonyms.add("meeting");
            synonyms.add("wire feed");
            synonyms.add("wire story");
            synonyms.add("news");
            synonyms.add("journal article (cije)");
        } else if (mediatype.equalsIgnoreCase("book")) {
            synonyms.add("book");
            synonyms.add("bk");
        } else if (mediatype.equalsIgnoreCase("chapter")) {
            synonyms.add("chapter");
            synonyms.add("book chapter");
            synonyms.add("book section");
        } else if (mediatype.equalsIgnoreCase("report")) {
            synonyms.add("report");
            synonyms.add("editorial material");
            synonyms.add("technical report");
            synonyms.add("se");
            synonyms.add("document (rie)");
        }
        return synonyms;
    }

    public Citation getTemporaryCitation() {
        return new BasicCitation();
    }

    public Citation getTemporaryCitation(Asset asset) {
        return new BasicCitation(asset);
    }

    public CitationCollection getTemporaryCollection() {
        return new BasicCitationCollection(true);
    }

    public Set getValidPropertyNames() {
        TreeSet<String> names = new TreeSet<String>();
        for (Schema schema : this.m_storage.getSchemas()) {
            for (Schema.Field field : schema.getFields()) {
                names.add(field.getIdentifier());
            }
        }
        return names;
    }

    public void init() {
        this.m_storage = this.newStorage();
        m_nextSerialNumber = new AtomicInteger(0);
        this.m_relativeAccessPoint = "/citation";
        rb = new ResourceLoader("citations");
        this.m_defaultSchema = "article";
        this.m_entityManager.registerEntityProducer((EntityProducer)this, "/citation");
        if (this.m_configService.isCitationsEnabledByDefault() || this.m_configService.isAllowSiteBySiteOverride()) {
            this.registerResourceType();
        }
    }

    protected void registerResourceType() {
        ResourceTypeRegistry registry = this.getResourceTypeRegistry();
        Vector<String> requiredPropertyKeys = new Vector<String>();
        requiredPropertyKeys.add("sakai:reference-root");
        requiredPropertyKeys.add("DAV:getcontenttype");
        CitationListCreateAction createAction = new CitationListCreateAction("create", ResourceToolAction.ActionType.CREATE_BY_HELPER, "org.sakaiproject.citation.impl.CitationList", "sakai.citation.tool", new Vector());
        createAction.setLocalizer(new BaseResourceAction.Localizer(){

            public String getLabel() {
                return rb.getString("action.create");
            }
        });
        BaseInteractionAction reviseAction = new BaseInteractionAction("revise", ResourceToolAction.ActionType.REVISE_CONTENT, "org.sakaiproject.citation.impl.CitationList", "sakai.citation.tool", new Vector());
        reviseAction.setLocalizer(new BaseResourceAction.Localizer(){

            public String getLabel() {
                return rb.getString("action.revise");
            }
        });
        BaseServiceLevelAction moveAction = new BaseServiceLevelAction("move", ResourceToolAction.ActionType.MOVE, "org.sakaiproject.citation.impl.CitationList", true);
        BaseServiceLevelAction revisePropsAction = new BaseServiceLevelAction("properties", ResourceToolAction.ActionType.REVISE_METADATA, "org.sakaiproject.citation.impl.CitationList", false);
        BasicSiteSelectableResourceType typedef = new BasicSiteSelectableResourceType("org.sakaiproject.citation.impl.CitationList");
        typedef.setSizeLabeler((BasicResourceType.SizeLabeler)new CitationSizeLabeler());
        typedef.setLocalizer((BasicResourceType.Localizer)new CitationLocalizer());
        typedef.addAction((ResourceToolAction)createAction);
        typedef.addAction((ResourceToolAction)reviseAction);
        typedef.addAction((ResourceToolAction)new CitationListDeleteAction());
        typedef.addAction((ResourceToolAction)new CitationListCopyAction());
        typedef.addAction((ResourceToolAction)new CitationListDuplicateAction());
        typedef.addAction((ResourceToolAction)revisePropsAction);
        typedef.addAction((ResourceToolAction)moveAction);
        typedef.setEnabledByDefault(this.m_configService.isCitationsEnabledByDefault());
        typedef.setIconLocation("sakai/citationlist.gif");
        typedef.setHasRightsDialog(false);
        registry.register((ResourceType)typedef);
    }

    protected void initializeSchemas() {
        BasicSchema unknown = new BasicSchema();
        unknown.setIdentifier("unknown");
        BasicSchema article = new BasicSchema();
        article.setIdentifier("article");
        BasicSchema book = new BasicSchema();
        book.setIdentifier("book");
        BasicSchema chapter = new BasicSchema();
        chapter.setIdentifier("chapter");
        BasicSchema report = new BasicSchema();
        report.setIdentifier("report");
        unknown.addField("creator", "shorttext", true, false, 0, Integer.MAX_VALUE);
        unknown.addAlternativeIdentifier("creator", "RIS", "A1");
        unknown.addField("title", "shorttext", true, true, 1, 1);
        unknown.addAlternativeIdentifier("title", "RIS", "T1");
        unknown.addField("year", "number", true, false, 0, 1);
        unknown.addAlternativeIdentifier("year", "RIS", "Y1");
        unknown.addField("date", "number", true, false, 0, 1);
        unknown.addAlternativeIdentifier("date", "RIS", "Y1");
        unknown.addField("publisher", "shorttext", true, false, 0, 1);
        unknown.addAlternativeIdentifier("publisher", "RIS", "PB");
        unknown.addField("publicationLocation", "shorttext", true, false, 0, 1);
        unknown.addAlternativeIdentifier("publicationLocation", "RIS", "CY");
        unknown.addField("volume", "number", true, false, 0, 1);
        unknown.addAlternativeIdentifier("volume", "RIS", "VL");
        unknown.addField("issue", "number", true, false, 0, 1);
        unknown.addAlternativeIdentifier("issue", "RIS", "IS");
        unknown.addField("pages", "number", true, false, 0, 1);
        unknown.addAlternativeIdentifier("pages", "RIS", "SP");
        unknown.addField("startPage", "number", true, false, 0, 1);
        unknown.addAlternativeIdentifier("startPage", "RIS", "SP");
        unknown.addField("endPage", "number", true, false, 0, 1);
        unknown.addAlternativeIdentifier("endPage", "RIS", "EP");
        unknown.addField("edition", "number", true, false, 0, 1);
        unknown.addAlternativeIdentifier("edition", "RIS", "VL");
        unknown.addField("editor", "shorttext", true, false, 0, Integer.MAX_VALUE);
        unknown.addAlternativeIdentifier("editor", "RIS", "A3");
        unknown.addField("sourceTitle", "shorttext", true, false, 0, 1);
        unknown.addAlternativeIdentifier("sourceTitle", "RIS", "T3");
        unknown.addField("Language", "number", true, false, 0, 1);
        unknown.addField("abstract", "longtext", true, false, 0, 1);
        unknown.addAlternativeIdentifier("abstract", "RIS", "N2");
        unknown.addField("note", "longtext", true, false, 0, Integer.MAX_VALUE);
        unknown.addAlternativeIdentifier("note", "RIS", "N1");
        unknown.addField("isnIdentifier", "shorttext", true, false, 0, 1);
        unknown.addAlternativeIdentifier("isnIdentifier", "RIS", "SN");
        unknown.addField("subject", "shorttext", true, false, 0, Integer.MAX_VALUE);
        unknown.addAlternativeIdentifier("subject", "RIS", "KW");
        unknown.addField("locIdentifier", "shorttext", true, false, 0, 1);
        unknown.addAlternativeIdentifier("locIdentifier", "RIS", "M1");
        unknown.addField("dateRetrieved", "date", false, false, 0, 1);
        unknown.addField("openURL", "shorttext", false, false, 0, 1);
        unknown.addField("doi", "number", true, false, 0, 1);
        unknown.addField("rights", "shorttext", true, false, 0, Integer.MAX_VALUE);
        article.addField("creator", "shorttext", true, false, 0, Integer.MAX_VALUE);
        article.addAlternativeIdentifier("creator", "RIS", "A1");
        article.addField("title", "shorttext", true, true, 1, 1);
        article.addAlternativeIdentifier("title", "RIS", "T1");
        article.addField("sourceTitle", "shorttext", true, false, 0, 1);
        article.addAlternativeIdentifier("sourceTitle", "RIS", "JF");
        article.addField("year", "number", true, false, 0, 1);
        article.addAlternativeIdentifier("year", "RIS", "Y1");
        article.addField("date", "number", true, false, 0, 1);
        article.addAlternativeIdentifier("date", "RIS", "Y1");
        article.addField("volume", "number", true, false, 0, 1);
        article.addAlternativeIdentifier("volume", "RIS", "VL");
        article.addField("issue", "number", true, false, 0, 1);
        article.addAlternativeIdentifier("issue", "RIS", "IS");
        article.addField("pages", "number", true, false, 0, 1);
        article.addAlternativeIdentifier("pages", "RIS", "SP");
        article.addField("startPage", "number", true, false, 0, 1);
        article.addAlternativeIdentifier("startPage", "RIS", "SP");
        article.addField("endPage", "number", true, false, 0, 1);
        article.addAlternativeIdentifier("endPage", "RIS", "EP");
        article.addField("abstract", "longtext", true, false, 0, 1);
        article.addAlternativeIdentifier("abstract", "RIS", "N2");
        article.addField("note", "longtext", true, false, 0, Integer.MAX_VALUE);
        article.addAlternativeIdentifier("note", "RIS", "N1");
        article.addField("isnIdentifier", "shorttext", true, false, 0, 1);
        article.addAlternativeIdentifier("isnIdentifier", "RIS", "SN");
        article.addField("subject", "shorttext", true, false, 0, Integer.MAX_VALUE);
        article.addAlternativeIdentifier("subject", "RIS", "KW");
        article.addField("Language", "number", true, false, 0, 1);
        article.addField("locIdentifier", "shorttext", true, false, 0, 1);
        article.addAlternativeIdentifier("locIdentifier", "RIS", "M1");
        article.addField("dateRetrieved", "date", false, false, 0, 1);
        article.addField("openURL", "shorttext", false, false, 0, 1);
        article.addField("doi", "number", true, false, 0, 1);
        article.addField("rights", "shorttext", true, false, 0, Integer.MAX_VALUE);
        book.addField("creator", "shorttext", true, true, 1, Integer.MAX_VALUE);
        book.addAlternativeIdentifier("creator", "RIS", "A1");
        book.addField("title", "shorttext", true, true, 1, 1);
        book.addAlternativeIdentifier("title", "RIS", "BT");
        book.addField("year", "number", true, false, 0, 1);
        book.addAlternativeIdentifier("year", "RIS", "Y1");
        book.addField("date", "number", true, false, 0, 1);
        book.addAlternativeIdentifier("date", "RIS", "Y1");
        book.addField("publisher", "shorttext", true, false, 0, 1);
        book.addAlternativeIdentifier("publisher", "RIS", "PB");
        book.addField("publicationLocation", "shorttext", true, false, 0, 1);
        book.addAlternativeIdentifier("publicationLocation", "RIS", "CY");
        book.addField("edition", "number", true, false, 0, 1);
        book.addAlternativeIdentifier("edition", "RIS", "VL");
        book.addField("editor", "shorttext", true, false, 0, Integer.MAX_VALUE);
        book.addAlternativeIdentifier("editor", "RIS", "A3");
        book.addField("sourceTitle", "shorttext", true, false, 0, 1);
        book.addAlternativeIdentifier("sourceTitle", "RIS", "T3");
        book.addField("abstract", "longtext", true, false, 0, 1);
        book.addAlternativeIdentifier("abstract", "RIS", "N2");
        book.addField("note", "longtext", true, false, 0, Integer.MAX_VALUE);
        book.addAlternativeIdentifier("note", "RIS", "N1");
        book.addField("isnIdentifier", "shorttext", true, false, 0, 1);
        book.addAlternativeIdentifier("isnIdentifier", "RIS", "SN");
        book.addField("subject", "shorttext", true, false, 0, Integer.MAX_VALUE);
        book.addAlternativeIdentifier("subject", "RIS", "KW");
        book.addField("Language", "number", true, false, 0, 1);
        book.addField("locIdentifier", "shorttext", true, false, 0, 1);
        book.addAlternativeIdentifier("locIdentifier", "RIS", "M1");
        book.addField("dateRetrieved", "date", false, false, 0, 1);
        book.addField("openURL", "shorttext", false, false, 0, 1);
        book.addField("doi", "number", true, false, 0, 1);
        book.addField("rights", "shorttext", true, false, 0, Integer.MAX_VALUE);
        book.addAlternativeIdentifier("pages", "RIS", "SP");
        chapter.addField("creator", "shorttext", true, true, 1, Integer.MAX_VALUE);
        chapter.addAlternativeIdentifier("creator", "RIS", "A1");
        chapter.addField("title", "shorttext", true, true, 1, 1);
        chapter.addAlternativeIdentifier("title", "RIS", "CT");
        chapter.addField("year", "number", true, false, 0, 1);
        chapter.addAlternativeIdentifier("year", "RIS", "Y1");
        chapter.addField("date", "number", true, false, 0, 1);
        chapter.addAlternativeIdentifier("date", "RIS", "Y1");
        chapter.addField("publisher", "shorttext", true, false, 0, 1);
        chapter.addAlternativeIdentifier("publisher", "RIS", "PB");
        chapter.addField("publicationLocation", "shorttext", true, false, 0, 1);
        chapter.addAlternativeIdentifier("publicationLocation", "RIS", "CY");
        chapter.addField("edition", "number", true, false, 0, 1);
        chapter.addAlternativeIdentifier("edition", "RIS", "VL");
        chapter.addField("editor", "shorttext", true, false, 0, Integer.MAX_VALUE);
        chapter.addAlternativeIdentifier("editor", "RIS", "ED");
        chapter.addField("sourceTitle", "shorttext", true, false, 0, 1);
        chapter.addAlternativeIdentifier("sourceTitle", "RIS", "BT");
        chapter.addField("pages", "number", true, false, 0, 1);
        chapter.addAlternativeIdentifier("pages", "RIS", "SP");
        chapter.addField("startPage", "number", true, false, 0, 1);
        chapter.addAlternativeIdentifier("startPage", "RIS", "SP");
        chapter.addField("endPage", "number", true, false, 0, 1);
        chapter.addAlternativeIdentifier("endPage", "RIS", "EP");
        chapter.addField("abstract", "longtext", true, false, 0, 1);
        chapter.addAlternativeIdentifier("abstract", "RIS", "N2");
        chapter.addField("note", "longtext", true, false, 0, Integer.MAX_VALUE);
        chapter.addAlternativeIdentifier("note", "RIS", "N1");
        chapter.addField("isnIdentifier", "shorttext", true, false, 0, 1);
        chapter.addAlternativeIdentifier("isnIdentifier", "RIS", "SN");
        chapter.addField("subject", "shorttext", true, false, 0, Integer.MAX_VALUE);
        chapter.addAlternativeIdentifier("subject", "RIS", "KW");
        chapter.addField("Language", "number", true, false, 0, 1);
        chapter.addField("locIdentifier", "shorttext", true, false, 0, 1);
        chapter.addAlternativeIdentifier("locIdentifier", "RIS", "M1");
        chapter.addField("dateRetrieved", "date", false, false, 0, 1);
        chapter.addField("openURL", "shorttext", false, false, 0, 1);
        chapter.addField("doi", "number", true, false, 0, 1);
        chapter.addField("rights", "shorttext", true, false, 0, Integer.MAX_VALUE);
        report.addField("creator", "shorttext", true, true, 1, Integer.MAX_VALUE);
        report.addAlternativeIdentifier("creator", "RIS", "A1");
        report.addField("title", "shorttext", true, true, 1, 1);
        report.addAlternativeIdentifier("title", "RIS", "T1");
        report.addField("year", "number", true, false, 0, 1);
        report.addAlternativeIdentifier("year", "RIS", "Y1");
        report.addField("date", "number", true, false, 0, 1);
        report.addAlternativeIdentifier("date", "RIS", "Y1");
        report.addField("publisher", "shorttext", true, false, 0, 1);
        report.addAlternativeIdentifier("publisher", "RIS", "PB");
        report.addField("publicationLocation", "shorttext", true, false, 0, 1);
        report.addAlternativeIdentifier("publicationLocation", "RIS", "CY");
        report.addField("editor", "shorttext", true, false, 0, Integer.MAX_VALUE);
        report.addAlternativeIdentifier("editor", "RIS", "A3");
        report.addField("edition", "number", true, false, 0, 1);
        report.addAlternativeIdentifier("edition", "RIS", "VL");
        report.addField("sourceTitle", "shorttext", true, false, 0, 1);
        report.addAlternativeIdentifier("sourceTitle", "RIS", "T3");
        report.addField("pages", "number", true, false, 0, 1);
        report.addAlternativeIdentifier("pages", "RIS", "SP");
        report.addField("abstract", "longtext", true, false, 0, 1);
        report.addAlternativeIdentifier("abstract", "RIS", "N2");
        report.addField("isnIdentifier", "shorttext", true, false, 0, 1);
        report.addAlternativeIdentifier("isnIdentifier", "RIS", "SN");
        report.addField("note", "longtext", true, false, 0, Integer.MAX_VALUE);
        report.addAlternativeIdentifier("note", "RIS", "N1");
        report.addField("subject", "shorttext", true, false, 0, Integer.MAX_VALUE);
        report.addAlternativeIdentifier("subject", "RIS", "KW");
        report.addField("Language", "number", true, false, 0, 1);
        report.addField("locIdentifier", "shorttext", true, false, 0, 1);
        report.addAlternativeIdentifier("locIdentifier", "RIS", "M1");
        report.addField("dateRetrieved", "date", false, false, 0, 1);
        report.addField("openURL", "shorttext", false, false, 0, 1);
        report.addField("doi", "number", true, false, 0, 1);
        report.addField("rights", "shorttext", true, false, 0, Integer.MAX_VALUE);
        if (this.m_storage.checkSchema(unknown.getIdentifier())) {
            this.m_storage.updateSchema(unknown);
        } else {
            this.m_storage.addSchema(unknown);
        }
        if (this.m_storage.checkSchema(article.getIdentifier())) {
            this.m_storage.updateSchema(article);
        } else {
            this.m_storage.addSchema(article);
        }
        if (this.m_storage.checkSchema(book.getIdentifier())) {
            this.m_storage.updateSchema(book);
        } else {
            this.m_storage.addSchema(book);
        }
        if (this.m_storage.checkSchema(chapter.getIdentifier())) {
            this.m_storage.updateSchema(chapter);
        } else {
            this.m_storage.addSchema(chapter);
        }
        if (this.m_storage.checkSchema(report.getIdentifier())) {
            this.m_storage.updateSchema(report);
        } else {
            this.m_storage.addSchema(report);
        }
    }

    public boolean isMultivalued(String schemaId, String fieldId) {
        Schema.Field field;
        Schema schema = this.getSchema(schemaId.toLowerCase());
        if (schema == null) {
            schema = this.getSynonyms("article").contains(schemaId.toLowerCase()) ? this.getSchema("article") : (this.getSynonyms("book").contains(schemaId.toLowerCase()) ? this.getSchema("book") : (this.getSynonyms("chapter").contains(schemaId.toLowerCase()) ? this.getSchema("chapter") : (this.getSynonyms("report").contains(schemaId.toLowerCase()) ? this.getSchema("report") : this.getSchema("unknown"))));
        }
        if ((field = schema.getField(fieldId)) == null) {
            return false;
        }
        return field.isMultivalued();
    }

    public List listSchemas() {
        Set names = (Set)((Object)this.m_storage.listSchemas());
        return new Vector(names);
    }

    public String merge(String siteId, Element root, String archivePath, String fromSiteId, Map attachmentNames, Map userIdTrans, Set userListAllowImport) {
        return null;
    }

    public abstract Storage newStorage();

    protected Integer nextSerialNumber() {
        return m_nextSerialNumber.getAndIncrement();
    }

    public boolean parseEntityReference(String reference, Reference ref) {
        boolean citationEntity = false;
        if (reference.startsWith("/citation")) {
            citationEntity = true;
            String[] parts = StringUtils.split((String)reference, (String)"/");
            String subType = null;
            String context = null;
            String id = null;
            String container = null;
            if (parts.length > 2) {
                subType = parts[1];
                if ("export_ris_all".equals(subType) || "export_ris_sel".equals(subType)) {
                    context = parts[2];
                    id = parts[2];
                    ref.set("sakai:citation", subType, id, container, context);
                } else if ("content".equals(subType)) {
                    String wrappedRef = reference.substring("/citation".length(), reference.length());
                    Reference wrapped = this.m_entityManager.newReference(wrappedRef);
                    if (ref == null) {
                        M_log.warn((Object)"CitationService.parseEntityReference called with null Reference object", new Throwable());
                    } else {
                        ref.set("sakai:citation", "list", wrapped.getId(), wrapped.getContainer(), wrapped.getContext());
                    }
                } else {
                    M_log.warn((Object)(".parseEntityReference(): unknown citation subtype: " + subType + " in ref: " + reference));
                    citationEntity = false;
                }
            } else {
                citationEntity = false;
            }
        }
        return citationEntity;
    }

    public void removeCollection(CitationCollection edit) {
    }

    public void save(Citation citation) {
        if (citation instanceof BasicCitation && ((BasicCitation)citation).isTemporary()) {
            ((BasicCitation)citation).m_id = this.m_idManager.createUuid();
            ((BasicCitation)citation).m_temporary = false;
            ((BasicCitation)citation).m_serialNumber = null;
        }
        this.m_storage.saveCitation(citation);
    }

    public void setIdManager(IdManager idManager) {
        this.m_idManager = idManager;
    }

    public void save(CitationCollection collection) {
        this.m_storage.saveCollection(collection);
    }

    public void setConfigurationService(ConfigurationService service) {
        this.m_configService = service;
    }

    public void setContentHostingService(ContentHostingService service) {
        this.m_contentHostingService = service;
    }

    public void setEntityManager(EntityManager service) {
        this.m_entityManager = service;
    }

    public void setServerConfigurationService(ServerConfigurationService service) {
        this.m_serverConfigurationService = service;
    }

    public boolean willArchiveMerge() {
        return false;
    }

    public boolean isAttemptToMatchSchema() {
        return this.attemptToMatchSchema;
    }

    public void setAttemptToMatchSchema(boolean attemptToMatchSchema) {
        this.attemptToMatchSchema = attemptToMatchSchema;
    }

    private void copyCitationCollection(Reference reference) {
        ContentHostingService contentService = (ContentHostingService)ComponentManager.get(ContentHostingService.class);
        try {
            ContentResourceEdit edit = contentService.editResource(reference.getId());
            String collectionId = new String(edit.getContent());
            CitationCollection oldCollection = this.getCollection(collectionId);
            BasicCitationCollection newCollection = new BasicCitationCollection();
            newCollection.copy((BasicCitationCollection)oldCollection);
            this.save(newCollection);
            edit.setContent(newCollection.getId().getBytes());
            contentService.commitResource(edit, 0);
        }
        catch (IdUnusedException e) {
            M_log.warn((Object)"IdUnusedException ", (Throwable)e);
        }
        catch (ServerOverloadException e) {
            M_log.warn((Object)"ServerOverloadException ", (Throwable)e);
        }
        catch (PermissionException e) {
            M_log.warn((Object)"PermissionException ", (Throwable)e);
        }
        catch (TypeException e) {
            M_log.warn((Object)"TypeException ", (Throwable)e);
        }
        catch (InUseException e) {
            M_log.warn((Object)"InUseException ", (Throwable)e);
        }
        catch (OverQuotaException e) {
            M_log.warn((Object)"OverQuotaException ", (Throwable)e);
        }
    }

    public Citation addCitation(HttpServletRequest request) {
        ContextObject co = this.m_openURLService.parse(request);
        Citation citation = null;
        if (co != null) {
            citation = this.m_openURLService.convert(co);
        }
        return citation;
    }

    static {
        AUTHOR_AS_KEY.add("author");
        AUTHOR_AS_KEY.add("year");
        AUTHOR_AS_KEY.add("title");
        AUTHOR_AS_KEY.add("uuid");
        YEAR_AS_KEY = new Vector<String>();
        YEAR_AS_KEY.add("year");
        YEAR_AS_KEY.add("author");
        YEAR_AS_KEY.add("title");
        YEAR_AS_KEY.add("uuid");
        TITLE_AS_KEY = new Vector<String>();
        TITLE_AS_KEY.add("title");
        TITLE_AS_KEY.add("author");
        TITLE_AS_KEY.add("year");
        TITLE_AS_KEY.add("uuid");
        GS_TAGS = new Hashtable<String, String>();
        GS_TAGS.put("rft.title", "title");
        GS_TAGS.put("rft.atitle", "title");
        GS_TAGS.put("rft.jtitle", "atitle");
        GS_TAGS.put("rft.btitle", "atitle");
        GS_TAGS.put("rft.aulast", "au");
        GS_TAGS.put("rft.aufirst", "au");
        GS_TAGS.put("rft.au", "au");
        GS_TAGS.put("rft.pub", "publisher");
        GS_TAGS.put("rft.volume", "volume");
        GS_TAGS.put("rft.issue", "issue");
        GS_TAGS.put("rft.pages", "pages");
        GS_TAGS.put("rft.date", "date");
        GS_TAGS.put("rft.issn", "id");
        GS_TAGS.put("rft.isbn", "id");
        M_log = LogFactory.getLog(BaseCitationService.class);
        m_RISType = new Hashtable();
        m_RISTypeInverse = new Hashtable();
        m_RISNoteFields = new Hashtable();
        m_RISSpecialFields = new HashSet();
        m_RISType.put("unknown", "JOUR");
        m_RISType.put("article", "JOUR");
        m_RISType.put("book", "BOOK");
        m_RISType.put("chapter", "CHAP");
        m_RISType.put("report", "RPRT");
        m_RISType.put("proceed", "CONF");
        m_RISType.put("electronic", "ELEC");
        m_RISType.put("thesis", "THES");
        m_RISTypeInverse.put("BOOK", "book");
        m_RISTypeInverse.put("CHAP", "chapter");
        m_RISTypeInverse.put("JOUR", "article");
        m_RISTypeInverse.put("RPRT", "report");
        m_RISTypeInverse.put("CONF", "proceed");
        m_RISTypeInverse.put("ELEC", "electronic");
        m_RISTypeInverse.put("THES", "thesis");
        m_RISNoteFields.put("language", "Language: ");
        m_RISNoteFields.put("doi", "DOI: ");
        m_RISNoteFields.put("rights", "Rights: ");
        m_RISSpecialFields.add("date");
        m_RISSpecialFields.add("doi");
    }

    public final class Counter {
        private int value;
        private Integer lock = new Integer(0);

        public Counter() {
            this.value = 0;
        }

        public Counter(int val) {
            this.value = val;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void increment() {
            Integer n = this.lock;
            synchronized (n) {
                ++this.value;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void decrement() {
            Integer n = this.lock;
            synchronized (n) {
                --this.value;
            }
        }

        public int intValue() {
            return this.value;
        }
    }

    public class CitationListDuplicateAction
    extends BaseServiceLevelAction {
        public CitationListDuplicateAction() {
            super("duplicate", ResourceToolAction.ActionType.DUPLICATE, "org.sakaiproject.citation.impl.CitationList", false);
        }

        public void finalizeAction(Reference reference) {
            BaseCitationService.this.copyCitationCollection(reference);
        }
    }

    public class CitationListCopyAction
    extends BaseServiceLevelAction {
        public CitationListCopyAction() {
            super("copy", ResourceToolAction.ActionType.COPY, "org.sakaiproject.citation.impl.CitationList", true);
        }

        public void finalizeAction(Reference reference) {
            BaseCitationService.this.copyCitationCollection(reference);
        }
    }

    public class CitationSizeLabeler
    implements BasicResourceType.SizeLabeler {
        public String getLongSizeLabel(ContentEntity entity) {
            return this.getSizeLabel(entity);
        }

        public String getSizeLabel(ContentEntity entity) {
            String label = null;
            if (entity instanceof ContentResource) {
                byte[] collectionId = null;
                ContentResource resource = (ContentResource)entity;
                try {
                    collectionId = resource.getContent();
                    if (collectionId != null) {
                        CitationCollection collection = BaseCitationService.this.getCollection(new String(collectionId));
                        Object[] args = new String[]{Integer.toString(collection.size())};
                        label = rb.getFormattedMessage("citation.count", args);
                    }
                }
                catch (Exception e) {
                    String citationCollectionId = "null";
                    if (collectionId != null) {
                        citationCollectionId = collectionId.toString();
                    }
                    M_log.warn((Object)("Unable to determine size of CitationCollection for entity: entityId == " + entity.getId() + " citationCollectionId == " + collectionId + " exception == " + e.toString()));
                }
            }
            return label;
        }
    }

    public class CitationLocalizer
    implements BasicResourceType.Localizer {
        public String getLabel() {
            return rb.getString("list.title");
        }

        public String getLocalizedHoverText(ContentEntity member) {
            return rb.getString("list.title");
        }
    }

    public class CitationListDeleteAction
    extends BaseServiceLevelAction {
        public CitationListDeleteAction() {
            super("delete", ResourceToolAction.ActionType.DELETE, "org.sakaiproject.citation.impl.CitationList", true);
        }

        public void finalizeAction(Reference reference) {
            try {
                ContentResource resource = (ContentResource)reference.getEntity();
                String collectionId = new String(resource.getContent());
                CitationCollection collection = BaseCitationService.this.getCollection(collectionId);
                BaseCitationService.this.removeCollection(collection);
            }
            catch (IdUnusedException e) {
                M_log.warn((Object)"IdUnusedException ", (Throwable)e);
            }
            catch (ServerOverloadException e) {
                M_log.warn((Object)"ServerOverloadException ", (Throwable)e);
            }
        }
    }

    public class CitationListCreateAction
    extends BaseInteractionAction {
        public CitationListCreateAction(String id, ResourceToolAction.ActionType actionType, String typeId, String helperId, List requiredPropertyKeys) {
            super(id, actionType, typeId, helperId, requiredPropertyKeys);
        }

        public boolean available(ContentEntity entity) {
            return super.available(entity);
        }
    }

    public class UrlWrapper {
        protected String m_label;
        protected String m_url;
        protected boolean m_addPrefix;

        public UrlWrapper(String label, String url, boolean addPrefix) {
            this.m_label = label;
            this.m_url = url;
            this.m_addPrefix = addPrefix;
        }

        public UrlWrapper(String label, String url) {
            this.m_label = label;
            this.m_url = url;
            this.m_addPrefix = false;
        }

        public String getLabel() {
            return this.m_label;
        }

        public String getUrl() {
            return this.m_url;
        }

        public boolean addPrefix() {
            return this.m_addPrefix;
        }

        public void setLabel(String label) {
            this.m_label = label;
        }

        public void setUrl(String url) {
            this.m_url = url;
        }

        public void setAddPrefix(boolean addPrefix) {
            this.m_addPrefix = addPrefix;
        }
    }

    protected static interface Storage {
        public Citation addCitation(String var1);

        public CitationCollection addCollection(Map var1, List var2);

        public Schema addSchema(Schema var1);

        public boolean checkCitation(String var1);

        public boolean checkCollection(String var1);

        public boolean checkSchema(String var1);

        public long mostRecentUpdate(String var1);

        public void close();

        public CitationCollection copyAll(String var1);

        public Citation getCitation(String var1);

        public CitationCollection getCollection(String var1);

        public Schema getSchema(String var1);

        public List getSchemas();

        public List listSchemas();

        public void open();

        public void putSchemas(Collection var1);

        public void removeCitation(Citation var1);

        public void removeCollection(CitationCollection var1);

        public void removeSchema(Schema var1);

        public void saveCitation(Citation var1);

        public void saveCollection(CitationCollection var1);

        public void updateSchema(Schema var1);

        public void updateSchemas(Collection var1);
    }

    protected class BasicSchema
    implements Schema {
        protected String defaultNamespace;
        protected List fields;
        protected String identifier;
        protected Map index;
        protected Map namespaces;
        protected Map identifiers;

        public BasicSchema() {
            this.fields = new Vector();
            this.index = new Hashtable();
            this.identifiers = new Hashtable();
        }

        public BasicSchema(Schema other) {
            this.identifier = other.getIdentifier();
            this.defaultNamespace = other.getNamespaceAbbrev();
            this.namespaces = new Hashtable();
            List nsAbbrevs = other.getNamespaceAbbreviations();
            if (nsAbbrevs != null) {
                for (String nsAbbrev : nsAbbrevs) {
                    String ns = other.getNamespaceUri(nsAbbrev);
                    this.namespaces.put(nsAbbrev, ns);
                }
            }
            this.identifiers = new Hashtable();
            if (other instanceof BasicSchema) {
                for (String format : ((BasicSchema)other).identifiers.keySet()) {
                    this.identifiers.put(format, ((BasicSchema)other).identifiers.get(format));
                }
            }
            this.fields = new Vector();
            this.index = new Hashtable();
            List fields = other.getFields();
            for (Schema.Field field : fields) {
                this.fields.add(new BasicField(field));
                this.index.put(field.getIdentifier(), field);
            }
        }

        public BasicSchema(String schemaId) {
            this.identifier = schemaId;
            this.fields = new Vector();
            this.index = new Hashtable();
            this.identifiers = new Hashtable();
        }

        public void addAlternativeIdentifier(String fieldId, String altFormat, String altIdentifier) {
            BasicField field = (BasicField)this.index.get(fieldId);
            if (field != null) {
                field.setIdentifier(altFormat, altIdentifier);
            }
        }

        public void addField(Schema.Field field) {
            this.index.put(field.getIdentifier(), field);
            this.fields.add(field);
        }

        public void addField(int order, Schema.Field field) {
            this.fields.add(order, field);
            this.index.put(this.identifier, field);
        }

        public BasicField addField(String identifier, String valueType, boolean isEditable, boolean required, int minCardinality, int maxCardinality) {
            if (this.fields == null) {
                this.fields = new Vector();
            }
            if (this.index == null) {
                this.index = new Hashtable();
            }
            BasicField field = new BasicField(identifier, valueType, isEditable, required, minCardinality, maxCardinality);
            this.fields.add(field);
            this.index.put(identifier, field);
            return field;
        }

        public BasicField addOptionalField(String identifier, String valueType, int minCardinality, int maxCardinality) {
            return this.addField(identifier, valueType, true, false, minCardinality, maxCardinality);
        }

        public BasicField addRequiredField(String identifier, String valueType, int minCardinality, int maxCardinality) {
            return this.addField(identifier, valueType, true, true, minCardinality, maxCardinality);
        }

        public Schema.Field getField(int index) {
            if (this.fields == null) {
                this.fields = new Vector();
            }
            return (Schema.Field)this.fields.get(index);
        }

        public Schema.Field getField(String name) {
            if (this.index == null) {
                this.index = new Hashtable();
            }
            return (Schema.Field)this.index.get(name);
        }

        public List getFields() {
            if (this.fields == null) {
                this.fields = new Vector();
            }
            return this.fields;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String getIdentifier(String format) {
            return (String)this.identifiers.get(format);
        }

        public String getNamespaceAbbrev() {
            return this.defaultNamespace;
        }

        public List getNamespaceAbbreviations() {
            if (this.namespaces == null) {
                this.namespaces = new Hashtable();
            }
            Set keys = this.namespaces.keySet();
            Vector rv = new Vector();
            if (keys != null) {
                rv.addAll(keys);
            }
            return rv;
        }

        public String getNamespaceUri(String abbrev) {
            if (this.namespaces == null) {
                this.namespaces = new Hashtable();
            }
            return (String)this.namespaces.get(abbrev);
        }

        public List getRequiredFields() {
            if (this.fields == null) {
                this.fields = new Vector();
            }
            Vector<Schema.Field> required = new Vector<Schema.Field>();
            for (Schema.Field field : this.fields) {
                if (!field.isRequired()) continue;
                required.add(field);
            }
            return required;
        }

        public void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public void setIdentifier(String format, String identifier) {
            this.identifiers.put(format, identifier);
        }

        public void sortFields() {
            Collections.sort(this.fields, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    if (arg0 instanceof BasicField && arg1 instanceof BasicField) {
                        Integer int0 = new Integer(((BasicField)arg0).getOrder());
                        Integer int1 = new Integer(((BasicField)arg1).getOrder());
                        return int0.compareTo(int1);
                    }
                    if (arg0 instanceof Schema.Field && arg1 instanceof Schema.Field) {
                        String lbl0 = ((Schema.Field)arg0).getLabel();
                        String lbl1 = ((Schema.Field)arg1).getLabel();
                        return lbl0.compareTo(lbl1);
                    }
                    throw new ClassCastException(arg0.toString() + " " + arg1.toString());
                }
            });
        }

        public String toString() {
            return "BasicSchema: " + this.identifier;
        }
    }

    public class BasicField
    implements Schema.Field {
        protected Object defaultValue;
        protected String description;
        protected String identifier;
        protected String label;
        protected int maxCardinality;
        protected int minCardinality;
        protected String namespace;
        protected int order;
        protected boolean required;
        protected String valueType;
        protected Map identifiers;
        protected boolean isEditable;
        public static final String DELIMITER = ",";

        public BasicField(Schema.Field other) {
            this.identifier = other.getIdentifier();
            this.valueType = other.getValueType();
            this.required = other.isRequired();
            this.minCardinality = other.getMinCardinality();
            this.maxCardinality = other.getMaxCardinality();
            this.namespace = other.getNamespaceAbbreviation();
            this.description = other.getDescription();
            this.identifiers = new Hashtable();
            this.isEditable = other.isEditable();
            if (other instanceof BasicField) {
                this.order = ((BasicField)other).getOrder();
                for (String format : ((BasicField)other).identifiers.keySet()) {
                    this.identifiers.put(format, ((BasicField)other).identifiers.get(format));
                }
            }
        }

        public BasicField(String identifier, String valueType, boolean isEditable, boolean required, int minCardinality, int maxCardinality) {
            this.identifier = identifier;
            this.valueType = valueType;
            this.required = required;
            this.minCardinality = minCardinality;
            this.maxCardinality = maxCardinality;
            this.namespace = "";
            this.label = "";
            this.description = "";
            this.order = 0;
            this.identifiers = new Hashtable();
            this.isEditable = true;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public String getDescription() {
            return this.description;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String getIdentifier(String format) {
            String tempString = null;
            String[] tokens = null;
            tempString = (String)this.identifiers.get(format);
            if (tempString == null) {
                tempString = "";
            }
            if ((tempString = tempString.trim()).indexOf(DELIMITER) != -1) {
                tokens = tempString.split(DELIMITER);
                tempString = tokens[0];
            }
            return tempString;
        }

        public String[] getIdentifierComplex(String format) {
            String tempString = null;
            String[] tokens = null;
            tempString = (String)this.identifiers.get(format);
            if (tempString == null) {
                tempString = "";
            }
            tokens = (tempString = tempString.trim()).indexOf(DELIMITER) != -1 ? tempString.split(DELIMITER) : new String[]{tempString};
            return tokens;
        }

        public String getLabel() {
            return this.label;
        }

        public int getMaxCardinality() {
            return this.maxCardinality;
        }

        public int getMinCardinality() {
            return this.minCardinality;
        }

        public String getNamespaceAbbreviation() {
            return this.namespace;
        }

        public int getOrder() {
            return this.order;
        }

        public String getValueType() {
            return this.valueType;
        }

        public boolean isEditable() {
            return this.isEditable;
        }

        public boolean isMultivalued() {
            return this.maxCardinality > 1;
        }

        public boolean isRequired() {
            return this.required;
        }

        public void setDefaultValue(Object value) {
            this.defaultValue = value;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setEditable(boolean isEditable) {
            this.isEditable = isEditable;
        }

        public void setIdentifier(String format, String identifier) {
            this.identifiers.put(format, identifier);
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public void setMaxCardinality(int maxCardinality) {
            this.maxCardinality = maxCardinality;
        }

        public void setMinCardinality(int minCardinality) {
            this.minCardinality = minCardinality;
        }

        public void setNamespaceAbbreviation(String namespace) {
            this.namespace = namespace;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }

        public void setValueType(String valueType) {
            this.valueType = valueType;
        }

        public String toString() {
            return "BasicField: " + this.identifier;
        }
    }

    public class BasicCitationCollection
    implements CitationCollection {
        protected final Comparator DEFAULT_COMPARATOR = new PositionComparator();
        protected Map<String, Citation> m_citations = new Hashtable<String, Citation>();
        protected Comparator m_comparator = this.DEFAULT_COMPARATOR;
        protected String m_sortOrder;
        protected SortedSet<String> m_order;
        protected int m_pageSize = 10;
        protected String m_description;
        protected String m_id;
        protected String m_title;
        protected boolean m_temporary = false;
        protected Integer m_serialNumber;
        protected ActiveSearch m_mySearch;
        protected boolean m_ascending = true;
        protected long m_mostRecentUpdate = 0L;

        public BasicCitationCollection() {
            this.m_id = BaseCitationService.this.m_idManager.createUuid();
        }

        public BasicCitationCollection(boolean temporary) {
            this.m_order = new TreeSet<String>(this.m_comparator);
            this.m_temporary = temporary;
            if (temporary) {
                this.m_serialNumber = BaseCitationService.this.nextSerialNumber();
            } else {
                this.m_id = BaseCitationService.this.m_idManager.createUuid();
            }
        }

        public BasicCitationCollection(Map attributes, List citations) {
            this.m_id = BaseCitationService.this.m_idManager.createUuid();
            this.m_order = new TreeSet<String>(this.m_comparator);
            if (citations != null) {
                Iterator citationIt = citations.iterator();
                while (citationIt.hasNext()) {
                    this.add((Citation)citationIt.next());
                }
            }
        }

        public BasicCitationCollection(String collectionId) {
            this.m_id = collectionId;
            this.m_order = new TreeSet<String>(this.m_comparator);
        }

        public void add(Citation citation) {
            if (!this.m_citations.keySet().contains(citation.getId())) {
                citation.setPosition(this.m_citations.size() + 1);
                this.m_citations.put(citation.getId(), citation);
            }
            if (!this.m_order.contains(citation.getId())) {
                this.m_order.add(citation.getId());
            }
        }

        public void addAll(CitationCollection other) {
            this.checkForUpdates();
            if (this.m_order == null) {
                this.m_order = new TreeSet<String>();
            }
            for (String key : ((BasicCitationCollection)other).m_order) {
                try {
                    Citation citation = other.getCitation(key);
                    this.add(citation);
                }
                catch (IdUnusedException e) {
                    M_log.debug((Object)("BasicCitationCollection.addAll citationId (" + key + ") in m_order but not in m_citations; collectionId: " + other.getId()));
                }
            }
        }

        public void clear() {
            this.m_order.clear();
            this.m_citations.clear();
        }

        public boolean contains(Citation citation) {
            this.checkForUpdates();
            return this.m_citations.containsKey(citation.getId());
        }

        protected void copy(BasicCitationCollection other) {
            this.checkForUpdates();
            this.m_ascending = other.m_ascending;
            this.m_comparator = other.m_comparator instanceof MultipleKeyComparator ? new MultipleKeyComparator((MultipleKeyComparator)other.m_comparator) : new MultipleKeyComparator(TITLE_AS_KEY, true);
            this.set(other);
        }

        public void exportRis(StringBuilder buffer, List<String> citationIds) throws IOException {
            this.checkForUpdates();
            for (String citationId : citationIds) {
                Citation citation = this.m_citations.get(citationId);
                if (citation == null) continue;
                citation.exportRis(buffer);
            }
        }

        protected String getAlternateReferenceRoot(String rootProperty) {
            if (rootProperty == null || rootProperty.trim().equals("")) {
                return "";
            }
            if (!rootProperty.startsWith("/")) {
                rootProperty = "/" + rootProperty;
            }
            if (rootProperty.endsWith("/")) {
                rootProperty = rootProperty.substring(0, rootProperty.length() - "/".length());
            }
            return rootProperty;
        }

        public Citation getCitation(String citationId) throws IdUnusedException {
            this.checkForUpdates();
            Citation citation = this.m_citations.get(citationId);
            if (citation == null) {
                throw new IdUnusedException(citationId);
            }
            return citation;
        }

        public List getCitations() {
            this.checkForUpdates();
            Vector<Citation> citations = new Vector<Citation>();
            if (this.m_citations == null) {
                this.m_citations = new Hashtable<String, Citation>();
            }
            if (this.m_order == null) {
                this.m_order = new TreeSet<String>();
            }
            for (String key : this.m_order) {
                Citation citation = this.m_citations.get(key);
                if (citation == null) continue;
                citations.add(citation);
            }
            return citations;
        }

        public CitationCollection getCitations(Comparator c) {
            this.checkForUpdates();
            return null;
        }

        public CitationCollection getCitations(Comparator c, Filter f) {
            this.checkForUpdates();
            return null;
        }

        public CitationCollection getCitations(Filter f) {
            this.checkForUpdates();
            return null;
        }

        public CitationCollection getCitations(Map properties) {
            this.checkForUpdates();
            return null;
        }

        public String getDescription() {
            this.checkForUpdates();
            return this.m_description;
        }

        public String getId() {
            return this.m_id;
        }

        public Date getLastModifiedDate() {
            this.checkForUpdates();
            return new Date(this.m_mostRecentUpdate);
        }

        public ResourceProperties getProperties() {
            return null;
        }

        public String getReference() {
            return this.getReference(null);
        }

        public String getReference(String rootProperty) {
            return BaseCitationService.this.m_relativeAccessPoint + this.getAlternateReferenceRoot(rootProperty) + "/" + this.getId();
        }

        public String getSort() {
            if (this.m_sortOrder == null) {
                this.m_sortOrder = "default";
            }
            return this.m_sortOrder;
        }

        public String getSaveUrl() {
            String url = BaseCitationService.this.m_serverConfigurationService.getServerUrl() + "/savecite/" + this.getId() + "/";
            return url;
        }

        public String getTitle() {
            this.checkForUpdates();
            return this.m_title;
        }

        public String getUrl() {
            return this.getUrl(null);
        }

        public String getUrl(String rootProperty) {
            return BaseCitationService.this.getAccessPoint(false) + this.getAlternateReferenceRoot(rootProperty) + "/" + this.getId();
        }

        public boolean isEmpty() {
            this.checkForUpdates();
            return this.m_citations.isEmpty();
        }

        public CitationIterator iterator() {
            this.checkForUpdates();
            return new BasicIterator();
        }

        public boolean remove(Citation item) {
            this.checkForUpdates();
            boolean success = true;
            this.m_order.remove(item.getId());
            Citation obj = this.m_citations.remove(item.getId());
            if (obj == null) {
                success = false;
            }
            return success;
        }

        public void saveCitation(Citation citation) {
            BaseCitationService.this.save(citation);
        }

        public void setSort(Comparator comparator) {
            this.checkForUpdates();
            this.m_comparator = comparator;
            SortedSet<String> oldSet = this.m_order;
            this.m_order = new TreeSet<String>(this.m_comparator);
            this.m_order.addAll(oldSet);
        }

        public void setSort(String sortBy, boolean ascending) {
            this.m_ascending = ascending;
            String status = "UNSET";
            if (sortBy == null || sortBy.equalsIgnoreCase("default")) {
                this.m_comparator = null;
            } else if (sortBy.equalsIgnoreCase("author")) {
                this.m_comparator = new AuthorComparator(ascending);
                status = "AUTHOR SET";
            } else if (sortBy.equalsIgnoreCase("title")) {
                this.m_comparator = new TitleComparator(ascending);
                status = "TITLE SET";
            } else if (sortBy.equalsIgnoreCase("year")) {
                this.m_comparator = new YearComparator(ascending);
                status = "YEAR SET";
            } else if (sortBy.equalsIgnoreCase("position")) {
                this.m_comparator = new PositionComparator();
                status = "POSITION SET";
            }
            if (this.m_comparator != null) {
                this.m_sortOrder = sortBy;
                SortedSet<String> oldSet = this.m_order;
                this.m_order = new TreeSet<String>(this.m_comparator);
                this.m_order.addAll(oldSet);
            }
        }

        public int size() {
            this.checkForUpdates();
            return this.m_order.size();
        }

        public String toString() {
            return "BasicCitationCollection: " + this.m_id;
        }

        public Element toXml(Document doc, Stack stack) {
            return null;
        }

        protected void checkForUpdates() {
            CitationCollection edit;
            if (this.m_mostRecentUpdate < BaseCitationService.this.m_storage.mostRecentUpdate(this.m_id) && (edit = BaseCitationService.this.m_storage.getCollection(this.m_id)) != null) {
                this.set((BasicCitationCollection)edit);
            }
        }

        protected void set(BasicCitationCollection other) {
            this.m_description = other.m_description;
            this.m_serialNumber = other.m_serialNumber;
            this.m_pageSize = other.m_pageSize;
            this.m_temporary = other.m_temporary;
            this.m_title = other.m_title;
            if (this.m_citations == null) {
                this.m_citations = new Hashtable<String, Citation>();
            }
            this.m_citations.clear();
            if (this.m_order == null) {
                this.m_order = new TreeSet<String>(this.m_comparator);
            }
            this.m_order.clear();
            for (String citationId : other.m_citations.keySet()) {
                BasicCitation oldCitation = (BasicCitation)other.m_citations.get(citationId);
                BasicCitation newCitation = new BasicCitation();
                try {
                    newCitation.copy(oldCitation);
                    newCitation.m_id = oldCitation.m_id;
                    newCitation.m_temporary = false;
                    this.saveCitation(newCitation);
                    this.add(newCitation);
                }
                catch (Exception e) {
                    M_log.warn((Object)("copy(" + oldCitation.getId() + ") ==> " + newCitation.getId()), (Throwable)e);
                }
            }
            this.m_mostRecentUpdate = TimeService.newTime().getTime();
        }

        public class TitleComparator
        extends MultipleKeyComparator {
            public TitleComparator(boolean ascending) {
                super(TITLE_AS_KEY, ascending);
            }
        }

        public class BasicIterator
        implements CitationIterator {
            protected List listOfKeys;
            protected int firstItem;
            protected int nextItem;
            protected int lastItem;

            public BasicIterator() {
                BasicCitationCollection.this.checkForUpdates();
                this.listOfKeys = new Vector<String>(BasicCitationCollection.this.m_order);
                this.firstItem = 0;
                this.setIndexes();
            }

            public int getPageSize() {
                return BasicCitationCollection.this.m_pageSize;
            }

            public boolean hasNext() {
                boolean hasNext = false;
                hasNext = BasicCitationCollection.this.m_ascending ? this.nextItem < this.lastItem && this.nextItem < this.listOfKeys.size() : this.nextItem > this.lastItem && this.nextItem > 0;
                return hasNext;
            }

            public boolean hasNextPage() {
                boolean hasNextPage = false;
                hasNextPage = BasicCitationCollection.this.m_ascending ? this.firstItem + BasicCitationCollection.this.m_pageSize < this.listOfKeys.size() : this.firstItem - BasicCitationCollection.this.m_pageSize >= 0;
                return hasNextPage;
            }

            public boolean hasPreviousPage() {
                boolean hasPreviousPage = false;
                hasPreviousPage = BasicCitationCollection.this.m_ascending ? this.firstItem > 0 : this.firstItem + BasicCitationCollection.this.m_pageSize < this.listOfKeys.size();
                return hasPreviousPage;
            }

            public Object next() {
                Citation item = null;
                if (BasicCitationCollection.this.m_ascending) {
                    if (this.nextItem >= this.lastItem || this.nextItem >= this.listOfKeys.size()) {
                        throw new NoSuchElementException();
                    }
                    item = BasicCitationCollection.this.m_citations.get(this.listOfKeys.get(this.nextItem++));
                } else {
                    if (this.nextItem <= this.lastItem || this.nextItem <= 0) {
                        throw new NoSuchElementException();
                    }
                    item = BasicCitationCollection.this.m_citations.get(this.listOfKeys.get(this.nextItem--));
                }
                return item;
            }

            public void nextPage() {
                this.firstItem = BasicCitationCollection.this.m_ascending ? (this.firstItem += BasicCitationCollection.this.m_pageSize) : (this.firstItem -= BasicCitationCollection.this.m_pageSize);
                this.setIndexes();
            }

            public void previousPage() {
                this.firstItem = BasicCitationCollection.this.m_ascending ? (this.firstItem -= BasicCitationCollection.this.m_pageSize) : (this.firstItem += BasicCitationCollection.this.m_pageSize);
                this.setIndexes();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            protected void setIndexes() {
                this.nextItem = this.firstItem;
                this.lastItem = BasicCitationCollection.this.m_ascending ? Math.min(this.listOfKeys.size(), this.nextItem + BasicCitationCollection.this.m_pageSize) : Math.max(0, this.nextItem - BasicCitationCollection.this.m_pageSize);
            }

            public void setOrder(Comparator comparator) {
                BasicCitationCollection.this.m_comparator = comparator;
                if (comparator != null) {
                    Collections.sort(this.listOfKeys, BasicCitationCollection.this.m_comparator);
                }
                this.firstItem = 0;
                this.setIndexes();
            }

            public void setPageSize(int size) {
                if (size > 0) {
                    if (this.lastItem <= size) {
                        this.firstItem = 0;
                    }
                    this.lastItem = this.firstItem + size;
                    if (this.lastItem >= this.listOfKeys.size()) {
                        this.lastItem = this.listOfKeys.size() - 1;
                    }
                    BasicCitationCollection.this.m_pageSize = size;
                    this.setIndexes();
                }
            }

            public int getStart() {
                return this.firstItem;
            }

            public int getEnd() {
                return this.lastItem;
            }

            public void setStart(int i) {
                if (i >= 0 && i < this.listOfKeys.size()) {
                    this.firstItem = i;
                    this.setIndexes();
                }
            }
        }

        public class PositionComparator
        implements Comparator {
            public int compare(Object arg0, Object arg1) {
                boolean rv = false;
                if (!(arg0 instanceof String) || !(arg1 instanceof String)) {
                    throw new ClassCastException();
                }
                Citation obj0 = BasicCitationCollection.this.m_citations.get(arg0);
                Citation obj1 = BasicCitationCollection.this.m_citations.get(arg1);
                if (!(obj0 instanceof Citation) || !(obj1 instanceof Citation)) {
                    throw new ClassCastException();
                }
                Citation cit0 = obj0;
                Citation cit1 = obj1;
                if (cit0.getPosition() > cit1.getPosition()) {
                    return 1;
                }
                if (cit0.getPosition() == cit1.getPosition()) {
                    return 0;
                }
                return -1;
            }
        }

        public class YearComparator
        extends MultipleKeyComparator {
            public YearComparator(boolean ascending) {
                super(YEAR_AS_KEY, ascending);
            }
        }

        public class AuthorComparator
        extends MultipleKeyComparator {
            public AuthorComparator(boolean ascending) {
                super(AUTHOR_AS_KEY, ascending);
            }
        }

        public class MultipleKeyComparator
        implements Comparator {
            protected List<String> m_keys = new Vector<String>();
            protected boolean m_ascending = true;

            public MultipleKeyComparator(List<String> keys, boolean ascending) {
                this.m_keys.addAll(keys);
            }

            public MultipleKeyComparator(MultipleKeyComparator mkc) {
                this.m_keys = mkc.m_keys;
                this.m_ascending = mkc.m_ascending;
            }

            public int compare(Object arg0, Object arg1) {
                int rv = 0;
                if (!(arg0 instanceof String) || !(arg1 instanceof String)) {
                    throw new ClassCastException();
                }
                Citation obj0 = BasicCitationCollection.this.m_citations.get(arg0);
                Citation obj1 = BasicCitationCollection.this.m_citations.get(arg1);
                if (!(obj0 instanceof Citation) || !(obj1 instanceof Citation)) {
                    throw new ClassCastException();
                }
                Citation cit0 = obj0;
                Citation cit1 = obj1;
                Iterator<String> keyIt = this.m_keys.iterator();
                while (rv == 0 && keyIt.hasNext()) {
                    String key = keyIt.next();
                    if ("title".equalsIgnoreCase(key)) {
                        String title0 = ((String)cit0.getCitationProperty("title", true)).toLowerCase();
                        String title1 = ((String)cit1.getCitationProperty("title", true)).toLowerCase();
                        if (title0 == null) {
                            title0 = "";
                        }
                        if (title1 == null) {
                            title1 = "";
                        }
                        rv = this.m_ascending ? title0.compareTo(title1) : title1.compareTo(title0);
                        continue;
                    }
                    if ("author".equalsIgnoreCase(key)) {
                        String author0 = cit0.getCreator().toLowerCase();
                        String author1 = cit1.getCreator().toLowerCase();
                        if (author0 == null) {
                            author0 = "";
                        }
                        if (author1 == null) {
                            author1 = "";
                        }
                        rv = this.m_ascending ? author0.compareTo(author1) : author1.compareTo(author0);
                        continue;
                    }
                    if ("year".equalsIgnoreCase(key)) {
                        String year0 = cit0.getYear();
                        String year1 = cit1.getYear();
                        if (year0 == null) {
                            year0 = "";
                        }
                        if (year1 == null) {
                            year1 = "";
                        }
                        rv = this.m_ascending ? year0.compareTo(year1) : year1.compareTo(year0);
                        continue;
                    }
                    if (!"uuid".equalsIgnoreCase(key)) continue;
                    rv = cit0.getId().compareTo(cit1.getId());
                }
                return rv;
            }

            public void addKey(String key) {
                this.m_keys.add(key);
            }
        }
    }

    public class BasicCitation
    implements Citation {
        protected static final String OPENURL_VERSION = "Z39.88-2004";
        protected static final String OPENURL_CONTEXT_FORMAT = "info:ofi/fmt:kev:mtx:ctx";
        protected static final String OPENURL_JOURNAL_FORMAT = "info:ofi/fmt:kev:mtx:journal";
        protected static final String OPENURL_BOOK_FORMAT = "info:ofi/fmt:kev:mtx:book";
        protected Map m_citationProperties = null;
        protected Map m_urls;
        protected String m_citationUrl = null;
        protected String m_fullTextUrl = null;
        protected String m_id = null;
        protected String m_imageUrl = null;
        protected int m_position;
        protected Schema m_schema;
        protected String m_searchSourceUrl = null;
        protected Integer m_serialNumber = null;
        protected boolean m_temporary = false;
        protected boolean m_isAdded = false;
        protected String m_preferredUrl;

        protected BasicCitation() {
            this.m_serialNumber = BaseCitationService.this.nextSerialNumber();
            this.m_temporary = true;
            this.m_citationProperties = new Hashtable();
            this.m_urls = new Hashtable();
            this.setType("unknown");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected BasicCitation(Asset asset) {
            this.m_serialNumber = BaseCitationService.this.nextSerialNumber();
            this.m_temporary = true;
            this.m_citationProperties = new Hashtable();
            this.m_urls = new Hashtable();
            boolean unknownSchema = true;
            String title = null;
            Set validProperties = BaseCitationService.this.getValidPropertyNames();
            Set multivalued = BaseCitationService.this.getMultivalued();
            String preferredUrl = null;
            String preferred = BaseCitationService.this.m_configService.getSiteConfigUsePreferredUrls();
            boolean usePreferredUrlAsTitle = preferred.equals("title-link");
            boolean usePreferredUrls = !preferred.equals("false");
            try {
                String description;
                title = asset.getDisplayName();
                if (title != null) {
                    this.m_citationProperties.put("title", title);
                }
                if ((description = asset.getDescription()) != null) {
                    this.m_citationProperties.put("abstract", description);
                }
                RecordIterator rit = asset.getRecords();
                try {
                    while (rit.hasNextRecord()) {
                        try {
                            Record record = rit.nextRecord();
                            preferredUrl = null;
                            try {
                                PartIterator pit = record.getParts();
                                try {
                                    while (pit.hasNextPart()) {
                                        try {
                                            List<Serializable> values;
                                            Part part = pit.nextPart();
                                            String type = part.getPartStructure().getType().getKeyword();
                                            if (type == null) continue;
                                            if (validProperties.contains(type)) {
                                                if (multivalued.contains(type)) {
                                                    values = (Vector<Serializable>)this.m_citationProperties.get(type);
                                                    if (values == null) {
                                                        values = new Vector<Serializable>();
                                                        this.m_citationProperties.put(type, values);
                                                    }
                                                    values.add(part.getValue());
                                                    continue;
                                                }
                                                this.m_citationProperties.put(type, part.getValue());
                                                continue;
                                            }
                                            if (type.equals("preferredUrl")) {
                                                preferredUrl = (String)((Object)part.getValue());
                                                continue;
                                            }
                                            if (!type.equals("type")) continue;
                                            if (this.m_schema == null || this.m_schema.getIdentifier().equals("unknown")) {
                                                if (BaseCitationService.this.getSynonyms("article").contains(part.getValue().toString().toLowerCase())) {
                                                    this.m_schema = BaseCitationService.this.getSchema("article");
                                                    unknownSchema = false;
                                                } else if (BaseCitationService.this.getSynonyms("book").contains(part.getValue().toString().toLowerCase())) {
                                                    this.m_schema = BaseCitationService.this.getSchema("book");
                                                    unknownSchema = false;
                                                } else if (BaseCitationService.this.getSynonyms("chapter").contains(part.getValue().toString().toLowerCase())) {
                                                    this.m_schema = BaseCitationService.this.getSchema("chapter");
                                                    unknownSchema = false;
                                                } else if (BaseCitationService.this.getSynonyms("report").contains(part.getValue().toString().toLowerCase())) {
                                                    this.m_schema = BaseCitationService.this.getSchema("report");
                                                    unknownSchema = false;
                                                } else {
                                                    this.m_schema = BaseCitationService.this.getSchema("unknown");
                                                    unknownSchema = true;
                                                }
                                            }
                                            if ((values = (List)this.m_citationProperties.get(type)) == null) {
                                                values = new Vector();
                                                this.m_citationProperties.put(type, values);
                                            }
                                            values.add(part.getValue());
                                        }
                                        catch (RepositoryException e) {
                                            M_log.warn((Object)("BasicCitation(" + asset + ") "), (Throwable)e);
                                        }
                                    }
                                }
                                catch (RepositoryException e) {
                                    M_log.warn((Object)("BasicCitation(" + asset + ") "), (Throwable)e);
                                }
                            }
                            catch (RepositoryException e1) {
                                M_log.warn((Object)("BasicCitation(" + asset + ") "), (Throwable)e1);
                            }
                        }
                        catch (RepositoryException e2) {
                            M_log.warn((Object)("BasicCitation(" + asset + ") "), (Throwable)e2);
                        }
                    }
                }
                catch (RepositoryException e) {
                    M_log.warn((Object)("BasicCitation(" + asset + ") "), (Throwable)e);
                }
            }
            catch (RepositoryException e) {
                M_log.warn((Object)("BasicCitation(" + asset + ") "), (Throwable)e);
            }
            if (unknownSchema && BaseCitationService.this.attemptToMatchSchema) {
                this.matchSchema();
            }
            this.setDefaults();
            if (usePreferredUrls && preferredUrl != null) {
                String id = this.addCustomUrl("", preferredUrl, "y");
                if (usePreferredUrlAsTitle) {
                    this.setPreferredUrl(id);
                }
            }
        }

        protected void matchSchema() {
            Hashtable<String, Counter> pros = new Hashtable<String, Counter>();
            Hashtable<String, Counter> cons = new Hashtable<String, Counter>();
            List schemas = BaseCitationService.this.getSchemas();
            Set fieldNames = this.m_citationProperties.keySet();
            for (Schema schema : schemas) {
                if (schema.getIdentifier().equals("unknown")) continue;
                pros.put(schema.getIdentifier(), new Counter());
                cons.put(schema.getIdentifier(), new Counter());
                for (String fieldName : fieldNames) {
                    Schema.Field field = schema.getField(fieldName);
                    if (field == null) {
                        ((Counter)cons.get(schema.getIdentifier())).increment();
                        continue;
                    }
                    ((Counter)pros.get(schema.getIdentifier())).increment();
                }
            }
            for (Map.Entry entry : cons.entrySet()) {
                if (((Counter)entry.getValue()).intValue() <= 0) continue;
                pros.remove(entry.getKey());
            }
            Iterator prosIt = pros.keySet().iterator();
            int bestScore = 0;
            String bestMatch = null;
            Object article = pros.get("article");
            if (article != null) {
                bestScore = ((Counter)article).intValue();
                bestMatch = "article";
            }
            while (prosIt.hasNext()) {
                String schemaId = (String)prosIt.next();
                int score = ((Counter)pros.get(schemaId)).intValue();
                if (score <= bestScore) continue;
                bestScore = score;
                bestMatch = schemaId;
            }
            if (bestMatch != null) {
                this.m_schema = BaseCitationService.this.getSchema(bestMatch);
            }
        }

        public BasicCitation(BasicCitation other) {
            this.m_id = other.m_id;
            this.m_serialNumber = other.m_serialNumber;
            this.m_temporary = other.m_temporary;
            this.m_citationProperties = new Hashtable();
            this.m_urls = new Hashtable();
            this.setSchema(other.m_schema);
            this.copy(other);
        }

        public BasicCitation(String mediatype) {
            this.m_id = BaseCitationService.this.m_idManager.createUuid();
            this.m_citationProperties = new Hashtable();
            this.m_urls = new Hashtable();
            this.setType(mediatype);
        }

        public BasicCitation(String citationId, Schema schema) {
            this.m_id = citationId;
            this.m_citationProperties = new Hashtable();
            this.m_urls = new Hashtable();
            this.setSchema(schema);
        }

        public BasicCitation(String citationId, String mediatype) {
            this.m_id = citationId;
            this.m_citationProperties = new Hashtable();
            this.m_urls = new Hashtable();
            this.setType(mediatype);
        }

        public String addCustomUrl(String label, String url) {
            UrlWrapper wrapper = new UrlWrapper(label, url);
            String id = BaseCitationService.this.m_idManager.createUuid();
            this.m_urls.put(id, wrapper);
            return id;
        }

        public String addCustomUrl(String label, String url, String prefixRequest) {
            UrlWrapper wrapper = new UrlWrapper(label, url, this.getPrefixBoolean(prefixRequest));
            String id = BaseCitationService.this.m_idManager.createUuid();
            this.m_urls.put(id, wrapper);
            return id;
        }

        public void updateCustomUrl(String urlid, String label, String url, String prefixRequest) {
            UrlWrapper wrapper = new UrlWrapper(label, url, this.getPrefixBoolean(prefixRequest));
            this.m_urls.put(urlid, wrapper);
        }

        private boolean getPrefixBoolean(String prefixRequest) {
            if (!"y".equals(prefixRequest) && !"n".equals(prefixRequest)) {
                M_log.debug((Object)("Unexpected \"add prefix\" request: " + prefixRequest));
            }
            return "y".equals(prefixRequest);
        }

        public void addPropertyValue(String name, Object value) {
            this.getCitationProperties();
            if (this.isMultivalued(name)) {
                Vector<Object> list = (Vector<Object>)this.m_citationProperties.get(name);
                if (list == null) {
                    list = new Vector<Object>();
                    this.m_citationProperties.put(name, list);
                }
                list.add(value);
            } else {
                this.m_citationProperties.put(name, value);
            }
        }

        public void copy(Citation citation) {
            BasicCitation other = (BasicCitation)citation;
            this.m_citationUrl = other.m_citationUrl;
            this.m_fullTextUrl = other.m_fullTextUrl;
            this.m_imageUrl = other.m_imageUrl;
            this.m_searchSourceUrl = other.m_searchSourceUrl;
            this.m_preferredUrl = other.m_preferredUrl;
            this.m_schema = other.m_schema;
            if (this.m_citationProperties == null) {
                this.m_citationProperties = new Hashtable();
            }
            this.m_citationProperties.clear();
            if (other.m_citationProperties != null) {
                for (String name : other.m_citationProperties.keySet()) {
                    Object obj = other.m_citationProperties.get(name);
                    if (obj == null) continue;
                    if (obj instanceof List) {
                        List list = (List)obj;
                        Vector copy = new Vector();
                        for (Object val : list) {
                            copy.add(val);
                        }
                        this.m_citationProperties.put(name, copy);
                        continue;
                    }
                    if (obj instanceof String) {
                        this.m_citationProperties.put(name, obj);
                        continue;
                    }
                    M_log.debug((Object)("BasicCitation copy constructor: property is not String or List: " + name + " (" + obj.getClass().getName() + ") == " + obj));
                    this.m_citationProperties.put(name, obj);
                }
            }
            if (this.m_urls == null) {
                this.m_urls = new Hashtable();
            }
            this.m_urls.clear();
            if (other.m_urls != null) {
                for (String id : other.m_urls.keySet()) {
                    UrlWrapper wrapper = (UrlWrapper)other.m_urls.get(id);
                    this.m_urls.put(id, wrapper);
                }
            }
        }

        public void exportRisField(String rislabel, String value, StringBuilder buffer, String prefix) {
            value = value.replaceAll("\n", " ");
            rislabel = rislabel.trim();
            if (prefix == null) {
                prefix = "";
            }
            if (!(prefix = prefix.trim()).equals("")) {
                prefix = prefix + ": ";
            }
            if (value != null && !value.trim().equals("") || rislabel.equals("ER")) {
                buffer.append(rislabel + BaseCitationService.RIS_DELIM + prefix + value + "\n");
            }
        }

        public void exportRisField(String rislabel, String value, StringBuilder buffer) {
            this.exportRisField(rislabel, value, buffer, "");
        }

        public void exportRisField(String rislabel, List propvalues, StringBuilder buffer, String prefix) {
            Iterator propvaliter = propvalues.iterator();
            while (propvaliter.hasNext()) {
                this.exportRisField(rislabel, propvaliter.next(), buffer, prefix);
            }
        }

        public void exportRisField(String rislabel, Object val, StringBuilder buffer, String prefix) {
            if (val instanceof List) {
                this.exportRisField(rislabel, (List)val, buffer, prefix);
            } else {
                this.exportRisField(rislabel, val.toString(), buffer, prefix);
            }
        }

        public void exportRisField(String rislabel, Object val, StringBuilder buffer) {
            this.exportRisField(rislabel, val, buffer, "");
        }

        public void exportRis(StringBuilder buffer) throws IOException {
            String ristype;
            String type = "article";
            if (this.m_schema != null) {
                type = this.m_schema.getIdentifier();
            }
            if ((ristype = (String)m_RISType.get(type)) == null) {
                ristype = (String)m_RISType.get("article");
            }
            this.exportRisField("TY", ristype, buffer);
            List fields = this.m_schema.getFields();
            for (Schema.Field field : fields) {
                String rislabel;
                String fieldname = field.getIdentifier();
                if (m_RISSpecialFields.contains(fieldname) || (rislabel = field.getIdentifier("RIS")) == null || rislabel.trim().equals("")) continue;
                this.exportRisField(rislabel, this.getCitationProperty(fieldname, false), buffer);
            }
            this.exportRisField("Y1", this.getCitationProperty("year", false) + "//", buffer);
            for (Map.Entry entry : m_RISNoteFields.entrySet()) {
                String fieldname = (String)entry.getKey();
                String prefix = (String)entry.getValue();
                this.exportRisField("N1", this.getCitationProperty(fieldname, false), buffer, prefix);
            }
            Iterator urlIDs = this.getCustomUrlIds().iterator();
            while (urlIDs.hasNext()) {
                String id = urlIDs.next().toString();
                try {
                    String url = this.getCustomUrl(id);
                    String urlLabel = this.getCustomUrlLabel(id);
                    this.exportRisField("UR", url, buffer);
                    this.exportRisField("NT", url, buffer, urlLabel);
                }
                catch (IdUnusedException idUnusedException) {}
            }
            this.exportRisField("ER", "", buffer);
            buffer.append("\n");
        }

        public Map getCitationProperties() {
            if (this.m_citationProperties == null) {
                this.m_citationProperties = new Hashtable();
            }
            return this.m_citationProperties;
        }

        public Object getCitationProperty(String name) {
            return this.getCitationProperty(name, false);
        }

        public Object getCitationProperty(String name, boolean needSingleValue) {
            Object value = null;
            if (name == null) {
                value = "";
            } else {
                if (this.m_citationProperties == null) {
                    this.m_citationProperties = new Hashtable();
                }
                if ((value = this.m_citationProperties.get(name)) == null) {
                    if (this.isMultivalued(name)) {
                        value = new Vector();
                        ((List)value).add("");
                    } else {
                        value = "";
                    }
                } else if (List.class.isInstance(value) && needSingleValue) {
                    value = ((List)value).get(0);
                }
            }
            return value;
        }

        public String getCreator() {
            List creatorList = null;
            Object creatorObj = this.m_citationProperties.get("creator");
            if (creatorObj == null) {
                creatorList = new Vector();
                this.m_citationProperties.put("creator", creatorList);
            } else if (creatorObj instanceof List) {
                creatorList = (List)creatorObj;
            } else if (creatorObj instanceof String) {
                creatorList = new Vector();
                creatorList.add(creatorObj);
                this.m_citationProperties.put("creator", creatorList);
            }
            String creators = "";
            int count = 0;
            if (creatorList == null) {
                return creators;
            }
            StringBuilder buf = new StringBuilder();
            Iterator it = creatorList.iterator();
            while (it.hasNext()) {
                String creator = (String)it.next();
                if (it.hasNext() && count > 0) {
                    buf.append(";");
                } else if (!it.hasNext()) {
                    if (count > 1) {
                        buf.append("; and ");
                    } else if (count > 0) {
                        buf.append(" and ");
                    }
                }
                buf.append(creator);
                ++count;
            }
            creators = buf.toString();
            if (!creators.trim().equals("") && !creators.trim().endsWith(".")) {
                creators = creators.trim() + ". ";
            }
            return creators;
        }

        public String getCustomUrl(String id) throws IdUnusedException {
            String prefix;
            UrlWrapper wrapper = (UrlWrapper)this.m_urls.get(id);
            if (wrapper == null) {
                throw new IdUnusedException(id);
            }
            StringBuilder urlBuffer = new StringBuilder(wrapper.getUrl());
            if (wrapper.addPrefix() && (prefix = this.getUrlPrefix()) != null) {
                urlBuffer.insert(0, prefix);
            }
            return urlBuffer.toString();
        }

        public String getUnprefixedCustomUrl(String id) throws IdUnusedException {
            UrlWrapper wrapper = (UrlWrapper)this.m_urls.get(id);
            if (wrapper == null) {
                throw new IdUnusedException(id);
            }
            return wrapper.getUrl();
        }

        public String getUrlPrefix() {
            return BaseCitationService.this.m_configService.getSiteConfigPreferredUrlPrefix();
        }

        public boolean addPrefixToUrl(String id) throws IdUnusedException {
            UrlWrapper wrapper = (UrlWrapper)this.m_urls.get(id);
            if (wrapper == null) {
                throw new IdUnusedException(id);
            }
            return wrapper.addPrefix();
        }

        public List getCustomUrlIds() {
            Vector rv = new Vector();
            if (!this.m_urls.isEmpty()) {
                rv.addAll(this.m_urls.keySet());
            }
            return rv;
        }

        public String getCustomUrlLabel(String id) throws IdUnusedException {
            UrlWrapper wrapper = (UrlWrapper)this.m_urls.get(id);
            if (wrapper == null) {
                throw new IdUnusedException(id);
            }
            return wrapper.getLabel();
        }

        public String getYear() {
            String yearDate = (String)this.getCitationProperty("year", true);
            return yearDate;
        }

        public String getDisplayName() {
            String displayName = (String)this.getCitationProperty("title", true);
            if (displayName == null || displayName.trim().equals("")) {
                displayName = "untitled";
                this.setCitationProperty("title", "untitled");
            }
            if (!((displayName = displayName.trim()).length() <= 0 || displayName.endsWith(".") || displayName.endsWith("?") || displayName.endsWith("!") || displayName.endsWith(","))) {
                displayName = displayName + ".";
            }
            return new String(displayName);
        }

        public String getPrimaryUrl() {
            if (this.m_citationProperties == null) {
                return null;
            }
            if (this.hasPreferredUrl()) {
                String id = this.getPreferredUrlId();
                try {
                    return this.getCustomUrl(id);
                }
                catch (IdUnusedException exception) {
                    M_log.warn((Object)("No matching URL for ID: " + id + ", returning an OpenURL"));
                }
            }
            return this.getOpenurl();
        }

        public String getFirstAuthor() {
            String firstAuthor = null;
            List authors = (List)this.m_citationProperties.get("creator");
            if (authors != null && !authors.isEmpty()) {
                firstAuthor = (String)authors.get(0);
            }
            if (firstAuthor != null) {
                firstAuthor = firstAuthor.trim();
            }
            return firstAuthor;
        }

        public String getId() {
            if (this.isTemporary()) {
                return this.m_serialNumber.toString();
            }
            return this.m_id;
        }

        public String getOpenurl() {
            if (this.m_citationProperties == null) {
                return null;
            }
            String resolverUrl = BaseCitationService.this.m_configService.getSiteConfigOpenUrlResolverAddress();
            String firstDelimiter = resolverUrl.indexOf("?") != -1 ? "&" : "?";
            String openUrlParams = this.getOpenurlParameters();
            return resolverUrl + firstDelimiter + openUrlParams;
        }

        public String getOpenurlParameters() {
            if (this.m_citationProperties == null) {
                return "";
            }
            ContextObject co = BaseCitationService.this.m_openURLService.convert(this);
            StringBuilder openUrl = new StringBuilder();
            if (co != null) {
                String openUrlParams = BaseCitationService.this.m_openURLService.toURL(co);
                openUrl.append(openUrlParams);
            }
            return openUrl.toString();
        }

        public int getPosition() {
            return this.m_position;
        }

        public Schema getSchema() {
            return this.m_schema;
        }

        public String getSource() {
            String place = (String)this.getCitationProperty("publicationLocation", true);
            String publisher = (String)this.getCitationProperty("publisher", true);
            String sourceTitle = (String)this.getCitationProperty("sourceTitle", true);
            String year = (String)this.getCitationProperty("year", true);
            String volume = (String)this.getCitationProperty("volume", true);
            String issue = (String)this.getCitationProperty("issue", true);
            String pages = (String)this.getCitationProperty("pages", true);
            String startPage = (String)this.getCitationProperty("startPage", true);
            String endPage = (String)this.getCitationProperty("endPage", true);
            if (pages == null || pages.trim().equals("")) {
                pages = null;
                if (startPage != null && !startPage.trim().equals("")) {
                    pages = startPage.trim();
                    if (endPage != null && !endPage.trim().equals("")) {
                        pages = pages + "-" + endPage;
                    }
                }
            }
            String source = "";
            String schemaId = "unknown";
            if (this.m_schema != null) {
                schemaId = this.m_schema.getIdentifier();
            }
            if ("book".equals(schemaId) || "report".equals(schemaId)) {
                if (place != null && !place.trim().equals("")) {
                    source = source + place;
                }
                if (publisher != null && !publisher.trim().equals("")) {
                    if (source.length() > 0) {
                        source = source.trim() + ": ";
                    }
                    source = source + publisher;
                }
                if (year != null && !year.trim().equals("")) {
                    if (source.length() > 0) {
                        source = source.trim() + ", ";
                    }
                    source = source + year;
                }
            } else if ("article".equals(schemaId)) {
                if (sourceTitle != null && !sourceTitle.trim().equals("")) {
                    source = source + sourceTitle;
                    if (volume != null && !volume.trim().equals("")) {
                        source = source + ", " + volume;
                        if (issue != null && !issue.trim().equals("")) {
                            source = source + "(" + issue + ") ";
                        }
                    }
                }
                if (year != null && !year.trim().equals("")) {
                    source = source + " " + year;
                }
                if (!(source == null || source.length() <= 1 || (source = source.trim()).endsWith(".") || source.endsWith("?") || source.endsWith("!") || source.endsWith(","))) {
                    source = source + ". ";
                }
                if (pages != null && !pages.trim().equals("")) {
                    source = source + pages;
                }
                if (!(source == null || source.length() <= 1 || (source = source.trim()).endsWith(".") || source.endsWith("?") || source.endsWith("!") || source.endsWith(","))) {
                    source = source + ". ";
                }
            } else if ("chapter".equals(schemaId)) {
                if (sourceTitle != null && !sourceTitle.trim().equals("")) {
                    source = source + "In " + sourceTitle;
                    if (pages == null) {
                        if (startPage != null && !startPage.trim().equals("")) {
                            source = source.trim() + ", " + startPage;
                            if (endPage != null && !endPage.trim().equals("")) {
                                source = source.trim() + "-" + endPage;
                            }
                        }
                    } else {
                        source = source.trim() + ", " + pages;
                    }
                    if (publisher != null && !publisher.trim().equals("")) {
                        if (place != null && !place.trim().equals("")) {
                            source = source + place + ": ";
                        }
                        source = source + publisher;
                        if (year != null && !year.trim().equals("")) {
                            source = source + ", " + year;
                        }
                    } else if (year != null && !year.trim().equals("")) {
                        source = source + " " + year;
                    }
                }
            } else if (sourceTitle != null && !sourceTitle.trim().equals("")) {
                source = source + sourceTitle;
                if (volume != null && !volume.trim().equals("")) {
                    source = source + ", " + volume;
                    if (issue != null && !issue.trim().equals("")) {
                        source = source + "(" + issue + ") ";
                    }
                }
                if (pages == null) {
                    if (startPage != null && !startPage.trim().equals("")) {
                        source = source + startPage;
                        if (endPage != null && !endPage.trim().equals("")) {
                            source = source + "-" + endPage;
                        }
                    }
                } else {
                    if (source.length() > 0) {
                        source = source + ". ";
                    }
                    source = source + pages + ". ";
                }
            } else if (publisher != null && !publisher.trim().equals("")) {
                if (place != null && !place.trim().equals("")) {
                    source = source + place + ": ";
                }
                source = source + publisher;
                if (year != null && !year.trim().equals("")) {
                    source = source + ", " + year;
                }
            }
            if (!(source.length() <= 1 || source.endsWith(".") || source.endsWith("?") || source.endsWith("!") || source.endsWith(","))) {
                source = source.trim() + ". ";
            }
            if (source.trim().endsWith("..")) {
                source = source.substring(0, source.length() - 2);
            }
            return source;
        }

        public String getAbstract() {
            String abstractText;
            if (this.m_citationProperties != null && this.m_citationProperties.get("abstract") != null && (abstractText = this.m_citationProperties.get("abstract").toString().trim()).length() > 0) {
                return abstractText;
            }
            return null;
        }

        public String getSubjectString() {
            Object subjects = this.getCitationProperty("subject", false);
            if (subjects instanceof List) {
                List subjectList = (List)subjects;
                ListIterator subjectListIterator = subjectList.listIterator();
                StringBuilder subjectStringBuf = new StringBuilder();
                while (subjectListIterator.hasNext()) {
                    subjectStringBuf.append(((String)subjectListIterator.next()).trim() + ", ");
                }
                String subjectString = subjectStringBuf.substring(0, subjectStringBuf.length() - 2);
                if (subjectString.equals("")) {
                    return null;
                }
                return subjectString;
            }
            return null;
        }

        public boolean hasCustomUrls() {
            return this.m_urls != null && !this.m_urls.isEmpty();
        }

        public boolean hasPropertyValue(String fieldId) {
            return this.hasCitationProperty(fieldId);
        }

        public void importFromRis(InputStream ris) throws IOException {
        }

        public boolean importFromRisList(List risImportList) {
            Log logger = LogFactory.getLog(BasicCitation.class);
            String currentLine = null;
            String RIScode = null;
            String RISvalue = null;
            Schema schema = null;
            String schemaName = null;
            List Fields = null;
            Schema.Field tempField = null;
            Iterator iter = null;
            boolean noFieldMapping = true;
            String[] RIScodes = null;
            String urlId = null;
            String continueTag = null;
            int delimiterIndex = 0;
            logger.debug((Object)("importFromRisList: In importFromRisList. List size is " + risImportList.size()));
            for (int i = 0; i < risImportList.size(); ++i) {
                String dirtyString = (String)risImportList.get(i);
                currentLine = dirtyString.replaceAll("[\ufeff-\uffff]", "");
                currentLine = currentLine.trim();
                logger.debug((Object)("importFromRisList: currentLine = " + currentLine));
                if (currentLine.length() < 4) {
                    RIScode = "CODENOTFOUND";
                    RISvalue = "";
                } else {
                    delimiterIndex = currentLine.indexOf(45);
                    if (delimiterIndex != -1) {
                        RIScode = currentLine.substring(0, delimiterIndex).trim();
                        RISvalue = currentLine.substring(delimiterIndex).trim();
                        RISvalue = RISvalue.length() > 1 ? RISvalue.substring(1) : "";
                    } else {
                        RIScode = "CODENOTFOUND";
                        RISvalue = "";
                    }
                    logger.debug((Object)("importFromRisList: substr value = " + RISvalue));
                }
                RISvalue = RISvalue.trim();
                if (i == 0) {
                    if (!RIScode.equalsIgnoreCase("TY")) {
                        logger.debug((Object)("importFromRisList: FALSE - 1st entry in RIS must be TY. It isn't it is " + RISvalue));
                        return false;
                    }
                    if (RISvalue.equalsIgnoreCase("NEWS") || RISvalue.equalsIgnoreCase("MGZN")) {
                        logger.debug((Object)"importFromRisList: force mapping NEWS or MGZN resource type to JOUR");
                        RISvalue = "JOUR";
                    }
                    logger.debug((Object)("importFromRisList: size of m_RISTypeInverse = " + m_RISTypeInverse.size()));
                    logger.debug((Object)("importFromRisList: RISvalue before schemaName = " + RISvalue));
                    schemaName = (String)m_RISTypeInverse.get(RISvalue);
                    if (schemaName == null) {
                        logger.debug((Object)("importFromRisList: Unknown Schema Name = " + RISvalue + ". Setting schemeName to 'unknown'"));
                        schemaName = "unknown";
                    }
                    logger.debug((Object)("importFromRisList: Schema Name = " + schemaName));
                    schema = BaseCitationService.this.getSchema(schemaName);
                    logger.debug((Object)("importFromRisList: Retrieved Schema Name = " + schema.getIdentifier()));
                    this.setSchema(schema);
                    continue;
                }
                if (RIScode.equalsIgnoreCase("ER")) {
                    logger.debug((Object)"importFromRisList: Read an ER. End of citation.");
                    return true;
                }
                Fields = schema.getFields();
                iter = Fields.iterator();
                noFieldMapping = true;
                while (iter.hasNext() && noFieldMapping) {
                    tempField = (Schema.Field)iter.next();
                    RIScodes = tempField.getIdentifierComplex("RIS");
                    for (int j = 0; j < RIScodes.length && noFieldMapping; ++j) {
                        if (!RIScode.equalsIgnoreCase(RIScodes[j])) continue;
                        noFieldMapping = false;
                        continueTag = null;
                        logger.debug((Object)"importFromRisList: Found field mapping");
                    }
                }
                if (noFieldMapping) {
                    logger.debug((Object)("importFromRisList: Cannot find field mapping for RIScode " + RIScode + " for Schema = " + schema));
                    delimiterIndex = currentLine.indexOf(45);
                    RIScode = delimiterIndex == -1 ? "CODENOTFOUND" : currentLine.substring(0, delimiterIndex).trim();
                    if (RIScode.equalsIgnoreCase("UR")) {
                        urlId = this.addCustomUrl("", RISvalue);
                        this.setPreferredUrl(urlId);
                        continueTag = RIScode.toUpperCase();
                        logger.debug((Object)("importFromRisList: set preferred url to " + urlId + " which is " + RISvalue));
                        continue;
                    }
                    if (continueTag == null || RIScode.length() == 2) continue;
                    logger.debug((Object)"importFromRisList: continuation of tag found (EndNote oddity). Hacking tag and resending line through the import system");
                    risImportList.set(i, continueTag + " - " + currentLine);
                    --i;
                    continue;
                }
                logger.debug((Object)("importFromRisList: Field mapping is " + tempField.getIdentifier() + " => " + RISvalue));
                if (RIScode.equalsIgnoreCase("KW")) {
                    continueTag = RIScode.toUpperCase();
                }
                this.setCitationProperty(tempField.getIdentifier(), RISvalue);
                if (!RIScode.equalsIgnoreCase("Y1") && !RIScode.equalsIgnoreCase("PY") || schemaName.equalsIgnoreCase("electronic") && schemaName.equalsIgnoreCase("proceed") && schemaName.equalsIgnoreCase("thesis")) continue;
                this.setYearProperty(RISvalue);
            }
            logger.debug((Object)"importFromRisList: FALSE - End of Input. Citation not added.");
            return false;
        }

        private void setDateProperty(String date) {
            char c;
            int i;
            this.setCitationProperty("date", date);
            if (date.length() < 4) {
                return;
            }
            StringBuilder normalized = new StringBuilder();
            String[] components = date.split("/");
            if (components.length == 0) {
                return;
            }
            for (i = 0; i < 4; ++i) {
                c = components[0].charAt(i);
                if (!Character.isDigit(c)) {
                    return;
                }
                normalized.append(c);
            }
            if (components.length == 1) {
                this.setCitationProperty("date", normalized.toString());
                return;
            }
            if (components[1].length() == 2) {
                normalized.append("-");
                for (i = 0; i < 2; ++i) {
                    c = components[1].charAt(i);
                    if (!Character.isDigit(c)) continue;
                    normalized.append(c);
                }
            }
            if (components.length == 2) {
                if (normalized.length() < 7) {
                    normalized.setLength(4);
                }
                this.setCitationProperty("date", normalized.toString());
                return;
            }
            if (components[2].length() == 2) {
                normalized.append("-");
                for (i = 0; i < 2; ++i) {
                    c = components[2].charAt(i);
                    if (!Character.isDigit(c)) continue;
                    normalized.append(c);
                }
                if (normalized.length() < 10) {
                    normalized.setLength(normalized.length() < 7 ? 4 : 7);
                }
            }
            this.setCitationProperty("date", normalized.toString());
            if (components.length == 3) {
                return;
            }
        }

        private void setYearProperty(String date) {
            if (date.length() < 4) {
                return;
            }
            StringBuilder year = new StringBuilder();
            for (int i = 0; i < 4; ++i) {
                char c = date.charAt(i);
                if (!Character.isDigit(c)) {
                    return;
                }
                year.append(c);
            }
            this.setCitationProperty("year", year.toString());
        }

        public boolean isAdded() {
            return this.m_isAdded;
        }

        public boolean isMultivalued(String fieldId) {
            boolean isMultivalued = false;
            isMultivalued = this.isSchemaLimited(fieldId) ? this.isSchemaMultivalued(fieldId) : this.isCurrentlyMultivalued(fieldId);
            return isMultivalued;
        }

        protected boolean isCurrentlyMultivalued(String fieldId) {
            return this.m_citationProperties.get(fieldId) instanceof List;
        }

        protected boolean isSchemaMultivalued(String fieldId) {
            Schema.Field field = this.m_schema.getField(fieldId);
            return field != null && field.isMultivalued();
        }

        public boolean isTemporary() {
            return this.m_temporary;
        }

        protected boolean isSchemaLimited(String fieldId) {
            return this.m_schema != null && this.m_schema.getField(fieldId) != null;
        }

        public List listCitationProperties() {
            if (this.m_citationProperties == null) {
                this.m_citationProperties = new Hashtable();
            }
            return new Vector(this.m_citationProperties.keySet());
        }

        public void setAdded(boolean added) {
            this.m_isAdded = added;
        }

        public void setCitationProperty(String name, Object value) {
            if (this.m_citationProperties == null) {
                this.m_citationProperties = new Hashtable();
            }
            if (this.isMultivalued(name)) {
                Vector list = (Vector)this.m_citationProperties.get(name);
                if (list == null) {
                    list = new Vector();
                    this.m_citationProperties.put(name, list);
                }
                if (value != null) {
                    list.add(value);
                }
            } else if (value == null) {
                this.m_citationProperties.remove(name);
            } else {
                Vector<Object> newValue = value;
                if (!this.isSchemaLimited(name) && this.hasCitationProperty(name)) {
                    Object existingValue = this.m_citationProperties.get(name);
                    Vector<Object> list = new Vector<Object>();
                    list.add(existingValue);
                    list.add(value);
                    newValue = list;
                }
                this.m_citationProperties.put(name, newValue);
            }
        }

        public boolean hasCitationProperty(String fieldId) {
            boolean hasValue;
            Object val = this.m_citationProperties.get(fieldId);
            boolean bl = hasValue = val != null;
            if (hasValue && val instanceof List) {
                List list = (List)val;
                hasValue = !list.isEmpty();
            }
            return hasValue;
        }

        protected void setDefaults() {
            if (this.m_schema != null) {
                List fields = this.m_schema.getFields();
                for (Schema.Field field : fields) {
                    Object value;
                    if (!field.isRequired() || (value = field.getDefaultValue()) == null) continue;
                    if (field.isMultivalued()) {
                        List current_values = (List)this.getCitationProperty(field.getIdentifier(), false);
                        if (!current_values.isEmpty()) continue;
                        this.setCitationProperty(field.getIdentifier(), value);
                        continue;
                    }
                    if (this.getCitationProperty(field.getIdentifier(), false) != null) continue;
                    this.setCitationProperty(field.getIdentifier(), value);
                }
            }
        }

        public void setDisplayName(String name) {
            if (name == null || name.trim().equals("")) {
                this.addPropertyValue("title", "untitled");
            } else {
                this.addPropertyValue("title", name);
            }
        }

        public void setPosition(int position) {
            this.m_position = position;
        }

        public void setSchema(Schema schema) {
            this.m_schema = schema;
            this.setDefaults();
        }

        protected void setType(String mediatype) {
            Schema schema = BaseCitationService.this.m_storage.getSchema(mediatype);
            if (schema == null) {
                schema = BaseCitationService.this.m_storage.getSchema("unknown");
            }
            this.setSchema(schema);
        }

        public String toString() {
            return "BasicCitation: " + this.m_id;
        }

        public void updateCitationProperty(String name, List values) {
            if (this.m_citationProperties == null) {
                this.m_citationProperties = new Hashtable();
            }
            if (this.isMultivalued(name)) {
                Vector list = (Vector)this.m_citationProperties.get(name);
                if (list == null) {
                    list = new Vector();
                    this.m_citationProperties.put(name, list);
                }
                list.clear();
                if (values != null) {
                    list.addAll(values);
                }
            } else if (values == null || values.isEmpty()) {
                this.m_citationProperties.remove(name);
            } else {
                this.m_citationProperties.put(name, values.get(0));
            }
        }

        public String getPreferredUrlId() {
            return this.m_preferredUrl;
        }

        public boolean hasPreferredUrl() {
            return this.m_preferredUrl != null;
        }

        public void setPreferredUrl(String urlid) {
            if (urlid == null) {
                this.m_preferredUrl = null;
            } else if (this.m_urls.containsKey(urlid)) {
                this.m_preferredUrl = urlid;
            }
        }
    }
}

