/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.citation.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osid.OsidContext;
import org.osid.OsidException;
import org.osid.OsidManager;

public class SakaiOsidLoader
implements Serializable {
    private static Log M_log = LogFactory.getLog(SakaiOsidLoader.class);

    public static InputStream getConfigStream(String fileName, Class curClass) {
        String sakaiHome = System.getProperty("sakai.home");
        String filePath = sakaiHome + fileName;
        try {
            File f = new File(filePath);
            if (f.exists()) {
                return new FileInputStream(f);
            }
        }
        catch (Throwable f) {
            // empty catch block
        }
        if (curClass == null) {
            return null;
        }
        InputStream istream = null;
        istream = curClass.getClassLoader().getResourceAsStream(fileName);
        if (istream != null) {
            return istream;
        }
        istream = curClass.getResourceAsStream("/data/" + fileName);
        if (istream != null) {
            return istream;
        }
        istream = curClass.getResourceAsStream(fileName);
        if (istream != null) {
            return istream;
        }
        istream = curClass.getResourceAsStream("/" + fileName);
        if (istream != null) {
            return istream;
        }
        istream = curClass.getResourceAsStream("/config/" + fileName);
        return istream;
    }

    private static Properties getConfiguration(OsidManager manager) throws OsidException {
        Properties properties = null;
        if (null != manager) {
            Class<?> managerClass = manager.getClass();
            try {
                String propertyName;
                InputStream is;
                String managerClassName = managerClass.getName();
                int index = managerClassName.lastIndexOf(".");
                if (-1 != index) {
                    managerClassName = managerClassName.substring(index + 1);
                }
                if (null != (is = SakaiOsidLoader.getConfigStream(propertyName = managerClassName + ".properties", managerClass))) {
                    properties = new Properties();
                    properties.load(is);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return properties;
    }

    public static OsidManager getManager(String osidPackageManagerName, String implPackageName, OsidContext context, Properties additionalConfiguration) throws OsidException {
        try {
            if (null != context && null != osidPackageManagerName && null != implPackageName) {
                String osidInterfaceName = osidPackageManagerName;
                String className = SakaiOsidLoader.makeClassName(osidPackageManagerName);
                String managerClassName = SakaiOsidLoader.makeFullyQualifiedClassName(implPackageName, className);
                Class<?> osidInterface = Class.forName(osidInterfaceName);
                if (null != osidInterface) {
                    Class<?> managerClass = Class.forName(managerClassName);
                    if (null != managerClass) {
                        if (osidInterface.isAssignableFrom(managerClass)) {
                            OsidManager manager = (OsidManager)managerClass.newInstance();
                            if (null != manager) {
                                try {
                                    manager.osidVersion_2_0();
                                }
                                catch (Throwable ex) {
                                    throw new OsidException("OSID Version mismatch error ");
                                }
                                try {
                                    manager.assignOsidContext(context);
                                }
                                catch (Exception ex) {
                                    throw new OsidException("Error assigning context ");
                                }
                                try {
                                    Properties configuration = SakaiOsidLoader.getConfiguration(manager);
                                    if (null == configuration) {
                                        configuration = new Properties();
                                    }
                                    if (null != additionalConfiguration) {
                                        Enumeration<?> enumer = additionalConfiguration.propertyNames();
                                        while (enumer.hasMoreElements()) {
                                            Serializable value;
                                            Serializable key = (Serializable)enumer.nextElement();
                                            if (null == key || null == (value = (Serializable)additionalConfiguration.get(key))) continue;
                                            configuration.put(key, value);
                                        }
                                    }
                                    manager.assignConfiguration(configuration);
                                    return manager;
                                }
                                catch (Exception ex) {
                                    throw new OsidException("Error assigning configuration ");
                                }
                            }
                            throw new OsidException("Manager instantiation error ");
                        }
                        throw new OsidException("Manager not OSID implementation ");
                    }
                    throw new OsidException("Manager not found ");
                }
                throw new OsidException("Interface not found ");
            }
            throw new OsidException("Null argument");
        }
        catch (OsidException oex) {
            M_log.warn((Object)"getManager() OsidException ", (Throwable)oex);
            throw new OsidException(oex.getMessage());
        }
        catch (Throwable ex) {
            M_log.warn((Object)"getManager() Throwable ", ex);
            throw new OsidException("Operation failed ");
        }
    }

    private static String makeClassName(String packageManagerName) throws OsidException {
        int lastdot;
        String className = packageManagerName;
        if (null != className && -1 != (lastdot = (className = className.endsWith(".") ? className.substring(0, className.length() - 1) : className).lastIndexOf("."))) {
            className = className.substring(lastdot + 1);
        }
        return className;
    }

    private static String makeFullyQualifiedClassName(String packageName, String className) throws OsidException {
        String cName = className;
        if (null != packageName) {
            String pName = packageName.endsWith(".") ? packageName : new String(packageName + ".");
            cName = pName + className;
        }
        return cName;
    }
}

