/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.citation.impl.openurl;

import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.sakaiproject.citation.api.Citation;
import org.sakaiproject.citation.impl.openurl.ContextObject;
import org.sakaiproject.citation.impl.openurl.ContextObjectEntity;
import org.sakaiproject.citation.impl.openurl.Converter;
import org.sakaiproject.citation.impl.openurl.Format;
import org.sakaiproject.citation.impl.openurl.InlineHttpTransport;
import org.sakaiproject.citation.impl.openurl.KEVFormat;
import org.sakaiproject.citation.impl.openurl.RawContextObject;
import org.sakaiproject.citation.impl.openurl.Transport;

public class OpenURLServiceImpl {
    private List<Transport> transports;
    private List<Format> formats;
    private List<Converter> converters;
    private Format urlFormat;
    private Transport urlTransport;

    public void setTransports(List<Transport> transports) {
        this.transports = transports;
    }

    public void setFormats(List<Format> formats) {
        this.formats = formats;
    }

    public void setConverters(List<Converter> converters) {
        this.converters = converters;
    }

    public void init() {
        for (Transport transport : this.transports) {
            if (!(transport instanceof InlineHttpTransport)) continue;
            this.urlTransport = transport;
            break;
        }
        for (Format format : this.formats) {
            if (!format.canHandle(KEVFormat.FORMAT_ID)) continue;
            this.urlFormat = format;
            break;
        }
    }

    public ContextObject parse(HttpServletRequest request) {
        ContextObject contextObject = null;
        for (Transport transport : this.transports) {
            Format format;
            RawContextObject rawContextObject = transport.parse(request);
            if (rawContextObject == null || rawContextObject.getData() == null) continue;
            Iterator<Format> i$ = this.formats.iterator();
            while (i$.hasNext() && (contextObject = (format = i$.next()).parse(rawContextObject.getData())) == null) {
            }
        }
        return contextObject;
    }

    public ContextObject convert(Citation citation) {
        ContextObject contextObject = null;
        if (citation != null && citation.getSchema() != null) {
            String schema = citation.getSchema().getIdentifier();
            for (Converter converter : this.converters) {
                if (!converter.canConvertCitation(schema)) continue;
                contextObject = new ContextObject();
                contextObject.getEntities().put(ContextObject.Entity.REFERENT, converter.convert(citation));
                break;
            }
        }
        return contextObject;
    }

    public Citation convert(ContextObject contextObject) {
        ContextObjectEntity referent;
        Citation citation = null;
        if (contextObject != null && (referent = contextObject.getEntity(ContextObject.Entity.REFERENT)) != null) {
            Converter converter;
            String format = referent.getFormat();
            Iterator<Converter> i$ = this.converters.iterator();
            while (!(!i$.hasNext() || (converter = i$.next()).canConvertOpenUrl(format) && (citation = converter.convert(referent)).hasCitationProperty("title"))) {
            }
            if (citation == null) {
                // empty if block
            }
        }
        return citation;
    }

    public String toURL(ContextObject contextObject) {
        String encodedCO = this.urlFormat.encode(contextObject);
        String url = this.urlTransport.encode(encodedCO);
        return url;
    }
}

