/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.citation.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.citation.api.Citation;
import org.sakaiproject.citation.api.CitationCollection;
import org.sakaiproject.citation.api.CitationCollectionOrder;
import org.sakaiproject.citation.api.CitationService;
import org.sakaiproject.citation.api.Schema;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.content.cover.ContentHostingService;
import org.sakaiproject.entity.api.EntityAccessOverloadException;
import org.sakaiproject.entity.api.EntityCopyrightException;
import org.sakaiproject.entity.api.EntityNotDefinedException;
import org.sakaiproject.entity.api.EntityPermissionException;
import org.sakaiproject.entity.api.EntityPropertyNotDefinedException;
import org.sakaiproject.entity.api.EntityPropertyTypeException;
import org.sakaiproject.entity.api.HttpAccess;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.ServerOverloadException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.util.ResourceLoader;
import org.sakaiproject.util.Validator;

public class CitationListAccessServlet
implements HttpAccess {
    public static final String LIST_TEMPLATE = "/vm/citationList.vm";
    protected static ResourceLoader rb = new ResourceLoader("citations");
    private static Log m_log = LogFactory.getLog(CitationListAccessServlet.class);
    private static final Collection<String> specialKeys = new HashSet<String>();

    public void handleAccess(HttpServletRequest req, HttpServletResponse res, Reference ref, Collection copyrightAcceptedRefs) throws EntityPermissionException, EntityNotDefinedException, EntityAccessOverloadException, EntityCopyrightException {
        String subtype = ref.getSubType();
        if ("export_ris_sel".equals(subtype) || "export_ris_all".equals(subtype)) {
            this.handleExportRequest(req, res, ref, "RIS", subtype);
        } else if ("list".equals(subtype)) {
            this.handleViewRequest(req, res, ref);
        } else {
            throw new EntityNotDefinedException(ref.getReference());
        }
        Event e = EventTrackingService.newEvent((String)ContentHostingService.EVENT_RESOURCE_READ, (String)("/content" + ref.getId()), (boolean)false);
        EventTrackingService.post((Event)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleExportRequest(HttpServletRequest req, HttpServletResponse res, Reference ref, String format, String subtype) throws EntityNotDefinedException, EntityAccessOverloadException, EntityPermissionException {
        SessionManager sessionManager = (SessionManager)ComponentManager.get(SessionManager.class);
        org.sakaiproject.content.api.ContentHostingService contentHostingService = (org.sakaiproject.content.api.ContentHostingService)ComponentManager.get(org.sakaiproject.content.api.ContentHostingService.class);
        if (!ContentHostingService.allowGetResource((String)req.getParameter("resourceId"))) {
            String url = req.getRequestURL().toString();
            String user = "";
            if (req.getUserPrincipal() != null) {
                user = req.getUserPrincipal().getName();
            }
            throw new EntityPermissionException(user, ContentHostingService.EVENT_RESOURCE_READ, ref.getReference());
        }
        String fileName = req.getParameter("resourceDisplayName");
        if (fileName == null || fileName.trim().equals("")) {
            fileName = rb.getString("export.default.filename");
        }
        if ("RIS".equals(format)) {
            String citationCollectionId = null;
            ContentResource resource = null;
            try {
                resource = contentHostingService.getResource(req.getParameter("resourceId"));
                citationCollectionId = new String(resource.getContent());
            }
            catch (PermissionException e) {
                throw new EntityPermissionException(sessionManager.getCurrentSessionUserId(), "handleExportRequest", ref.getReference());
            }
            catch (IdUnusedException e) {
                throw new EntityNotDefinedException(ref.getReference());
            }
            catch (TypeException e) {
                throw new IllegalStateException("Resource Mismatch: " + ref.getReference(), e);
            }
            catch (ServerOverloadException e) {
                throw new EntityAccessOverloadException(ref.getReference());
            }
            ArrayList<String> citationIds = new ArrayList<String>();
            CitationCollection collection = null;
            try {
                collection = org.sakaiproject.citation.cover.CitationService.getCollection((String)citationCollectionId);
            }
            catch (IdUnusedException e) {
                throw new EntityNotDefinedException(ref.getReference());
            }
            if ("export_ris_sel".equals(subtype)) {
                String[] paramCitationIds = req.getParameterValues("citationId");
                if (paramCitationIds == null || paramCitationIds.length < 1) {
                    try {
                        res.sendError(400, rb.getString("export.none_selected"));
                    }
                    catch (IOException e) {
                        m_log.warn((Object)("export-selected request received with not citations selected. citationCollectionId: " + citationCollectionId));
                    }
                    return;
                }
                citationIds.addAll(Arrays.asList(paramCitationIds));
                fileName = rb.getFormattedMessage("export.filename.selected.ris", new Object[]{fileName});
            } else {
                List citations = collection.getCitations();
                if (citations == null || citations.size() < 1) {
                    try {
                        res.sendError(204, rb.getString("export.empty_collection"));
                    }
                    catch (IOException e) {
                        m_log.warn((Object)("export-all request received for empty citation collection. citationCollectionId: " + citationCollectionId));
                    }
                    return;
                }
                for (Citation citation : citations) {
                    citationIds.add(citation.getId());
                }
                fileName = rb.getFormattedMessage("export.filename.all.ris", new Object[]{fileName});
            }
            StringBuilder buffer = new StringBuilder(4096);
            try {
                collection.exportRis(buffer, citationIds);
            }
            catch (IOException e) {
                throw new EntityAccessOverloadException(ref.getReference());
            }
            res.addHeader("Content-disposition", "attachment; filename=\"" + fileName + "\"");
            res.setContentType("application/x-Research-Info-Systems");
            res.setContentLength(buffer.length());
            if (buffer.length() > 0) {
                res.setBufferSize(buffer.length());
            }
            ServletOutputStream out = null;
            try {
                out = res.getOutputStream();
                if (buffer.length() > 0) {
                    out.write(buffer.toString().getBytes());
                }
                out.flush();
                out.close();
            }
            catch (Throwable throwable) {
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    protected void handleViewRequest(HttpServletRequest req, HttpServletResponse res, Reference ref) throws EntityPermissionException, EntityAccessOverloadException, EntityNotDefinedException {
        try {
            ContentResource resource = ContentHostingService.getResource((String)ref.getId());
            if (!"org.sakaiproject.citation.impl.CitationList".equals(resource.getResourceType())) {
                throw new EntityNotDefinedException("Couldn't find citation list");
            }
            if (resource.getContentLength() > 1024L) {
                throw new EntityAccessOverloadException(ref.getId());
            }
            ResourceProperties properties = resource.getProperties();
            String title = properties.getProperty("DAV:displayname");
            String introduction = properties.getProperty("CITATIONS:introduction");
            String citationCollectionId = new String(resource.getContent());
            CitationService citationService = (CitationService)ComponentManager.get(CitationService.class);
            CitationCollection collection = citationService.getUnnestedCitationCollection(citationCollectionId);
            CitationCollection fullCollection = org.sakaiproject.citation.cover.CitationService.getCollection((String)citationCollectionId);
            res.setContentType("text/html; charset=UTF-8");
            PrintWriter out = res.getWriter();
            out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\" xml:lang=\"en\">\n<head>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\n<title>" + rb.getString("list.title") + ": " + Validator.escapeHtml((String)title) + "</title>\n" + "<link href=\"/library/skin/tool_base.css\" type=\"text/css\" rel=\"stylesheet\" media=\"all\" />\n" + "<link href=\"/library/skin/" + ServerConfigurationService.getString((String)"skin.default") + "/tool.css\" type=\"text/css\" rel=\"stylesheet\" media=\"all\" />\n" + "<link href=\"/sakai-citations-tool/css/citations.css\" type=\"text/css\" rel=\"stylesheet\" media=\"all\" />\n" + "<script type=\"text/javascript\" src=\"/library/webjars/jquery/1.11.3/jquery.min.js\"></script>\n" + "<script type=\"text/javascript\" src=\"/sakai-citations-tool/js/citationscript.js\"></script>\n" + "<script type=\"text/javascript\" src=\"/sakai-citations-tool/js/view_nested_citations.js\"></script>\n" + "<script type=\"text/javascript\" src=\"/sakai-citations-tool/js/jquery.googlebooks.thumbnails.js\"></script>\n" + "</head>\n<body>");
            List citations = collection.getCitations();
            String contentCollectionId = resource.getContainingCollection().getId();
            String exportParams = "?resourceDisplayName=" + resource.getProperties().getProperty("DAV:displayname") + "&resourceId=" + resource.getId();
            String exportUrlAll = fullCollection.getUrl("export_ris_all") + exportParams;
            String displayDate = null;
            try {
                displayDate = new SimpleDateFormat("dd/MM/yyyy", rb.getLocale()).format(properties.getDateProperty("DAV:getlastmodified"));
            }
            catch (EntityPropertyNotDefinedException e) {
                m_log.warn((Object)("CitationListAccessServlet.handleViewRequest() : Property name requested is not defined - for contentCollectionId" + contentCollectionId));
            }
            catch (EntityPropertyTypeException e) {
                m_log.warn((Object)("CitationListAccessServlet.handleViewRequest() : Named property found does not match the type of access requested - for contentCollectionId" + contentCollectionId));
            }
            out.println("<div class=\"portletBody\">\n\t<div class=\"listWidth citationList\">");
            boolean isPrintView = req.getParameter("printView") != null;
            out.println("\t<div style=\"width: 100%; height: 90px; line-height: 90px; background-color:" + ServerConfigurationService.getString((String)"official.institution.background.colour") + "; \">" + "<div class=\"banner\"><h1 style=\" margin-left:15px; color:" + ServerConfigurationService.getString((String)"official.institution.text.colour") + ";\">" + Validator.escapeHtml((String)title) + "</h1></div> " + "<div class=\"bannerLinks\">" + (!isPrintView ? "<a class=\"export\" href=" + exportUrlAll + ">Export</a>" + "<a class=\"print\" target=\"_blank\" href=" + req.getRequestURL() + "?printView" + ">Print</a>" : "") + "<div class=\"lastUpdated\">Last updated: " + displayDate + "</div>" + "</div>" + "</div>");
            out.println("<div style=\"clear:both;\"></div>");
            if (introduction != null && !introduction.trim().equals("")) {
                out.println("\t<div class='descriptionView'>" + introduction + "</div>");
            }
            this.displayNestedSections(title, citationCollectionId, citationService, collection, fullCollection, out, contentCollectionId);
            this.displayCitations(out, citations, collection, false, citationCollectionId, title, contentCollectionId);
            String[] logos = ServerConfigurationService.getStrings((String)"citations.logo");
            String logoHTML = "";
            if (logos != null) {
                logoHTML = "<div class='logos'>";
                for (String logo : logos) {
                    logoHTML = logoHTML + "<img src='" + logo + "' width='100' height='100'>";
                }
                logoHTML = logoHTML + "</div>";
                out.println(logoHTML);
            }
            if (citations.size() > 0) {
                out.println("</div></div>");
                out.println("</body></html>");
            }
        }
        catch (IOException e) {
            throw new EntityAccessOverloadException(ref.getReference());
        }
        catch (ServerOverloadException e) {
            throw new EntityAccessOverloadException(ref.getReference());
        }
        catch (IdUnusedException e) {
            throw new EntityNotDefinedException(ref.getReference());
        }
        catch (PermissionException e) {
            throw new EntityPermissionException(e.getUser(), ContentHostingService.EVENT_RESOURCE_READ, ref.getReference());
        }
        catch (TypeException e) {
            throw new EntityNotDefinedException(ref.getReference());
        }
    }

    private void displayCitations(PrintWriter out, List<Citation> citations, CitationCollection collection, boolean isNested, String citationCollectionId, String title, String contentCollectionId) {
        out.println("\t<table class=\"listHier lines nolines\" summary=\"citations table\" cellpadding=\"0\" cellspacing=\"0\">");
        out.println("\t<tbody>");
        if (citations.size() > 0 && !isNested) {
            out.println("\t<tr><th colspan=\"2\">");
            out.println("\t\t<div class=\"viewNav\" style=\"padding: 0pt;\"><strong>" + rb.getString("listing.title") + "</strong> (" + collection.size() + ")");
            out.println("\t\t</div>");
            out.println("\t</th></tr>");
        }
        if (citations.size() > 0 && !isNested) {
            out.println("\t<tr class=\"exclude\"><td colspan=\"2\">");
            out.println("\t\t<div class=\"itemAction\">");
            out.println("\t\t\t<a href=\"#\" onclick=\"showAllDetails( '" + rb.getString("link.hide.results") + "' ); return false;\">" + rb.getString("link.show.readonly") + "</a> |");
            out.println("\t\t\t<a href=\"#\" onclick=\"hideAllDetails( '" + rb.getString("link.show.readonly") + "' ); return false;\">" + rb.getString("link.hide.results") + "</a>");
            out.println("\t\t</div>\n\t</td></tr>");
        }
        for (Citation citation : citations) {
            String label;
            Object value;
            String label2;
            String value2;
            Iterator valueIt;
            List values;
            String escapedId = citation.getId().replace('-', 'x');
            out.println("\t\t<tr>");
            out.println("\t\t\t<td class=\"attach\">");
            out.println("\t\t\t\t<img onclick=\"toggleDetails( '" + escapedId + "', '" + rb.getString("link.show.readonly") + "', '" + rb.getString("link.hide.results") + "' );\"");
            out.println("\t\t\t\tid=\"toggle_" + escapedId + "\" class=\"toggleIcon\"");
            out.println("\t\t\t\tstyle=\"cursor: pointer;\" src=\"/library/image/sakai/expand.gif?panel=Main\"");
            out.println("\t\t\t\talt=\"" + rb.getString("link.show.readonly") + "\" align=\"top\"");
            out.println("\t\t\t\tborder=\"0\" height=\"13\" width=\"13\" />");
            out.println("\t\t\t</td>");
            String href = null;
            try {
                href = citation.hasPreferredUrl() ? citation.getCustomUrl(citation.getPreferredUrlId()) : citation.getOpenurl();
            }
            catch (IdUnusedException idUnusedException) {
                // empty catch block
            }
            out.println("\t\t<td headers=\"details\">");
            out.println("\t\t\t<div class=\"detailsDiv\"><div style=\"padding:5px;\"><div class=\"imgDiv\" style=\"padding-right:5px;\"><a href=\"" + Validator.escapeHtml((String)href) + "\"><img src=\"/sakai-citations-tool/image/sakai/book-placeholder.png\" data-isbn=\"" + citation.getCitationProperty("isnIdentifier") + "\" class=\"googleBookCover\"></a></div><div style=\"float:left;\"><div><a href=\"" + Validator.escapeHtml((String)href) + "\" target=\"_blank\">" + Validator.escapeHtml((String)((String)citation.getCitationProperty("title", true))) + "</a></div>");
            out.println("\t\t\t\t<div class=\"creatorDiv\">" + Validator.escapeHtml((String)citation.getCreator()) + "</div>");
            out.println("\t\t\t\t<div class=\"sourceDiv\">" + Validator.escapeHtml((String)citation.getSource()) + "</div>");
            out.println("\t\t\t<div><table class=\"listHier lines nolines\" cellpadding=\"0\" cellspacing=\"0\">");
            Schema schema = citation.getSchema();
            if (schema == null) {
                m_log.warn((Object)("CLAS.handleViewRequest() Schema is null: " + citation));
                continue;
            }
            List fields = schema.getFields();
            for (Schema.Field field : fields) {
                if (!specialKeys.contains(field.getIdentifier())) continue;
                if (field.isMultivalued()) {
                    if ("creator".equals(field.getIdentifier())) continue;
                    values = (List)citation.getCitationProperty(field.getIdentifier());
                    valueIt = values.iterator();
                    boolean first = true;
                    while (valueIt.hasNext()) {
                        value2 = (String)valueIt.next();
                        if (value2 != null && !value2.trim().equals("")) {
                            if (first) {
                                label2 = rb.getString(schema.getIdentifier() + "." + field.getIdentifier(), field.getIdentifier());
                                out.println("\t\t\t\t<tr>\n\t\t\t\t\t<td class=\"attach\"><strong>" + label2 + ":</strong></td>\n\t\t\t\t\t<td>" + Validator.escapeHtml((String)value2) + "</td>\n\t\t\t\t</tr>");
                            } else {
                                out.println("\t\t\t\t<tr>\n\t\t\t\t\t<td class=\"attach\">&nbsp;</td>\n\t\t\t\t\t<td>" + Validator.escapeHtml((String)value2) + "</td>\n\t\t\t\t</tr>\n");
                            }
                        }
                        first = false;
                    }
                    continue;
                }
                value = (String)citation.getCitationProperty(field.getIdentifier(), true);
                if (value == null || ((String)value).trim().equals("")) continue;
                label = rb.getString(schema.getIdentifier() + "." + field.getIdentifier(), field.getIdentifier());
                if ("title".equals(field.getIdentifier())) continue;
                out.println("\t\t\t\t<tr>\n\t\t\t\t\t<td class=\"attach\"><strong>" + label + "</strong></td>\n\t\t\t\t\t<td>" + Validator.escapeHtml((String)value) + "</td>\n\t\t\t\t</tr>");
            }
            out.println("\t\t\t</table></div></div>");
            out.println("\t\t\t<div>");
            if (citation.hasCustomUrls() || citation.getCitationProperty("otherIds") instanceof Vector) {
                out.println("\t\t\t<div class=\"itemAction links\" style=\"width:20%\">");
            }
            if (citation.hasCustomUrls()) {
                List customUrlIds = citation.getCustomUrlIds();
                for (String urlId : customUrlIds) {
                    if (citation.hasPreferredUrl() && (!citation.hasPreferredUrl() || citation.getPreferredUrlId().equals(urlId))) continue;
                    String urlLabel = null;
                    try {
                        urlLabel = citation.getCustomUrlLabel(urlId) == null || citation.getCustomUrlLabel(urlId).trim().equals("") ? rb.getString("nullUrlLabel.view") : Validator.escapeHtml((String)citation.getCustomUrlLabel(urlId));
                    }
                    catch (IdUnusedException e) {
                        e.printStackTrace();
                    }
                    try {
                        out.println("\t\t\t\t<a href=\"" + Validator.escapeHtml((String)citation.getCustomUrl(urlId)) + "\" target=\"_blank\">" + urlLabel + "</a>");
                    }
                    catch (IdUnusedException e) {
                        e.printStackTrace();
                    }
                    out.println("\t\t\t\t |");
                }
            } else if (citation.getCitationProperty("otherIds") instanceof Vector) {
                out.println("\t\t\t\t<a href=\"" + ((Vector)citation.getCitationProperty("otherIds")).get(0) + "\" target=\"_blank\">" + "Find it" + " on SOLO" + "</a>");
            }
            if (citation.hasCustomUrls() || citation.getCitationProperty("otherIds") instanceof Vector) {
                out.println("\t\t\t</div>");
            }
            out.println("\t\t\t\t<span class=\"Z3988\" title=\"" + citation.getOpenurlParameters().substring(1).replace("&", "&amp;") + "\"></span>");
            out.println("\t\t\t</div></div>");
            out.println("\t\t\t</div></div>");
            out.println("\t\t\t<div><table class=\"listHier lines nolines\" cellpadding=\"0\" cellspacing=\"0\">");
            out.println("\t\t\t</table></div>");
            out.println("\t\t<div id=\"details_" + escapedId + "\" class=\"citationDetails\" style=\"display: none;\">");
            out.println("\t\t\t<table class=\"listHier lines nolines\" cellpadding=\"0\" cellspacing=\"0\">");
            out.println("\t\t<div class=\"availabilityHeader\"></div>");
            out.println("\t\t</td>");
            fields = schema.getFields();
            for (Schema.Field field : fields) {
                if (specialKeys.contains(field.getIdentifier())) continue;
                if (field.isMultivalued()) {
                    if ("creator".equals(field.getIdentifier())) continue;
                    values = (List)citation.getCitationProperty(field.getIdentifier());
                    valueIt = values.iterator();
                    boolean first = true;
                    while (valueIt.hasNext()) {
                        value2 = (String)valueIt.next();
                        if (value2 != null && !value2.trim().equals("")) {
                            if (first) {
                                label2 = rb.getString(schema.getIdentifier() + "." + field.getIdentifier(), field.getIdentifier());
                                out.println("\t\t\t\t<tr>\n\t\t\t\t\t<td class=\"attach\"><strong>" + label2 + ":</strong></td>\n\t\t\t\t\t<td>" + Validator.escapeHtml((String)value2) + "</td>\n\t\t\t\t</tr>");
                            } else {
                                out.println("\t\t\t\t<tr>\n\t\t\t\t\t<td class=\"attach\">&nbsp;</td>\n\t\t\t\t\t<td>" + Validator.escapeHtml((String)value2) + "</td>\n\t\t\t\t</tr>\n");
                            }
                        }
                        first = false;
                    }
                    continue;
                }
                value = (String)citation.getCitationProperty(field.getIdentifier());
                if (value == null || ((String)value).trim().equals("")) continue;
                label = rb.getString(schema.getIdentifier() + "." + field.getIdentifier(), field.getIdentifier());
                if ("title".equals(field.getIdentifier())) continue;
                out.println("\t\t\t\t<tr>\n\t\t\t\t\t<td class=\"attach\"><strong>" + label + ":</strong></td>\n\t\t\t\t\t<td>" + Validator.escapeHtml((String)value) + "</td>\n\t\t\t\t</tr>");
            }
            out.println("\t\t\t</table>");
            out.println("\t\t</div>");
            out.println("\t\t</td>");
            out.println("\t\t</tr>");
        }
        if (citations.size() > 0) {
            if (!isNested) {
                out.println("\t<tr class=\"exclude\"><td colspan=\"2\">");
                out.println("\t\t<div class=\"itemAction\">");
                out.println("\t\t\t<a href=\"#\" onclick=\"showAllDetails( '" + rb.getString("link.hide.results") + "' ); return false;\">" + rb.getString("link.show.readonly") + "</a> |");
                out.println("\t\t\t<a href=\"#\" onclick=\"hideAllDetails( '" + rb.getString("link.show.readonly") + "' ); return false;\">" + rb.getString("link.hide.results") + "</a>");
                out.println("\t\t</div>\n\t</td></tr>");
                out.println("\t<tr><th colspan=\"2\">");
                out.println("\t\t<div class=\"viewNav\" style=\"padding: 0pt;\"><strong>" + rb.getString("listing.title") + "</strong> (" + collection.size() + ")");
                out.println("\t\t</div>");
                out.println("\t</th></tr>");
            }
            out.println("\t</tbody>");
            out.println("\t</table>");
        }
    }

    private void displayNestedSections(String title, String citationCollectionId, CitationService citationService, CitationCollection collection, CitationCollection fullCollection, PrintWriter out, String contentCollectionId) throws IdUnusedException {
        CitationCollectionOrder nestedCollection = citationService.getNestedCollection(citationCollectionId);
        int nestedSectionsSize = nestedCollection.getChildren().size();
        out.println("<ol class='serialization viewCitations h1NestedLevel' style='padding:0;'>");
        if (nestedSectionsSize > 0) {
            for (CitationCollectionOrder nestedSection : nestedCollection.getChildren()) {
                String editorDivId = "sectionInlineEditor" + nestedSection.getLocation();
                String linkId = "link" + nestedSection.getLocation();
                String linkClick = "linkClick" + nestedSection.getLocation();
                String toggleImgDiv = "toggleImgDiv" + nestedSection.getLocation();
                String toggleImg = "toggleImg" + nestedSection.getLocation();
                String addSubsectionId = "addSubsection" + nestedSection.getLocation();
                int citationNo = nestedSection.getCountCitations();
                out.println("<li id = '" + linkId + "' class='h1Editor accordionH1 " + (nestedSection.getChildren().size() > 0 ? " hasSections" : "") + "' data-sectiontype='" + nestedSection.getSectiontype() + "'>" + "<div id='" + linkClick + "' style='width:100%; float:left; '><div id='" + toggleImgDiv + "'>" + (nestedSection.getChildren().size() > 0 ? "<img border='0' width='16' height='16' align='top' alt='Citation View' src='/library/image/sakai/white-arrow-right.gif' class='toggleIcon accordionArrow' id='" + toggleImg + "'>" : "") + "</div>" + "<div id = '" + editorDivId + "' class='editor accordionDiv'>" + (nestedSection.getValue() != null ? nestedSection.getValue() : "") + (citationNo != 0 ? " (" + citationNo + " citations)" : "") + "</div></div>");
                if (nestedSection.getChildren().size() > 0) {
                    out.println("<ol id = '" + addSubsectionId + "' class='h2NestedLevel' style='clear:both;'>");
                    for (CitationCollectionOrder h2Section : nestedSection.getChildren()) {
                        editorDivId = "sectionInlineEditor" + h2Section.getLocation();
                        linkId = "link" + h2Section.getLocation();
                        linkClick = "linkClick" + h2Section.getLocation();
                        toggleImgDiv = "toggleImgDiv" + h2Section.getLocation();
                        toggleImg = "toggleImg" + h2Section.getLocation();
                        addSubsectionId = "addSubsection" + h2Section.getLocation();
                        if (h2Section.getSectiontype().toString().equals("HEADING2")) {
                            out.println("<li id = '" + linkId + "' class='h2Section " + (h2Section.getChildren().size() > 0 ? " hasSections" : "") + "' data-location='" + h2Section.getLocation() + "' data-sectiontype='" + h2Section.getSectiontype() + "' style='background: #cef none repeat scroll 0 0;'>" + "<div id='" + linkClick + "' style='width:100%;'><div id='" + toggleImgDiv + "'>" + (h2Section.getChildren().size() > 0 ? "<img border='0' width='16' height='16' align='top' alt='Citation View' src='/library/image/sakai/collapse.gif' class='toggleIcon accordionArrow' id='" + toggleImg + "'>" : "") + "</div>" + "<div id = '" + editorDivId + "' class='editor h2Editor' style='min-height:30px; padding:5px;'>" + (h2Section.getValue() != null ? h2Section.getValue() : "") + "</div></div>");
                            if (h2Section.getChildren().size() > 0) {
                                out.println("<ol id='" + addSubsectionId + "' class='h3NestedLevel' style='padding-top:0px;'>");
                                for (CitationCollectionOrder h3Section : h2Section.getChildren()) {
                                    ArrayList<Object> h3Citations;
                                    editorDivId = "sectionInlineEditor" + h3Section.getLocation();
                                    linkId = "link" + h3Section.getLocation();
                                    linkClick = "linkClick" + h3Section.getLocation();
                                    toggleImgDiv = "toggleImgDiv" + h3Section.getLocation();
                                    toggleImg = "toggleImg" + h3Section.getLocation();
                                    addSubsectionId = "addSubsection" + h3Section.getLocation();
                                    if (h3Section.getSectiontype().toString().equals("HEADING3")) {
                                        out.println("<li id = '" + linkId + "' class='h3Section " + (h3Section.getChildren().size() > 0 ? " hasSections" : "") + " ' data-location='" + h3Section.getLocation() + "' data-sectiontype='" + h3Section.getSectiontype() + "'>" + "<div id='" + linkClick + "' style='width:100%;'><div id='" + toggleImgDiv + "'>" + (h3Section.getChildren().size() > 0 ? "<img border='0' width='16' height='16' align='top' alt='Citation View' src='/library/image/sakai/collapse.gif' class='toggleIcon accordionArrow' id='" + toggleImg + "'>" : "") + "</div>" + "<div style='' id = '" + editorDivId + "' class='editor h3Editor' " + "style='padding-left:20px; '>" + "<div style=''>" + (h3Section.getValue() != null ? h3Section.getValue() : "") + "</div></div></div>");
                                        if (h3Section.getChildren().size() <= 0) continue;
                                        out.println("<ol id='" + addSubsectionId + "' class='h4NestedLevel' style='padding-top:0;'>");
                                        h3Citations = new ArrayList();
                                        for (CitationCollectionOrder nestedCitation : h3Section.getChildren()) {
                                            if (nestedCitation.getSectiontype().toString().equals("CITATION")) {
                                                Citation c = fullCollection.getCitation(nestedCitation.getCitationid());
                                                if (c == null) continue;
                                                h3Citations.add(c);
                                                continue;
                                            }
                                            if (!nestedCitation.getSectiontype().toString().equals("DESCRIPTION")) continue;
                                            out.println("<li id = '" + linkId + "' class='h3Section' data-location='" + nestedCitation.getLocation() + "' data-sectiontype='" + nestedCitation.getSectiontype() + "' style='background: #cef none repeat scroll 0 0;'>" + "<div id = '" + editorDivId + "' class='editor description' style='min-height:30px; padding:5px;'>" + nestedCitation.getValue() + "</div></li>");
                                        }
                                        if (h3Citations != null && !h3Citations.isEmpty()) {
                                            this.displayCitations(out, h3Citations, collection, true, citationCollectionId, title, contentCollectionId);
                                        }
                                        out.println("</ol>");
                                        continue;
                                    }
                                    if (h3Section.getSectiontype().toString().equals("CITATION")) {
                                        out.println("<ol id='" + addSubsectionId + "' class='h4NestedLevel' style='padding-top:0;'>");
                                        h3Citations = new ArrayList<Citation>();
                                        Citation c = fullCollection.getCitation(h3Section.getCitationid());
                                        if (c != null) {
                                            h3Citations.add(c);
                                        }
                                        this.displayCitations(out, h3Citations, collection, true, citationCollectionId, title, contentCollectionId);
                                        out.println("</ol>");
                                        continue;
                                    }
                                    if (!h3Section.getSectiontype().toString().equals("DESCRIPTION")) continue;
                                    out.println("<li id = '" + linkId + "' class='h3Section' data-location='" + h3Section.getLocation() + "' data-sectiontype='" + h3Section.getSectiontype() + "' style='background: #cef none repeat scroll 0 0;'>" + "<div id = '" + editorDivId + "' class='editor description' style='min-height:30px; padding:5px;'>" + h3Section.getValue() + "</div></li>");
                                }
                                out.println("</ol>");
                                continue;
                            }
                            out.println("<ol class='h3NestedLevel'></ol>");
                            continue;
                        }
                        if (h2Section.getSectiontype().toString().equals("CITATION")) {
                            out.println("<ol id='" + addSubsectionId + "' class='h4NestedLevel' style='padding-top:0;'>");
                            ArrayList<Citation> h3Citations = new ArrayList<Citation>();
                            Citation c = fullCollection.getCitation(h2Section.getCitationid());
                            if (c != null) {
                                h3Citations.add(c);
                            }
                            this.displayCitations(out, h3Citations, collection, true, citationCollectionId, title, contentCollectionId);
                            out.println("</ol>");
                            continue;
                        }
                        if (!h2Section.getSectiontype().toString().equals("DESCRIPTION")) continue;
                        out.println("<li id = '" + linkId + "' class='h2Section' data-location='" + h2Section.getLocation() + "' data-sectiontype='" + h2Section.getSectiontype() + "' style='background: #cef none repeat scroll 0 0;'>" + "<div id = '" + editorDivId + "' class='editor description' style='min-height:30px; padding:5px;'>" + h2Section.getValue() + "</div></li>");
                    }
                    out.println("</ol>");
                }
                out.println("</li>");
            }
        }
        out.println("</ol>");
    }

    static {
        specialKeys.add("edition");
        specialKeys.add("note");
        specialKeys.add("notes");
    }
}

