/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.citation.impl.openurl;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Utils {
    public static String getValue(Map<String, String[]> params, String key) {
        String[] values = params.get(key);
        if (values != null && values.length > 0) {
            if (values.length > 1) {
                // empty if block
            }
            return values[0];
        }
        return null;
    }

    public static Map<String, String[]> split(String source) {
        HashMap<String, String[]> values = new HashMap<String, String[]>();
        if (source != null) {
            String[] parts;
            for (String part : parts = source.split("&")) {
                String value;
                String[] kv = part.split("=");
                if (kv.length != 2 && kv.length != 1 || kv[0].length() <= 1) continue;
                String key = kv[0];
                String string = value = kv.length > 1 ? kv[1] : null;
                if (values.containsKey(key)) {
                    ArrayList<Object> valuesList = new ArrayList<Object>(Arrays.asList((Object[])values.get(key)));
                    valuesList.add(value);
                    values.put(key, valuesList.toArray(new String[0]));
                    continue;
                }
                values.put(key, new String[]{value});
            }
        }
        return values;
    }

    public static Map<String, String[]> decode(Map<String, String[]> source, String encoding) {
        try {
            HashMap<String, String[]> decoded = new HashMap<String, String[]>();
            for (Map.Entry<String, String[]> entry : source.entrySet()) {
                String key = URLDecoder.decode(entry.getKey(), encoding);
                String[] values = new String[entry.getValue().length];
                for (int i = 0; i < entry.getValue().length; ++i) {
                    values[i] = entry.getValue()[i] == null ? null : URLDecoder.decode(entry.getValue()[i], encoding);
                }
                decoded.put(key, values);
            }
            return decoded;
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalArgumentException("Unsupported encoding: " + encoding);
        }
    }

    public static String lookForAuthor(Map<String, List<String>> values) {
        StringBuilder author = new StringBuilder();
        if (Utils.appendFirst(author, values.get("aulast"), null)) {
            if (values.containsKey("au")) {
                for (String otherAuthor : values.get("au")) {
                    if (otherAuthor == null || !otherAuthor.toLowerCase().contains(author.toString().toLowerCase())) continue;
                    return null;
                }
            }
            if (!Utils.appendFirst(author, values.get("aufirst"), ", ") && !Utils.appendFirst(author, values.get("auinit"), ", ") && Utils.appendFirst(author, values.get("auinit1"), ", ")) {
                Utils.appendFirst(author, values.get("auinitm"), " ");
            }
            return author.toString();
        }
        return null;
    }

    public static boolean appendFirst(StringBuilder buffer, List<String> values, String seperator) {
        String value;
        if (values != null && !values.isEmpty() && (value = values.get(0)) != null) {
            if (seperator != null) {
                buffer.append(seperator);
            }
            buffer.append(value);
            return true;
        }
        return false;
    }
}

