/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.citation.impl;

import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.sakaiproject.authz.api.SecurityAdvisor;
import org.sakaiproject.authz.cover.SecurityService;
import org.sakaiproject.citation.api.ConfigurationService;
import org.sakaiproject.citation.api.SiteOsidConfiguration;
import org.sakaiproject.citation.util.api.OsidConfigurationException;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.content.cover.ContentHostingService;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.cover.EntityManager;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.exception.IdInvalidException;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.IdUsedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.ServerOverloadException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.tool.api.SessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BaseConfigurationService
implements ConfigurationService,
Observer {
    private static Logger m_log = LoggerFactory.getLogger(BaseConfigurationService.class);
    private static final String SERVER_DEFAULT_LOCALE = Locale.ENGLISH.getLanguage();
    public static final String DEFAULT_SECONDS_BETWEEN_SAVECITE_REFRESHES = "5";
    public static final int MAXIMUM_SECONDS_BETWEEN_SAVECITE_REFRESHES = 30;
    public static final String PARAM_SECONDS_BETWEEN_SAVECITE_REFRESHES = "secondsBetweenSaveciteRefreshes";
    protected boolean m_citationsEnabledByDefault = false;
    protected boolean m_allowSiteBySiteOverride = false;
    protected String m_googleSearchEnabled = "false";
    protected String m_librarySearchEnabled = "false";
    protected boolean m_externalSearchEnabled = false;
    protected String m_adminSiteName = "citationsAdmin";
    protected String m_configFolder = "config";
    protected String m_configXml = "sakai/citationsConfig.xml";
    protected String m_categoriesXml = "sakai/databaseHierarchy.xml";
    protected SortedSet<String> m_updatableResources = Collections.synchronizedSortedSet(new TreeSet());
    protected String m_databaseXml;
    protected String m_siteConfigXml;
    protected String m_metasearchUsername;
    protected String m_metasearchPassword;
    protected String m_metasearchBaseUrl;
    protected String m_osidImpl;
    protected String m_extendedRepositoryId;
    protected String m_openUrlLabel;
    protected String m_openUrlResolverAddress;
    protected String m_googleBaseUrl;
    protected String m_sakaiServerKey;
    protected String m_externalSearchUrl;
    protected String m_osidConfig;
    protected SessionManager m_sessionManager;
    protected ServerConfigurationService m_serverConfigurationService;
    private TreeSet<String> m_categories;
    private TreeSet<String> m_configs;
    private static SiteOsidConfiguration m_siteConfigInstance = null;
    protected static Map<String, Map<String, String>> m_configMaps = new HashMap<String, Map<String, String>>();
    protected static String m_configListRef = null;
    protected Map<String, List<Map<String, String>>> saveciteClients = new HashMap<String, List<Map<String, String>>>();

    public String getConfigurationXml() throws OsidConfigurationException {
        SiteOsidConfiguration siteConfig = this.getSiteOsidConfiguration();
        String configXml = null;
        if (siteConfig != null) {
            configXml = siteConfig.getConfigurationXml();
        }
        if (this.isNull(configXml)) {
            configXml = this.m_siteConfigXml;
        }
        return configXml;
    }

    public boolean isConfigurationXmlAvailable() {
        try {
            String configXml = this.getConfigurationXml();
            if (configXml == null) {
                return false;
            }
            return this.exists(configXml);
        }
        catch (OsidConfigurationException exception) {
            m_log.warn("Unexpected exception: " + (Object)((Object)exception));
            return false;
        }
    }

    public String getConfigFolderReference() {
        String configFolderRef = null;
        if (!this.isNull(this.m_adminSiteName) && !this.isNull(this.m_configFolder)) {
            configFolderRef = "/content/group/" + this.m_adminSiteName + "/" + this.m_configFolder + "/";
        }
        return configFolderRef;
    }

    public String getConfigFolderId() {
        String configFolderId = null;
        if (!this.isNull(this.m_adminSiteName) && !this.isNull(this.m_configFolder)) {
            configFolderId = "/group/" + this.m_adminSiteName + "/" + this.m_configFolder + "/";
        }
        return configFolderId;
    }

    public String getDatabaseHierarchyXml() throws OsidConfigurationException {
        SiteOsidConfiguration siteConfig = this.getSiteOsidConfiguration();
        String databaseXml = null;
        if (siteConfig != null) {
            databaseXml = siteConfig.getDatabaseHierarchyXml();
        }
        if (this.isNull(databaseXml)) {
            databaseXml = this.m_databaseXml;
        }
        return databaseXml;
    }

    public boolean isDatabaseHierarchyXmlAvailable() {
        try {
            String dbXml = this.getDatabaseHierarchyXml();
            if (dbXml == null) {
                return false;
            }
            return this.exists(dbXml);
        }
        catch (OsidConfigurationException exception) {
            m_log.warn("Unexpected exception: " + (Object)((Object)exception));
            return false;
        }
    }

    public List<String> getGroupIds() throws OsidConfigurationException {
        SiteOsidConfiguration siteConfig = this.getSiteOsidConfiguration();
        if (siteConfig == null) {
            ArrayList<String> emptyList = new ArrayList<String>();
            return emptyList;
        }
        return siteConfig.getGroupIds();
    }

    public synchronized String getSiteConfigOsidPackageName() {
        String value = this.getConfigurationParameter("osid-impl");
        return value != null ? value : this.getOsidImpl();
    }

    public synchronized String getSiteConfigExtendedRepositoryId() {
        String value = this.getConfigurationParameter("extended-repository-id");
        return value != null ? value : this.getExtendedRepositoryId();
    }

    public synchronized String getSiteConfigMetasearchUsername() {
        String value = this.getConfigurationParameter("metasearch-username");
        return value != null ? value : this.getMetasearchUsername();
    }

    public synchronized String getSiteConfigMetasearchPassword() {
        String value = this.getConfigurationParameter("metasearch-password");
        return value != null ? value : this.getMetasearchPassword();
    }

    public synchronized String getSiteConfigMetasearchBaseUrl() {
        String value = this.getConfigurationParameter("metasearch-baseurl");
        return value != null ? value : this.getMetasearchBaseUrl();
    }

    public synchronized String getSiteConfigOpenUrlLabel() {
        String value = this.getConfigurationParameter("openurl-label");
        return value != null ? value : this.getOpenUrlLabel();
    }

    public synchronized String getSiteConfigOpenUrlResolverAddress() {
        String value = this.getConfigurationParameter("openurl-resolveraddress");
        return value != null ? value : this.getOpenUrlResolverAddress();
    }

    public synchronized String getSiteConfigGoogleBaseUrl() {
        String value = this.getConfigurationParameter("google-baseurl");
        return value != null ? value : this.getGoogleBaseUrl();
    }

    public synchronized String getSiteConfigSakaiServerKey() {
        String value = this.getConfigurationParameter("sakai-serverkey");
        return value != null ? value : this.getSakaiServerKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getSiteConfigMaximumSearchableDBs() {
        String configValue = this.getConfigurationParameter("searchable-databases");
        int searchableDbs = 8;
        if (configValue == null) {
            return searchableDbs;
        }
        try {
            searchableDbs = Integer.parseInt(configValue);
            if (searchableDbs <= 0) {
                throw new NumberFormatException(configValue);
            }
        }
        catch (NumberFormatException exception) {
            if (m_log.isDebugEnabled()) {
                m_log.debug("Maximum searchable database exception: " + exception.toString());
            }
            searchableDbs = 8;
            return searchableDbs;
        }
        finally {
            return searchableDbs;
        }
    }

    public synchronized String getSiteConfigUsePreferredUrls() {
        String value = this.getConfigurationParameter("provide-direct-url");
        if (value == null) {
            return "false";
        }
        if (!((value = value.trim().toLowerCase()).equals("false") || value.equals("related-link") || value.equals("title-link"))) {
            m_log.debug("Invalid value for <provide-direct-url>: \"" + value + "\", using \"false\"");
            value = "false";
        }
        return value;
    }

    public synchronized String getSiteConfigPreferredUrlPrefix() {
        return this.getConfigurationParameter("direct-url-prefix");
    }

    public void setCitationsEnabledByDefault(boolean citationsEnabledByDefault) {
        this.m_citationsEnabledByDefault = citationsEnabledByDefault;
    }

    public boolean isCitationsEnabledByDefault() {
        String state = this.getConfigurationParameter("citations-enabled-by-default");
        if (state != null) {
            m_log.debug("Citations enabled by default (1): " + state.equals("true"));
            return state.equals("true");
        }
        m_log.debug("Citations enabled by default (2): " + this.m_citationsEnabledByDefault);
        return this.m_citationsEnabledByDefault;
    }

    public void setAllowSiteBySiteOverride(boolean allowSiteBySiteOverride) {
        this.m_allowSiteBySiteOverride = allowSiteBySiteOverride;
    }

    public boolean isAllowSiteBySiteOverride() {
        String state = this.getConfigurationParameter("citations-enabled-site-by-site");
        if (state != null) {
            m_log.debug("Citations enabled site-by-site (1): " + state.equals("true"));
            return state.equals("true");
        }
        m_log.debug("Citations enabled site-by-site (2): " + this.m_allowSiteBySiteOverride);
        return this.m_allowSiteBySiteOverride;
    }

    public void setGoogleScholarEnabled(boolean state) {
        String enabled = state ? "true" : "false";
        this.setGoogleSearchEnabled(enabled);
    }

    public boolean isGoogleScholarEnabled() {
        String state = this.getConfigurationParameter("google-scholar-enabled");
        if (state == null) {
            state = this.getGoogleSearchEnabled();
        }
        m_log.debug("Google enabled: " + state.equals("true"));
        return state.equals("true");
    }

    public void setLibrarySearchEnabled(boolean state) {
        String enabled = state ? "true" : "false";
        this.setLibrarySearchEnabled(enabled);
    }

    public boolean isLibrarySearchEnabled() {
        String state = this.getConfigurationParameter("library-search-enabled");
        if (state == null) {
            state = this.getLibrarySearchEnabled();
        }
        m_log.debug("Library Search enabled: " + state.equals("true"));
        return state.equals("true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getConfigurationParameter(String parameter) {
        Map<String, String> parameterMap = null;
        try {
            SiteOsidConfiguration siteConfig = this.getSiteOsidConfiguration();
            if (siteConfig == null) {
                return null;
            }
            String configXml = siteConfig.getConfigurationXml();
            if (configXml == null) {
                return null;
            }
            String configXmlRef = this.getConfigFolderReference() + configXml;
            BaseConfigurationService baseConfigurationService = this;
            synchronized (baseConfigurationService) {
                parameterMap = m_configMaps.get(configXmlRef);
            }
        }
        catch (OsidConfigurationException exception) {
            m_log.warn("Failed to get a dynamic XML value for " + parameter + ": " + (Object)((Object)exception));
        }
        return parameterMap == null ? null : (String)parameterMap.get(parameter);
    }

    protected SiteOsidConfiguration getSiteOsidConfiguration() {
        SiteOsidConfiguration siteConfig;
        try {
            siteConfig = this.getConfigurationHandler(this.m_osidConfig);
            siteConfig.init();
        }
        catch (Exception exception) {
            m_log.warn("Failed to get " + this.m_osidConfig + ": " + exception);
            siteConfig = null;
        }
        return siteConfig;
    }

    public synchronized SiteOsidConfiguration getConfigurationHandler(String osidConfigHandler) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (m_siteConfigInstance == null) {
            Class<?> configClass = Class.forName(osidConfigHandler);
            m_siteConfigInstance = (SiteOsidConfiguration)configClass.newInstance();
        }
        return m_siteConfigInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateConfig(String configurationXml, InputStream stream) {
        Document document = this.parseXmlFromStream(stream);
        if (document == null) {
            return;
        }
        BaseConfigurationService baseConfigurationService = this;
        synchronized (baseConfigurationService) {
            Map<String, String> parameterMap = m_configMaps.get(configurationXml);
            if (parameterMap == null) {
                parameterMap = new HashMap<String, String>();
            }
            parameterMap.clear();
            this.saveParameter(document, parameterMap, "citations-enabled-by-default");
            this.saveParameter(document, parameterMap, "citations-enabled-site-by-site");
            this.saveParameter(document, parameterMap, "google-scholar-enabled");
            this.saveParameter(document, parameterMap, "library-search-enabled");
            this.saveParameter(document, parameterMap, "osid-impl");
            this.saveParameter(document, parameterMap, "extended-repository-id");
            this.saveParameter(document, parameterMap, "metasearch-username");
            this.saveParameter(document, parameterMap, "metasearch-password");
            this.saveParameter(document, parameterMap, "metasearch-baseurl");
            this.saveParameter(document, parameterMap, "metasearch-enabled");
            this.saveParameter(document, parameterMap, "openurl-label");
            this.saveParameter(document, parameterMap, "openurl-resolveraddress");
            this.saveParameter(document, parameterMap, "provide-direct-url");
            this.saveParameter(document, parameterMap, "direct-url-prefix");
            this.saveParameter(document, parameterMap, "google-baseurl");
            this.saveParameter(document, parameterMap, "sakai-serverkey");
            this.saveParameter(document, parameterMap, "searchable-databases");
            this.saveParameter(document, parameterMap, "config-id");
            this.saveParameter(document, parameterMap, "database-xml");
            this.saveParameter(document, parameterMap, PARAM_SECONDS_BETWEEN_SAVECITE_REFRESHES);
            this.saveServletClientMappings(document);
            m_configMaps.put(configurationXml, parameterMap);
        }
    }

    protected void saveServletClientMappings(Document document) {
        NodeList mapNodes;
        Element clientElement = document.getElementById("saveciteClients");
        if (clientElement == null && (mapNodes = document.getElementsByTagName("map")) != null) {
            for (int i = 0; i < mapNodes.getLength(); ++i) {
                Element mapElement = (Element)mapNodes.item(i);
                if (!mapElement.hasAttribute("id") || !mapElement.getAttribute("id").equals("saveciteClients")) continue;
                clientElement = mapElement;
                break;
            }
        }
        if (clientElement != null) {
            try {
                XStream xstream = new XStream();
                TransformerFactory transFactory = TransformerFactory.newInstance();
                Transformer transformer = transFactory.newTransformer();
                StringWriter buffer = new StringWriter();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.transform(new DOMSource(clientElement), new StreamResult(buffer));
                String str = buffer.toString();
                this.saveciteClients = (Map)xstream.fromXML(str);
            }
            catch (Exception e) {
                m_log.warn("Exception trying to read saveciteClients from config XML", (Throwable)e);
            }
        }
    }

    protected void saveParameter(Document document, Map parameterMap, String name) {
        String value = this.getText(document, name);
        if (value != null) {
            parameterMap.put(name, value);
        }
    }

    protected Document parseXmlFromStream(InputStream stream) {
        try {
            DocumentBuilder documentBuilder = this.getXmlDocumentBuilder();
            if (documentBuilder != null) {
                return documentBuilder.parse(stream);
            }
        }
        catch (Exception exception) {
            m_log.warn("XML parse on \"" + stream + "\" failed: " + exception);
        }
        return null;
    }

    protected DocumentBuilder getXmlDocumentBuilder() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            return factory.newDocumentBuilder();
        }
        catch (Exception exception) {
            m_log.warn("Failed to get XML DocumentBuilder: " + exception);
            return null;
        }
    }

    protected String normalizeText(String original, String update) {
        if (original == null) {
            return update == null ? "" : update.trim();
        }
        StringBuilder result = new StringBuilder(original.trim());
        result.append(' ');
        result.append(update.trim());
        return result.toString();
    }

    protected String getText(Document root, String elementName) {
        return this.getText(root.getDocumentElement(), elementName);
    }

    protected String getText(Element root, String elementName) {
        NodeList nodeList = root.getElementsByTagName(elementName);
        if (nodeList.getLength() == 0) {
            return null;
        }
        String text = null;
        Element parent = (Element)nodeList.item(0);
        block3: for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getNodeType()) {
                case 3: {
                    text = this.normalizeText(text, child.getNodeValue());
                    continue block3;
                }
            }
        }
        return text == null ? text : text.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init() {
        block20: {
            block19: {
                block18: {
                    BaseConfigurationService.m_log.info("init()");
                    EventTrackingService.addObserver((Observer)this);
                    siteService = (SiteService)ComponentManager.get(SiteService.class);
                    contentService = (org.sakaiproject.content.api.ContentHostingService)ComponentManager.get(org.sakaiproject.content.api.ContentHostingService.class);
                    BaseConfigurationService.m_log.info("init() site m_adminSiteName == \"" + this.m_adminSiteName + "\"");
                    if (!this.isNull(this.m_adminSiteName)) break block18;
                    BaseConfigurationService.m_log.info("init() m_adminSiteName is null");
                    ** GOTO lbl88
                }
                if (!siteService.siteExists(this.m_adminSiteName)) break block19;
                BaseConfigurationService.m_log.info("init() site " + this.m_adminSiteName + " already exists");
                ** GOTO lbl88
            }
            if (this.m_serverConfigurationService.getBoolean("citationsAdmin.autocreate", true)) break block20;
            BaseConfigurationService.m_log.info("init() skipping autocreate of citationsAdmin site");
            ** GOTO lbl88
        }
        pushed = null;
        try {
            pushed = this.enableSecurityAdvisor();
            s = this.m_sessionManager.getCurrentSession();
            s.setUserId("admin");
            adminSite = siteService.addSite(this.m_adminSiteName, "project");
            adminSite.setTitle("Citations Admin");
            adminSite.setPublished(true);
            adminSite.setJoinable(false);
            page = adminSite.addPage();
            page.setTitle("Resources");
            page.addTool("sakai.resources");
            siteService.save(adminSite);
            BaseConfigurationService.m_log.debug("init() site " + this.m_adminSiteName + " has been created");
            if (pushed == null) ** GOTO lbl88
            found = false;
            ** GOTO lbl64
        }
        catch (IdInvalidException e) {
            BaseConfigurationService.m_log.warn("IdInvalidException ", (Throwable)e);
            if (pushed == null) ** GOTO lbl88
            found = false;
            ** GOTO lbl69
            catch (IdUsedException e) {
                BaseConfigurationService.m_log.warn("IdUsedException ", (Throwable)e);
                if (pushed == null) ** GOTO lbl88
                found = false;
                ** GOTO lbl74
                catch (PermissionException e) {
                    BaseConfigurationService.m_log.warn("PermissionException ", (Throwable)e);
                    if (pushed == null) ** GOTO lbl88
                    found = false;
                    ** GOTO lbl79
                    catch (IdUnusedException e) {
                        try {
                            BaseConfigurationService.m_log.warn("IdUnusedException ", (Throwable)e);
                            if (pushed == null) ** GOTO lbl88
                            found = false;
                            ** GOTO lbl84
                        }
                        catch (Throwable var7_17) {
                            block21: {
                                block22: {
                                    block23: {
                                        if (pushed == null) break block21;
                                        found = false;
                                        break block22;
lbl64:
                                        // 2 sources

                                        while (SecurityService.hasAdvisors() && !found) {
                                            popped = SecurityService.popAdvisor();
                                            found = pushed == popped;
                                        }
                                        break block23;
lbl69:
                                        // 2 sources

                                        while (SecurityService.hasAdvisors() && !found) {
                                            popped = SecurityService.popAdvisor();
                                            found = pushed == popped;
                                        }
                                        break block23;
lbl74:
                                        // 2 sources

                                        while (SecurityService.hasAdvisors() && !found) {
                                            popped = SecurityService.popAdvisor();
                                            found = pushed == popped;
                                        }
                                        break block23;
lbl79:
                                        // 2 sources

                                        while (SecurityService.hasAdvisors() && !found) {
                                            popped = SecurityService.popAdvisor();
                                            found = pushed == popped;
                                        }
                                        break block23;
lbl84:
                                        // 2 sources

                                        while (SecurityService.hasAdvisors() && !found) {
                                            popped = SecurityService.popAdvisor();
                                            found = pushed == popped;
                                        }
                                    }
                                    var3_3 = this.m_configs.iterator();
                                    while (true) {
                                        if (!var3_3.hasNext()) {
                                            return;
                                        }
                                        config = var3_3.next();
                                        configFileRef = this.getConfigFolderReference() + config;
                                        this.updateConfig(configFileRef);
                                    }
                                }
                                while (SecurityService.hasAdvisors() && !found) {
                                    popped = SecurityService.popAdvisor();
                                    found = pushed == popped;
                                }
                            }
                            throw var7_17;
                        }
                    }
                }
            }
        }
    }

    public void destroy() {
        m_log.info("destroy()");
    }

    public String getOsidImpl() {
        return this.m_osidImpl;
    }

    public void setOsidImpl(String osidImpl) {
        this.m_osidImpl = osidImpl;
    }

    public String getExtendedRepositoryId() {
        return this.m_extendedRepositoryId;
    }

    public void setExtendedRepositoryId(String extendedRepositoryId) {
        this.m_extendedRepositoryId = extendedRepositoryId;
    }

    public String getMetasearchUsername() {
        return this.m_metasearchUsername;
    }

    public void setMetasearchUsername(String username) {
        this.m_metasearchUsername = username;
    }

    public String getMetasearchBaseUrl() {
        return this.m_metasearchBaseUrl;
    }

    public void setMetasearchBaseUrl(String baseUrl) {
        this.m_metasearchBaseUrl = baseUrl;
    }

    public String getMetasearchPassword() {
        return this.m_metasearchPassword;
    }

    public void setMetasearchPassword(String password) {
        this.m_metasearchPassword = password;
    }

    public String getGoogleBaseUrl() {
        return this.m_googleBaseUrl;
    }

    public void setGoogleBaseUrl(String googleBaseUrl) {
        this.m_googleBaseUrl = googleBaseUrl;
    }

    public String getSakaiServerKey() {
        return this.m_sakaiServerKey;
    }

    public void setSakaiServerKey(String sakaiId) {
        this.m_sakaiServerKey = sakaiId;
    }

    public String getOpenUrlLabel() {
        return this.m_openUrlLabel;
    }

    public void setOpenUrlLabel(String openUrlLabel) {
        this.m_openUrlLabel = openUrlLabel;
    }

    public String getOpenUrlResolverAddress() {
        return this.m_openUrlResolverAddress;
    }

    public void setOpenUrlResolverAddress(String openUrlResolverAddress) {
        this.m_openUrlResolverAddress = openUrlResolverAddress;
    }

    public String getDatabaseXml() {
        return this.m_databaseXml;
    }

    public void setDatabaseXml(String databaseXml) {
        this.m_databaseXml = databaseXml;
    }

    public String getSiteConfigXml() {
        return this.m_siteConfigXml;
    }

    public void setSiteConfigXml(String siteConfigXml) {
        this.m_siteConfigXml = siteConfigXml;
    }

    public ServerConfigurationService getServerConfigurationService() {
        return this.m_serverConfigurationService;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.m_serverConfigurationService = serverConfigurationService;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.m_sessionManager = sessionManager;
    }

    public SessionManager getSessionManager() {
        return this.m_sessionManager;
    }

    public String getOsidConfig() {
        return this.m_osidConfig;
    }

    public void setOsidConfig(String osidConfig) {
        this.m_osidConfig = osidConfig;
    }

    public String getGoogleSearchEnabled() {
        return this.m_googleSearchEnabled;
    }

    public void setGoogleSearchEnabled(String googleSearchEnabled) {
        if (googleSearchEnabled.equalsIgnoreCase("true") || googleSearchEnabled.equalsIgnoreCase("false")) {
            this.m_googleSearchEnabled = googleSearchEnabled;
            return;
        }
        m_log.warn("Invalid Google support setting \"" + googleSearchEnabled + "\", disabling Google search");
        this.m_googleSearchEnabled = "false";
    }

    public String getLibrarySearchEnabled() {
        return this.m_librarySearchEnabled;
    }

    public void setLibrarySearchEnabled(String librarySearchEnabled) {
        if (librarySearchEnabled.equalsIgnoreCase("true") || librarySearchEnabled.equalsIgnoreCase("false")) {
            this.m_librarySearchEnabled = librarySearchEnabled;
            return;
        }
        m_log.warn("Invalid library support setting \"" + librarySearchEnabled + "\", disabling library search");
        this.m_librarySearchEnabled = "false";
    }

    public String getAdminSiteName() {
        return this.m_adminSiteName;
    }

    public void setAdminSiteName(String adminSiteName) {
        this.m_adminSiteName = adminSiteName;
    }

    public String getConfigFolder() {
        return this.m_configFolder;
    }

    public void setConfigFolder(String configFolder) {
        this.m_configFolder = configFolder;
    }

    public String getConfigXmlCache() {
        StringBuilder buf = new StringBuilder();
        Iterator<String> it = this.m_configs.iterator();
        while (it.hasNext()) {
            String str = it.next();
            buf.append(str);
            if (!it.hasNext()) continue;
            buf.append(',');
        }
        return buf.toString();
    }

    public void setConfigXmlCache(String configXml) {
        this.m_configs = new TreeSet();
        if (!this.isNull(configXml)) {
            String[] configs;
            for (String config : configs = configXml.split("\\s*,\\s*")) {
                this.m_configs.add(config);
            }
        }
    }

    public String getDatabaseXmlCache() {
        StringBuilder buf = new StringBuilder();
        Iterator<String> it = this.m_categories.iterator();
        while (it.hasNext()) {
            String str = it.next();
            buf.append(str);
            if (!it.hasNext()) continue;
            buf.append(',');
        }
        return buf.toString();
    }

    public void setDatabaseXmlCache(String categoriesXml) {
        this.m_categories = new TreeSet();
        if (!this.isNull(categoriesXml)) {
            String[] categories;
            for (String category : categories = categoriesXml.split("\\s*,\\s*")) {
                this.m_categories.add(category);
            }
        }
    }

    public Map<String, List<Map<String, String>>> getSaveciteClients() {
        return this.saveciteClients;
    }

    public void setSaveciteClients(Map<String, List<Map<String, String>>> saveciteClients) {
        m_log.info("saveciteClients updated");
        this.saveciteClients = saveciteClients;
        if (m_log.isDebugEnabled()) {
            if (this.saveciteClients == null) {
                m_log.debug("setSaveciteClients() called but saveciteClients is null");
                return;
            }
            StringBuilder buf = new StringBuilder("setSaveciteClients()\n");
            buf.append('\n');
            buf.append('\n');
            this.addMapToStringBuilder(buf, this.saveciteClients, 4, 4);
            buf.append('\n');
            buf.append('\n');
            m_log.debug(buf.toString());
        }
    }

    public List<Map<String, String>> getSaveciteClientsForLocale(Locale locale) {
        List<Map<String, String>> clients = null;
        clients = this.saveciteClients == null || this.saveciteClients.isEmpty() ? new ArrayList<Map<String, String>>() : (this.saveciteClients.containsKey(locale.toString()) ? this.saveciteClients.get(locale.toString()) : (this.saveciteClients.containsKey(locale.getLanguage() + "_" + locale.getCountry()) ? this.saveciteClients.get(locale.getLanguage() + "_" + locale.getCountry()) : (this.saveciteClients.containsKey(locale.getLanguage()) ? this.saveciteClients.get(locale.getLanguage()) : (this.saveciteClients.containsKey(SERVER_DEFAULT_LOCALE) ? this.saveciteClients.get(SERVER_DEFAULT_LOCALE) : new ArrayList()))));
        return clients;
    }

    protected void addMapToStringBuilder(StringBuilder buf, Map map, int indent, int indentIncrement) {
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            for (int i = 0; i < indent; ++i) {
                buf.append(' ');
            }
            buf.append(key);
            Object val = entry.getValue();
            if (val instanceof Map) {
                buf.append('\n');
                this.addMapToStringBuilder(buf, (Map)val, indent + indentIncrement, indentIncrement);
                continue;
            }
            if (val instanceof List) {
                this.addListToStringBuilder(buf, (List)val, indent + indentIncrement, indentIncrement);
                continue;
            }
            buf.append(" == ");
            buf.append(val);
            buf.append('\n');
        }
    }

    protected void addListToStringBuilder(StringBuilder buf, List list, int indent, int indentIncrement) {
        buf.append('\n');
        for (Object val : list) {
            int i;
            if (val instanceof Map) {
                this.addMapToStringBuilder(buf, (Map)val, indent + indentIncrement, indentIncrement);
                continue;
            }
            if (val instanceof List) {
                for (i = 0; i < indent; ++i) {
                    buf.append(' ');
                }
                buf.append("----------\n");
                for (i = 0; i < indent; ++i) {
                    buf.append(' ');
                }
                this.addListToStringBuilder(buf, (List)val, indent + indentIncrement, indentIncrement);
                continue;
            }
            for (i = 0; i < indent; ++i) {
                buf.append(' ');
            }
            buf.append(val);
            buf.append('\n');
        }
    }

    public Collection<String> getAllCategoryXml() {
        return new TreeSet<String>((SortedSet<String>)this.m_categories);
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        String refstr;
        Event event;
        if (arg1 instanceof Event && (event = (Event)arg1).getModify() && this.m_updatableResources.contains(refstr = event.getResource())) {
            m_log.debug("Updating configuration from " + refstr);
            this.updateConfig(refstr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateConfig(String configFileRef) {
        ref = EntityManager.newReference((String)configFileRef);
        pushed = null;
        if (ref == null) ** GOTO lbl64
        try {
            pushed = this.enableSecurityAdvisor();
            resource = ContentHostingService.getResource((String)ref.getId());
            if (resource != null) {
                this.populateConfig(configFileRef, resource.streamContent());
            }
            if (pushed == null) ** GOTO lbl64
            found = false;
            ** GOTO lbl40
        }
        catch (PermissionException e) {
            BaseConfigurationService.m_log.warn("Exception: " + (Object)e + ", continuing");
            if (pushed == null) ** GOTO lbl64
            found = false;
            ** GOTO lbl45
            catch (IdUnusedException e) {
                BaseConfigurationService.m_log.warn("Citations configuration XML is missing (" + configFileRef + "); Citations ConfigurationService will watch for its creation");
                if (pushed == null) ** GOTO lbl64
                found = false;
                ** GOTO lbl50
                catch (TypeException e) {
                    BaseConfigurationService.m_log.warn("Exception: " + (Object)e + ", continuing");
                    if (pushed == null) ** GOTO lbl64
                    found = false;
                    ** GOTO lbl55
                    catch (ServerOverloadException e) {
                        try {
                            BaseConfigurationService.m_log.warn("Exception: " + (Object)e + ", continuing");
                            if (pushed == null) ** GOTO lbl64
                            found = false;
                            ** GOTO lbl60
                        }
                        catch (Throwable var6_19) {
                            block17: {
                                block18: {
                                    block19: {
                                        if (pushed == null) break block17;
                                        found = false;
                                        break block18;
lbl40:
                                        // 2 sources

                                        while (SecurityService.hasAdvisors() && !found) {
                                            popped = SecurityService.popAdvisor();
                                            found = popped == pushed;
                                        }
                                        break block19;
lbl45:
                                        // 2 sources

                                        while (SecurityService.hasAdvisors() && !found) {
                                            popped = SecurityService.popAdvisor();
                                            found = popped == pushed;
                                        }
                                        break block19;
lbl50:
                                        // 2 sources

                                        while (SecurityService.hasAdvisors() && !found) {
                                            popped = SecurityService.popAdvisor();
                                            found = popped == pushed;
                                        }
                                        break block19;
lbl55:
                                        // 2 sources

                                        while (SecurityService.hasAdvisors() && !found) {
                                            popped = SecurityService.popAdvisor();
                                            found = popped == pushed;
                                        }
                                        break block19;
lbl60:
                                        // 2 sources

                                        while (SecurityService.hasAdvisors() && !found) {
                                            popped = SecurityService.popAdvisor();
                                            found = popped == pushed;
                                        }
                                    }
                                    this.m_updatableResources.add(configFileRef);
                                    return;
                                }
                                while (SecurityService.hasAdvisors() && !found) {
                                    popped = SecurityService.popAdvisor();
                                    found = popped == pushed;
                                }
                            }
                            throw var6_19;
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean exists(String resourceName) {
        block19: {
            SecurityAdvisor popped;
            SecurityAdvisor pushed;
            block15: {
                boolean bl;
                block18: {
                    boolean found;
                    Reference reference;
                    block16: {
                        boolean bl2;
                        block17: {
                            pushed = null;
                            String configFolderRef = this.getConfigFolderReference();
                            if (this.isNull(configFolderRef) || this.isNull(resourceName)) break block15;
                            String referenceName = configFolderRef + resourceName;
                            reference = EntityManager.newReference((String)referenceName);
                            if (reference != null) break block16;
                            bl2 = false;
                            if (pushed == null) break block17;
                            boolean found2 = false;
                            while (SecurityService.hasAdvisors() && !found2) {
                                SecurityAdvisor popped2 = SecurityService.popAdvisor();
                                found2 = popped2 == pushed;
                            }
                        }
                        return bl2;
                    }
                    try {
                        pushed = this.enableSecurityAdvisor();
                        ContentResource resource = ContentHostingService.getResource((String)reference.getId());
                        boolean bl3 = bl = resource != null;
                        if (pushed == null) break block18;
                        found = false;
                    }
                    catch (IdUnusedException exception) {
                        m_log.debug("exists() failed find resource: " + (Object)((Object)exception));
                        if (pushed == null) break block19;
                        boolean found3 = false;
                        while (SecurityService.hasAdvisors() && !found3) {
                            popped = SecurityService.popAdvisor();
                            found3 = popped == pushed;
                        }
                    }
                    while (SecurityService.hasAdvisors() && !found) {
                        SecurityAdvisor popped3 = SecurityService.popAdvisor();
                        found = popped3 == pushed;
                    }
                }
                return bl;
            }
            if (pushed != null) {
                boolean found = false;
                while (SecurityService.hasAdvisors() && !found) {
                    SecurityAdvisor popped4 = SecurityService.popAdvisor();
                    found = popped4 == pushed;
                }
            }
            break block19;
            break block19;
            catch (Exception exception) {
                m_log.warn("exists() failed find resource: ", (Throwable)exception);
                if (pushed == null) break block19;
                boolean found = false;
                while (SecurityService.hasAdvisors() && !found) {
                    popped = SecurityService.popAdvisor();
                    found = popped == pushed;
                }
                {
                    break block19;
                    catch (Throwable throwable) {
                        if (pushed != null) {
                            boolean found4 = false;
                            while (SecurityService.hasAdvisors() && !found4) {
                                SecurityAdvisor popped5 = SecurityService.popAdvisor();
                                found4 = popped5 == pushed;
                            }
                        }
                        throw throwable;
                    }
                }
            }
        }
        return false;
    }

    protected SecurityAdvisor enableSecurityAdvisor() {
        SecurityAdvisor advisor = new SecurityAdvisor(){

            public SecurityAdvisor.SecurityAdvice isAllowed(String userId, String function, String reference) {
                return SecurityAdvisor.SecurityAdvice.ALLOWED;
            }
        };
        SecurityService.pushAdvisor((SecurityAdvisor)advisor);
        return advisor;
    }

    private boolean isNull(String string) {
        return string == null || string.trim().equals("");
    }

    public boolean librarySearchEnabled() {
        return this.isLibrarySearchEnabled() && this.isConfigurationXmlAvailable() && this.isDatabaseHierarchyXmlAvailable();
    }

    public void setExternalSearchEnabled(boolean state) {
        this.m_externalSearchEnabled = state;
    }

    public boolean isExternalSerarchEnabled() {
        boolean enabled = this.m_externalSearchEnabled;
        String state = this.getConfigurationParameter("external-search-enabled");
        if (state != null) {
            enabled = "true".equals(state);
        }
        m_log.debug("External Search enabled: " + enabled);
        return enabled && this.getExternalSearchUrl() != null;
    }

    public void setExternalSearchUrl(String url) {
        this.m_externalSearchUrl = url;
    }

    public String getExternalSearchUrl() {
        String url = this.getConfigurationParameter("external-search-url");
        if (url == null) {
            url = this.m_externalSearchUrl;
        }
        return url;
    }

    public String getSecondsBetweenSaveciteRefreshes() {
        String secondsBetweenRefreshes = this.getConfigurationParameter(PARAM_SECONDS_BETWEEN_SAVECITE_REFRESHES);
        if (secondsBetweenRefreshes == null) {
            secondsBetweenRefreshes = DEFAULT_SECONDS_BETWEEN_SAVECITE_REFRESHES;
        } else {
            try {
                int num = Integer.parseInt(secondsBetweenRefreshes);
                if (num < 1) {
                    secondsBetweenRefreshes = DEFAULT_SECONDS_BETWEEN_SAVECITE_REFRESHES;
                } else if (num > 30) {
                    secondsBetweenRefreshes = Integer.toString(30);
                }
            }
            catch (NumberFormatException e) {
                secondsBetweenRefreshes = DEFAULT_SECONDS_BETWEEN_SAVECITE_REFRESHES;
            }
        }
        return secondsBetweenRefreshes;
    }
}

