/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.citation.impl.openurl;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.sakaiproject.citation.api.Citation;
import org.sakaiproject.citation.impl.openurl.ContextObjectEntity;
import org.sakaiproject.citation.impl.openurl.Converter;

public abstract class AbstractConverter
implements Converter {
    protected static final String DOI_PREFIX = "info:doi/";
    protected static final String ISSN_PREFIX = "ISSN:";
    protected static final String ISBN_URN_PREFIX = "urn:ISBN:";

    protected void convertSimple(Map<String, Object> props, ContextObjectEntity entity) {
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            String entityKey = this.getOpenUrlKey(key);
            if (entityKey != null) {
                this.addValue(entity, value, entityKey);
                continue;
            }
            if ("doi".equals(key)) {
                if (!(value instanceof String)) continue;
                entity.addId("info:doi" + value);
                continue;
            }
            if (!"otherIds".equals(key)) continue;
            if (value instanceof String || value instanceof Date) {
                entity.addId((String)value);
                continue;
            }
            if (!(value instanceof List)) continue;
            for (String id : (List)value) {
                entity.addId(id);
            }
        }
    }

    protected abstract String getOpenUrlKey(String var1);

    protected abstract String getCitationsKey(String var1);

    protected void convertSimple(Map<String, List<String>> values, Citation citation) {
        for (Map.Entry<String, List<String>> entry : values.entrySet()) {
            String key = entry.getKey();
            List<String> entryValues = entry.getValue();
            String citationKey = this.getCitationsKey(key);
            if (citationKey == null) continue;
            if (citation.hasCitationProperty(citationKey)) {
                if (!citation.isMultivalued(citationKey)) continue;
                for (String value : entryValues) {
                    citation.setCitationProperty(citationKey, (Object)value);
                }
                continue;
            }
            for (String value : entryValues) {
                if (value == null) continue;
                citation.setCitationProperty(citationKey, (Object)value);
            }
        }
    }

    void addValue(ContextObjectEntity entity, Object value, String entityKey) {
        if (value instanceof String || value instanceof Date) {
            entity.addValue(entityKey, value.toString());
        } else if (value instanceof List) {
            for (String listValue : (List)value) {
                entity.addValue(entityKey, listValue);
            }
        }
    }

    void addId(ContextObjectEntity entity, Object value, String prefix) {
        if (value instanceof String || value instanceof Date) {
            entity.addId(prefix + value.toString());
        } else if (value instanceof List) {
            for (String listValue : (List)value) {
                entity.addId(prefix + listValue);
            }
        }
    }
}

