/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.citation.impl.openurl;

import java.util.List;
import java.util.Map;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.TreeBidiMap;
import org.sakaiproject.citation.api.Citation;
import org.sakaiproject.citation.api.CitationService;
import org.sakaiproject.citation.impl.openurl.AbstractConverter;
import org.sakaiproject.citation.impl.openurl.ContextObjectEntity;
import org.sakaiproject.citation.impl.openurl.Converter;
import org.sakaiproject.citation.impl.openurl.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookConverter
extends AbstractConverter
implements Converter {
    static final Logger log = LoggerFactory.getLogger(BookConverter.class);
    public static final String ID = "info:ofi/fmt:kev:mtx:book";
    private CitationService citationService;
    static BidiMap conversion = new TreeBidiMap();

    public void setCitationService(CitationService citationService) {
        this.citationService = citationService;
    }

    @Override
    public String getOpenUrlKey(String citationsKey) {
        return (String)conversion.get((Object)citationsKey);
    }

    @Override
    public String getCitationsKey(String openUrlKey) {
        return (String)conversion.getKey((Object)openUrlKey);
    }

    @Override
    public boolean canConvertOpenUrl(String format) {
        return ID.equals(format);
    }

    @Override
    public boolean canConvertCitation(String type) {
        return "book".equals(type);
    }

    @Override
    public ContextObjectEntity convert(Citation citation) {
        Map props = citation.getCitationProperties();
        ContextObjectEntity entity = new ContextObjectEntity();
        entity.addValue("genre", "book");
        this.convertSimple(props, entity);
        if (citation.hasCitationProperty("isbn")) {
            Object value = citation.getCitationProperty("isbn", false);
            this.addId(entity, value, "urn:ISBN:");
        }
        return entity;
    }

    @Override
    public Citation convert(ContextObjectEntity entity) {
        Map<String, List<String>> values = entity.getValues();
        String genre = null;
        List<String> genres = values.get("genre");
        if (genres != null) {
            genre = genres.get(0);
        }
        if (genre == null) {
            genre = "book";
        }
        Citation citation = this.citationService.addCitation(genre);
        for (String id : entity.getIds()) {
            if (id.startsWith("urn:ISBN:")) {
                String isbn = id.substring("urn:ISBN:".length());
                if (isbn.length() <= 0) continue;
                citation.setCitationProperty("isnIdentifier", (Object)isbn);
                continue;
            }
            if (id.startsWith("info:doi/")) {
                String doi = id.substring("info:doi/".length());
                if (doi.length() <= 0) continue;
                citation.setCitationProperty("info:doi/", (Object)doi);
                continue;
            }
            citation.setCitationProperty("otherIds", (Object)id);
        }
        this.convertSimple(values, citation);
        String author = Utils.lookForAuthor(values);
        if (author != null) {
            citation.setCitationProperty("creator", (Object)author);
        }
        return citation;
    }

    static {
        conversion.put((Object)"creator", (Object)"au");
        conversion.put((Object)"title", (Object)"btitle");
        conversion.put((Object)"year", (Object)"date");
        conversion.put((Object)"publisher", (Object)"pub");
        conversion.put((Object)"publicationLocation", (Object)"place");
        conversion.put((Object)"edition", (Object)"edition");
        conversion.put((Object)"sourceTitle", (Object)"series");
        conversion.put((Object)"isnIdentifier", (Object)"isbn");
    }
}

