/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.citation.entity;

import java.util.Map;
import org.sakaiproject.citation.api.Citation;
import org.sakaiproject.citation.api.CitationCollection;
import org.sakaiproject.citation.api.CitationService;
import org.sakaiproject.citation.entity.CitationEntityProvider;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.entitybroker.EntityView;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityCustomAction;
import org.sakaiproject.entitybroker.entityprovider.capabilities.ActionsExecutable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.AutoRegisterEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.capabilities.Outputable;
import org.sakaiproject.entitybroker.exception.EntityException;
import org.sakaiproject.entitybroker.exception.EntityNotFoundException;
import org.sakaiproject.entitybroker.util.AbstractEntityProvider;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.ServerOverloadException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.user.api.UserDirectoryService;

public class CitationEntityProvider
extends AbstractEntityProvider
implements AutoRegisterEntityProvider,
ActionsExecutable,
Outputable {
    private CitationService citationService;
    private ContentHostingService contentHostingService;
    private UserDirectoryService userDirectoryService;

    public void setCitationService(CitationService citationService) {
        this.citationService = citationService;
    }

    public void setContentHostingService(ContentHostingService contentHostingService) {
        this.contentHostingService = contentHostingService;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    public String getEntityPrefix() {
        return "citation";
    }

    @EntityCustomAction(action="list", viewKey="list")
    public DecoratedCitationCollection getCitationList(EntityView view, Map<String, Object> params) {
        StringBuilder resourceId = new StringBuilder();
        String[] segments = view.getPathSegments();
        for (int i = 2; i < segments.length; ++i) {
            resourceId.append("/");
            resourceId.append(segments[i]);
        }
        if (resourceId.length() == 0) {
            throw new EntityNotFoundException("You must supply a path to the citation list.", null);
        }
        try {
            ContentResource resource = this.contentHostingService.getResource(resourceId.toString());
            if (!"org.sakaiproject.citation.impl.CitationList".equals(resource.getResourceType())) {
                throw new EntityException("Not a citation list", resourceId.toString(), 400);
            }
            if (resource.getContentLength() > 1024L) {
                throw new EntityException("Bad citation list", resourceId.toString(), 400);
            }
            String citationCollectionId = new String(resource.getContent());
            CitationCollection collection = this.citationService.getCollection(citationCollectionId);
            ResourceProperties properties = resource.getProperties();
            String title = properties.getProperty("DAV:displayname");
            String description = properties.getProperty("CHEF:description");
            DecoratedCitationCollection dCollection = new DecoratedCitationCollection(this, collection.getId(), title, description);
            for (Citation citation : collection.getCitations()) {
                dCollection.addCitation(new DecoratedCitation(this, citation.getId(), citation.getSchema().getIdentifier(), citation.getCitationProperties()));
            }
            return dCollection;
        }
        catch (PermissionException e) {
            if (this.userDirectoryService.getAnonymousUser().equals(this.userDirectoryService.getCurrentUser())) {
                throw new EntityException("Login required", resourceId.toString(), 401);
            }
            throw new EntityException("Permission denied", resourceId.toString(), 403);
        }
        catch (IdUnusedException e) {
            throw new EntityException("Not found", resourceId.toString(), 404);
        }
        catch (TypeException e) {
            throw new EntityException("Wrong type", resourceId.toString(), 400);
        }
        catch (ServerOverloadException e) {
            throw new EntityException("Server Overloaded", resourceId.toString(), 500);
        }
    }

    public String[] getHandledOutputFormats() {
        return new String[]{"json", "form", "html", "xml", "txt"};
    }
}

