/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.citation.tool;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.antivirus.api.VirusFoundException;
import org.sakaiproject.cheftool.Context;
import org.sakaiproject.cheftool.JetspeedRunData;
import org.sakaiproject.cheftool.RunData;
import org.sakaiproject.cheftool.VelocityPortlet;
import org.sakaiproject.cheftool.VelocityPortletPaneledAction;
import org.sakaiproject.citation.api.ActiveSearch;
import org.sakaiproject.citation.api.Citation;
import org.sakaiproject.citation.api.CitationCollection;
import org.sakaiproject.citation.api.CitationIterator;
import org.sakaiproject.citation.api.CitationService;
import org.sakaiproject.citation.api.ConfigurationService;
import org.sakaiproject.citation.api.Schema;
import org.sakaiproject.citation.api.SearchCategory;
import org.sakaiproject.citation.api.SearchDatabaseHierarchy;
import org.sakaiproject.citation.api.SearchManager;
import org.sakaiproject.citation.tool.CitationHelperAction;
import org.sakaiproject.citation.util.api.SearchCancelException;
import org.sakaiproject.citation.util.api.SearchException;
import org.sakaiproject.citation.util.api.SearchQuery;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.content.api.ContentCollection;
import org.sakaiproject.content.api.ContentEntity;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.content.api.ContentResourceEdit;
import org.sakaiproject.content.api.GroupAwareEntity;
import org.sakaiproject.content.api.ResourceToolAction;
import org.sakaiproject.content.api.ResourceToolActionPipe;
import org.sakaiproject.entity.api.EntityManager;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.entity.api.ResourcePropertiesEdit;
import org.sakaiproject.event.api.SessionState;
import org.sakaiproject.exception.IdInvalidException;
import org.sakaiproject.exception.IdLengthException;
import org.sakaiproject.exception.IdUniquenessException;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.InUseException;
import org.sakaiproject.exception.InconsistentException;
import org.sakaiproject.exception.OverQuotaException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.ServerOverloadException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.time.api.Time;
import org.sakaiproject.time.cover.TimeService;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.tool.api.Tool;
import org.sakaiproject.tool.api.ToolException;
import org.sakaiproject.tool.api.ToolManager;
import org.sakaiproject.tool.api.ToolSession;
import org.sakaiproject.util.FileItem;
import org.sakaiproject.util.ParameterParser;
import org.sakaiproject.util.Resource;
import org.sakaiproject.util.ResourceLoader;
import org.sakaiproject.util.Validator;
import org.sakaiproject.util.api.FormattedText;

/*
 * Exception performing whole class analysis ignored.
 */
public class CitationHelperAction
extends VelocityPortletPaneledAction {
    protected static final Log logger = LogFactory.getLog(CitationHelperAction.class);
    public static ResourceLoader rb = new ResourceLoader("citations");
    private static final String DEFAULT_RESOURCECLASS = "org.sakaiproject.sharedI18n.SharedProperties";
    private static final String DEFAULT_RESOURCEBUNDLE = "org.sakaiproject.sharedI18n.bundle.shared";
    private static final String RESOURCECLASS = "resource.class.shared";
    private static final String RESOURCEBUNDLE = "resource.bundle.shared";
    private ResourceLoader srb;
    protected CitationService citationService;
    protected ConfigurationService configurationService;
    protected SearchManager searchManager;
    protected ContentHostingService contentService;
    protected EntityManager entityManager;
    protected SessionManager sessionManager;
    protected static FormattedText formattedText;
    protected static ToolManager toolManager;
    public static final Integer DEFAULT_RESULTS_PAGE_SIZE;
    public static final Integer DEFAULT_LIST_PAGE_SIZE;
    public static Integer defaultListPageSize;
    protected static final String ELEMENT_ID_CREATE_FORM = "createForm";
    protected static final String ELEMENT_ID_EDIT_FORM = "editForm";
    protected static final String ELEMENT_ID_LIST_FORM = "listForm";
    protected static final String ELEMENT_ID_SEARCH_FORM = "searchForm";
    protected static final String ELEMENT_ID_RESULTS_FORM = "resultsForm";
    protected static final String ELEMENT_ID_VIEW_FORM = "viewForm";
    public static final String CITATIONS_HELPER_CALLER = "citations_helper_caller";
    protected static Set<Mode> ignoreModes;
    protected static final String PARAM_FORM_NAME = "FORM_NAME";
    protected static final String STATE_RESOURCES_ADD = "citation.resources_add";
    protected static final String STATE_CURRENT_DATABASES = "citation.current_databases";
    protected static final String STATE_CANCEL_PAGE = "citation.cancel_page";
    protected static final String STATE_CITATION_COLLECTION_ID = "citation.citation_collection_id";
    protected static final String STATE_CITATION_COLLECTION = "citation.citation_collection";
    protected static final String STATE_CITATION_ID = "citation.citation_id";
    protected static final String STATE_COLLECTION_TITLE = "citation.collection_name";
    protected static final String STATE_CURRENT_REPOSITORY = "citation.current_repository";
    protected static final String STATE_CURRENT_RESULTS = "citation.current_results";
    protected static final String STATE_LIST_ITERATOR = "citation.list_iterator";
    protected static final String STATE_LIST_PAGE = "citation.list_page";
    protected static final String STATE_LIST_PAGE_SIZE = "citation.list_page_size";
    protected static final String STATE_LIST_NO_SCROLL = "citation.list_no_scroll";
    protected static final String STATE_NO_KEYWORDS = "citation.no_search_criteria";
    protected static final String STATE_NO_DATABASES = "citation.no_databases";
    protected static final String STATE_NO_RESULTS = "citation.no_results";
    protected static final String STATE_SEARCH_HIERARCHY = "citation.search_hierarchy";
    protected static final String STATE_SELECTED_CATEGORY = "citation.selected_category";
    protected static final String STATE_DEFAULT_CATEGORY = "citation.default_category";
    protected static final String STATE_UNAUTHORIZED_DB = "citation.unauthorized_database";
    protected static final String STATE_REPOSITORY_MAP = "citation.repository_map";
    protected static final String STATE_RESULTS_PAGE_SIZE = "citation.results_page_size";
    protected static final String STATE_KEYWORDS = "citation.search_criteria";
    protected static final String STATE_SEARCH_INFO = "citation.search_info";
    protected static final String STATE_BASIC_SEARCH = "citation.basic_search";
    protected static final String STATE_SEARCH_RESULTS = "citation.search_results";
    protected static final String STATE_RESOURCE_ENTITY_PROPERTIES = "citation.citationList_properties";
    protected static final String STATE_SORT = "citation.sort";
    protected static final String TEMPLATE_NEW_RESOURCE = "citation/new_resource";
    protected static final String TEMPLATE_CREATE = "citation/create";
    protected static final String TEMPLATE_EDIT = "citation/edit";
    protected static final String TEMPLATE_ERROR = "citation/error";
    protected static final String TEMPLATE_ERROR_FATAL = "citation/error_fatal";
    protected static final String TEMPLATE_LIST = "citation/list";
    protected static final String TEMPLATE_REORDER = "citation/reorder";
    protected static final String TEMPLATE_ADD_CITATIONS = "citation/add_citations";
    protected static final String TEMPLATE_IMPORT_CITATIONS = "citation/import_citations";
    protected static final String TEMPLATE_MESSAGE = "citation/_message";
    protected static final String TEMPLATE_SEARCH = "citation/search";
    protected static final String TEMPLATE_RESULTS = "citation/results";
    protected static final String TEMPLATE_VIEW = "citation/view";
    protected static final String TEMPLATE_DATABASE = "citation/_databases";
    protected static final String PROP_ACCESS_MODE = "accessMode";
    protected static final String PROP_IS_COLLECTION = "isCollection";
    protected static final String PROP_IS_DROPBOX = "isDropbox";
    protected static final String PROP_IS_GROUP_INHERITED = "isGroupInherited";
    protected static final String PROP_IS_GROUP_POSSIBLE = "isGroupPossible";
    protected static final String PROP_IS_HIDDEN = "isHidden";
    protected static final String PROP_IS_PUBVIEW = "isPubview";
    protected static final String PROP_IS_PUBVIEW_INHERITED = "isPubviewInherited";
    protected static final String PROP_IS_PUBVIEW_POSSIBLE = "isPubviewPossible";
    protected static final String PROP_IS_SINGLE_GROUP_INHERITED = "isSingleGroupInherited";
    protected static final String PROP_IS_SITE_COLLECTION = "isSiteCollection";
    protected static final String PROP_IS_SITE_ONLY = "isSiteOnly";
    protected static final String PROP_IS_USER_SITE = "isUserSite";
    protected static final String PROP_POSSIBLE_GROUPS = "possibleGroups";
    protected static final String PROP_RELEASE_DATE = "releaseDate";
    protected static final String PROP_RELEASE_DATE_STR = "releaseDateStr";
    protected static final String PROP_RETRACT_DATE = "retractDate";
    protected static final String PROP_RETRACT_DATE_STR = "retractDateStr";
    protected static final String PROP_USE_RELEASE_DATE = "useReleaseDate";
    protected static final String PROP_USE_RETRACT_DATE = "useRetractDate";
    public static final String CITATION_ACTION = "citation_action";
    public static final String UPDATE_RESOURCE = "update_resource";
    public static final String CREATE_RESOURCE = "create_resource";
    public static final String IMPORT_CITATIONS = "import_citations";
    public static final String UPDATE_SAVED_SORT = "update_saved_sort";
    public static final String CHECK_FOR_UPDATES = "check_for_updates";
    public static final String MIMETYPE_JSON = "application/json";
    public static final String MIMETYPE_HTML = "text/html";
    public static final String REQUESTED_MIMETYPE = "requested_mimetype";
    public static final String CHARSET_UTF8 = "UTF-8";
    public static final long ONE_DAY = 86400000L;
    public static final long ONE_WEEK = 604800000L;

    public void init() throws ServletException {
        ServerConfigurationService scs = (ServerConfigurationService)ComponentManager.get(ServerConfigurationService.class);
        String resourceClass = scs.getString("resource.class.shared", "org.sakaiproject.sharedI18n.SharedProperties");
        String resourceBundle = scs.getString("resource.bundle.shared", "org.sakaiproject.sharedI18n.bundle.shared");
        this.srb = new Resource().getLoader(resourceClass, resourceBundle);
        if (scs != null) {
            defaultListPageSize = scs.getInt("citations.default.list.page.size", DEFAULT_LIST_PAGE_SIZE.intValue());
        } else {
            logger.warn((Object)("Failed to get default list page size as ServerConfigurationService is null. Defaulting to " + DEFAULT_LIST_PAGE_SIZE));
            defaultListPageSize = DEFAULT_LIST_PAGE_SIZE;
        }
    }

    protected void toolModeDispatch(String methodBase, String methodExt, HttpServletRequest req, HttpServletResponse res) throws ToolException {
        logger.debug((Object)"toolModeDispatch()");
        ToolSession toolSession = this.getSessionManager().getCurrentToolSession();
        Object done = toolSession.getAttribute("resourceToolAction.done");
        if (done != null || !this.initHelper(this.getState(req))) {
            toolSession.removeAttribute("resourceToolAction.started");
            Tool tool = CitationHelperAction.getToolManager().getCurrentTool();
            String url = (String)toolSession.getAttribute(tool.getId() + "sakai.tool.helper.done.url");
            toolSession.removeAttribute(tool.getId() + "sakai.tool.helper.done.url");
            try {
                res.sendRedirect(url);
            }
            catch (IOException e) {
                logger.warn((Object)"IOException", (Throwable)e);
            }
            return;
        }
        super.toolModeDispatch(methodBase, methodExt, req, res);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        logger.debug((Object)"doGet()");
        String isAjaxRequest = req.getParameter("ajaxRequest");
        if (isAjaxRequest != null && isAjaxRequest.trim().equalsIgnoreCase(Boolean.toString(true))) {
            ParameterParser params = (ParameterParser)req.getAttribute("sakai.wrapper.params");
            if (params == null) {
                params = new ParameterParser(req);
            }
            SessionState state = this.getState(req);
            String requestedMimetype = params.getString("requested_mimetype");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("doGet() requestedMimetype == " + requestedMimetype));
            }
            if (requestedMimetype != null && requestedMimetype.equals("application/json")) {
                this.doGetJsonResponse(params, state, req, res);
            } else if (requestedMimetype != null && requestedMimetype.equals("text/html")) {
                this.doGetHtmlFragmentResponse(params, state, req, res);
            }
            return;
        }
        super.doGet(req, res);
    }

    protected void doGetHtmlFragmentResponse(ParameterParser params, SessionState state, HttpServletRequest req, HttpServletResponse res) {
    }

    protected void doGetJsonResponse(ParameterParser params, SessionState state, HttpServletRequest req, HttpServletResponse res) {
        res.setCharacterEncoding("UTF-8");
        res.setContentType("application/json");
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        String sakai_csrf_token = params.getString("sakai_csrf_token");
        if (sakai_csrf_token != null && !sakai_csrf_token.trim().equals("")) {
            jsonMap.put("sakai_csrf_token", sakai_csrf_token);
        }
        jsonMap.put("timestamp", Long.toString(System.currentTimeMillis()));
        String citation_action = params.getString("citation_action");
        if (citation_action != null && citation_action.trim().equals("check_for_updates")) {
            Map result = this.checkForUpdates(params, state, req, res);
            jsonMap.putAll(result);
        }
        jsonMap.put("secondsBetweenSaveciteRefreshes", new Integer(this.configurationService.getSecondsBetweenSaveciteRefreshes()));
        String jsonString = JSONObject.fromObject(jsonMap).toString();
        try {
            PrintWriter writer = res.getWriter();
            writer.print(jsonString);
            writer.flush();
        }
        catch (IOException e) {
            logger.warn((Object)("IOException in doGetJsonResponse() " + e));
        }
    }

    protected Map<String, Object> checkForUpdates(ParameterParser params, SessionState state, HttpServletRequest req, HttpServletResponse res) {
        String citationCollectionId;
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean changed = false;
        long lastcheckLong = 0L;
        String lastcheck = params.getString("lastcheck");
        if (lastcheck != null && !lastcheck.trim().equals("")) {
            try {
                lastcheckLong = Long.parseLong(lastcheck);
            }
            catch (Exception e) {
                logger.warn((Object)("Error parsing long from string: " + lastcheck), (Throwable)e);
            }
        }
        if (lastcheckLong > 0L && (citationCollectionId = params.getString("citationCollectionId")) != null && !citationCollectionId.trim().equals("")) {
            try {
                CitationCollection citationCollection = this.citationService.getCollection(citationCollectionId);
                if (citationCollection.getLastModifiedDate().getTime() > lastcheckLong) {
                    changed = true;
                    result.put("html", "<div>something goes here</div>");
                }
            }
            catch (IdUnusedException e) {
                logger.warn((Object)("IdUnusedException in checkForUpdates() " + (Object)((Object)e)));
            }
        }
        result.put("changed", Boolean.toString(changed));
        return result;
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        logger.debug((Object)"doPost()");
        String isAjaxRequest = req.getParameter("ajaxRequest");
        if (isAjaxRequest != null && isAjaxRequest.trim().equalsIgnoreCase(Boolean.toString(true))) {
            ParameterParser params = (ParameterParser)req.getAttribute("sakai.wrapper.params");
            if (params == null) {
                params = new ParameterParser(req);
            }
            SessionState state = this.getState(req);
            String requestedMimetype = params.getString("requested_mimetype");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("doPost() requestedMimetype == " + requestedMimetype));
            }
            if (requestedMimetype != null && requestedMimetype.equals("application/json")) {
                this.doPostJsonResponse(params, state, req, res);
            } else if (requestedMimetype != null && requestedMimetype.equals("text/html")) {
                this.doPostHtmlFragmentResponse(params, state, req, res);
            }
            return;
        }
        super.doPost(req, res);
    }

    protected void doPostHtmlFragmentResponse(ParameterParser params, SessionState state, HttpServletRequest req, HttpServletResponse res) {
        Map result = this.ensureCitationListExists(params, state, req, res);
        res.setCharacterEncoding("UTF-8");
        res.setContentType("text/html");
        String sakai_csrf_token = params.getString("sakai_csrf_token");
        if (sakai_csrf_token != null && !sakai_csrf_token.trim().equals("")) {
            this.setVmReference("sakai_csrf_token", (Object)sakai_csrf_token, req);
        }
        for (Map.Entry entry : result.entrySet()) {
            this.setVmReference((String)entry.getKey(), entry.getValue(), req);
        }
    }

    protected void doPostJsonResponse(ParameterParser params, SessionState state, HttpServletRequest req, HttpServletResponse res) {
        Map result;
        res.setCharacterEncoding("UTF-8");
        res.setContentType("application/json");
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        String sakai_csrf_token = params.getString("sakai_csrf_token");
        if (sakai_csrf_token != null && !sakai_csrf_token.trim().equals("")) {
            jsonMap.put("sakai_csrf_token", sakai_csrf_token);
        }
        jsonMap.put("timestamp", Long.toString(System.currentTimeMillis()));
        String citation_action = params.getString("citation_action");
        if (citation_action != null && citation_action.trim().equals("update_resource")) {
            result = this.updateCitationList(params, state, req, res);
            jsonMap.putAll(result);
        } else if (citation_action != null && citation_action.trim().equals("update_saved_sort")) {
            result = this.updateSavedSort(params, state, req, res);
            jsonMap.putAll(result);
        } else {
            result = this.createCitationList(params, state, req, res);
            jsonMap.putAll(result);
        }
        jsonMap.put("secondsBetweenSaveciteRefreshes", this.configurationService.getSecondsBetweenSaveciteRefreshes());
        String jsonString = JSONObject.fromObject(jsonMap).toString();
        try {
            PrintWriter writer = res.getWriter();
            writer.print(jsonString);
            writer.flush();
        }
        catch (IOException e) {
            logger.warn((Object)"IOException in doPostJsonResponse() ", (Throwable)e);
        }
    }

    protected Map<String, Object> updateSavedSort(ParameterParser params, SessionState state, HttpServletRequest req, HttpServletResponse res) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        Object message = null;
        String citationCollectionId = params.getString("citationCollectionId");
        String new_sort = params.getString("new_sort");
        if (citationCollectionId == null || citationCollectionId.trim().equals("")) {
            results.put("message", rb.getString("sort.save.error"));
        } else {
            if (new_sort == null || new_sort.trim().equals("")) {
                new_sort = "default";
            }
            try {
                CitationCollection citationCollection = this.citationService.getCollection(citationCollectionId);
                citationCollection.setSort(new_sort, true);
                this.citationService.save(citationCollection);
                results.put("message", rb.getString("sort.save.success"));
            }
            catch (IdUnusedException e) {
                results.put("message", rb.getString("sort.save.error"));
            }
        }
        return results;
    }

    protected Map<String, Object> createCitationList(ParameterParser params, SessionState state, HttpServletRequest req, HttpServletResponse res) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.putAll(this.ensureCitationListExists(params, state, req, res));
        return results;
    }

    protected Map<String, Object> updateCitationList(ParameterParser params, SessionState state, HttpServletRequest req, HttpServletResponse res) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        String resourceUuid = params.getString("resourceUuid");
        String message = null;
        if (resourceUuid == null) {
            results.putAll(this.ensureCitationListExists(params, state, req, res));
        } else {
            try {
                int priority = this.capturePriority(params);
                String resourceId = this.getContentService().resolveUuid(resourceUuid);
                ContentResourceEdit edit = this.getContentService().editResource(resourceId);
                this.captureDisplayName(params, state, edit, results);
                this.captureDescription(params, state, edit, results);
                this.captureAccess(params, state, edit, results);
                this.captureAvailability(params, edit, results);
                this.getContentService().commitResource(edit, priority);
                message = "Resource updated";
            }
            catch (IdUnusedException e) {
                message = e.getMessage();
                logger.warn((Object)("IdUnusedException in updateCitationList() " + (Object)((Object)e)));
            }
            catch (TypeException e) {
                message = e.getMessage();
                logger.warn((Object)("TypeException in updateCitationList() " + (Object)((Object)e)));
            }
            catch (InUseException e) {
                message = e.getMessage();
                logger.warn((Object)("InUseException in updateCitationList() " + (Object)((Object)e)));
            }
            catch (PermissionException e) {
                message = e.getMessage();
                logger.warn((Object)("PermissionException in updateCitationList() " + (Object)((Object)e)));
            }
            catch (OverQuotaException e) {
                message = e.getMessage();
                logger.warn((Object)("OverQuotaException in updateCitationList() " + (Object)((Object)e)));
            }
            catch (ServerOverloadException e) {
                message = e.getMessage();
                logger.warn((Object)("ServerOverloadException in updateCitationList() " + (Object)((Object)e)));
            }
            catch (VirusFoundException e) {
                message = e.getMessage();
                logger.warn((Object)("VirusFoundException in updateCitationList() " + (Object)((Object)e)));
            }
            if (message != null && !message.trim().equals("")) {
                results.put("message", message);
            }
        }
        return results;
    }

    private int capturePriority(ParameterParser params) {
        int priority = 0;
        if (params != null) {
            String notify = params.getString("notify");
            if ("r".equals(notify)) {
                priority = 1;
            } else if ("o".equals(notify)) {
                priority = 2;
            }
        }
        return priority;
    }

    protected Map<String, Object> ensureCitationListExists(ParameterParser params, SessionState state, HttpServletRequest req, HttpServletResponse res) {
        CitationCollection cCollection;
        HashMap<String, Object> results = new HashMap<String, Object>();
        String message = null;
        String displayName = params.getString("displayName");
        if (displayName == null) {
            // empty if block
        }
        if ((cCollection = this.getCitationCollection(state, true)) != null) {
            String citationCollectionId = cCollection.getId();
            String contentCollectionId = params.getString("contentCollectionId");
            if (contentCollectionId == null || contentCollectionId.trim().equals("")) {
                ToolSession toolSession = this.getSessionManager().getCurrentToolSession();
                ResourceToolActionPipe pipe = (ResourceToolActionPipe)toolSession.getAttribute("resourceToolAction.action_pipe");
                contentCollectionId = pipe.getContentEntity().getId();
            }
            ContentResource resource = null;
            String resourceUuid = params.getString("resourceUuid");
            String resourceId = null;
            if (resourceUuid == null || resourceUuid.trim().equals("")) {
                if (contentCollectionId == null) {
                    message = rb.getString("resource.null_collectionId.error");
                } else {
                    int priority = this.capturePriority(params);
                    try {
                        ContentResourceEdit edit = this.getContentService().addResource(contentCollectionId, displayName, null, 100);
                        edit.setResourceType("org.sakaiproject.citation.impl.CitationList");
                        byte[] bytes = citationCollectionId.getBytes();
                        edit.setContent(bytes);
                        this.captureDescription(params, state, edit, results);
                        this.captureAccess(params, state, edit, results);
                        this.captureAvailability(params, edit, results);
                        ResourcePropertiesEdit properties = edit.getPropertiesEdit();
                        properties.addProperty("DAV:displayname", displayName);
                        properties.addProperty("sakai:reference-root", "/citation");
                        properties.addProperty("DAV:getcontenttype", "text/html");
                        this.getContentService().commitResource(edit, priority);
                        resourceId = edit.getId();
                        message = rb.getFormattedMessage("resource.new.success", (Object[])new String[]{displayName});
                    }
                    catch (IdUniquenessException e) {
                        message = e.getMessage();
                        logger.warn((Object)("IdUniquenessException in ensureCitationListExists() " + (Object)((Object)e)));
                    }
                    catch (IdLengthException e) {
                        message = e.getMessage();
                        logger.warn((Object)("IdLengthException in ensureCitationListExists() " + (Object)((Object)e)));
                    }
                    catch (IdInvalidException e) {
                        message = e.getMessage();
                        logger.warn((Object)("IdInvalidException in ensureCitationListExists() " + (Object)((Object)e)));
                    }
                    catch (OverQuotaException e) {
                        message = e.getMessage();
                        logger.warn((Object)("OverQuotaException in ensureCitationListExists() " + (Object)((Object)e)));
                    }
                    catch (ServerOverloadException e) {
                        message = e.getMessage();
                        logger.warn((Object)("ServerOverloadException in ensureCitationListExists() " + (Object)((Object)e)));
                    }
                    catch (PermissionException e) {
                        message = e.getMessage();
                        logger.warn((Object)("PermissionException in ensureCitationListExists() " + (Object)((Object)e)));
                    }
                    catch (IdUnusedException e) {
                        message = e.getMessage();
                        logger.warn((Object)("IdUnusedException in ensureCitationListExists() " + (Object)((Object)e)));
                    }
                }
            } else {
                resourceId = this.getContentService().resolveUuid(resourceUuid);
                if (citationCollectionId == null) {
                    try {
                        resource = this.contentService.getResource(resourceId);
                        citationCollectionId = new String(resource.getContent());
                    }
                    catch (IdUnusedException e) {
                        message = e.getMessage();
                        logger.warn((Object)("IdUnusedException in getting resource in ensureCitationListExists() " + (Object)((Object)e)));
                    }
                    catch (TypeException e) {
                        message = e.getMessage();
                        logger.warn((Object)("TypeException in getting resource in ensureCitationListExists() " + (Object)((Object)e)));
                    }
                    catch (PermissionException e) {
                        message = e.getMessage();
                        logger.warn((Object)("PermissionException in getting resource in ensureCitationListExists() " + (Object)((Object)e)));
                    }
                    catch (ServerOverloadException e) {
                        message = e.getMessage();
                        logger.warn((Object)("ServerOverloadException in getting citationCollectionId in ensureCitationListExists() " + (Object)((Object)e)));
                    }
                }
            }
            results.put("citationCollectionId", citationCollectionId);
            resourceUuid = this.getContentService().getUuid(resourceId);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ensureCitationListExists() created new resource with resourceUuid == " + resourceUuid + " and resourceId == " + resourceId));
            }
            results.put("resourceUuid", resourceUuid);
            String clientId = params.getString("saveciteClientId");
            if (clientId != null && !clientId.trim().equals("")) {
                Locale locale = rb.getLocale();
                List saveciteClients = this.getConfigurationService().getSaveciteClientsForLocale(locale);
                if (saveciteClients != null) {
                    for (Map client : saveciteClients) {
                        if (client == null || client.get("id") == null || !((String)client.get("id")).equalsIgnoreCase(clientId)) continue;
                        String saveciteUrl = this.getSearchManager().getSaveciteUrl(resourceUuid, clientId);
                        try {
                            saveciteUrl = URLEncoder.encode(saveciteUrl, "UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            logger.warn((Object)"Error encoding savecite URL", (Throwable)e);
                        }
                        StringBuilder buf = new StringBuilder();
                        buf.append((String)client.get("searchurl_base"));
                        buf.append("?linkurl_base=");
                        buf.append(saveciteUrl);
                        if (client.get("linkurl_id") != null && !((String)client.get("linkurl_id")).trim().equals("")) {
                            buf.append("&linkurl_id=");
                            buf.append((String)client.get("linkurl_id"));
                        }
                        buf.append('&');
                        results.put("saveciteUrl", buf.toString());
                        break;
                    }
                }
            }
            results.put("contentCollectionId", contentCollectionId);
        }
        results.put("message", message);
        return results;
    }

    private void captureDescription(ParameterParser params, SessionState state, ContentResourceEdit edit, Map<String, Object> results) {
        String description = params.get("description");
        String oldDescription = edit.getProperties().getProperty("CHEF:description");
        if (description == null || description.trim().equals("")) {
            if (oldDescription != null) {
                edit.getPropertiesEdit().removeProperty("CHEF:description");
                results.put("description", "");
            }
        } else if (oldDescription == null || !oldDescription.equals(description)) {
            edit.getPropertiesEdit().removeProperty("CHEF:description");
            edit.getPropertiesEdit().addProperty("CHEF:description", description);
            results.put("description", description);
        }
    }

    protected void captureDisplayName(ParameterParser params, SessionState state, ContentResourceEdit edit, Map<String, Object> results) {
        String displayName = params.getString("displayName");
        if (displayName == null || displayName.trim().equals("")) {
            throw new RuntimeException("invalid name for resource: " + displayName);
        }
        String oldDisplayName = edit.getProperties().getProperty("DAV:displayname");
        if (oldDisplayName == null || !oldDisplayName.equals(displayName)) {
            ResourcePropertiesEdit props = edit.getPropertiesEdit();
            props.removeProperty("DAV:displayname");
            props.addProperty("DAV:displayname", displayName);
            results.put("displayName", displayName);
        }
    }

    protected void captureAvailability(ParameterParser params, ContentResourceEdit edit, Map<String, Object> results) {
        String retractDateStr;
        String releaseDateStr;
        boolean hidden = params.getBoolean("hidden");
        boolean useReleaseDate = params.getBoolean("use_start_date");
        DateFormat df = DateFormat.getDateTimeInstance();
        Time releaseDate = null;
        if (useReleaseDate && (releaseDateStr = params.getString("releaseDate")) != null) {
            try {
                releaseDate = TimeService.newTime((long)df.parse(releaseDateStr).getTime());
            }
            catch (ParseException e) {
                logger.warn((Object)("ParseException in captureAvailability() " + e));
            }
        }
        Time retractDate = null;
        boolean useRetractDate = params.getBoolean("use_end_date");
        if (useRetractDate && (retractDateStr = params.getString("retractDate")) != null) {
            try {
                retractDate = TimeService.newTime((long)df.parse(retractDateStr).getTime());
            }
            catch (ParseException e) {
                logger.warn((Object)("ParseException in captureAvailability() " + e));
            }
        }
        boolean oldHidden = edit.isHidden();
        Time oldReleaseDate = edit.getReleaseDate();
        Time oldRetractDate = edit.getRetractDate();
        boolean changesFound = false;
        if (oldHidden != hidden) {
            results.put("isHidden", Boolean.toString(hidden));
            changesFound = true;
        }
        if (!(oldReleaseDate == null && releaseDate == null || oldReleaseDate != null && oldReleaseDate.equals(releaseDate))) {
            if (releaseDate == null) {
                results.put("releaseDateStr", df.format(new Date()));
            } else {
                results.put("releaseDateStr", df.format(new Date(releaseDate.getTime())));
            }
            results.put("releaseDate", releaseDate);
            results.put("useReleaseDate", useReleaseDate);
            changesFound = true;
        }
        if (!(oldRetractDate == null && retractDate == null || oldRetractDate != null && oldRetractDate.equals(retractDate))) {
            if (retractDate == null) {
                results.put("retractDateStr", df.format(new Date(System.currentTimeMillis() + 604800000L)));
            } else {
                results.put("retractDateStr", df.format(new Date(retractDate.getTime())));
            }
            results.put("retractDate", retractDate);
            changesFound = true;
        }
        if (changesFound) {
            edit.setAvailability(hidden, releaseDate, retractDate);
        }
    }

    protected void captureAccess(ParameterParser params, SessionState state, ContentResourceEdit edit, Map<String, Object> results) {
        String oldAccessMode;
        Map entityProperties = (Map)state.getAttribute("citation.citationList_properties");
        boolean changesFound = false;
        String access_mode = params.getString("access_mode");
        if (access_mode == null) {
            access_mode = GroupAwareEntity.AccessMode.INHERITED.toString();
        }
        if ((oldAccessMode = entityProperties.get("accessMode").toString()) == null) {
            oldAccessMode = GroupAwareEntity.AccessMode.INHERITED.toString();
        }
        if (!access_mode.equals(oldAccessMode)) {
            results.put("accessMode", GroupAwareEntity.AccessMode.fromString((String)access_mode));
            changesFound = true;
        }
        if (GroupAwareEntity.AccessMode.GROUPED.toString().equals(access_mode)) {
            ArrayList possibleGroups;
            String[] access_groups = params.getStrings("access_groups");
            TreeSet<String> new_groups = new TreeSet<String>();
            if (access_groups != null) {
                new_groups.addAll(Arrays.asList(access_groups));
            }
            if ((possibleGroups = (ArrayList)entityProperties.get("possibleGroups")) == null) {
                possibleGroups = new ArrayList();
            }
            Map possibleGroupMap = this.mapGroupRefs((List)possibleGroups);
            SortedSet new_group_refs = this.convertToRefs(new_groups, possibleGroupMap);
            boolean groups_are_inherited = new_groups.size() == possibleGroupMap.size() && possibleGroupMap.keySet().containsAll(new_groups);
            try {
                if (groups_are_inherited) {
                    edit.clearGroupAccess();
                    edit.setGroupAccess((Collection)new_group_refs);
                } else {
                    edit.setGroupAccess((Collection)new_group_refs);
                }
                edit.clearPublicAccess();
            }
            catch (InconsistentException e) {
                logger.warn((Object)("InconsistentException in captureAccess() " + (Object)((Object)e)));
            }
            catch (PermissionException e) {
                logger.warn((Object)("PermissionException in captureAccess() " + (Object)((Object)e)));
            }
        } else if ("public".equals(access_mode)) {
            Boolean isPubviewInherited = (Boolean)entityProperties.get("isPubviewInherited");
            if (isPubviewInherited == null || !isPubviewInherited.booleanValue()) {
                try {
                    edit.setPublicAccess();
                }
                catch (InconsistentException e) {
                    logger.warn((Object)("InconsistentException in captureAccess() " + (Object)((Object)e)));
                }
                catch (PermissionException e) {
                    logger.warn((Object)("PermissionException in captureAccess() " + (Object)((Object)e)));
                }
            }
        } else if (GroupAwareEntity.AccessMode.INHERITED.toString().equals(access_mode)) {
            try {
                if (edit.getAccess() == GroupAwareEntity.AccessMode.GROUPED) {
                    edit.clearGroupAccess();
                }
                edit.clearPublicAccess();
            }
            catch (InconsistentException e) {
                logger.warn((Object)("InconsistentException in captureAccess() " + (Object)((Object)e)));
            }
            catch (PermissionException e) {
                logger.warn((Object)("PermissionException in captureAccess() " + (Object)((Object)e)));
            }
        }
        results.put("isPubview", this.getContentService().isPubView(edit.getId()));
        results.put("isPubviewInherited", new Boolean(this.getContentService().isInheritingPubView(edit.getId())));
        Boolean preventPublicDisplay = (Boolean)state.getAttribute("resources.request.prevent_public_display");
        if (preventPublicDisplay == null) {
            preventPublicDisplay = Boolean.FALSE;
        }
        results.put("isPubviewPossible", new Boolean(preventPublicDisplay == false));
        results.put("accessMode", edit.getAccess());
        results.put("isGroupInherited", GroupAwareEntity.AccessMode.GROUPED == edit.getInheritedAccess());
        Collection inheritedGroupObjs = edit.getInheritedGroupObjects();
        HashMap groups = new HashMap();
        if (inheritedGroupObjs != null) {
            for (Group group : inheritedGroupObjs) {
                HashMap<String, String> grp = new HashMap<String, String>();
                grp.put("groupId", group.getId());
                grp.put("title", group.getTitle());
                grp.put("description", group.getDescription());
                grp.put("entityRef", group.getReference());
                groups.put(grp.get("groupId"), grp);
            }
        }
        results.put("possibleGroups", groups);
        results.put("isGroupPossible", new Boolean(groups != null && groups.size() > 0));
        results.put("isSingleGroupInherited", new Boolean(groups != null && groups.size() == 1));
        results.put("isSiteOnly", new Boolean(preventPublicDisplay != false && (groups == null || groups.size() < 1)));
        SiteService siteService = (SiteService)ComponentManager.get(SiteService.class);
        Reference ref = this.getEntityManager().newReference(edit.getReference());
        results.put("isUserSite", siteService.isUserSite(ref.getContext()));
    }

    private Map<String, String> mapGroupRefs(List<Map<String, String>> possibleGroups) {
        HashMap<String, String> groupRefMap = new HashMap<String, String>();
        for (Map<String, String> groupInfo : possibleGroups) {
            if (groupInfo.get("groupId") == null || groupInfo.get("entityRef") == null) continue;
            groupRefMap.put(groupInfo.get("groupId"), groupInfo.get("entityRef"));
        }
        return groupRefMap;
    }

    public SortedSet<String> convertToRefs(Collection<String> groupIds, Map<String, String> possibleGroupMap) {
        TreeSet<String> groupRefs = new TreeSet<String>();
        for (String groupId : groupIds) {
            String groupRef = possibleGroupMap.get(groupId);
            if (groupRef == null) continue;
            groupRefs.add(groupRef);
        }
        return groupRefs;
    }

    protected void preserveEntityIds(ParameterParser params, SessionState state) {
        String resourceId = params.getString("resourceId");
        String resourceUuid = params.getString("resourceUuid");
        String citationCollectionId = params.getString("citationCollectionId");
        if (resourceId != null && !resourceId.trim().equals("")) {
            state.setAttribute("citation.resource_id", (Object)resourceId);
        }
        if (resourceUuid != null && !resourceUuid.trim().equals("")) {
            state.setAttribute("citation.resource_uuid", (Object)resourceUuid);
        }
        if (citationCollectionId != null && !citationCollectionId.trim().equals("")) {
            state.setAttribute("citation.current_collection_id", (Object)citationCollectionId);
        }
    }

    protected void putCitationCollectionDetails(Context context, SessionState state) {
        String resourceId = (String)state.getAttribute("citation.resource_id");
        String refStr = this.getContentService().getReference(resourceId);
        Reference ref = this.getEntityManager().newReference(refStr);
        String collectionTitle = null;
        if (ref != null) {
            collectionTitle = ref.getProperties().getProperty("DAV:displayname");
        }
        if (collectionTitle == null) {
            collectionTitle = (String)state.getAttribute("citation.collection_name");
        }
        if (collectionTitle != null && !collectionTitle.trim().equals("")) {
            context.put("collectionTitle", (Object)CitationHelperAction.getFormattedText().escapeHtml(collectionTitle));
        }
        String citationCollectionId = (String)state.getAttribute("citation.citation_collection_id");
        context.put("citationCollectionId", (Object)citationCollectionId);
        CitationCollection collection = this.getCitationCollection(state, false);
        int collectionSize = 0;
        if (collection == null) {
            logger.warn((Object)("buildAddCitationsPanelContext unable to access citationCollection " + citationCollectionId));
            return;
        }
        collectionSize = collection.size();
        context.put("collectionSize", (Object)new Integer(collectionSize));
    }

    public String buildImportCitationsPanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        context.put("state", (Object)state);
        context.put("tlang", (Object)rb);
        context.put("stlang", (Object)this.srb);
        context.put("xilator", (Object)new Validator());
        context.put("FORM_NAME", (Object)"importForm");
        int requestStateId = CitationHelperAction.preserveRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."});
        context.put("requestStateId", (Object)requestStateId);
        return "citation/import_citations";
    }

    public String buildAddCitationsPanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        context.put("state", (Object)state);
        context.put("tlang", (Object)rb);
        context.put("stlang", (Object)this.srb);
        context.put("sakai_onload", (Object)"setMainFrameHeight( window.name )");
        String resourceId = (String)state.getAttribute("citation.resource_id");
        String refStr = this.getContentService().getReference(resourceId);
        Reference ref = this.getEntityManager().newReference(refStr);
        String collectionTitle = null;
        if (ref != null) {
            collectionTitle = ref.getProperties().getProperty("DAV:displayname");
        }
        if (collectionTitle == null) {
            collectionTitle = (String)state.getAttribute("citation.collection_name");
        }
        if (collectionTitle != null && !collectionTitle.trim().equals("")) {
            context.put("collectionTitle", (Object)CitationHelperAction.getFormattedText().escapeHtml(collectionTitle));
        }
        String citationCollectionId = (String)state.getAttribute("citation.citation_collection_id");
        context.put("citationCollectionId", (Object)citationCollectionId);
        CitationCollection citationCollection = this.getCitationCollection(state, false);
        int collectionSize = 0;
        if (citationCollection == null) {
            logger.warn((Object)("buildAddCitationsPanelContext unable to access citationCollection " + citationCollectionId));
            int requestStateId = CitationHelperAction.preserveRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."});
            context.put("requestStateId", (Object)requestStateId);
            return "citation/error";
        }
        collectionSize = citationCollection.size();
        context.put("collectionSize", (Object)new Integer(collectionSize));
        Locale locale = rb.getLocale();
        List saveciteClients = this.getConfigurationService().getSaveciteClientsForLocale(locale);
        if (saveciteClients != null) {
            for (Map client : saveciteClients) {
                String saveciteUrl = this.getSearchManager().getSaveciteUrl(this.getContentService().getUuid(resourceId), (String)client.get("id"));
                try {
                    client.put("saveciteUrl", URLEncoder.encode(saveciteUrl, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    logger.warn((Object)"Error encoding savecite URL", (Throwable)e);
                }
            }
            context.put("saveciteClients", (Object)saveciteClients);
        }
        if (this.getConfigurationService().isGoogleScholarEnabled()) {
            String googleUrl = this.getSearchManager().getGoogleScholarUrl(this.getContentService().getUuid(resourceId));
            context.put("googleUrl", (Object)googleUrl);
            Object[] googleArgs = new Object[]{rb.getString("linkLabel.google")};
            context.put("googleArgs", (Object)googleArgs);
        }
        if (this.getConfigurationService().librarySearchEnabled()) {
            context.put("searchLibrary", (Object)Boolean.TRUE);
        }
        context.put("FORM_NAME", (Object)"createForm");
        int requestStateId = CitationHelperAction.preserveRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."});
        context.put("requestStateId", (Object)requestStateId);
        return "citation/add_citations";
    }

    public String buildCreatePanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        context.put("state", (Object)state);
        context.put("tlang", (Object)rb);
        context.put("stlang", (Object)this.srb);
        context.put("xilator", (Object)new Validator());
        context.put("FORM_NAME", (Object)"createForm");
        List schemas = this.getCitationService().getSchemas();
        context.put("TEMPLATES", (Object)schemas);
        Schema defaultSchema = this.getCitationService().getDefaultSchema();
        context.put("DEFAULT_TEMPLATE", (Object)defaultSchema);
        Object[] instrArgs = new Object[]{rb.getString("submit.create")};
        context.put("instrArgs", (Object)instrArgs);
        int requestStateId = CitationHelperAction.preserveRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."});
        context.put("requestStateId", (Object)requestStateId);
        return "citation/create";
    }

    public String buildDatabasePanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        context.put("tlang", (Object)rb);
        context.put("stlang", (Object)this.srb);
        SearchDatabaseHierarchy hierarchy = (SearchDatabaseHierarchy)state.getAttribute("citation.search_hierarchy");
        SearchCategory category = (SearchCategory)state.getAttribute("citation.selected_category");
        if (category == null) {
            logger.warn((Object)"buildDatabasePanelContext getting null selected category from state.");
        }
        context.put("category", (Object)category);
        Integer maxDbNum = new Integer(hierarchy.getNumMaxSearchableDb());
        context.put("maxDbNum", (Object)maxDbNum);
        Object[] maxDbArgs = new Object[]{maxDbNum};
        context.put("maxDbArgs", (Object)maxDbArgs);
        context.put("xilator", (Object)new Validator());
        this.setMode(state, Mode.SEARCH);
        int requestStateId = CitationHelperAction.preserveRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."});
        context.put("requestStateId", (Object)requestStateId);
        return "citation/_databases";
    }

    public String buildEditPanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        context.put("tlang", (Object)rb);
        context.put("stlang", (Object)this.srb);
        context.put("xilator", (Object)new Validator());
        context.put("sakai_onload", (Object)"setMainFrameHeight( window.name ); heavyResize();");
        context.put("FORM_NAME", (Object)"createForm");
        Citation citation = (Citation)state.getAttribute("citation.edit_item_item");
        if (citation == null) {
            this.doEdit(rundata);
            citation = (Citation)state.getAttribute("citation.edit_item_item");
        }
        context.put("citation", (Object)citation);
        String citationId = (String)state.getAttribute("citation.edit_item_id");
        String citationCollectionId = (String)state.getAttribute("citation.citation_collection_id");
        context.put("citationId", (Object)citationId);
        context.put("citationCollectionId", (Object)citationCollectionId);
        List schemas = this.getCitationService().getSchemas();
        context.put("TEMPLATES", (Object)schemas);
        context.put("DEFAULT_TEMPLATE", (Object)citation.getSchema());
        Object[] instrArgs = new Object[]{rb.getString("submit.edit")};
        context.put("instrArgs", (Object)instrArgs);
        int requestStateId = CitationHelperAction.preserveRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."});
        context.put("requestStateId", (Object)requestStateId);
        return "citation/edit";
    }

    private String buildErrorPanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        int requestStateId = CitationHelperAction.preserveRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."});
        context.put("requestStateId", (Object)requestStateId);
        return "citation/error";
    }

    private String buildErrorFatalPanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        return "citation/error_fatal";
    }

    public String buildListPanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        context.put("tlang", (Object)rb);
        context.put("stlang", (Object)this.srb);
        context.put("xilator", (Object)new Validator());
        if (state.removeAttribute("citation.list_no_scroll") == null) {
            context.put("sakai_onload", (Object)"setMainFrameHeight( window.name )");
        } else {
            context.put("sakai_onload", (Object)"resizeFrame()");
        }
        String resourceId = (String)state.getAttribute("citation.resource_id");
        try {
            ContentResource resource = this.getContentService().getResource(resourceId);
            String description = resource.getProperties().getProperty("CHEF:description");
            context.put("description", (Object)description);
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        String refStr = this.getContentService().getReference(resourceId);
        Reference ref = this.getEntityManager().newReference(refStr);
        String collectionTitle = null;
        if (ref != null && ref.getProperties() != null) {
            collectionTitle = ref.getProperties().getProperty("DAV:displayname");
        }
        if (collectionTitle == null) {
            collectionTitle = (String)state.getAttribute("citation.collection_name");
        }
        if (collectionTitle != null && !collectionTitle.trim().equals("")) {
            context.put("collectionTitle", (Object)CitationHelperAction.getFormattedText().escapeHtml(collectionTitle));
        }
        context.put("openUrlLabel", (Object)this.getConfigurationService().getSiteConfigOpenUrlLabel());
        context.put("FORM_NAME", (Object)"listForm");
        CitationCollection collection = this.getCitationCollection(state, true);
        context.put("collectionSize", (Object)new Integer(collection.size()));
        String exportUrlSel = collection.getUrl("export_ris_sel");
        String exportUrlAll = collection.getUrl("export_ris_all");
        context.put("exportUrlSel", (Object)exportUrlSel);
        context.put("exportUrlAll", (Object)exportUrlAll);
        Integer listPageSize = (Integer)state.getAttribute("citation.list_page_size");
        if (listPageSize == null) {
            listPageSize = defaultListPageSize;
            state.setAttribute("citation.list_page_size", (Object)listPageSize);
        }
        context.put("listPageSize", (Object)listPageSize);
        CitationIterator newIterator = collection.iterator();
        CitationIterator oldIterator = (CitationIterator)state.getAttribute("citation.list_iterator");
        if (oldIterator != null) {
            newIterator.setPageSize(listPageSize.intValue());
            newIterator.setStart(oldIterator.getStart());
        }
        context.put("citations", (Object)newIterator);
        context.put("citationCollectionId", (Object)collection.getId());
        context.put("resourceId", (Object)resourceId);
        if (!collection.isEmpty()) {
            context.put("show_citations", (Object)Boolean.TRUE);
            int totalSize = collection.size();
            int start = newIterator.getStart();
            int end = newIterator.getEnd();
            Object[] position = new Integer[]{new Integer(start + 1), new Integer(end), new Integer(totalSize)};
            String showing = rb.getFormattedMessage("showing.results", position);
            context.put("showing", (Object)showing);
        }
        state.setAttribute("citation.list_iterator", (Object)newIterator);
        context.put("searchResults", state.getAttribute("citation.search_results"));
        context.put("titleProperty", (Object)"title");
        Object[] instrMainArgs = new Object[]{this.getConfigurationService().getSiteConfigOpenUrlLabel()};
        context.put("instrMainArgs", (Object)instrMainArgs);
        Object[] instrSubArgs = new Object[]{rb.getString("label.finish")};
        context.put("instrSubArgs", (Object)instrSubArgs);
        Object[] emptyListArgs = new Object[]{rb.getString("label.menu")};
        context.put("emptyListArgs", (Object)emptyListArgs);
        String sort = (String)state.getAttribute("citation.sort");
        if (sort == null || sort.trim().length() == 0) {
            sort = collection.getSort();
        }
        context.put("sort", (Object)sort);
        int requestStateId = CitationHelperAction.preserveRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."});
        context.put("requestStateId", (Object)requestStateId);
        return "citation/list";
    }

    public String buildReorderPanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        context.put("tlang", (Object)rb);
        context.put("stlang", (Object)this.srb);
        context.put("xilator", (Object)new Validator());
        if (state.removeAttribute("citation.list_no_scroll") == null) {
            context.put("sakai_onload", (Object)"setMainFrameHeight( window.name )");
        } else {
            context.put("sakai_onload", (Object)"resizeFrame()");
        }
        String resourceId = (String)state.getAttribute("citation.resource_id");
        String refStr = this.getContentService().getReference(resourceId);
        Reference ref = this.getEntityManager().newReference(refStr);
        String collectionTitle = null;
        if (ref != null) {
            collectionTitle = ref.getProperties().getProperty("DAV:displayname");
        }
        if (collectionTitle == null) {
            collectionTitle = (String)state.getAttribute("citation.collection_name");
        } else if (!collectionTitle.trim().equals("")) {
            context.put("collectionTitle", (Object)Validator.escapeHtml((String)collectionTitle));
        }
        CitationCollection collection = this.getCitationCollection(state, true);
        collection.setSort("position", true);
        CitationIterator newIterator = collection.iterator();
        newIterator.setPageSize(collection.size());
        context.put("citations", (Object)newIterator);
        context.put("citationCollectionId", (Object)collection.getId());
        state.setAttribute("citation.list_iterator", (Object)newIterator);
        return "citation/reorder";
    }

    protected CitationCollection getCitationCollection(SessionState state, boolean create) {
        CitationCollection citationCollection = (CitationCollection)state.getAttribute("citation.citation_collection");
        if (citationCollection == null) {
            String citationCollectionId = (String)state.getAttribute("citation.citation_collection_id");
            if (citationCollectionId == null && create) {
                citationCollection = this.getCitationService().addCollection();
                this.getCitationService().save(citationCollection);
            } else {
                try {
                    citationCollection = this.getCitationService().getCollection(citationCollectionId);
                }
                catch (IdUnusedException e) {
                    logger.warn((Object)("IdUnusedException: CitationHelperAction.getCitationCollection() unable to access citationCollection " + citationCollectionId));
                }
                if (citationCollection == null && create) {
                    citationCollection = this.getCitationService().addCollection();
                    this.getCitationService().save(citationCollection);
                }
            }
            if (citationCollection != null) {
                state.setAttribute("citation.citation_collection", (Object)citationCollection);
                state.setAttribute("citation.citation_collection_id", (Object)citationCollection.getId());
            }
        }
        return citationCollection;
    }

    public String buildMainPanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        logger.debug((Object)"buildMainPanelContext()");
        context.put("tlang", (Object)rb);
        context.put("stlang", (Object)this.srb);
        if (state.getAttribute("citation.resources_add") != null) {
            context.put("resourcesAddAction", (Object)Boolean.TRUE);
        }
        VelocityPortletPaneledAction.disableObservers((SessionState)state);
        String template = "";
        Mode mode = (Mode)state.getAttribute("citation.helper.mode");
        if (mode == null) {
            logger.warn((Object)"buildMainPanelContext() getting null Mode from state");
            mode = Mode.NEW_RESOURCE;
            this.setMode(state, mode);
        }
        context.put("citationsHelperMode", (Object)mode);
        switch (1.$SwitchMap$org$sakaiproject$citation$tool$CitationHelperAction$Mode[mode.ordinal()]) {
            case 1: {
                template = this.buildNewResourcePanelContext(portlet, context, rundata, state);
                break;
            }
            case 2: {
                template = this.buildImportCitationsPanelContext(portlet, context, rundata, state);
                break;
            }
            case 3: {
                template = this.buildAddCitationsPanelContext(portlet, context, rundata, state);
                break;
            }
            case 4: {
                template = this.buildCreatePanelContext(portlet, context, rundata, state);
                break;
            }
            case 5: {
                template = this.buildDatabasePanelContext(portlet, context, rundata, state);
                break;
            }
            case 6: {
                template = this.buildEditPanelContext(portlet, context, rundata, state);
                break;
            }
            case 7: {
                template = this.buildErrorPanelContext(portlet, context, rundata, state);
                break;
            }
            case 8: {
                template = this.buildErrorFatalPanelContext(portlet, context, rundata, state);
                break;
            }
            case 9: {
                template = this.buildListPanelContext(portlet, context, rundata, state);
                break;
            }
            case 10: {
                template = this.buildReorderPanelContext(portlet, context, rundata, state);
                break;
            }
            case 11: {
                template = this.buildMessagePanelContext(portlet, context, rundata, state);
                break;
            }
            case 12: {
                template = this.buildSearchPanelContext(portlet, context, rundata, state);
                break;
            }
            case 13: {
                template = this.buildResultsPanelContext(portlet, context, rundata, state);
                break;
            }
            case 14: {
                template = this.buildViewPanelContext(portlet, context, rundata, state);
            }
        }
        return template;
    }

    public String buildNewResourcePanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        logger.debug((Object)"buildNewResourcePanelContext()");
        context.put("MIMETYPE_JSON", (Object)"application/json");
        context.put("REQUESTED_MIMETYPE", (Object)"requested_mimetype");
        context.put("xilator", (Object)new Validator());
        context.put("availability_is_enabled", (Object)Boolean.TRUE);
        context.put("GROUP_ACCESS", (Object)GroupAwareEntity.AccessMode.GROUPED);
        context.put("INHERITED_ACCESS", (Object)GroupAwareEntity.AccessMode.INHERITED);
        Boolean resourceAdd = (Boolean)state.getAttribute("citation.resources_add");
        if (resourceAdd != null && resourceAdd.equals(true)) {
            context.put("resourceAdd", (Object)Boolean.TRUE);
            context.put("citation_action", (Object)"create_resource");
        } else {
            context.put("citation_action", (Object)"update_resource");
        }
        String resourceId = (String)state.getAttribute("citation.resource_id");
        String resourceUuid = (String)state.getAttribute("citation.resource_uuid");
        if (resourceId == null || resourceId.trim().equals("")) {
            if (resourceUuid != null && !resourceUuid.trim().equals("")) {
                if (resourceUuid.startsWith("/")) {
                    resourceId = resourceUuid;
                    resourceUuid = this.getContentService().getUuid(resourceId);
                    if (resourceUuid != null) {
                        state.setAttribute("citation.resource_id", (Object)resourceId);
                        state.setAttribute("citation.resource_uuid", (Object)resourceUuid);
                    }
                } else {
                    resourceId = this.getContentService().resolveUuid(resourceUuid);
                    if (resourceId != null) {
                        state.setAttribute("citation.resource_id", (Object)resourceId);
                    }
                }
            }
        } else if ((resourceUuid == null || resourceUuid.trim().equals("")) && (resourceUuid = this.getContentService().getUuid(resourceId)) != null) {
            state.setAttribute("citation.resource_uuid", (Object)resourceUuid);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("buildNewResourcePanelContext()  resourceUuid == " + resourceUuid + "  resourceId == " + resourceId));
        }
        String citationCollectionId = null;
        ContentResource resource = null;
        HashMap contentProperties = null;
        if (resourceId != null) {
            try {
                resource = this.getContentService().getResource(resourceId);
            }
            catch (IdUnusedException e) {
                logger.warn((Object)("IdUnusedException geting resource in buildNewResourcePanelContext() " + (Object)((Object)e)));
            }
            catch (TypeException e) {
                logger.warn((Object)("TypeException geting resource in buildNewResourcePanelContext() " + (Object)((Object)e)));
            }
            catch (PermissionException e) {
                logger.warn((Object)("PermissionException geting resource in buildNewResourcePanelContext() " + (Object)((Object)e)));
            }
        }
        if (resource == null) {
            context.put("citation_action", (Object)"create_resource");
            ToolSession toolSession = this.getSessionManager().getCurrentToolSession();
            ResourceToolActionPipe pipe = (ResourceToolActionPipe)toolSession.getAttribute("resourceToolAction.action_pipe");
            String contentCollectionId = pipe.getContentEntity().getId();
            context.put("contentCollectionId", (Object)contentCollectionId);
            try {
                ContentCollection collection = this.getContentService().getCollection(contentCollectionId);
                contentProperties = this.getProperties((ContentEntity)collection, state);
            }
            catch (IdUnusedException e) {
                logger.warn((Object)("IdUnusedException geting collection in buildNewResourcePanelContext() " + (Object)((Object)e)));
            }
            catch (TypeException e) {
                logger.warn((Object)("TypeException geting collection in buildNewResourcePanelContext() " + (Object)((Object)e)));
            }
            catch (PermissionException e) {
                logger.warn((Object)("PermissionException geting collection in buildNewResourcePanelContext() " + (Object)((Object)e)));
            }
        } else {
            ResourceProperties props = resource.getProperties();
            contentProperties = this.getProperties((ContentEntity)resource, state);
            context.put("resourceTitle", (Object)props.getProperty("DAV:displayname"));
            context.put("resourceDescription", (Object)props.getProperty("CHEF:description"));
            context.put("resourceUuid", (Object)resourceUuid);
            context.put("contentCollectionId", (Object)resource.getContainingCollection().getId());
            try {
                citationCollectionId = new String(resource.getContent());
                if (citationCollectionId != null) {
                    state.setAttribute("citation.citation_collection_id", (Object)citationCollectionId);
                }
            }
            catch (ServerOverloadException e) {
                logger.warn((Object)("ServerOverloadException geting props in buildNewResourcePanelContext() " + (Object)((Object)e)));
            }
            context.put("citation_action", (Object)"update_resource");
        }
        if (contentProperties == null) {
            contentProperties = new HashMap();
        }
        context.put("contentProperties", contentProperties);
        int collectionSize = 0;
        CitationCollection citationCollection = this.getCitationCollection(state, true);
        if (citationCollection == null) {
            logger.warn((Object)("buildAddCitationsPanelContext unable to access citationCollection " + citationCollectionId));
            int requestStateId = CitationHelperAction.preserveRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."});
            context.put("requestStateId", (Object)requestStateId);
            return "citation/error";
        }
        collectionSize = citationCollection.size();
        citationCollectionId = citationCollection.getId();
        context.put("citationCollectionId", (Object)citationCollectionId);
        context.put("collectionSize", (Object)new Integer(collectionSize));
        Locale locale = rb.getLocale();
        List saveciteClients = this.getConfigurationService().getSaveciteClientsForLocale(locale);
        if (saveciteClients != null) {
            if (resource != null && resourceId != null) {
                for (Map client : saveciteClients) {
                    String saveciteUrl = this.getSearchManager().getSaveciteUrl(resourceUuid, (String)client.get("id"));
                    try {
                        client.put("saveciteUrl", URLEncoder.encode(saveciteUrl, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        logger.warn((Object)"Error encoding savecite URL", (Throwable)e);
                    }
                }
            }
            context.put("saveciteClients", (Object)saveciteClients);
        }
        if (this.getConfigurationService().isGoogleScholarEnabled()) {
            String googleUrl = this.getSearchManager().getGoogleScholarUrl(this.getContentService().getUuid(resourceId));
            context.put("googleUrl", (Object)googleUrl);
            Object[] googleArgs = new Object[]{rb.getString("linkLabel.google")};
            context.put("googleArgs", (Object)googleArgs);
        }
        if (this.getConfigurationService().librarySearchEnabled()) {
            context.put("searchLibrary", (Object)Boolean.TRUE);
        }
        if (citationCollection != null && citationCollection.size() > 0) {
            context.put("openUrlLabel", (Object)this.getConfigurationService().getSiteConfigOpenUrlLabel());
            String currentSort = (String)state.getAttribute("citation.sort");
            if (currentSort == null || currentSort.trim().length() == 0) {
                currentSort = citationCollection.getSort();
            }
            if (currentSort == null || currentSort.trim().length() == 0) {
                currentSort = "title";
            }
            context.put("currentSort", (Object)currentSort);
            String savedSort = citationCollection.getSort();
            if (savedSort == null || savedSort.trim().equals("")) {
                savedSort = "title";
            }
            if (savedSort != currentSort) {
                citationCollection.setSort(currentSort, true);
            }
            context.put("collectionSize", (Object)new Integer(citationCollection.size()));
            String exportUrlSel = citationCollection.getUrl("export_ris_sel");
            String exportUrlAll = citationCollection.getUrl("export_ris_all");
            context.put("exportUrlSel", (Object)exportUrlSel);
            context.put("exportUrlAll", (Object)exportUrlAll);
            Integer listPageSize = (Integer)state.getAttribute("citation.list_page_size");
            if (listPageSize == null) {
                listPageSize = defaultListPageSize;
                state.setAttribute("citation.list_page_size", (Object)listPageSize);
            }
            context.put("listPageSize", (Object)listPageSize);
            CitationIterator newIterator = citationCollection.iterator();
            CitationIterator oldIterator = (CitationIterator)state.getAttribute("citation.list_iterator");
            if (oldIterator == null) {
                newIterator.setPageSize(listPageSize.intValue());
                newIterator.setStart(0);
            } else {
                newIterator.setPageSize(listPageSize.intValue());
                newIterator.setStart(oldIterator.getStart());
            }
            context.put("citations", (Object)newIterator);
            context.put("citationCollectionId", (Object)citationCollection.getId());
            if (!citationCollection.isEmpty()) {
                context.put("show_citations", (Object)Boolean.TRUE);
                int totalSize = citationCollection.size();
                int start = newIterator.getStart();
                int end = newIterator.getEnd();
                Object[] position = new Integer[]{new Integer(start + 1), new Integer(end), new Integer(totalSize)};
                String showing = rb.getFormattedMessage("showing.results", position);
                context.put("showing", (Object)showing);
            }
            state.setAttribute("citation.list_iterator", (Object)newIterator);
            context.put("titleProperty", (Object)"title");
            int requestStateId = CitationHelperAction.preserveRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."});
            context.put("requestStateId", (Object)requestStateId);
        }
        return "citation/new_resource";
    }

    public String buildMessagePanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        context.put("sakai_onload", (Object)"");
        context.put("citationId", state.getAttribute("citation.citation_id"));
        String citationCollectionId = (String)state.getAttribute("citation.citation_collection_id");
        context.put("citationCollectionId", (Object)citationCollectionId);
        int size = 0;
        CitationCollection collection = this.getCitationCollection(state, false);
        if (collection == null) {
            logger.warn((Object)("buildMessagePanelContext unable to access citationCollection " + citationCollectionId));
        } else {
            size = collection.size();
        }
        context.put("citationCount", (Object)new Integer(size));
        int requestStateId = CitationHelperAction.preserveRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."});
        context.put("requestStateId", (Object)requestStateId);
        return "citation/_message";
    }

    public String buildResultsPanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        Object noDatabases;
        Object noSearch;
        Object noResults;
        Caller caller = this.getCaller(state);
        context.put("tlang", (Object)rb);
        context.put("stlang", (Object)this.srb);
        context.put("TextValidator", (Object)new QuotedTextValidator());
        context.put("xilator", (Object)new Validator());
        switch (1.$SwitchMap$org$sakaiproject$citation$tool$CitationHelperAction$Caller[caller.ordinal()]) {
            case 1: {
                context.put("sakai_onload", (Object)("SRC_initializePageInfo('resultsForm','" + rb.getString("add.results") + "'); SRC_verifyWindowOpener();"));
                context.put("editorIntegration", (Object)Boolean.TRUE);
                context.put("resourcesTool", (Object)Boolean.FALSE);
                break;
            }
            default: {
                context.put("sakai_onload", (Object)("setMainFrameHeight( window.name ); highlightButtonSelections( '" + rb.getString("remove.results") + "' )"));
                context.put("editorIntegration", (Object)Boolean.FALSE);
                context.put("resourcesTool", (Object)Boolean.TRUE);
                this.putCitationCollectionDetails(context, state);
            }
        }
        Object basicSearch = state.getAttribute("citation.basic_search");
        context.put("basicSearch", basicSearch);
        if (basicSearch != null) {
            context.put("searchType", (Object)"basic");
        } else {
            context.put("searchType", (Object)"advanced");
        }
        ActiveSearch searchResults = (ActiveSearch)state.getAttribute("citation.search_results");
        if (searchResults != null) {
            context.put("searchResults", (Object)searchResults);
            List currentResults = (List)state.getAttribute("citation.current_results");
            context.put("currentResults", (Object)currentResults);
            Object[] position = new Integer[]{new Integer(searchResults.getFirstRecordIndex() + 1), new Integer(searchResults.getLastRecordIndex()), searchResults.getNumRecordsFound()};
            String showing = rb.getFormattedMessage("showing.results", position);
            context.put("showing", (Object)showing);
        }
        String[] databaseIds = (String[])state.getAttribute("citation.current_databases");
        context.put("selectedDatabases", (Object)databaseIds);
        this.loadSearchFormState(context, state);
        ActiveSearch searchInfo = (ActiveSearch)state.getAttribute("citation.search_info");
        context.put("searchInfo", (Object)searchInfo);
        context.put("FORM_NAME", (Object)"resultsForm");
        context.put("openUrlLabel", (Object)this.getConfigurationService().getSiteConfigOpenUrlLabel());
        Object[] instrMainArgs = new Object[]{rb.getString("add.results")};
        context.put("instrMainArgs", (Object)instrMainArgs);
        Object[] instrSubArgs = new Object[]{rb.getString("label.new.search")};
        context.put("instrSubArgs", (Object)instrSubArgs);
        String alertMessages = (String)state.removeAttribute("message");
        if (alertMessages != null) {
            context.put("alertMessages", (Object)alertMessages);
        }
        if ((noResults = state.removeAttribute("citation.no_results")) != null) {
            context.put("noResults", noResults);
        }
        if ((noSearch = state.removeAttribute("citation.no_search_criteria")) != null) {
            context.put("noSearch", noSearch);
        }
        if ((noDatabases = state.removeAttribute("citation.no_databases")) != null) {
            context.put("noDatabases", noDatabases);
        }
        int requestStateId = CitationHelperAction.preserveRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."});
        context.put("requestStateId", (Object)requestStateId);
        return "citation/results";
    }

    public String buildSearchPanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        Caller caller = this.getCaller(state);
        context.put("tlang", (Object)rb);
        context.put("stlang", (Object)this.srb);
        context.put("TextValidator", (Object)new QuotedTextValidator());
        context.put("xilator", (Object)new Validator());
        switch (1.$SwitchMap$org$sakaiproject$citation$tool$CitationHelperAction$Caller[caller.ordinal()]) {
            case 1: {
                context.put("sakai_onload", (Object)"SRC_verifyWindowOpener(); showTopCategory();");
                context.put("editorIntegration", (Object)Boolean.TRUE);
                context.put("resourcesTool", (Object)Boolean.FALSE);
                break;
            }
            default: {
                context.put("sakai_onload", (Object)"setMainFrameHeight( window.name ); showTopCategory();");
                context.put("editorIntegration", (Object)Boolean.FALSE);
                context.put("resourcesTool", (Object)Boolean.TRUE);
                this.putCitationCollectionDetails(context, state);
            }
        }
        String resourceId = (String)state.getAttribute("citation.resource_id");
        String guid = this.getContentService().getUuid(resourceId);
        context.put("RESOURCE_ID", (Object)guid);
        SearchDatabaseHierarchy hierarchy = (SearchDatabaseHierarchy)state.getAttribute("citation.search_hierarchy");
        context.put("defaultCategory", (Object)hierarchy.getDefaultCategory());
        context.put("categoryListing", (Object)hierarchy.getCategoryListing());
        this.loadSearchFormState(context, state);
        context.put("basicSearch", state.getAttribute("citation.basic_search"));
        ActiveSearch searchInfo = (ActiveSearch)state.getAttribute("citation.search_info");
        context.put("searchInfo", (Object)searchInfo);
        Integer maxDbNum = new Integer(hierarchy.getNumMaxSearchableDb());
        context.put("maxDbNum", (Object)maxDbNum);
        context.put("FORM_NAME", (Object)"searchForm");
        context.put("openUrlLabel", (Object)this.getConfigurationService().getSiteConfigOpenUrlLabel());
        Object[] instrArgs = new Object[]{rb.getString("submit.search")};
        context.put("instrArgs", (Object)instrArgs);
        String searchType = null;
        if (searchInfo != null) {
            searchType = searchInfo.getSearchType();
        }
        if (searchType == null) {
            searchType = "basic";
        }
        context.put("searchType", (Object)searchType);
        int requestStateId = CitationHelperAction.preserveRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."});
        context.put("requestStateId", (Object)requestStateId);
        return "citation/search";
    }

    public String buildViewPanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        context.put("tlang", (Object)rb);
        context.put("stlang", (Object)this.srb);
        context.put("xilator", (Object)new Validator());
        context.put("FORM_NAME", (Object)"viewForm");
        Citation citation = (Citation)state.getAttribute("citation.edit_item_item");
        if (citation == null) {
            this.doEdit(rundata);
            citation = (Citation)state.getAttribute("citation.edit_item_item");
        }
        context.put("citation", (Object)citation);
        String citationId = (String)state.getAttribute("citation.edit_item_id");
        String citationCollectionId = (String)state.getAttribute("citation.citation_collection_id");
        context.put("citationId", (Object)citationId);
        context.put("citationCollectionId", (Object)citationCollectionId);
        List schemas = this.getCitationService().getSchemas();
        context.put("TEMPLATES", (Object)schemas);
        context.put("DEFAULT_TEMPLATE", (Object)citation.getSchema());
        int requestStateId = CitationHelperAction.preserveRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."});
        context.put("requestStateId", (Object)requestStateId);
        return "citation/view";
    }

    protected void loadSearchFormState(Context context, SessionState state) {
        if (state.getAttribute("citation.basic_search") != null) {
            context.put("keywords", (Object)((String)state.getAttribute("citation.search_criteria")));
            context.put("advField1", (Object)"keyword");
            context.put("advField2", (Object)"author");
            context.put("advField3", (Object)"title");
            context.put("advField4", (Object)"subject");
            context.put("advField5", (Object)"year");
        } else {
            AdvancedSearchHelper.putFieldSelections((Context)context, (SessionState)state);
            AdvancedSearchHelper.putFieldCriteria((Context)context, (SessionState)state);
        }
        context.put("basicSearchType", (Object)"basic");
        context.put("advancedSearchType", (Object)"advanced");
    }

    public void doFinish(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ToolSession toolSession = this.getSessionManager().getCurrentToolSession();
        ParameterParser params = data.getParameters();
        int requestStateId = params.getInt("requestStateId", 0);
        CitationHelperAction.restoreRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."}, (int)requestStateId);
        ResourceToolActionPipe pipe = (ResourceToolActionPipe)toolSession.getAttribute("resourceToolAction.action_pipe");
        if (pipe == null) {
            logger.warn((Object)"doFinish() pipe = null");
            this.setMode(state, Mode.ERROR_FATAL);
            return;
        }
        boolean citationCount = false;
        CitationCollection collection = this.getCitationCollection(state, true);
        if (collection != null) {
            String citationCollectionId = (String)state.getAttribute("citation.citation_collection_id");
            Object[] args = new String[]{Integer.toString(collection.size())};
            String size_str = rb.getFormattedMessage("citation.count", args);
            pipe.setRevisedResourceProperty("DAV:getcontentlength", size_str);
            pipe.setActionCanceled(false);
            pipe.setErrorEncountered(false);
            pipe.setActionCompleted(true);
            toolSession.setAttribute("resourceToolAction.done", (Object)Boolean.TRUE);
            toolSession.removeAttribute("citation.citation_helper_initialized");
            this.cleanup(toolSession, "citation.", state);
            state.removeAttribute("citation.sort");
            state.removeAttribute("citation.citation_collection_id");
            state.removeAttribute("citation.citation_collection");
            state.removeAttribute("fromListPage");
        }
    }

    public void doCancel(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ToolSession toolSession = this.getSessionManager().getCurrentToolSession();
        ParameterParser params = data.getParameters();
        int requestStateId = params.getInt("requestStateId", 0);
        CitationHelperAction.restoreRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."}, (int)requestStateId);
        ResourceToolActionPipe pipe = (ResourceToolActionPipe)toolSession.getAttribute("resourceToolAction.action_pipe");
        if (pipe == null) {
            logger.warn((Object)"doCancel() pipe = null");
            this.setMode(state, Mode.ERROR_FATAL);
            return;
        }
        if (pipe.getAction().getActionType() == ResourceToolAction.ActionType.CREATE_BY_HELPER) {
            // empty if block
        }
        pipe.setActionCanceled(false);
        pipe.setErrorEncountered(false);
        pipe.setActionCompleted(true);
        toolSession.setAttribute("resourceToolAction.done", (Object)Boolean.TRUE);
        toolSession.removeAttribute("citation.citation_helper_initialized");
        state.removeAttribute("fromListPage");
        this.cleanup(toolSession, "citation.", state);
    }

    public void doAddCitation(RunData data) {
        CitationCollection permCollection;
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        int requestStateId = params.getInt("requestStateId", 0);
        CitationHelperAction.restoreRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."}, (int)requestStateId);
        String[] citationIds = params.getStrings("citationId");
        String citationCollectionId = params.getString("citationCollectionId");
        Integer page = (Integer)state.getAttribute("citation.list_page");
        ActiveSearch search = (ActiveSearch)state.getAttribute("citation.search_results");
        CitationCollection tempCollection = search.getSearchResults();
        Hashtable index = search.getIndex();
        if (index == null) {
            index = new Hashtable();
            search.setIndex(index);
        }
        if ((permCollection = this.getCitationCollection(state, true)) != null) {
            for (int i = 0; i < citationIds.length; ++i) {
                try {
                    Citation citation = tempCollection.getCitation(citationIds[i]);
                    citation.setAdded(true);
                    permCollection.add(citation);
                    continue;
                }
                catch (IdUnusedException ex) {
                    logger.warn((Object)("doAdd: unable to add citation " + citationIds[i] + " to collection " + citationCollectionId));
                }
            }
            this.getCitationService().save(permCollection);
        }
    }

    public void doRemove(RunData data) {
        CitationCollection permCollection;
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        int requestStateId = params.getInt("requestStateId", 0);
        CitationHelperAction.restoreRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."}, (int)requestStateId);
        String[] citationIds = params.getStrings("citationId");
        String citationCollectionId = params.getString("citationCollectionId");
        ActiveSearch search = (ActiveSearch)state.getAttribute("citation.search_results");
        CitationCollection tempCollection = search.getSearchResults();
        Hashtable index = search.getIndex();
        if (index == null) {
            index = new Hashtable();
            search.setIndex(index);
        }
        if ((permCollection = this.getCitationCollection(state, true)) != null) {
            for (int i = 0; i < citationIds.length; ++i) {
                try {
                    Citation citation = tempCollection.getCitation(citationIds[i]);
                    citation.setAdded(false);
                    permCollection.remove(citation);
                    continue;
                }
                catch (IdUnusedException ex) {
                    logger.warn((Object)("doAdd: unable to add citation " + citationIds[i] + " to collection " + citationCollectionId));
                }
            }
            this.getCitationService().save(permCollection);
        }
        this.setMode(state, Mode.NEW_RESOURCE);
    }

    public void doDatabasePopulate(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        int requestStateId = params.getInt("requestStateId", 0);
        CitationHelperAction.restoreRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."}, (int)requestStateId);
        String categoryId = params.get("categoryId");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("doDatabasePopulate() categoryId from URL: " + categoryId));
        }
        if (categoryId == null) {
            this.setMode(state, Mode.ERROR);
            return;
        }
        SearchDatabaseHierarchy hierarchy = (SearchDatabaseHierarchy)state.getAttribute("citation.search_hierarchy");
        SearchCategory category = hierarchy.getCategory(categoryId);
        state.setAttribute("citation.selected_category", (Object)category);
        this.setMode(state, Mode.DATABASE);
    }

    public void doImportPage(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        int requestStateId = params.getInt("requestStateId", 0);
        CitationHelperAction.restoreRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."}, (int)requestStateId);
        this.preserveEntityIds(params, state);
        this.setMode(state, Mode.IMPORT_CITATIONS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doImport(RunData data) {
        logger.debug((Object)"doImport called.");
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        int requestStateId = params.getInt("requestStateId", 0);
        CitationHelperAction.restoreRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."}, (int)requestStateId);
        Iterator iter = params.getNames();
        String param = null;
        while (iter.hasNext()) {
            param = (String)iter.next();
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("param = " + param));
            logger.debug((Object)(param + " value = " + params.get(param)));
        }
        String citationCollectionId = params.getString("citationCollectionId");
        if (citationCollectionId == null) {
            citationCollectionId = (String)state.getAttribute("citation.citation_collection_id");
        }
        CitationCollection collection = null;
        collection = this.getCitationCollection(state, false);
        String ristext = params.get("ristext");
        BufferedReader bread = null;
        if (ristext.trim().length() > 0) {
            StringReader risStringReader = new StringReader(ristext);
            bread = new BufferedReader(risStringReader);
            logger.debug((Object)"String buffered reader ready");
        } else {
            InputStreamReader isr;
            BOMInputStream irs;
            block31: {
                FileItem risImport;
                String upload = params.get("risupload");
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Upload String = " + upload));
                }
                if ((risImport = params.getFileItem("risupload")) == null) {
                    logger.debug((Object)"risImport is null.");
                    return;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Filename = " + risImport.getFileName()));
                }
                InputStream risImportStream = risImport.getInputStream();
                irs = new BOMInputStream(risImportStream);
                isr = null;
                String bomCharsetName = null;
                try {
                    bomCharsetName = irs.getBOMCharsetName();
                    if (bomCharsetName != null) {
                        isr = new InputStreamReader(risImportStream, bomCharsetName);
                    }
                }
                catch (UnsupportedEncodingException uee) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Problem using character set when importing RIS: " + bomCharsetName));
                    }
                }
                catch (IOException ioe) {
                    if (!logger.isDebugEnabled()) break block31;
                    logger.debug((Object)("Problem reading the character set from RIS import: " + ioe.getMessage()));
                }
            }
            if (isr == null) {
                isr = new InputStreamReader((InputStream)irs);
            }
            bread = new BufferedReader(isr);
        }
        StringBuilder fileString = new StringBuilder();
        String importLine = null;
        ArrayList<String> importList = new ArrayList<String>();
        try {
            while ((importLine = bread.readLine()) != null) {
                if ((importLine = importLine.trim()) == null || importLine.length() <= 2) continue;
                importList.add(importLine);
                if (!logger.isDebugEnabled()) continue;
                fileString.append("\n");
                fileString.append(importLine);
            }
        }
        catch (Exception e) {
            logger.debug((Object)("ISR error = " + e));
        }
        finally {
            if (bread != null) {
                try {
                    bread.close();
                }
                catch (IOException e) {}
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("fileString = \n" + fileString.toString()));
        }
        ArrayList<String> tempList = new ArrayList<String>();
        Citation importCitation = this.getCitationService().getTemporaryCitation();
        CitationCollection importCollection = this.getCitationService().getTemporaryCollection();
        int sucessfullyReadCitations = 0;
        int totalNumberCitations = 0;
        for (int i = 0; i < importList.size(); ++i) {
            String importEntryString = (String)importList.get(i);
            tempList.add(importEntryString);
            if (importEntryString == null || importEntryString.length() <= 1 || !importEntryString.substring(0, 2).equalsIgnoreCase("ER")) continue;
            ++totalNumberCitations;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("------> Trying to add citation " + totalNumberCitations));
            }
            if (importCitation.importFromRisList(tempList)) {
                importCollection.add(importCitation);
                ++sucessfullyReadCitations;
            }
            tempList.clear();
            importCitation = this.getCitationService().getTemporaryCitation();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Done reading in " + sucessfullyReadCitations + " / " + totalNumberCitations + " citations."));
        }
        collection.addAll(importCollection);
        this.getCitationService().save(collection);
        state.removeAttribute("citation.citation_collection");
        this.setMode(state, Mode.NEW_RESOURCE);
    }

    public void doCreateResource(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        int requestStateId = params.getInt("requestStateId", 0);
        CitationHelperAction.restoreRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."}, (int)requestStateId);
        this.setMode(state, Mode.NEW_RESOURCE);
    }

    public void doCreate(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        int requestStateId = params.getInt("requestStateId", 0);
        CitationHelperAction.restoreRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."}, (int)requestStateId);
        this.setMode(state, Mode.CREATE);
    }

    protected Caller getCaller(SessionState state) {
        Caller caller = (Caller)state.getAttribute("citations_helper_caller");
        return caller == null ? Caller.RESOURCE_TOOL : Caller.EDITOR_INTEGRATION;
    }

    protected void setCaller(SessionState state, Caller caller) {
        state.setAttribute("citations_helper_caller", (Object)caller);
    }

    protected void setMode(SessionState state, Mode new_mode) {
        state.setAttribute("citation.helper.mode", (Object)new_mode);
    }

    public void doCreateCitation(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        int requestStateId = params.getInt("requestStateId", 0);
        CitationHelperAction.restoreRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."}, (int)requestStateId);
        Set validPropertyNames = this.getCitationService().getValidPropertyNames();
        String mediatype = params.getString("type");
        CitationCollection collection = this.getCitationCollection(state, true);
        if (collection != null) {
            Citation citation = this.getCitationService().addCitation(mediatype);
            this.updateCitationFromParams(citation, params);
            collection.add(citation);
            this.getCitationService().save(collection);
        }
        this.setMode(state, Mode.NEW_RESOURCE);
    }

    protected void updateCitationFromParams(Citation citation, ParameterParser params) {
        Schema schema = citation.getSchema();
        List fields = schema.getFields();
        for (Schema.Field field : fields) {
            String name = field.getIdentifier();
            if (field.isMultivalued()) {
                Vector<String> values = new Vector<String>();
                String count = params.getString(name + "_count");
                int num = 10;
                try {
                    num = Integer.parseInt(count);
                    for (int i = 0; i < num; ++i) {
                        String value = params.getString(name + i);
                        if (value == null || values.contains(value)) continue;
                        values.add(value);
                    }
                    citation.updateCitationProperty(name, values);
                }
                catch (NumberFormatException i) {}
                continue;
            }
            String value = params.getString(name);
            citation.setCitationProperty(name, (Object)value);
            if (!name.equals("title")) continue;
            citation.setDisplayName(value);
        }
        int urlCount = 0;
        try {
            urlCount = params.getInt("url_count");
        }
        catch (Exception e) {
            logger.debug((Object)"doCreateCitation: unable to parse int for urlCount");
        }
        citation.setPreferredUrl(null);
        String id = null;
        for (int i = 0; i < urlCount; ++i) {
            String label = params.getString("label_" + i);
            String url = params.getString("url_" + i);
            String urlid = params.getString("urlid_" + i);
            String preferred = params.getString("pref_" + i);
            String addPrefix = params.getString("addprefix_" + i);
            if (url == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("doCreateCitation: url null? " + url));
                }
            } else {
                try {
                    url = this.validateURL(url);
                }
                catch (MalformedURLException e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("doCreateCitation: unable to validate URL: " + url));
                    continue;
                }
            }
            if (label == null || url == null) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("doCreateCitation: label null? " + label + " url null? " + url));
                continue;
            }
            if (urlid == null || urlid.trim().equals("")) {
                id = citation.addCustomUrl(label, url, addPrefix);
                if (preferred == null || preferred.trim().equals("")) continue;
                citation.setPreferredUrl(id);
                continue;
            }
            citation.updateCustomUrl(urlid, label, url, addPrefix);
            if (preferred == null || preferred.trim().equals("")) continue;
            citation.setPreferredUrl(urlid);
        }
    }

    public void doEdit(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        int requestStateId = params.getInt("requestStateId", 0);
        CitationHelperAction.restoreRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."}, (int)requestStateId);
        String citationId = params.getString("citationId");
        String citationCollectionId = params.getString("citationCollectionId");
        CitationCollection collection = this.getCitationCollection(state, true);
        if (collection != null) {
            Citation citation = null;
            try {
                citation = collection.getCitation(citationId);
            }
            catch (IdUnusedException idUnusedException) {
                // empty catch block
            }
            if (citation == null) {
                CitationHelperAction.addAlert((SessionState)state, (String)rb.getString("alert.access"));
            } else {
                state.setAttribute("citation.edit_item_id", (Object)citationId);
                state.setAttribute("citation.edit_item_item", (Object)citation);
                this.setMode(state, Mode.EDIT);
            }
        }
    }

    public void doList(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        int requestStateId = params.getInt("requestStateId", 0);
        CitationHelperAction.restoreRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."}, (int)requestStateId);
        this.setMode(state, Mode.NEW_RESOURCE);
    }

    public void doResults(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        int requestStateId = params.getInt("requestStateId", 0);
        CitationHelperAction.restoreRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."}, (int)requestStateId);
        this.setMode(state, Mode.RESULTS);
    }

    public void doAddCitations(RunData data) {
        logger.debug((Object)"doAddCitations()");
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        int requestStateId = params.getInt("requestStateId", 0);
        CitationHelperAction.restoreRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."}, (int)requestStateId);
        this.preserveEntityIds(params, state);
        this.setMode(state, Mode.NEW_RESOURCE);
        logger.debug((Object)"doAddCitations()");
    }

    public void doMessageFrame(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        int requestStateId = params.getInt("requestStateId", 0);
        CitationHelperAction.restoreRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."}, (int)requestStateId);
        String citationId = params.getString("citationId");
        String citationCollectionId = params.getString("citationCollectionId");
        String operation = params.getString("operation");
        if (operation == null) {
            logger.warn((Object)"doMessageFrame() 'operation' null argument");
            this.setMode(state, Mode.ERROR);
            return;
        }
        if (operation.trim().equalsIgnoreCase("refreshCount")) {
            this.setMode(state, Mode.MESSAGE);
            return;
        }
        if (operation == null || citationId == null || citationCollectionId == null) {
            logger.warn((Object)("doMessageFrame() null argument - operation: " + operation + ", citationId: " + citationId + ", " + "citationCollectionId: " + citationCollectionId));
            this.setMode(state, Mode.ERROR);
            return;
        }
        List currentResults = (List)state.getAttribute("citation.current_results");
        Citation citation = null;
        for (Citation c : currentResults) {
            if (!c.getId().equals(citationId)) continue;
            citation = c;
            break;
        }
        if (citation == null) {
            logger.warn((Object)("doMessageFrame() bad citationId: " + citationId));
            this.setMode(state, Mode.ERROR);
            return;
        }
        CitationCollection collection = this.getCitationCollection(state, false);
        if (collection == null) {
            logger.warn((Object)("doMessageFrame() unable to access citationCollection " + citationCollectionId));
        } else {
            if (operation.equalsIgnoreCase("add")) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("adding citation " + citationId + " to " + citationCollectionId));
                }
                citation.setAdded(true);
                collection.add(citation);
                this.getCitationService().save(collection);
            } else if (operation.equalsIgnoreCase("remove")) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("removing citation " + citationId + " from " + citationCollectionId));
                }
                collection.remove(citation);
                citation.setAdded(false);
                this.getCitationService().save(collection);
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("null operation: " + operation));
            }
            state.setAttribute("citation.citation_id", (Object)citation.getId());
        }
        this.setMode(state, Mode.MESSAGE);
    }

    public void doRemoveAllCitations(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        int requestStateId = params.getInt("requestStateId", 0);
        CitationHelperAction.restoreRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."}, (int)requestStateId);
        String citationCollectionId = params.getString("citationCollectionId");
        CitationCollection collection = this.getCitationCollection(state, false);
        if (collection == null) {
            logger.warn((Object)("CitationHelperAction.doRemoveCitation collection null: " + citationCollectionId));
        } else {
            List citations = collection.getCitations();
            if (citations != null && citations.size() > 0) {
                for (Citation citation : citations) {
                    collection.remove(citation);
                }
                this.getCitationService().save(collection);
            }
        }
        this.setMode(state, Mode.NEW_RESOURCE);
    }

    public void doImportCitationFromResourceUrl(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        String resourceUrl = params.getString("resourceUrl");
        CitationCollection collection = this.getCitationCollection(state, false);
        if (resourceUrl != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("RESOURCE URL: " + resourceUrl));
            }
            String resourceId = resourceUrl.substring(resourceUrl.indexOf("/group"));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("RESOURCE ID: " + resourceId));
            }
            ContentHostingService contentService = (ContentHostingService)ComponentManager.get((String)"org.sakaiproject.content.api.ContentHostingService");
            try {
                ContentResource resource = contentService.getResource(resourceId);
                ResourceProperties props = resource.getProperties();
                String displayName = props.getProperty("DAV:displayname");
                Citation citation = this.citationService.addCitation("unknown");
                citation.setDisplayName(displayName);
                citation.setCitationProperty("resourceId", (Object)resourceId);
                String urlId = citation.addCustomUrl(resourceUrl, resourceUrl);
                citation.setPreferredUrl(urlId);
                collection.add(citation);
                this.citationService.save(collection);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        state.setAttribute("sort", (Object)"title");
        this.setMode(state, Mode.LIST);
    }

    public void doShowReorderCitations(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        this.setMode(state, Mode.REORDER);
    }

    public void doReorderCitations(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        String orderedCitationIds = params.getString("orderedCitationIds");
        CitationCollection collection = this.getCitationCollection(state, false);
        String[] splitIds = orderedCitationIds.split(",");
        try {
            for (int i = 1; i <= splitIds.length; ++i) {
                collection.getCitation(splitIds[i - 1]).setPosition(i);
            }
            this.getCitationService().save(collection);
        }
        catch (IdUnusedException iue) {
            logger.error((Object)"One of the supplied citation ids was invalid. The new order was not saved.");
        }
        state.removeAttribute("citation.citation_collection");
        state.setAttribute("citation.sort", (Object)"position");
        this.setMode(state, Mode.NEW_RESOURCE);
    }

    public void doRemoveSelectedCitations(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        int requestStateId = params.getInt("requestStateId", 0);
        CitationHelperAction.restoreRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."}, (int)requestStateId);
        String citationCollectionId = params.getString("citationCollectionId");
        CitationCollection collection = this.getCitationCollection(state, false);
        if (collection == null) {
            logger.warn((Object)("doRemoveSelectedCitation() collection null: " + citationCollectionId));
        } else {
            String[] paramCitationIds = params.getStrings("citationId");
            if (paramCitationIds != null && paramCitationIds.length > 0) {
                ArrayList<String> citationIds = new ArrayList<String>();
                citationIds.addAll(Arrays.asList(paramCitationIds));
                try {
                    for (String citationId : citationIds) {
                        Citation citation = collection.getCitation(citationId);
                        collection.remove(citation);
                    }
                    this.getCitationService().save(collection);
                }
                catch (IdUnusedException e) {
                    logger.warn((Object)"doRemoveSelectedCitation() unable to get and remove citation", (Throwable)e);
                }
            }
        }
        state.setAttribute("citation.list_no_scroll", (Object)Boolean.TRUE);
        this.setMode(state, Mode.NEW_RESOURCE);
    }

    public void doReviseCitation(RunData data) {
        String citationId;
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        int requestStateId = params.getInt("requestStateId", 0);
        CitationHelperAction.restoreRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."}, (int)requestStateId);
        CitationCollection collection = this.getCitationCollection(state, false);
        if (collection != null && (citationId = (String)state.getAttribute("citation.edit_item_id")) != null) {
            try {
                Citation citation = collection.getCitation(citationId);
                String schemaId = params.getString("type");
                Schema schema = this.getCitationService().getSchema(schemaId);
                citation.setSchema(schema);
                this.updateCitationFromParams(citation, params);
                collection.saveCitation(citation);
            }
            catch (IdUnusedException idUnusedException) {
                // empty catch block
            }
            this.getCitationService().save(collection);
        }
        this.setMode(state, Mode.NEW_RESOURCE);
    }

    public void doCancelSearch(RunData data) {
        Thread searchThread;
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        int requestStateId = params.getInt("requestStateId", 0);
        CitationHelperAction.restoreRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."}, (int)requestStateId);
        ActiveSearch search = (ActiveSearch)state.getAttribute("citation.search_info");
        if (search != null && (searchThread = search.getSearchThread()) != null) {
            try {
                searchThread.interrupt();
            }
            catch (SecurityException se) {
                logger.warn((Object)("doSearch() [in ThreadGroup " + Thread.currentThread().getThreadGroup().getName() + "] unable to interrupt search Thread [name=" + searchThread.getName() + ", id=" + searchThread.getId() + ", group=" + searchThread.getThreadGroup().getName() + "]"));
            }
        }
    }

    public void doSearch(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        logger.debug((Object)"doSearch()");
        int requestStateId = params.getInt("requestStateId", 0);
        CitationHelperAction.restoreRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."}, (int)requestStateId);
        this.doSearchCommon(state, Mode.NEW_RESOURCE);
    }

    protected void doSearchCommon(SessionState state, Mode errorMode) {
        state.removeAttribute("citation.search_results");
        state.removeAttribute("citation.current_results");
        state.removeAttribute("citation.search_criteria");
        state.setAttribute("citation.basic_search", new Object());
        try {
            SearchDatabaseHierarchy hierarchy = this.getSearchManager().getSearchHierarchy();
            if (hierarchy == null) {
                CitationHelperAction.addAlert((SessionState)state, (String)rb.getString("search.problem"));
                this.setMode(state, errorMode);
                return;
            }
            state.setAttribute("citation.search_hierarchy", (Object)hierarchy);
            this.setMode(state, Mode.SEARCH);
        }
        catch (SearchException exception) {
            String error = exception.getMessage();
            if (error == null || error.length() == 0) {
                error = rb.getString("search.problem");
            }
            CitationHelperAction.addAlert((SessionState)state, (String)error);
            this.setMode(state, Mode.ERROR);
        }
    }

    public void doBeginSearch(RunData data) {
        String[] databaseIds;
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        int requestStateId = params.getInt("requestStateId", 0);
        CitationHelperAction.restoreRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."}, (int)requestStateId);
        ActiveSearch search = (ActiveSearch)state.getAttribute("citation.search_info");
        if (search == null) {
            logger.debug((Object)"doBeginSearch() got null ActiveSearch from state.");
            search = this.getSearchManager().newSearch();
        }
        if ((databaseIds = params.getStrings("databasesSelected")) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Databases selected:");
                for (String databaseId : databaseIds) {
                    logger.debug((Object)("  " + databaseId));
                }
            }
            SearchDatabaseHierarchy hierarchy = (SearchDatabaseHierarchy)state.getAttribute("citation.search_hierarchy");
            for (int i = 0; i < databaseIds.length; ++i) {
                if (hierarchy.isSearchableDatabase(databaseIds[i])) continue;
                state.setAttribute("citation.unauthorized_database", (Object)Boolean.TRUE);
                logger.warn((Object)("doBeginSearch() unauthorized database: " + databaseIds[i]));
                this.setMode(state, Mode.RESULTS);
                return;
            }
        } else {
            state.setAttribute("citation.no_databases", (Object)Boolean.TRUE);
            this.setMode(state, Mode.RESULTS);
            return;
        }
        search.setDatabaseIds(databaseIds);
        state.setAttribute("citation.current_databases", (Object)databaseIds);
        String searchType = params.getString("searchType");
        if (searchType != null && searchType.equalsIgnoreCase("advanced")) {
            this.doAdvancedSearch(params, state, search);
        } else {
            this.doBasicSearch(params, state, search);
        }
        String cancel = params.getString("cancelOp");
        if (cancel != null && !cancel.trim().equals("")) {
            if (cancel.equalsIgnoreCase("resultsForm")) {
                state.setAttribute("citation.cancel_page", (Object)Mode.RESULTS);
            } else {
                state.setAttribute("citation.cancel_page", (Object)Mode.SEARCH);
            }
        }
        try {
            search.setSearchThread(Thread.currentThread());
            state.setAttribute("citation.search_info", (Object)search);
            List latestResults = search.viewPage();
            String msg = search.getStatusMessage();
            if (msg != null) {
                CitationHelperAction.addAlert((SessionState)state, (String)msg);
                search.setStatusMessage();
            }
            if (latestResults != null) {
                state.setAttribute("citation.search_results", (Object)search);
                state.setAttribute("citation.current_results", (Object)latestResults);
                this.setMode(state, Mode.RESULTS);
            }
        }
        catch (SearchException se) {
            StringBuilder alertMsg = new StringBuilder(se.getMessage());
            logger.warn((Object)("doBeginSearch() SearchException: " + alertMsg));
            if (search.getStatusMessage() != null && !search.getStatusMessage().trim().equals("")) {
                logger.warn((Object)(" |-- nested metasearch error: " + search.getStatusMessage()));
                alertMsg.append(" (" + search.getStatusMessage() + ")");
            }
            CitationHelperAction.addAlert((SessionState)state, (String)alertMsg.toString());
            state.setAttribute("citation.no_results", (Object)Boolean.TRUE);
            this.setMode(state, Mode.RESULTS);
            return;
        }
        catch (SearchCancelException sce) {
            logger.debug((Object)"doBeginSearch() SearchCancelException: user cancelled search");
            this.setMode(state, (Mode)state.getAttribute("citation.cancel_page"));
        }
        ActiveSearch newSearch = this.getSearchManager().newSearch();
        state.setAttribute("citation.search_info", (Object)newSearch);
    }

    protected void doBasicSearch(ParameterParser params, SessionState state, ActiveSearch search) {
        state.setAttribute("citation.basic_search", new Object());
        search.setSearchType("basic");
        String keywords = params.getString("keywords");
        if (keywords == null || keywords.trim().equals("")) {
            logger.warn((Object)"doBasicSearch() getting null/empty keywords");
        }
        org.sakaiproject.citation.util.impl.SearchQuery basicQuery = new org.sakaiproject.citation.util.impl.SearchQuery();
        basicQuery.addKeywords(keywords);
        search.setBasicQuery((SearchQuery)basicQuery);
        state.setAttribute("citation.search_criteria", (Object)keywords);
    }

    protected void doAdvancedSearch(ParameterParser params, SessionState state, ActiveSearch search) {
        state.removeAttribute("citation.basic_search");
        search.setSearchType("advanced");
        AdvancedSearchHelper.clearAdvancedFormState((SessionState)state);
        AdvancedSearchHelper.setFieldSelections((ParameterParser)params, (SessionState)state);
        AdvancedSearchHelper.setFieldCriteria((ParameterParser)params, (SessionState)state);
        search.setAdvancedQuery(AdvancedSearchHelper.getAdvancedCriteria((SessionState)state));
    }

    public void doNextListPage(RunData data) {
        CitationCollection collection;
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        int requestStateId = params.getInt("requestStateId", 0);
        CitationHelperAction.restoreRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."}, (int)requestStateId);
        CitationIterator listIterator = (CitationIterator)state.getAttribute("citation.list_iterator");
        if (listIterator == null && (collection = this.getCitationCollection(state, true)) != null) {
            listIterator = collection.iterator();
            state.setAttribute("citation.list_iterator", (Object)listIterator);
        }
        if (listIterator != null && listIterator.hasNextPage()) {
            listIterator.nextPage();
        }
    }

    public void doPrevListPage(RunData data) {
        CitationCollection collection;
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        int requestStateId = params.getInt("requestStateId", 0);
        CitationHelperAction.restoreRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."}, (int)requestStateId);
        CitationIterator listIterator = (CitationIterator)state.getAttribute("citation.list_iterator");
        if (listIterator == null && (collection = this.getCitationCollection(state, true)) != null) {
            listIterator = collection.iterator();
            state.setAttribute("citation.list_iterator", (Object)listIterator);
        }
        if (listIterator != null && listIterator.hasPreviousPage()) {
            listIterator.previousPage();
        }
    }

    public void doLastListPage(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        int requestStateId = params.getInt("requestStateId", 0);
        CitationHelperAction.restoreRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."}, (int)requestStateId);
        CitationCollection collection = this.getCitationCollection(state, true);
        if (collection != null) {
            CitationIterator listIterator = (CitationIterator)state.getAttribute("citation.list_iterator");
            if (listIterator == null) {
                listIterator = collection.iterator();
                state.setAttribute("citation.list_iterator", (Object)listIterator);
            } else {
                int pageSize = listIterator.getPageSize();
                int totalSize = collection.size();
                boolean lastPage = false;
                listIterator.setStart(totalSize - pageSize);
            }
        }
    }

    public void doFirstListPage(RunData data) {
        CitationCollection collection;
        CitationIterator listIterator;
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        int requestStateId = params.getInt("requestStateId", 0);
        CitationHelperAction.restoreRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."}, (int)requestStateId);
        if (state.getAttribute("citation.resource_id") == null) {
            String resourceId = params.get("resourceId");
            if (resourceId == null || resourceId.trim().equals("")) {
                String resourceUuid = (String)state.getAttribute("citation.resource_uuid");
                if (resourceUuid == null || resourceUuid.trim().equals("")) {
                    resourceUuid = params.get("resourceUuid");
                }
                if (resourceUuid != null && !resourceUuid.trim().equals("")) {
                    resourceId = this.getContentService().resolveUuid(resourceUuid);
                    state.setAttribute("citation.resource_id", (Object)resourceId);
                    state.setAttribute("citation.resource_uuid", (Object)resourceUuid);
                }
            } else {
                state.setAttribute("citation.resource_id", (Object)resourceId);
            }
        }
        if ((listIterator = (CitationIterator)state.getAttribute("citation.list_iterator")) == null && (collection = this.getCitationCollection(state, true)) != null) {
            listIterator = collection.iterator();
            state.setAttribute("citation.list_iterator", (Object)listIterator);
        }
        if (listIterator != null) {
            listIterator.setStart(0);
        }
    }

    public void doNextSearchPage(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        int requestStateId = params.getInt("requestStateId", 0);
        CitationHelperAction.restoreRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."}, (int)requestStateId);
        ActiveSearch search = (ActiveSearch)state.getAttribute("citation.search_results");
        if (search == null) {
            search = this.getSearchManager().newSearch();
        }
        try {
            List latestResults = search.viewPage(search.getViewPageNumber() + 1);
            String msg = search.getStatusMessage();
            if (msg != null) {
                CitationHelperAction.addAlert((SessionState)state, (String)msg);
                search.setStatusMessage();
            }
            state.setAttribute("citation.current_results", (Object)latestResults);
            this.setMode(state, Mode.RESULTS);
        }
        catch (SearchException e) {
            logger.warn((Object)("doNextSearchPage: " + e.getMessage()));
            CitationHelperAction.addAlert((SessionState)state, (String)rb.getString("error.search"));
            this.setMode(state, Mode.RESULTS);
        }
        catch (Exception e) {
            logger.warn((Object)("doNextSearchPage: " + e.getMessage()));
        }
    }

    public void doPrevSearchPage(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        int requestStateId = params.getInt("requestStateId", 0);
        CitationHelperAction.restoreRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."}, (int)requestStateId);
        ActiveSearch search = (ActiveSearch)state.getAttribute("citation.search_results");
        if (search == null) {
            search = this.getSearchManager().newSearch();
        }
        try {
            List latestResults = search.viewPage(search.getViewPageNumber() - 1);
            String msg = search.getStatusMessage();
            if (msg != null) {
                CitationHelperAction.addAlert((SessionState)state, (String)msg);
                search.setStatusMessage();
            }
            state.setAttribute("citation.current_results", (Object)latestResults);
            this.setMode(state, Mode.RESULTS);
        }
        catch (SearchException e) {
            logger.warn((Object)("doPrevSearchPage: " + e.getMessage()));
            CitationHelperAction.addAlert((SessionState)state, (String)rb.getString("error.search"));
            this.setMode(state, Mode.RESULTS);
        }
        catch (Exception e) {
            logger.warn((Object)("doPrevSearchPage: " + e.getMessage()));
        }
    }

    public void doFirstSearchPage(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        int requestStateId = params.getInt("requestStateId", 0);
        CitationHelperAction.restoreRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."}, (int)requestStateId);
        ActiveSearch search = (ActiveSearch)state.getAttribute("citation.search_results");
        if (search == null) {
            search = this.getSearchManager().newSearch();
        }
        try {
            List latestResults = search.viewPage(0);
            String msg = search.getStatusMessage();
            if (msg != null) {
                CitationHelperAction.addAlert((SessionState)state, (String)msg);
                search.setStatusMessage();
            }
            state.setAttribute("citation.current_results", (Object)latestResults);
            this.setMode(state, Mode.RESULTS);
        }
        catch (SearchException e) {
            logger.warn((Object)("doFirstSearchPage: " + e.getMessage()));
            CitationHelperAction.addAlert((SessionState)state, (String)rb.getString("error.search"));
            this.setMode(state, Mode.RESULTS);
        }
        catch (Exception e) {
            logger.warn((Object)("doFirstSearchPage: " + e.getMessage()));
        }
    }

    public void doChangeSearchPageSize(RunData data) {
        String pageSelector;
        int pageSize;
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        int requestStateId = params.getInt("requestStateId", 0);
        CitationHelperAction.restoreRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."}, (int)requestStateId);
        ActiveSearch search = (ActiveSearch)state.getAttribute("citation.search_results");
        if (search == null) {
            search = this.getSearchManager().newSearch();
            state.setAttribute("citation.search_results", (Object)search);
        }
        if ((pageSize = (pageSelector = params.get("pageSelector")).equals("top") ? params.getInt("pageSizeTop") : params.getInt("pageSizeBottom")) <= 0) {
            pageSize = search.getViewPageSize();
        }
        state.setAttribute("citation.results_page_size", (Object)new Integer(pageSize));
        try {
            int last = search.getLastRecordIndex();
            int page = (last - 1) / pageSize;
            search.setViewPageSize(pageSize);
            List latestResults = search.viewPage(page);
            String msg = search.getStatusMessage();
            if (msg != null) {
                CitationHelperAction.addAlert((SessionState)state, (String)msg);
                search.setStatusMessage();
            }
            state.setAttribute("citation.current_results", (Object)latestResults);
            this.setMode(state, Mode.RESULTS);
        }
        catch (SearchException e) {
            logger.warn((Object)("doChangeSearchPageSize: " + e.getMessage()));
            CitationHelperAction.addAlert((SessionState)state, (String)rb.getString("error.search"));
            this.setMode(state, Mode.RESULTS);
        }
        catch (Exception e) {
            logger.warn((Object)("doChangeSearchPageSize: " + e.getMessage()));
        }
    }

    public void doChangeListPageSize(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        int requestStateId = params.getInt("requestStateId", 0);
        CitationHelperAction.restoreRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."}, (int)requestStateId);
        int pageSize = params.getInt("newPageSize");
        if (pageSize < 1) {
            String pageSelector = params.get("pageSelector");
            pageSize = pageSelector.equals("top") ? params.getInt("pageSizeTop") : params.getInt("pageSizeBottom");
        }
        if (pageSize > 0) {
            state.setAttribute("citation.list_page_size", (Object)new Integer(pageSize));
            CitationIterator tempIterator = (CitationIterator)state.getAttribute("citation.list_iterator");
            tempIterator.setPageSize(pageSize);
            state.removeAttribute("citation.list_iterator");
            state.setAttribute("citation.list_iterator", (Object)tempIterator);
        }
    }

    public void doView(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        int requestStateId = params.getInt("requestStateId", 0);
        CitationHelperAction.restoreRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."}, (int)requestStateId);
        String citationId = params.getString("citationId");
        String citationCollectionId = params.getString("citationCollectionId");
        CitationCollection collection = this.getCitationCollection(state, false);
        if (collection == null) {
            CitationHelperAction.addAlert((SessionState)state, (String)rb.getString("alert.access"));
        } else {
            Citation citation = null;
            try {
                citation = collection.getCitation(citationId);
            }
            catch (IdUnusedException idUnusedException) {
                // empty catch block
            }
            if (citation == null) {
                CitationHelperAction.addAlert((SessionState)state, (String)rb.getString("alert.access"));
            } else {
                state.setAttribute("citation.edit_item_id", (Object)citationId);
                state.setAttribute("citation.edit_item_item", (Object)citation);
                this.setMode(state, Mode.VIEW);
            }
        }
    }

    protected Mode validateState() {
        return null;
    }

    protected boolean initHelper(SessionState state) {
        logger.debug((Object)"initHelper()");
        if (this.getCaller(state) == Caller.EDITOR_INTEGRATION) {
            Mode mode = (Mode)state.getAttribute("citation.helper.mode");
            if (mode == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("initHelper(): mode is undefined, using " + Mode.NEW_RESOURCE));
                }
                this.setMode(state, Mode.NEW_RESOURCE);
            }
            if (state.getAttribute("citation.results_page_size") == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("initHelper(): result page size is undefined, using " + DEFAULT_RESULTS_PAGE_SIZE));
                }
                state.setAttribute("citation.results_page_size", (Object)DEFAULT_RESULTS_PAGE_SIZE);
            }
            return true;
        }
        ToolSession toolSession = this.getSessionManager().getCurrentToolSession();
        ResourceToolActionPipe pipe = (ResourceToolActionPipe)toolSession.getAttribute("resourceToolAction.action_pipe");
        if (pipe == null) {
            logger.warn((Object)"initHelper() pipe = null");
            this.setMode(state, Mode.ERROR_FATAL);
            return true;
        }
        if (pipe.isActionCompleted()) {
            return true;
        }
        if (toolSession.getAttribute("citation.citation_helper_initialized") == null) {
            switch (1.$SwitchMap$org$sakaiproject$content$api$ResourceToolAction$ActionType[pipe.getAction().getActionType().ordinal()]) {
                case 1: {
                    state.setAttribute("citation.resources_add", (Object)Boolean.TRUE);
                    this.setMode(state, Mode.NEW_RESOURCE);
                    break;
                }
                case 2: {
                    state.setAttribute("citation.resource_id", (Object)pipe.getContentEntity().getId());
                    try {
                        state.setAttribute("citation.citation_collection_id", (Object)new String(((ContentResource)pipe.getContentEntity()).getContent()));
                    }
                    catch (ServerOverloadException e) {
                        logger.warn((Object)"ServerOverloadException ", (Throwable)e);
                    }
                    state.removeAttribute("citation.resources_add");
                    this.setMode(state, Mode.NEW_RESOURCE);
                    break;
                }
            }
            toolSession.setAttribute("citation.citation_helper_initialized", (Object)Boolean.toString(true));
        } else {
            Mode mode = (Mode)state.getAttribute("citation.helper.mode");
            if (mode == null) {
                this.setMode(state, Mode.NEW_RESOURCE);
            }
        }
        if (state.getAttribute("citation.results_page_size") == null) {
            state.setAttribute("citation.results_page_size", (Object)DEFAULT_RESULTS_PAGE_SIZE);
        }
        if (state.getAttribute("citation.list_page_size") == null) {
            state.setAttribute("citation.list_page_size", (Object)defaultListPageSize);
        }
        return true;
    }

    protected ContentResource createTemporaryResource(ResourceToolActionPipe pipe) {
        try {
            ContentResourceEdit newItem = this.getContentService().addResource(pipe.getContentEntity().getId(), rb.getString("new.citations.list"), null, 100);
            this.getCitationService();
            newItem.setResourceType("org.sakaiproject.citation.impl.CitationList");
            newItem.setContentType("text/html");
            ResourcePropertiesEdit props = newItem.getPropertiesEdit();
            this.getContentService();
            props.addProperty("sakai:reference-root", "/citation");
            props.addProperty("DAV:getcontenttype", "text/html");
            this.getCitationService();
            props.addProperty("citations.temporary_citation_list", Boolean.TRUE.toString());
            CitationCollection collection = this.getCitationService().addCollection();
            newItem.setContent(collection.getId().getBytes());
            newItem.setContentType("text/html");
            this.getContentService().commitResource(newItem, 0);
            return newItem;
        }
        catch (PermissionException e) {
            logger.warn((Object)"PermissionException ", (Throwable)e);
        }
        catch (IdUniquenessException e) {
            logger.warn((Object)"IdUniquenessException ", (Throwable)e);
        }
        catch (IdLengthException e) {
            logger.warn((Object)"IdLengthException ", (Throwable)e);
        }
        catch (IdInvalidException e) {
            logger.warn((Object)"IdInvalidException ", (Throwable)e);
        }
        catch (IdUnusedException e) {
            logger.warn((Object)"IdUnusedException ", (Throwable)e);
        }
        catch (OverQuotaException e) {
            logger.warn((Object)e.getMessage());
            pipe.setErrorEncountered(true);
            pipe.setErrorMessage(rb.getString("action.create.quota"));
        }
        catch (ServerOverloadException e) {
            logger.warn((Object)"ServerOverloadException ", (Throwable)e);
        }
        return null;
    }

    protected String validateURL(String url) throws MalformedURLException {
        if (url == null || url.trim().equals("")) {
            throw new MalformedURLException();
        }
        if ((url = url.trim()).indexOf("://") == -1) {
            url = "http://" + url;
        }
        try {
            URL uRL = new URL(url);
        }
        catch (MalformedURLException e1) {
            try {
                Pattern pattern = Pattern.compile("\\s*([a-zA-Z0-9]+)://([^\\n]+)");
                Matcher matcher = pattern.matcher(url);
                if (!matcher.matches()) {
                    throw e1;
                }
                URL uRL = new URL("http://" + matcher.group(2));
            }
            catch (MalformedURLException e2) {
                throw e1;
            }
        }
        return url;
    }

    protected void cleanup(ToolSession toolSession, String prefix, SessionState sessionState) {
        Enumeration attributeNames = toolSession.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String aName = (String)attributeNames.nextElement();
            if (!aName.startsWith(prefix)) continue;
            toolSession.removeAttribute(aName);
        }
        VelocityPortletPaneledAction.enableObservers((SessionState)sessionState);
    }

    public void doSortCollection(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        int requestStateId = params.getInt("requestStateId", 0);
        CitationHelperAction.restoreRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."}, (int)requestStateId);
        String citationCollectionId = params.getString("citationCollectionId");
        String sort = params.getString("currentSort");
        if (sort == null || sort.trim().equals("")) {
            sort = "title";
        }
        CitationCollection collection = null;
        if (citationCollectionId == null) {
            citationCollectionId = (String)state.getAttribute("citation.citation_collection_id");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("doSortCollection sort type  = " + sort));
        }
        if ((collection = this.getCitationCollection(state, false)) == null) {
            logger.warn((Object)("doSortCollection() collection null: " + citationCollectionId));
        } else {
            logger.debug((Object)"doSortCollection() ready to sort");
            if (sort.equalsIgnoreCase("title")) {
                collection.setSort("title", true);
            } else if (sort.equalsIgnoreCase("author")) {
                collection.setSort("author", true);
            } else if (sort.equalsIgnoreCase("year")) {
                collection.setSort("year", true);
            } else if (sort.equalsIgnoreCase("position")) {
                collection.setSort("position", true);
            }
            state.setAttribute("citation.sort", (Object)sort);
            for (Citation tempCit : collection) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)"doSortCollection() tempcit 1 -------------");
                logger.debug((Object)("doSortCollection() tempcit 1 (author) = " + tempCit.getFirstAuthor()));
                logger.debug((Object)("doSortCollection() tempcit 1 (year)   = " + tempCit.getYear()));
                logger.debug((Object)("doSortCollection() tempcit 1 = " + tempCit.getDisplayName()));
            }
            CitationIterator listIterator = (CitationIterator)state.getAttribute("citation.list_iterator");
            if (listIterator != null) {
                listIterator.setStart(0);
            }
        }
        this.setMode(state, Mode.NEW_RESOURCE);
    }

    public void doSaveCollection(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        ParameterParser params = data.getParameters();
        int requestStateId = params.getInt("requestStateId", 0);
        CitationHelperAction.restoreRequestState((SessionState)state, (String[])new String[]{"resources.request.", "citation."}, (int)requestStateId);
        String citationCollectionId = params.getString("citationCollectionId");
        CitationCollection collection = null;
        if (citationCollectionId == null) {
            citationCollectionId = (String)state.getAttribute("citation.citation_collection_id");
        }
        if ((collection = this.getCitationCollection(state, false)) == null) {
            logger.warn((Object)("doSaveCollection() collection null: " + citationCollectionId));
            return;
        }
        this.getCitationService().save(collection);
        String sort = collection.getSort();
        if (sort != null) {
            state.setAttribute("citation.sort", (Object)sort);
        }
        this.setMode(state, Mode.NEW_RESOURCE);
    }

    public static int preserveRequestState(SessionState state, String[] prefixes) {
        Tool tool;
        Object url;
        HashMap<String, Object> requestState = new HashMap<String, Object>();
        int requestStateId = 0;
        while (requestStateId == 0) {
            requestStateId = (int)(Math.random() * 2.147483647E9);
        }
        List attrNames = state.getAttributeNames();
        block1: for (String attrName : attrNames) {
            for (String prefix : prefixes) {
                if (!attrName.startsWith(prefix)) continue;
                requestState.put(attrName, state.getAttribute(attrName));
                continue block1;
            }
        }
        Object pipe = state.getAttribute("resourceToolAction.action_pipe");
        if (pipe != null) {
            requestState.put("resourceToolAction.action_pipe", pipe);
        }
        if ((url = state.getAttribute((tool = CitationHelperAction.getToolManager().getCurrentTool()).getId() + "sakai.tool.helper.done.url")) != null) {
            requestState.put(tool.getId() + "sakai.tool.helper.done.url", url);
        }
        state.setAttribute("resources.sys." + requestStateId, requestState);
        logger.debug((Object)("preserveRequestState() requestStateId == " + requestStateId + "\n" + requestState));
        return requestStateId;
    }

    public static void restoreRequestState(SessionState state, String[] prefixes, int requestStateId) {
        Map requestState = (Map)state.removeAttribute("resources.sys." + requestStateId);
        logger.debug((Object)("restoreRequestState() requestStateId == " + requestStateId + "\n" + requestState));
        if (requestState != null) {
            List attrNames = state.getAttributeNames();
            block0: for (String string : attrNames) {
                for (String prefix : prefixes) {
                    if (!string.startsWith(prefix)) continue;
                    state.removeAttribute(string);
                    continue block0;
                }
            }
            for (Map.Entry entry : requestState.entrySet()) {
                state.setAttribute((String)entry.getKey(), entry.getValue());
            }
        }
    }

    protected Map<String, Object> getProperties(ContentEntity entity, SessionState state) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        ResourceProperties properties = entity.getProperties();
        Reference ref = this.getEntityManager().newReference(entity.getReference());
        DateFormat df = DateFormat.getDateTimeInstance();
        props.put("isHidden", new Boolean(entity.isHidden()));
        Date releaseDate = null;
        if (entity.getReleaseDate() == null) {
            releaseDate = new Date(System.currentTimeMillis());
            props.put("useReleaseDate", Boolean.FALSE);
        } else {
            releaseDate = new Date(entity.getReleaseDate().getTime());
            props.put("useReleaseDate", Boolean.TRUE);
        }
        props.put("releaseDateStr", df.format(releaseDate));
        props.put("releaseDate", releaseDate);
        Date retractDate = null;
        if (entity.getRetractDate() == null) {
            retractDate = new Date(System.currentTimeMillis() + 604800000L);
            props.put("useRetractDate", Boolean.FALSE);
        } else {
            retractDate = new Date(entity.getRetractDate().getTime());
            props.put("useRetractDate", Boolean.TRUE);
        }
        props.put("retractDateStr", df.format(retractDate));
        props.put("retractDate", retractDate);
        props.put("isCollection", entity.isCollection());
        props.put("isDropbox", new Boolean(this.getContentService().isInDropbox(entity.getId())));
        props.put("isSiteCollection", new Boolean(ref.getContext() != null && ref.getContext().equals(entity.getId())));
        props.put("isPubview", this.getContentService().isPubView(entity.getId()));
        props.put("isPubviewInherited", new Boolean(this.getContentService().isInheritingPubView(entity.getId())));
        Boolean preventPublicDisplay = (Boolean)state.getAttribute("resources.request.prevent_public_display");
        if (preventPublicDisplay == null) {
            preventPublicDisplay = Boolean.FALSE;
        }
        props.put("isPubviewPossible", new Boolean(preventPublicDisplay == false));
        GroupAwareEntity.AccessMode accessMode = entity.getAccess();
        props.put("accessMode", accessMode);
        props.put("isGroupInherited", GroupAwareEntity.AccessMode.GROUPED == entity.getInheritedAccess());
        SiteService siteService = (SiteService)ComponentManager.get(SiteService.class);
        TreeSet<String> currentGroups = new TreeSet<String>();
        if (GroupAwareEntity.AccessMode.GROUPED == accessMode) {
            for (Group gr : entity.getGroupObjects()) {
                currentGroups.add(gr.getId());
            }
        }
        Collection inheritedGroupObjs = null;
        if (entity.getInheritedAccess() == GroupAwareEntity.AccessMode.GROUPED) {
            inheritedGroupObjs = entity.getInheritedGroupObjects();
        } else {
            try {
                Site site = siteService.getSite(ref.getContext());
                inheritedGroupObjs = site.getGroups();
            }
            catch (IdUnusedException e) {
                logger.warn((Object)("IdUnusedException in getProperties() " + (Object)((Object)e)));
            }
        }
        ArrayList groups = new ArrayList();
        if (inheritedGroupObjs != null) {
            Collection groupsWithRemovePermission = null;
            if (GroupAwareEntity.AccessMode.GROUPED == accessMode) {
                Collection more;
                groupsWithRemovePermission = this.contentService.getGroupsWithRemovePermission(entity.getId());
                String container = ref.getContainer();
                if (container != null && (more = this.contentService.getGroupsWithRemovePermission(container)) != null && !more.isEmpty()) {
                    groupsWithRemovePermission.addAll(more);
                }
            } else if (GroupAwareEntity.AccessMode.GROUPED == entity.getInheritedAccess()) {
                groupsWithRemovePermission = this.contentService.getGroupsWithRemovePermission(ref.getContainer());
            } else if (ref.getContext() != null && this.contentService.getSiteCollection(ref.getContext()) != null) {
                groupsWithRemovePermission = this.contentService.getGroupsWithRemovePermission(this.contentService.getSiteCollection(ref.getContext()));
            }
            TreeSet<String> idsOfGroupsWithRemovePermission = new TreeSet<String>();
            if (groupsWithRemovePermission != null) {
                for (Group gr : groupsWithRemovePermission) {
                    idsOfGroupsWithRemovePermission.add(gr.getId());
                }
            }
            for (Group group : inheritedGroupObjs) {
                HashMap<String, String> grp = new HashMap<String, String>();
                grp.put("groupId", group.getId());
                grp.put("title", group.getTitle());
                grp.put("description", group.getDescription());
                grp.put("entityRef", group.getReference());
                if (currentGroups.contains(group.getId())) {
                    grp.put("isLocal", Boolean.toString(true));
                }
                if (idsOfGroupsWithRemovePermission.contains(group.getId())) {
                    grp.put("allowedRemove", Boolean.toString(true));
                }
                groups.add(grp);
            }
        }
        props.put("possibleGroups", groups);
        props.put("isGroupPossible", new Boolean(groups != null && groups.size() > 0));
        props.put("isSingleGroupInherited", new Boolean(groups != null && groups.size() == 1));
        props.put("isSiteOnly", new Boolean(preventPublicDisplay != false && (groups == null || groups.size() < 1)));
        props.put("isUserSite", siteService.isUserSite(ref.getContext()));
        state.setAttribute("citation.citationList_properties", props);
        return props;
    }

    protected CitationService getCitationService() {
        if (this.citationService == null) {
            this.citationService = (CitationService)ComponentManager.get(CitationService.class);
        }
        return this.citationService;
    }

    protected ConfigurationService getConfigurationService() {
        if (this.configurationService == null) {
            this.configurationService = (ConfigurationService)ComponentManager.get(ConfigurationService.class);
        }
        return this.configurationService;
    }

    protected SearchManager getSearchManager() {
        if (this.searchManager == null) {
            this.searchManager = (SearchManager)ComponentManager.get(SearchManager.class);
        }
        return this.searchManager;
    }

    protected ContentHostingService getContentService() {
        if (this.contentService == null) {
            this.contentService = (ContentHostingService)ComponentManager.get((String)"org.sakaiproject.content.api.ContentHostingService");
        }
        return this.contentService;
    }

    protected EntityManager getEntityManager() {
        if (this.entityManager == null) {
            this.entityManager = (EntityManager)ComponentManager.get(EntityManager.class);
        }
        return this.entityManager;
    }

    protected SessionManager getSessionManager() {
        if (this.sessionManager == null) {
            this.sessionManager = (SessionManager)ComponentManager.get(SessionManager.class);
        }
        return this.sessionManager;
    }

    protected static ToolManager getToolManager() {
        if (toolManager == null) {
            toolManager = (ToolManager)ComponentManager.get(ToolManager.class);
        }
        return toolManager;
    }

    protected static FormattedText getFormattedText() {
        if (formattedText == null) {
            formattedText = (FormattedText)ComponentManager.get(FormattedText.class);
        }
        return formattedText;
    }

    static {
        DEFAULT_RESULTS_PAGE_SIZE = new Integer(10);
        defaultListPageSize = DEFAULT_LIST_PAGE_SIZE = new Integer(50);
        ignoreModes = new HashSet();
        ignoreModes.add(Mode.DATABASE);
        ignoreModes.add(Mode.MESSAGE);
    }
}

