/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.citation.tool;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.cheftool.JetspeedRunData;
import org.sakaiproject.cheftool.RunData;
import org.sakaiproject.citation.tool.CitationHelperAction;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.event.api.SessionState;
import org.sakaiproject.event.cover.UsageSessionService;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.tool.api.Placement;
import org.sakaiproject.tool.cover.ToolManager;

public class EditorIntegrationHelperAction
extends CitationHelperAction {
    protected static final Log m_log = LogFactory.getLog(EditorIntegrationHelperAction.class);
    protected static String DELIMITER = " : ";
    protected static String DEFAULT_HELPER_NAME = "Search Library Resources";

    public void doIntegrationSearch(RunData data) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        m_log.debug((Object)"doIntegrationSearch()");
        this.setCaller(state, CitationHelperAction.Caller.EDITOR_INTEGRATION);
        this.doSearchCommon(state, CitationHelperAction.Mode.ERROR);
    }

    protected SessionState getState(HttpServletRequest req) {
        SessionState rv;
        String key = this.getPid(req);
        if (key == null) {
            key = this.toString() + ".";
            m_log.warn((Object)("getState(): using servlet key: " + key));
        }
        if ((rv = UsageSessionService.getSessionState((String)(key = key + ".org.sakaiproject.citation.tool.EditorIntegrationHelperAction"))) == null) {
            m_log.warn((Object)("getState(): no state found for key: " + key + " " + req.getPathInfo() + " " + req.getQueryString() + " " + req.getRequestURI()));
        }
        return rv;
    }

    protected void setVmStdRef(HttpServletRequest request, HttpServletResponse response) {
        super.setVmStdRef(request, response);
        request.setAttribute("toolTitle", (Object)this.getPageTitle());
    }

    private String getPageTitle() {
        String siteTitle;
        StringBuilder pageTitle = new StringBuilder();
        boolean addedHelper = false;
        String sakaiInstance = ServerConfigurationService.getString((String)"ui.service", (String)"Sakai");
        if (!this.isNull(sakaiInstance)) {
            pageTitle.append(sakaiInstance);
        }
        Placement placement = ToolManager.getCurrentPlacement();
        Site site = null;
        try {
            site = SiteService.getSite((String)placement.getContext());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (site != null && !this.isNull(siteTitle = site.getTitle())) {
            if (pageTitle.length() > 0) {
                pageTitle.append(DELIMITER);
            }
            pageTitle.append(siteTitle);
        }
        try {
            String toolTitle = placement.getTitle();
            if (!this.isNull(toolTitle)) {
                if (pageTitle.length() > 0) {
                    pageTitle.append(DELIMITER);
                }
                pageTitle.append(toolTitle);
            }
        }
        catch (Exception toolTitle) {
            // empty catch block
        }
        try {
            String helperTitle = ToolManager.getCurrentTool().getTitle();
            if (!this.isNull(helperTitle)) {
                if (pageTitle.length() > 0) {
                    pageTitle.append(DELIMITER);
                }
                pageTitle.append(helperTitle);
                addedHelper = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!addedHelper) {
            if (pageTitle.length() > 0) {
                pageTitle.append(DELIMITER);
            }
            pageTitle.append(DEFAULT_HELPER_NAME);
        }
        return pageTitle.toString();
    }

    private boolean isNull(String string) {
        return string == null || string.trim().length() == 0;
    }
}

