/*
 * Decompiled with CFR 0.152.
 */
package edu.indiana.lib.osid.base.repository.http;

import edu.indiana.lib.osid.base.repository.http.Part;
import edu.indiana.lib.osid.base.repository.http.PartIterator;
import edu.indiana.lib.osid.base.repository.http.RecordStructure;
import edu.indiana.lib.twinpeaks.util.LogUtils;
import java.io.Serializable;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.osid.id.IdManager;
import org.osid.repository.RepositoryException;
import org.osid.shared.Id;

public class Record
extends edu.indiana.lib.osid.base.repository.Record {
    private static Log _log = LogUtils.getLog(Record.class);
    private Vector partVector = new Vector();
    private IdManager idManager = null;
    private Id recordStructureId = null;
    private String displayName = null;
    private Id id = null;

    @Override
    public String getDisplayName() throws RepositoryException {
        return this.displayName;
    }

    @Override
    public Id getId() throws RepositoryException {
        return this.id;
    }

    protected Record(Id recordStructureId, IdManager idManager) throws RepositoryException {
        try {
            this.idManager = idManager;
            this.recordStructureId = recordStructureId;
            this.id = idManager.createId();
        }
        catch (Throwable t) {
            _log.error((Object)t.getMessage());
            throw new RepositoryException("Operation failed ");
        }
    }

    @Override
    public org.osid.repository.Part createPart(Id partStructureId, Serializable value) throws RepositoryException {
        try {
            Part part = new Part(partStructureId, value, this.idManager);
            this.partVector.addElement(part);
            return part;
        }
        catch (Throwable t) {
            _log.error((Object)t.getMessage());
            throw new RepositoryException("Operation failed ");
        }
    }

    @Override
    public void deletePart(Id partId) throws RepositoryException {
        try {
            int size = this.partVector.size();
            for (int i = 0; i < size; ++i) {
                org.osid.repository.Part part = (org.osid.repository.Part)this.partVector.elementAt(i);
                if (!part.getId().isEqual(partId)) continue;
                this.partVector.removeElementAt(i);
                return;
            }
            throw new RepositoryException("Unknown Id ");
        }
        catch (Throwable t) {
            _log.error((Object)t.getMessage());
            throw new RepositoryException("Operation failed ");
        }
    }

    @Override
    public org.osid.repository.PartIterator getParts() throws RepositoryException {
        return new PartIterator(this.partVector);
    }

    @Override
    public org.osid.repository.RecordStructure getRecordStructure() throws RepositoryException {
        try {
            if (this.recordStructureId.isEqual(RecordStructure.getInstance().getId())) {
                return new RecordStructure();
            }
            return null;
        }
        catch (Throwable t) {
            _log.error((Object)t.getMessage());
            throw new RepositoryException("Operation failed ");
        }
    }

    @Override
    public boolean isMultivalued() throws RepositoryException {
        return false;
    }
}

