/*
 * Decompiled with CFR 0.152.
 */
package edu.indiana.lib.twinpeaks.net;

import edu.indiana.lib.twinpeaks.util.LogUtils;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.HashMap;
import org.apache.commons.logging.Log;

public class HttpAuthenticator
extends Authenticator {
    private static Log _log = LogUtils.getLog(HttpAuthenticator.class);
    private HashMap credentialMap = new HashMap();

    public synchronized void setCredentials(String realm, String username, String password) {
        this.credentialMap.put(realm, new Credentials(username, password));
    }

    @Override
    protected synchronized PasswordAuthentication getPasswordAuthentication() {
        _log.debug((Object)("Authorization requested for \"" + this.getRequestingPrompt() + "\", scheme: \"" + this.getRequestingScheme() + "\", site: \"" + this.getRequestingSite() + "\""));
        Credentials credential = (Credentials)this.credentialMap.get(this.getRequestingPrompt());
        if (credential == null) {
            _log.warn((Object)"No credentials configured");
            return null;
        }
        int attempts = credential.getAuthorizationAttempts() + 1;
        credential.setAuthorizationAttempts(attempts);
        if (attempts > 1) {
            if (attempts % 3 == 0) {
                credential.setAuthorizationAttempts(0);
            }
            _log.warn((Object)"Authorization refused");
            return null;
        }
        _log.warn((Object)"Returning credentials for authorization");
        return new PasswordAuthentication(credential.getUsername(), credential.getPassword());
    }

    private static class Credentials {
        private String username;
        private char[] password;
        private int attempts;

        private Credentials() {
        }

        public Credentials(String username, String password) {
            this.username = username;
            this.password = password.toCharArray();
            this.attempts = 0;
        }

        public String getUsername() {
            return this.username;
        }

        public char[] getPassword() {
            return this.password;
        }

        public synchronized void setAuthorizationAttempts(int value) {
            this.attempts = value;
        }

        public synchronized int getAuthorizationAttempts() {
            return this.attempts;
        }
    }
}

