/*
 * Decompiled with CFR 0.152.
 */
package edu.indiana.lib.twinpeaks.search;

import edu.indiana.lib.twinpeaks.search.QueryBase;
import edu.indiana.lib.twinpeaks.search.SearchResultBase;
import edu.indiana.lib.twinpeaks.util.DomException;
import edu.indiana.lib.twinpeaks.util.DomUtils;
import edu.indiana.lib.twinpeaks.util.LogUtils;
import edu.indiana.lib.twinpeaks.util.SearchException;
import edu.indiana.lib.twinpeaks.util.StringUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SearchSource {
    private static Log _log = LogUtils.getLog(SearchSource.class);
    private static final int ENABLED = 1;
    private static HashMap _globalMap;
    private String _name;
    private String _id;
    private String _description;
    private String _queryClassName;
    private Class _queryClass;
    private String _searchResultClassName;
    private Class _searchResultClass;
    private String _authority;
    private String _domain;
    private String _searchType;
    private String _typeDescription;
    private HashMap _parameterMap;
    private int _flags;
    private static ArrayList _sourceList;
    private static Object _sourceSync;

    private SearchSource() {
    }

    private SearchSource(String name, String description, String id, String authority, String domain, String searchType, String typeDescription, String queryClassName, String searchResultClassName, HashMap parameterMap, int flags) {
        this._name = name;
        this._description = description;
        this._id = id;
        this._authority = authority;
        this._domain = domain;
        this._searchType = searchType;
        this._typeDescription = typeDescription;
        this._queryClassName = queryClassName;
        this._searchResultClassName = searchResultClassName;
        this._parameterMap = parameterMap;
        this._flags = flags;
        _log.debug((Object)("*************** name + parameters = " + this._parameterMap));
    }

    public String getName() {
        return this._name;
    }

    public String getId() {
        return this._id;
    }

    public String getAuthority() {
        return this._authority;
    }

    public String getDomain() {
        return this._domain;
    }

    public String getSearchType() {
        return this._searchType;
    }

    public String getTypeDescription() {
        return this._typeDescription;
    }

    public String getDescription() {
        return this._description;
    }

    public boolean isEnabled() {
        return (this._flags & 1) == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryBase getQueryHandler() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        SearchSource searchSource = this;
        synchronized (searchSource) {
            if (this._queryClass == null) {
                this._queryClass = Class.forName(this._queryClassName);
            }
            return (QueryBase)this._queryClass.newInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getQueryHandlerClassName() {
        SearchSource searchSource = this;
        synchronized (searchSource) {
            return this._queryClassName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchResultBase getSearchResultHandler() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        SearchSource searchSource = this;
        synchronized (searchSource) {
            if (this._searchResultClass == null) {
                this._searchResultClass = Class.forName(this._searchResultClassName);
            }
            return (SearchResultBase)this._searchResultClass.newInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSearchResultHandlerClassName() {
        SearchSource searchSource = this;
        synchronized (searchSource) {
            return this._searchResultClassName;
        }
    }

    private static void setGlobalConfiguationValue(Document document, String name) {
        String text;
        Element element = DomUtils.getElement(document.getDocumentElement(), name);
        if (element != null && !StringUtils.isNull(text = element.getAttribute("name"))) {
            _globalMap.put(name, text);
        }
    }

    public static String getGlobalConfigurationValue(String name) {
        return _globalMap == null ? null : (String)_globalMap.get(name);
    }

    public static String getMandatoryGlobalConfigurationValue(String name) {
        String value = SearchSource.getGlobalConfigurationValue(name);
        if (value == null) {
            throw new ConfigurationException("Global configuration item \"" + name + "\" is not defined");
        }
        return value;
    }

    public synchronized String getConfiguredParameter(String name) {
        return this._parameterMap == null ? null : (String)this._parameterMap.get(name);
    }

    public static String getConfiguredParameter(String name, String parameterName) {
        SearchSource source = SearchSource.getSourceByName(name);
        return source.getConfiguredParameter(parameterName);
    }

    public static String getMandatoryParameter(String name, String parameterName) {
        SearchSource source = SearchSource.getSourceByName(name);
        String value = source.getConfiguredParameter(parameterName);
        if (value == null) {
            throw new ConfigurationException("\"" + parameterName + "\" parameter undefined for search source: " + name);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SearchSource getSourceByName(String name) {
        SearchSource.verifyList();
        Object object = _sourceSync;
        synchronized (object) {
            for (SearchSource source : _sourceList) {
                if (!source.getName().equalsIgnoreCase(name)) continue;
                return source;
            }
        }
        throw new ConfigurationException("Unknown search source: " + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDefaultSourceName() {
        SearchSource.verifyList();
        Object object = _sourceSync;
        synchronized (object) {
            return ((SearchSource)_sourceList.get(0)).getName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator getSearchListIterator() {
        SearchSource.verifyList();
        Object object = _sourceSync;
        synchronized (object) {
            return _sourceList.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void populate(InputStream xmlStream) throws DomException, SearchException {
        _log.debug((Object)"SearchSource.populate() starts --------------------------");
        Object object = _sourceSync;
        synchronized (object) {
            Document document;
            if (_sourceList != null) {
                _log.debug((Object)"No action required");
                return;
            }
            _sourceList = new ArrayList();
            _log.debug((Object)"Populating configuration");
            try {
                document = DomUtils.parseXmlStream(xmlStream);
                _log.info((Object)DomUtils.serialize(document));
            }
            catch (Exception exception) {
                _log.error((Object)"DOM parse exception");
                exception.printStackTrace();
                throw new RuntimeException("DOM error");
            }
            _globalMap = new HashMap();
            SearchSource.setGlobalConfiguationValue(document, "osid_20_Id_Implementation");
            NodeList sourceNodeList = DomUtils.getElementList(document.getDocumentElement(), "source");
            int length = sourceNodeList.getLength();
            for (int i = 0; i < length; ++i) {
                Element sourceElement = (Element)sourceNodeList.item(i);
                String sourceName = sourceElement.getAttribute("name");
                if (StringUtils.isNull(sourceName)) {
                    _log.warn((Object)"Skipping un-named <source> element");
                    continue;
                }
                String description = SearchSource.parseHandler(sourceElement, "description");
                if (description == null) {
                    _log.warn((Object)("Missing <description> in source \"" + sourceName + "\""));
                    continue;
                }
                String id = SearchSource.parseHandler(sourceElement, "id");
                if (id == null) {
                    _log.warn((Object)("Missing <id> in source \"" + sourceName + "\""));
                    continue;
                }
                String queryHandler = SearchSource.parseHandler(sourceElement, "queryhandler");
                if (queryHandler == null) {
                    _log.warn((Object)("Missing <queryhandler> in source \"" + sourceName + "\""));
                    continue;
                }
                String searchResultHandler = SearchSource.parseHandler(sourceElement, "responsehandler");
                if (searchResultHandler == null) {
                    _log.warn((Object)("Missing <responsehandler> in source \"" + sourceName + "\""));
                    continue;
                }
                String authority = SearchSource.parseHandler(sourceElement, "authority");
                if (authority == null) {
                    _log.warn((Object)("Missing <authority> in source \"" + sourceName + "\""));
                    continue;
                }
                String domain = SearchSource.parseHandler(sourceElement, "domain");
                if (domain == null) {
                    _log.warn((Object)("Missing <domain> in source \"" + sourceName + "\""));
                    continue;
                }
                String searchType = SearchSource.parseHandler(sourceElement, "searchtype");
                if (searchType == null) {
                    _log.warn((Object)("Missing <searchtype> in source \"" + sourceName + "\""));
                    continue;
                }
                String typeDescription = SearchSource.parseHandler(sourceElement, "searchdescription");
                if (typeDescription == null) {
                    _log.warn((Object)("Missing <searchdescription> in source \"" + sourceName + "\""));
                    continue;
                }
                int flags = 0;
                Element element = DomUtils.getElement(sourceElement, "options");
                if (element != null && "true".equalsIgnoreCase(element.getAttribute("enabled"))) {
                    flags |= 1;
                }
                HashMap<String, String> parameterMap = null;
                NodeList parameterList = DomUtils.getElementList(sourceElement, "parameter");
                if (parameterList != null) {
                    for (int j = 0; j < parameterList.getLength(); ++j) {
                        element = (Element)parameterList.item(j);
                        String name = element.getAttribute("name");
                        String value = element.getAttribute("value");
                        if (StringUtils.isNull(name)) {
                            throw new SearchException("Invalid configuration parameter, source: \"" + sourceName + "\", <parameter name=\"" + name + "\" value=\"" + value + "\">");
                        }
                        if (parameterMap == null) {
                            parameterMap = new HashMap<String, String>();
                        }
                        parameterMap.put(name, value);
                    }
                }
                SearchSource.addSource(new SearchSource(sourceName, description, id, authority, domain, searchType, typeDescription, queryHandler, searchResultHandler, parameterMap, flags), _sourceList);
            }
        }
        _log.debug((Object)"SearchSource.populate() ends --------------------------");
        if (_sourceList.size() == 0) {
            throw new SearchException("No Repositories were configured");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSourceListPopulated() {
        Object object = _sourceSync;
        synchronized (object) {
            return _sourceList != null && !_sourceList.isEmpty();
        }
    }

    private static String parseHandler(Element parent, String handlerName) {
        Element element = DomUtils.getElement(parent, handlerName);
        if (element == null) {
            return null;
        }
        String handler = element.getAttribute("name");
        return StringUtils.isNull(handler) ? null : handler;
    }

    private static void verifyList() {
        if (!SearchSource.isSourceListPopulated()) {
            throw new SearchException("No search handlers have ben configured");
        }
    }

    private static void addSource(SearchSource source, ArrayList list) {
        list.add(source);
    }

    static {
        _sourceList = null;
        _sourceSync = new Object();
    }

    private static class ConfigurationException
    extends RuntimeException {
        public ConfigurationException(String text) {
            super(text);
        }

        public ConfigurationException() {
            super("");
        }
    }
}

