/*
 * Decompiled with CFR 0.152.
 */
package edu.indiana.lib.twinpeaks.search.singlesearch.web2;

import edu.indiana.lib.osid.base.repository.http.CreatorPartStructure;
import edu.indiana.lib.osid.base.repository.http.DOIPartStructure;
import edu.indiana.lib.osid.base.repository.http.DataSource;
import edu.indiana.lib.osid.base.repository.http.DatePartStructure;
import edu.indiana.lib.osid.base.repository.http.EditionPartStructure;
import edu.indiana.lib.osid.base.repository.http.EndPagePartStructure;
import edu.indiana.lib.osid.base.repository.http.InLineCitationPartStructure;
import edu.indiana.lib.osid.base.repository.http.IsnIdentifierPartStructure;
import edu.indiana.lib.osid.base.repository.http.IssuePartStructure;
import edu.indiana.lib.osid.base.repository.http.LanguagePartStructure;
import edu.indiana.lib.osid.base.repository.http.PagesPartStructure;
import edu.indiana.lib.osid.base.repository.http.PreferredUrlPartStructure;
import edu.indiana.lib.osid.base.repository.http.PublisherPartStructure;
import edu.indiana.lib.osid.base.repository.http.SourceTitlePartStructure;
import edu.indiana.lib.osid.base.repository.http.StartPagePartStructure;
import edu.indiana.lib.osid.base.repository.http.SubjectPartStructure;
import edu.indiana.lib.osid.base.repository.http.TypePartStructure;
import edu.indiana.lib.osid.base.repository.http.URLPartStructure;
import edu.indiana.lib.osid.base.repository.http.VolumePartStructure;
import edu.indiana.lib.osid.base.repository.http.YearPartStructure;
import edu.indiana.lib.twinpeaks.search.MatchItem;
import edu.indiana.lib.twinpeaks.search.PreferredUrlHandler;
import edu.indiana.lib.twinpeaks.search.QueryBase;
import edu.indiana.lib.twinpeaks.search.SearchResultBase;
import edu.indiana.lib.twinpeaks.util.DomUtils;
import edu.indiana.lib.twinpeaks.util.LogUtils;
import edu.indiana.lib.twinpeaks.util.SearchException;
import edu.indiana.lib.twinpeaks.util.SessionContext;
import edu.indiana.lib.twinpeaks.util.StatusUtils;
import edu.indiana.lib.twinpeaks.util.StringUtils;
import java.io.Serializable;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.osid.repository.RepositoryException;
import org.osid.shared.Id;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Web2Response
extends SearchResultBase {
    private static Log _log = LogUtils.getLog(Web2Response.class);
    private SessionContext sessionContext;

    @Override
    public void initialize(QueryBase query) {
        super.initialize(query);
        this.sessionContext = SessionContext.getInstance(this._sessionId);
    }

    @Override
    protected Document parseResponse() throws SearchException {
        try {
            return DomUtils.parseXmlBytes(this._searchResponseBytes);
        }
        catch (Exception exception) {
            throw new SearchException(exception.toString());
        }
    }

    @Override
    public void doParse() {
        Document responseDocument = this.getSearchResponseDocument();
        Element resultElement = DomUtils.getElement(responseDocument.getDocumentElement(), "RESULTS");
        NodeList recordList = DomUtils.getElementList(resultElement, "RECORD");
        for (int i = 0; i < recordList.getLength(); ++i) {
            String description;
            Element recordElement = (Element)recordList.item(i);
            String recordType = recordElement.getAttribute("type");
            if (!StringUtils.isNull(recordType)) {
                if (recordType.equalsIgnoreCase("error")) {
                    String status = recordElement.getAttribute("status");
                    Element element = DomUtils.getElement(recordElement, "DATA");
                    String text = DomUtils.getText(element);
                    if (StringUtils.isNull(status)) {
                        status = "<unknown>";
                    }
                    if (text == null) {
                        text = "";
                    }
                    StatusUtils.setGlobalError(this.sessionContext, status, text);
                    _log.error((Object)"Error RECORD found");
                    this.displayXml(recordElement);
                    throw new SearchException(status);
                }
                _log.debug((Object)("Skipping RECORD with non-null TYPE \"" + recordType + "\""));
                continue;
            }
            String hit = recordElement.getAttribute("hit");
            String target = recordElement.getAttribute("sourceID");
            String database = recordElement.getAttribute("source");
            String recordId = recordElement.getAttribute("identifier");
            StatusUtils.updateHits(this.sessionContext, target);
            Element dataElement = DomUtils.getElement(recordElement, "DATA");
            if (dataElement == null) {
                _log.error((Object)"No DATA element present in server response");
                this.displayXml(recordElement);
                throw new SearchException("Missing mandatory <DATA> element in server response");
            }
            String title = this.getText(dataElement, "TITLE");
            if (StringUtils.isNull(title)) {
                _log.debug((Object)"No TITLE text in server response");
                title = "";
            }
            if (StringUtils.isNull(description = this.getText(dataElement, "DESCRIPTION"))) {
                _log.debug((Object)"No DESCRIPTION text in server response");
                description = "";
            }
            MatchItem item = new MatchItem();
            _log.debug((Object)("Adding TITLE: " + title));
            item.setDisplayName(title);
            item.setDescription(description);
            item.setId(recordId);
            this.addPartStructure(dataElement, "PUBLICATION", item, PublisherPartStructure.getPartStructureId());
            this.addPartStructure(dataElement, "LANGUAGE", item, LanguagePartStructure.getPartStructureId());
            if (!(this.addPartStructure(dataElement, "CITATION", item, InLineCitationPartStructure.getPartStructureId()) || this.addPartStructure(dataElement, "SOURCE", item, InLineCitationPartStructure.getPartStructureId()) || this.addPartStructure(dataElement, "DESCRIPTION", item, InLineCitationPartStructure.getPartStructureId()))) {
                this.addPartStructure(dataElement, "TITLE", item, InLineCitationPartStructure.getPartStructureId());
            }
            if (!this.addPartStructure(dataElement, "CITATION-JOURNAL-TITLE", item, SourceTitlePartStructure.getPartStructureId())) {
                this.addPartStructure(dataElement, "SOURCE", item, SourceTitlePartStructure.getPartStructureId());
            }
            this.addPartStructure(dataElement, "CITATION-VOLUME", item, VolumePartStructure.getPartStructureId());
            this.addPartStructure(dataElement, "CITATION-ISSUE", item, IssuePartStructure.getPartStructureId());
            this.addPartStructure(dataElement, "CITATION-PART", item, EditionPartStructure.getPartStructureId());
            this.addPartStructure(dataElement, "CITATION-PAGES", item, PagesPartStructure.getPartStructureId());
            this.addPartStructure(dataElement, "CITATION-START-PAGE", item, StartPagePartStructure.getPartStructureId());
            this.addPartStructure(dataElement, "CITATION-END-PAGE", item, EndPagePartStructure.getPartStructureId());
            this.addPartStructure(dataElement, "CITATION-DATE", item, DatePartStructure.getPartStructureId());
            if (!this.addPartStructure(dataElement, "CITATION-DATE-YEAR", item, YearPartStructure.getPartStructureId())) {
                this.addPartStructure(dataElement, "CITATION-DATE", item, YearPartStructure.getPartStructureId());
            }
            if (!this.addPartStructure(dataElement, "TYPE", item, TypePartStructure.getPartStructureId()) && !this.addPartStructure(dataElement, "PUBLICATION-TYPE", item, TypePartStructure.getPartStructureId()) && this.getText(dataElement, "CITATION-JOURNAL-TITLE") != null) {
                item.addPartStructure(TypePartStructure.getPartStructureId(), (Serializable)((Object)"Journal"));
            }
            this.addPartStructure(dataElement, "URL", item, URLPartStructure.getPartStructureId());
            this.addPartStructure(dataElement, "ISBN", item, IsnIdentifierPartStructure.getPartStructureId());
            this.addPartStructure(dataElement, "ISSN", item, IsnIdentifierPartStructure.getPartStructureId());
            if (!this.addPartStructure(dataElement, "CITATION-DOI", item, DOIPartStructure.getPartStructureId())) {
                this.addPartStructure(dataElement, "DOI", item, DOIPartStructure.getPartStructureId());
            }
            this.addPartStructureList(dataElement, "AUTHOR", item, CreatorPartStructure.getPartStructureId());
            this.addPartStructureList(dataElement, "SUBJECT", item, SubjectPartStructure.getPartStructureId());
            String preferredUrl = PreferredUrlHandler.getUrl(target, dataElement);
            if (preferredUrl != null) {
                this.addPartStructure(item, PreferredUrlPartStructure.getPartStructureId(), preferredUrl);
            }
            this.doRegexParse(database, item);
            this.addItem(item);
        }
    }

    private void doRegexParse(String database, MatchItem item) {
        boolean hasVolume = false;
        boolean hasIssue = false;
        boolean hasDate = false;
        boolean hasYear = false;
        boolean hasStartPage = false;
        boolean hasEndPage = false;
        boolean hasSourceTitle = false;
        try {
            Pattern pattern;
            Matcher matcher;
            String citation = (String)((Object)this.getPartPair(InLineCitationPartStructure.getPartStructureId(), item).getValue());
            DataSource dataSource = new DataSource(database, citation);
            if (!dataSource.findRegExp()) {
                return;
            }
            hasVolume = this.recordHasPart(VolumePartStructure.getPartStructureId(), item);
            hasIssue = this.recordHasPart(IssuePartStructure.getPartStructureId(), item);
            hasDate = this.recordHasPart(DatePartStructure.getPartStructureId(), item);
            hasYear = this.recordHasPart(YearPartStructure.getPartStructureId(), item);
            hasStartPage = this.recordHasPart(StartPagePartStructure.getPartStructureId(), item);
            hasEndPage = this.recordHasPart(EndPagePartStructure.getPartStructureId(), item);
            hasSourceTitle = this.recordHasPart(SourceTitlePartStructure.getPartStructureId(), item);
            if (!hasVolume && (matcher = (pattern = Pattern.compile(dataSource.getVolumeToken())).matcher(citation)).find()) {
                this.addPartStructure(item, VolumePartStructure.getInstance().getId(), matcher.group());
            }
            if (!hasIssue && (matcher = (pattern = Pattern.compile(dataSource.getIssueToken())).matcher(citation)).find()) {
                this.addPartStructure(item, IssuePartStructure.getInstance().getId(), matcher.group().replaceAll("\\D", ""));
            }
            if (!hasDate && (matcher = (pattern = Pattern.compile(dataSource.getDateToken())).matcher(citation)).find()) {
                String date = matcher.group().substring(dataSource.getReplaceStartToken(), matcher.group().length() - dataSource.getReplaceEndToken());
                this.addPartStructure(item, DatePartStructure.getInstance().getId(), date);
            }
            if (!hasYear && (matcher = (pattern = Pattern.compile(dataSource.getYearToken())).matcher(citation)).find()) {
                String year = matcher.group().substring(dataSource.getReplaceStartToken(), matcher.group().length() - dataSource.getReplaceEndToken());
                this.addPartStructure(item, YearPartStructure.getInstance().getId(), year);
            }
            if (!(hasStartPage && hasEndPage || !(matcher = (pattern = Pattern.compile(dataSource.getPagesToken())).matcher(citation)).find())) {
                this.createPagesPart(matcher.group(), item);
            }
            if (!hasSourceTitle && (matcher = (pattern = Pattern.compile(dataSource.getSourceTitleToken())).matcher(citation)).find()) {
                String sourceTitle = matcher.group().substring(0, matcher.group().length() - 1);
                this.addPartStructure(item, SourceTitlePartStructure.getInstance().getId(), sourceTitle);
            }
        }
        catch (RepositoryException e) {
            _log.warn((Object)"doRegexParse() failed", (Throwable)e);
        }
    }

    private void createPagesPart(String text, MatchItem item) throws RepositoryException {
        try {
            if (text == null || text.equals("")) {
                return;
            }
            if (text.charAt(0) == ',') {
                return;
            }
            this.addPartStructure(item, PagesPartStructure.getInstance().getId(), text);
            String[] pages = text.split("-");
            if (pages.length == 0) {
                return;
            }
            String spage = pages[0].trim();
            spage = spage.replaceAll("\\D", "");
            _log.debug((Object)"======================&&&& Start page: spage &&&================");
            this.addPartStructure(item, StartPagePartStructure.getInstance().getId(), spage);
            if (pages.length == 2) {
                String epage = pages[1].trim();
                epage = epage.replaceAll("\\D", "");
                this.addPartStructure(item, EndPagePartStructure.getInstance().getId(), epage);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            _log.warn((Object)"createPagesPart()", (Throwable)e);
        }
    }

    private boolean recordHasPart(Id partStructureId, MatchItem item) {
        return this.getPartPair(partStructureId, item) != null;
    }

    private MatchItem.PartPair getPartPair(Id partStructureId, MatchItem item) {
        Iterator partPairIterator = item.partPairIterator();
        while (partPairIterator.hasNext()) {
            MatchItem.PartPair partPair = (MatchItem.PartPair)partPairIterator.next();
            if (!partPair.getId().equals(partStructureId)) continue;
            return partPair;
        }
        return null;
    }

    private boolean addPartStructureList(Element parentElement, String partDataName, MatchItem item, Id id) {
        return this.addPartStructureList(parentElement, partDataName, null, null, item, id);
    }

    private boolean addPartStructureList(Element parentElement, String partDataName, String partAttributeName, String partAttributeValue, MatchItem item, Id id) {
        NodeList nodeList = DomUtils.getElementList(parentElement, partDataName);
        boolean partsAdded = false;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String text;
            Element element = (Element)nodeList.item(i);
            if (partAttributeName != null && !element.getAttribute(partAttributeName).equals(partAttributeValue) || StringUtils.isNull(text = DomUtils.getText(element))) continue;
            this.addPartStructure(item, id, text);
            partsAdded = true;
        }
        return partsAdded;
    }

    private boolean addPartStructure(MatchItem item, Id id, String value) {
        boolean partAdded = false;
        String text = value;
        if (text != null) {
            text = text.trim();
        }
        if (!StringUtils.isNull(text)) {
            item.addPartStructure(id, (Serializable)((Object)text));
            partAdded = true;
        }
        return partAdded;
    }

    private boolean addPartStructure(Element parentElement, String partDataName, MatchItem item, Id id) {
        String value = this.getText(parentElement, partDataName);
        return this.addPartStructure(item, id, value);
    }

    private String getText(Element parent, String name) {
        Element element = DomUtils.getElement(parent, name);
        String text = null;
        if (element != null) {
            text = DomUtils.getText(element);
        }
        return text;
    }

    private static void displayXml(String errorText, Object xmlObject) {
        try {
            LogUtils.displayXml(_log, errorText, xmlObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void displayXml(Object xmlObject) {
        try {
            LogUtils.displayXml(_log, xmlObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

