/*
 * Decompiled with CFR 0.152.
 */
package edu.indiana.lib.twinpeaks.util;

import edu.indiana.lib.twinpeaks.util.CookieData;
import edu.indiana.lib.twinpeaks.util.LogUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;

public class CookieUtils {
    private static Log _log = LogUtils.getLog(CookieUtils.class);

    private CookieUtils() {
    }

    public static List newCookieList() {
        return new ArrayList();
    }

    public static CookieData parseCookie(URL url, String value) {
        String[] cookieFields = value.split(";\\s*");
        CookieData cookie = CookieUtils.makeCookieData(url, cookieFields[0]);
        for (int j = 1; j < cookieFields.length; ++j) {
            if ("secure".equalsIgnoreCase(cookieFields[j])) {
                cookie.setSecure(true);
                continue;
            }
            if (cookieFields[j].indexOf(61) <= 0) continue;
            String[] field = cookieFields[j].split("=");
            if ("expires".equalsIgnoreCase(field[0])) {
                cookie.setExpires(field[1]);
                continue;
            }
            if ("domain".equalsIgnoreCase(field[0])) {
                cookie.setDomain(field[1]);
                continue;
            }
            if ("path".equalsIgnoreCase(field[0])) {
                cookie.setPath(field[1]);
                continue;
            }
            if ("version".equalsIgnoreCase(field[0])) {
                cookie.setVersion(field[1]);
                continue;
            }
            if (!"max-age".equalsIgnoreCase(field[0])) continue;
            cookie.setMaxAge(field[1]);
        }
        return cookie;
    }

    private static CookieData makeCookieData(URL url, String cookieText) {
        for (int i = 0; i < cookieText.length(); ++i) {
            if (cookieText.charAt(i) != '=') continue;
            String name = cookieText.substring(0, i);
            String value = "";
            if (i + 1 <= cookieText.length()) {
                value = cookieText.substring(i + 1);
            }
            return new CookieData(url, name, value);
        }
        return new CookieData(url, cookieText, "");
    }

    public static void storeCookie(List cookieList, CookieData cookie) {
        int size = cookieList.size();
        for (int i = 0; i < size; ++i) {
            CookieData cd = (CookieData)cookieList.get(i);
            if (!cookie.equals(cd)) continue;
            if (cookie.getMaxAge() == 0) {
                cookieList.remove(i);
                return;
            }
            cookieList.set(i, cookie);
            return;
        }
        if (cookie.getMaxAge() != 0) {
            cookieList.add(cookie);
        }
    }

    public static boolean inDomain(String urlString, CookieData cookie) {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException exception) {
            return false;
        }
        return CookieUtils.inDomain(url, cookie);
    }

    public static boolean inDomain(URL url, CookieData cookie) {
        String domain = cookie.getDomain();
        return url.getHost().toLowerCase().endsWith(domain.toLowerCase());
    }

    public static boolean inPath(String urlString, CookieData cookie) {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException exception) {
            return false;
        }
        return CookieUtils.inPath(url, cookie);
    }

    public static boolean inPath(URL url, CookieData cookie) {
        return url.getFile().startsWith(cookie.getPath());
    }

    public static List findCookiesForServer(List cookieList, URL url) {
        Iterator iterator = cookieList.iterator();
        ArrayList<CookieData> list = new ArrayList<CookieData>();
        while (iterator.hasNext()) {
            CookieData cookie = (CookieData)iterator.next();
            if (!CookieUtils.inDomain(url, cookie) || !CookieUtils.inPath(url, cookie)) continue;
            list.add(cookie);
        }
        return list;
    }

    public static List getCookies(List cookieList, URL url, String name, boolean exact) {
        List serverCookies = CookieUtils.findCookiesForServer(cookieList, url);
        Iterator iterator = serverCookies.iterator();
        ArrayList<CookieData> list = new ArrayList<CookieData>();
        while (iterator.hasNext()) {
            CookieData cookie = (CookieData)iterator.next();
            if (exact) {
                if (!cookie.getName().equals(name)) continue;
                list.add(cookie);
                continue;
            }
            if (!cookie.getName().startsWith(name)) continue;
            list.add(cookie);
        }
        return list;
    }

    public static List getCookiesByName(List cookieList, URL url, String name) {
        return CookieUtils.getCookies(cookieList, url, name, true);
    }

    public static List getCookiesByPrefix(List cookieList, URL url, String name) {
        return CookieUtils.getCookies(cookieList, url, name, false);
    }
}

