/*
 * Decompiled with CFR 0.152.
 */
package edu.indiana.lib.twinpeaks.util;

import edu.indiana.lib.twinpeaks.util.DomException;
import edu.indiana.lib.twinpeaks.util.LogUtils;
import edu.indiana.lib.twinpeaks.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DomUtils {
    private static Log _log = LogUtils.getLog(DomUtils.class);
    private static final String ENCODING_OPTION = "http://cyberneko.org/html/properties/default-encoding";
    public static final String INPUT_ENCODING = "iso-8859-1";
    public static final String ENCODING = "UTF-8";

    private DomUtils() {
    }

    public static Element createElement(Document document, String name) {
        return document.createElement(name);
    }

    public static Element createElement(Element parent, String name) {
        Document document = parent.getOwnerDocument();
        Element element = document.createElement(name);
        parent.appendChild(element);
        return element;
    }

    public static void addText(Element element, String text) {
        element.appendChild(element.getOwnerDocument().createTextNode(text));
    }

    public static void addEntity(Element element, String entity) {
        element.appendChild(element.getOwnerDocument().createEntityReference(entity));
    }

    public static String normalizeText(String update) {
        return DomUtils.normalizeText(null, update);
    }

    public static String normalizeText(String original, String update) {
        if (original == null) {
            return update == null ? "" : StringUtils.replace(update.trim(), "\\s", " ");
        }
        StringBuilder result = new StringBuilder(original.trim());
        result.append(' ');
        result.append(update.trim());
        return StringUtils.replace(result.toString(), "\\s", " ");
    }

    public static String getText(Node parent) {
        return DomUtils.textSearch(parent, false);
    }

    public static String getText(Node parent, String elementName) {
        Element element = DomUtils.getElement((Element)parent, elementName);
        if (element == null) {
            return null;
        }
        return DomUtils.textSearch(element, false);
    }

    public static String getTextNS(String namespace, Node parent, String elementName) {
        Element element = DomUtils.getElementNS(namespace, (Element)parent, elementName);
        if (element == null) {
            return null;
        }
        return DomUtils.textSearch(element, false);
    }

    public static String getAllTextAtNode(Node parent) {
        return DomUtils.textSearch(parent, true);
    }

    public static String textSearch(Node parent, boolean recursiveSearch) {
        String text = null;
        if (parent != null) {
            block4: for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
                switch (child.getNodeType()) {
                    case 3: {
                        text = DomUtils.normalizeText(text, child.getNodeValue());
                        continue block4;
                    }
                    case 1: {
                        if (!recursiveSearch) continue block4;
                        text = DomUtils.normalizeText(text, DomUtils.getText(child));
                        continue block4;
                    }
                }
            }
        }
        return text == null ? text : text.trim();
    }

    public static String getFirstText(Node parent) {
        return DomUtils.getTextNodeByNumber(parent, 1);
    }

    public static String getTextNodeByNumber(Node parent, int number) {
        String text = null;
        int count = 1;
        if (parent != null) {
            for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 3 || count++ != number) continue;
                text = child.getNodeValue();
                return text.trim();
            }
        }
        return text;
    }

    public static String getAllText(Node parent) {
        String text = null;
        if (parent != null) {
            for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
                String childText;
                if (child.getNodeType() == 3) {
                    text = DomUtils.normalizeText(text, child.getNodeValue());
                    continue;
                }
                if (child.getNodeType() != 1 || (childText = DomUtils.getText(child)) == null) continue;
                text = DomUtils.normalizeText(text, childText);
            }
        }
        return text;
    }

    public static String getAttribute(Element element, String name) {
        return element.getAttribute(name);
    }

    public static void setAttribute(Element element, String name, String value) {
        element.setAttribute(name, value);
    }

    public static NodeList getElementList(Element element, String name) {
        return element.getElementsByTagName(name);
    }

    public static NodeList getElementListNS(String namespace, Element element, String name) {
        return element.getElementsByTagNameNS(namespace, name);
    }

    public static List selectElementsByAttributeValue(Element element, String name, String attribute, String value) {
        return DomUtils.selectElementsByAttributeValue(element, name, attribute, value, false);
    }

    public static Element selectFirstElementByAttributeValue(Element element, String name, String attribute, String value) {
        ArrayList resultList = (ArrayList)DomUtils.selectElementsByAttributeValue(element, name, attribute, value, true);
        return resultList.size() == 0 ? null : (Element)resultList.get(0);
    }

    public static List selectElementsByAttributeValue(Element element, String name, String attribute, String value, boolean returnFirst) {
        NodeList elementList = element.getElementsByTagName(name);
        ArrayList<Node> resultList = new ArrayList<Node>();
        for (int i = 0; i < elementList.getLength(); ++i) {
            if (!DomUtils.getAttribute((Element)elementList.item(i), attribute).equals(value)) continue;
            resultList.add(elementList.item(i));
            if (returnFirst) break;
        }
        return resultList;
    }

    public static List selectElementsByAttributeValueNS(String namespace, Element element, String name, String attribute, String value) {
        return DomUtils.selectElementsByAttributeValueNS(namespace, element, name, attribute, value, false);
    }

    public static Element selectFirstElementByAttributeValueNS(String namespace, Element element, String name, String attribute, String value) {
        ArrayList resultList = (ArrayList)DomUtils.selectElementsByAttributeValueNS(namespace, element, name, attribute, value, true);
        return resultList.size() == 0 ? null : (Element)resultList.get(0);
    }

    public static List selectElementsByAttributeValueNS(String namespace, Element element, String name, String attribute, String value, boolean returnFirst) {
        NodeList elementList = element.getElementsByTagNameNS(namespace, name);
        ArrayList<Node> resultList = new ArrayList<Node>();
        for (int i = 0; i < elementList.getLength(); ++i) {
            if (!DomUtils.getAttribute((Element)elementList.item(i), attribute).equals(value)) continue;
            resultList.add(elementList.item(i));
            if (returnFirst) break;
        }
        return resultList;
    }

    public static Element getElement(Element element, String name) {
        NodeList nodeList = DomUtils.getElementList(element, name);
        return nodeList.getLength() == 0 ? null : (Element)nodeList.item(0);
    }

    public static Element getElementNS(String namespace, Element element, String name) {
        NodeList nodeList = DomUtils.getElementListNS(namespace, element, name);
        return nodeList.getLength() == 0 ? null : (Element)nodeList.item(0);
    }

    public Node removeNode(Node node) {
        return node.getParentNode().removeChild(node);
    }

    public static Node getPreviousNodeByName(Node currentNode, String tagName) {
        Node node;
        for (node = currentNode.getParentNode(); node != null && !node.getNodeName().equals(tagName); node = node.getParentNode()) {
        }
        return node;
    }

    public static Node getPreviousSiblingByName(Node currentNode, String tagName) {
        Node node;
        for (node = currentNode.getPreviousSibling(); node != null && !node.getNodeName().equals(tagName); node = node.getPreviousSibling()) {
        }
        return node;
    }

    public static Node getNextSiblingByName(Node currentNode, String tagName) {
        Node node;
        for (node = currentNode.getNextSibling(); node != null && !node.getNodeName().equals(tagName); node = node.getNextSibling()) {
        }
        return node;
    }

    public static Node getNextNodeByName(Node currentNode, String tagName) {
        return DomUtils.getNextSiblingByName(currentNode, tagName);
    }

    public static Node getChildSiblingByName(Node currentNode, String tagName) {
        Node node;
        for (node = currentNode.getFirstChild(); node != null && !node.getNodeName().equals(tagName); node = node.getNextSibling()) {
        }
        return node;
    }

    public static DocumentBuilder getXmlDocumentBuilder() throws DomException {
        return DomUtils.getXmlDocumentBuilder(false);
    }

    public static DocumentBuilder getXmlDocumentBuilderNS() throws DomException {
        return DomUtils.getXmlDocumentBuilder(true);
    }

    public static DocumentBuilder getXmlDocumentBuilder(boolean namespaceAware) throws DomException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(namespaceAware);
            _log.debug((Object)("DOM parse: namespace aware = " + namespaceAware));
            return factory.newDocumentBuilder();
        }
        catch (Exception e) {
            throw new DomException(e.toString());
        }
    }

    public static Document createXmlDocument() throws DomException {
        return DomUtils.createXmlDocument("xml");
    }

    public static Document createXmlDocument(String rootName) throws DomException {
        try {
            Document document = DomUtils.getXmlDocumentBuilder().newDocument();
            Element root = document.createElement(rootName);
            document.appendChild(root);
            return document;
        }
        catch (Exception e) {
            throw new DomException(e.toString());
        }
    }

    public static void copyDocument(Document source, Document target) {
        Node node = target.importNode(source.getDocumentElement(), true);
        target.getDocumentElement().appendChild(node);
    }

    public static void copyDocumentNode(Node source, Document target) {
        Node node = target.importNode(source, true);
        target.getDocumentElement().appendChild(node);
    }

    public static Document parseXmlStream(InputStream xmlStream) throws DomException {
        try {
            return DomUtils.getXmlDocumentBuilder().parse(new InputSource(xmlStream));
        }
        catch (Exception e) {
            throw new DomException(e.toString());
        }
    }

    public static Document parseXmlStreamNS(InputStream xmlStream) throws DomException {
        try {
            return DomUtils.getXmlDocumentBuilderNS().parse(new InputSource(xmlStream));
        }
        catch (Exception e) {
            throw new DomException(e.toString());
        }
    }

    public static Document parseXmlReader(Reader xmlReader) throws DomException {
        try {
            return DomUtils.getXmlDocumentBuilder().parse(new InputSource(xmlReader));
        }
        catch (Exception e) {
            throw new DomException(e.toString());
        }
    }

    public static Document parseXmlBytes(byte[] xml) throws DomException {
        return DomUtils.parseXmlStream(new ByteArrayInputStream(xml));
    }

    public static Document parseXmlBytesNS(byte[] xml) throws DomException {
        return DomUtils.parseXmlStreamNS(new ByteArrayInputStream(xml));
    }

    public static Document parseXmlString(String xml) throws DomException {
        return DomUtils.parseXmlStream(new ByteArrayInputStream(xml.getBytes()));
    }

    public static Document parseXmlFile(String filename) throws DomException {
        try {
            return DomUtils.getXmlDocumentBuilder().parse(filename);
        }
        catch (Exception exception) {
            throw new DomException(exception.toString());
        }
    }

    public static Document parseHtmlBytes(byte[] html) throws DomException {
        return DomUtils.parseXmlStreamNS(new ByteArrayInputStream(html));
    }

    public static Document parseHtmlString(String html) throws DomException {
        return DomUtils.parseXmlReader(new StringReader(html));
    }

    public static void serializeXml(Node node, OutputStream target) throws DomException {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(node), new StreamResult(target));
        }
        catch (Exception e) {
            throw new DomException(e.toString());
        }
    }

    public static void serializeXml(Node node, Writer writer) throws DomException {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(node), new StreamResult(writer));
        }
        catch (Exception e) {
            throw new DomException(e.toString());
        }
    }

    public static String serialize(Object object) throws DomException {
        ByteArrayOutputStream stream = null;
        Writer writer = null;
        try {
            stream = new ByteArrayOutputStream();
            writer = new OutputStreamWriter((OutputStream)stream, ENCODING);
            if (object instanceof Document) {
                DomUtils.serializeXml((Node)((Document)object).getDocumentElement(), writer);
            } else if (object instanceof Element) {
                DomUtils.serializeXml((Node)object, writer);
            } else {
                throw new IllegalArgumentException("Unexpected object for serialzation: " + object.toString());
            }
            String string = stream.toString();
            return string;
        }
        catch (Exception e) {
            throw new DomException(e.toString());
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

