/*
 * Decompiled with CFR 0.152.
 */
package edu.indiana.lib.twinpeaks.util;

import edu.indiana.lib.twinpeaks.util.LogUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;

public class StringUtils {
    private static Log _log = LogUtils.getLog(StringUtils.class);
    private static final int MINIMUM_SUPPORTED_LENGTH = 4;

    private StringUtils() {
    }

    public static String replace(String text, String targetText, String newText) {
        Pattern pattern = Pattern.compile(targetText, 2);
        Matcher matcher = pattern.matcher(text);
        return matcher.replaceAll(newText);
    }

    public static boolean isNull(String string) {
        return string == null || string.length() == 0;
    }

    public static String truncateAtWhitespace(String text, int length) {
        int i;
        if (length < 4) {
            throw new IllegalArgumentException("Requested length too short (must be 4 or greated)");
        }
        if (text.length() <= length) {
            return text;
        }
        int lowerBound = length / 4;
        int upperBound = length + length / 2;
        for (i = length - 1; i > lowerBound; --i) {
            if (!Character.isWhitespace(text.charAt(i))) continue;
            return text.substring(0, i);
        }
        for (i = length; i < upperBound; ++i) {
            if (!Character.isWhitespace(text.charAt(i))) continue;
            return text.substring(0, i);
        }
        return text.substring(0, length);
    }

    public static String trimFront(String text, char character) {
        if (StringUtils.isNull(text)) {
            return text;
        }
        String normalizedText = text.trim();
        int index = 0;
        while (normalizedText.charAt(index) == character && ++index < normalizedText.length()) {
        }
        return normalizedText.substring(index).trim();
    }

    public static String trimEnd(String text, char character) {
        if (StringUtils.isNull(text)) {
            return text;
        }
        String normalizedText = text.trim();
        int index = normalizedText.length() - 1;
        while (normalizedText.charAt(index) == character) {
            if (--index >= 0) continue;
            return "";
        }
        return normalizedText.substring(0, index + 1).trim();
    }

    public static String trimAll(String text, char character) {
        String normalizedText = StringUtils.trimFront(text, character);
        return StringUtils.trimEnd(normalizedText, character);
    }

    public static String capitalize(String text) {
        StringBuilder resultText = new StringBuilder();
        char previousC = '.';
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (Character.isLetter(c) && !Character.isLetter(previousC)) {
                resultText.append(Character.toUpperCase(c));
            } else {
                resultText.append(c);
            }
            previousC = c;
        }
        return resultText.toString();
    }

    public static String removeCharacterOrRangeAsWord(String source, String pattern) {
        return StringUtils.removeCharacterOrRange(source, pattern, true);
    }

    public static String removeCharacterOrRangeAsCharacter(String source, String pattern) {
        return StringUtils.removeCharacterOrRange(source, pattern, false);
    }

    private static String removeCharacterOrRange(String source, String pattern, boolean removeAsWord) {
        StringBuilder patternBuffer = new StringBuilder();
        patternBuffer.append('[');
        patternBuffer.append(pattern);
        patternBuffer.append(']');
        String rangePattern = patternBuffer.toString();
        String result = StringUtils.replace(source, "\\S+" + rangePattern + "\\S+", "");
        if (removeAsWord) {
            result = StringUtils.replace(result, rangePattern + "\\S+", "");
            result = StringUtils.replace(result, "\\S+" + rangePattern, "");
        }
        return StringUtils.replace(result, rangePattern, " ");
    }

    public static void main(String[] args) throws Exception {
        System.out.println(StringUtils.replace(args[0], args[1], args[2]));
    }
}

