/*
 * Decompiled with CFR 0.152.
 */
package edu.indiana.lib.twinpeaks.search;

import edu.indiana.lib.twinpeaks.search.MatchItem;
import edu.indiana.lib.twinpeaks.search.QueryBase;
import edu.indiana.lib.twinpeaks.search.SearchResultInterface;
import edu.indiana.lib.twinpeaks.util.DomUtils;
import edu.indiana.lib.twinpeaks.util.HttpTransactionUtils;
import edu.indiana.lib.twinpeaks.util.LogUtils;
import edu.indiana.lib.twinpeaks.util.SearchException;
import edu.indiana.lib.twinpeaks.util.StringUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.osid.repository.AssetIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class SearchResultBase
implements SearchResultInterface {
    private static Log _log = LogUtils.getLog(SearchResultBase.class);
    private ArrayList _itemList;
    private AssetIterator _assetIterator;
    private int _start;
    private int _count;
    private String _nextPreviewPage;
    private String _previousPreviewPage;
    protected String _searchQuery;
    protected byte[] _searchResponseBytes;
    protected String _searchResponseString;
    protected Document _searchResponseDocument;
    protected String _database;
    protected String _sessionId;
    protected String _baseUrl;

    @Override
    public void initialize(QueryBase query) {
        this._searchQuery = query.getRequestParameter("searchString");
        this._database = query.getRequestParameter("database");
        this._sessionId = query.getRequestParameter("guid");
        this._searchResponseString = query.getResponseString();
        this._searchResponseBytes = query.getResponseBytes();
        this._searchResponseDocument = this.parseResponse();
        this._itemList = new ArrayList();
        this._start = 1;
        this.saveBaseUrl(query.getUrl());
    }

    public void addItem(MatchItem item) {
        this._itemList.add(item);
    }

    @Override
    public String getQuery() {
        return this._searchQuery;
    }

    @Override
    public int getSearchStart() {
        return this._start;
    }

    public void setSearchStart(int start) {
        this._start = start;
    }

    public void setSearchStart(String start) {
        try {
            this._start = Integer.parseInt(start);
        }
        catch (NumberFormatException exception) {
            _log.warn((Object)("Invalid number format: " + start));
            return;
        }
    }

    @Override
    public int getMatchCount() {
        return this._itemList.size();
    }

    @Override
    public String getNextPreviewPage() {
        return this._nextPreviewPage;
    }

    public void setNextPreviewPage(String reference) {
        this._nextPreviewPage = reference;
    }

    @Override
    public String getPreviousPreviewPage() {
        return this._previousPreviewPage;
    }

    public void setPreviousPreviewPage(String reference) {
        this._previousPreviewPage = reference;
    }

    @Override
    public boolean canPaginate() {
        return this._previousPreviewPage != null || this._nextPreviewPage != null;
    }

    @Override
    public Iterator iterator() {
        return this._itemList.iterator();
    }

    public MatchItem[] toArray() {
        return this._itemList.toArray(new MatchItem[this._itemList.size()]);
    }

    @Override
    public String getSearchResponseString() {
        return this._searchResponseString;
    }

    public Document getSearchResponseDocument() {
        return this._searchResponseDocument;
    }

    protected Document parseResponse() throws SearchException {
        try {
            return DomUtils.parseHtmlBytes(this._searchResponseBytes);
        }
        catch (Exception exception) {
            throw new SearchException(exception.toString());
        }
    }

    public void saveBaseUrl(String url) {
        this._baseUrl = HttpTransactionUtils.getServer(url);
    }

    public String getFullUrl(String baseUrl, String urlFragment) {
        String thisUrl = baseUrl;
        if (thisUrl == null) {
            thisUrl = this._baseUrl;
        }
        if (thisUrl != null) {
            try {
                URL base = new URL(thisUrl);
                return new URL(base, urlFragment).toString();
            }
            catch (MalformedURLException exception) {
                throw new SearchException(exception.toString());
            }
        }
        return urlFragment;
    }

    public String getFullUrl(String urlFragment) {
        return this.getFullUrl(null, urlFragment);
    }

    public String prependProxy(String url, String proxy) {
        _log.debug((Object)("prependProxy: proxy [" + proxy + "] vs. [" + url + "]"));
        if (StringUtils.isNull(proxy)) {
            return url;
        }
        if (url.startsWith(proxy)) {
            return url;
        }
        StringBuilder fullUrl = new StringBuilder(proxy);
        fullUrl.append(url);
        return fullUrl.toString();
    }

    public boolean expectedNodeCount(NodeList nodeList, int expected) {
        int length = nodeList.getLength();
        if (length == expected) {
            return true;
        }
        String tag = "Element";
        if (length > 0) {
            tag = nodeList.item(0).getNodeName();
        }
        _log.debug((Object)("Unexpected " + tag + " count: " + length + " (ignoring entry)"));
        return false;
    }

    public String getImageAttribute(Element parent, String name) {
        Element image = DomUtils.getElement(parent, "IMG");
        if (image == null) {
            return null;
        }
        String value = image.getAttribute(name);
        return StringUtils.isNull(value) ? null : value;
    }
}

