/*
 * Decompiled with CFR 0.152.
 */
package edu.indiana.lib.twinpeaks.search.sru;

import edu.indiana.lib.twinpeaks.util.LogUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLParser;

public class CqlParser
extends DefaultHandler {
    private static Log _log = LogUtils.getLog(CqlParser.class);
    private static final Map INDEX_MAP = new HashMap();
    private static final Map BOOL_RELATION_MAP;
    SAXParser saxParser;
    StringBuilder textBuffer;
    StringBuilder searchClause;
    boolean inSearchClause;
    Stack cqlStack = new Stack();
    static final boolean TREAT_ALL_FIELDS_AS_PHRASE = true;
    boolean inKeyword;

    public CqlParser() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            this.saxParser = factory.newSAXParser();
        }
        catch (SAXException e) {
            _log.error((Object)("SAX exception: " + e));
        }
        catch (ParserConfigurationException e) {
            _log.error((Object)("Parse failed: " + e));
        }
    }

    public String doCQL2MetasearchCommand(String cqlSearchQuery) {
        if (cqlSearchQuery == null || cqlSearchQuery.equals("")) {
            return null;
        }
        CQLParser parser = new CQLParser();
        CQLNode root = null;
        try {
            root = parser.parse(cqlSearchQuery);
        }
        catch (Exception exception) {
            _log.error((Object)("Exception in CQL parse: " + exception));
        }
        if (root == null) {
            return null;
        }
        String cqlXml = root.toXCQL(0);
        _log.debug((Object)"CQL XML:");
        _log.debug((Object)cqlXml);
        ByteArrayInputStream byteInputStream = null;
        try {
            byteInputStream = new ByteArrayInputStream(cqlXml.getBytes("UTF8"));
        }
        catch (Exception exception) {
            _log.error((Object)("Exception opening input stream: " + exception));
        }
        if (byteInputStream == null) {
            return null;
        }
        this.cqlStack.removeAllElements();
        try {
            this.saxParser.parse((InputStream)byteInputStream, (DefaultHandler)this);
            byteInputStream.close();
        }
        catch (Exception exception) {
            _log.error((Object)("Exception in parse: " + exception));
        }
        String cqlResult = (String)this.cqlStack.pop();
        return cqlResult.trim();
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        if (qName.equals("searchClause")) {
            this.inSearchClause = true;
            this.inKeyword = false;
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        this.extractDataFromText(qName);
        if (qName.equals("searchClause")) {
            this.inSearchClause = false;
            this.inKeyword = false;
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        String text = new String(buf, offset, len);
        if (this.textBuffer == null) {
            this.textBuffer = new StringBuilder(text);
        } else {
            this.textBuffer.append(text);
        }
    }

    private void extractDataFromText(String element) {
        if (this.textBuffer == null) {
            return;
        }
        String text = this.textBuffer.toString().trim();
        if (text.equals("") && !element.equals("triple")) {
            return;
        }
        if (!this.inSearchClause && element.equals("value")) {
            this.cqlStack.push(text);
        }
        if (this.inSearchClause) {
            if (this.searchClause == null) {
                this.searchClause = new StringBuilder();
            }
            if (element.equals("index")) {
                String field = this.translateIndex(text);
                this.inKeyword = ((String)INDEX_MAP.get("keyword")).equals(field);
                this.searchClause.append(field);
            } else if (!element.equals("value") && element.equals("term")) {
                this.searchClause.append('\"');
                this.searchClause.append(text.replaceAll("\\+", " ").trim());
                this.searchClause.append('\"');
                this.cqlStack.push(this.searchClause.toString().trim());
                this.searchClause = null;
            }
        }
        if (element.equals("triple")) {
            String rightOperand = (String)this.cqlStack.pop();
            String leftOperand = (String)this.cqlStack.pop();
            String booleanRelation = (String)this.cqlStack.pop();
            this.cqlStack.push(leftOperand.replaceAll("\\+", " ").trim() + this.translateBooleanRelation(booleanRelation) + rightOperand.replaceAll("\\+", " ").trim());
        }
        this.textBuffer = null;
    }

    private String translateIndex(String cqlIndex) {
        String s360Index = (String)INDEX_MAP.get(cqlIndex);
        if (s360Index == null || s360Index.equals("")) {
            _log.error((Object)"translateIndex(): bad index, using KEYWORD");
            s360Index = (String)INDEX_MAP.get("keyword");
        }
        return s360Index;
    }

    private String translateBooleanRelation(String booleanRelation) {
        String s360Boolean = (String)BOOL_RELATION_MAP.get(booleanRelation);
        if (s360Boolean == null || s360Boolean.equals("")) {
            _log.error((Object)"translateBooleanRelation(): bad boolean relation, using AND");
            s360Boolean = (String)BOOL_RELATION_MAP.get("and");
        }
        return s360Boolean;
    }

    public static void main(String[] args) {
        CqlParser parser = new CqlParser();
        String query = "title=\"My Title\"";
        System.out.println();
        System.out.println("CQL: " + query);
        System.out.println("360: " + parser.doCQL2MetasearchCommand(query));
        query = "title=\"\\\"My Title\\\"\"";
        System.out.println();
        System.out.println("CQL: " + query);
        System.out.println("360: " + parser.doCQL2MetasearchCommand(query));
        query = "title=\"My Title\" and keyword=\"some keywords\"";
        System.out.println();
        System.out.println("CQL: " + query);
        System.out.println("360: " + parser.doCQL2MetasearchCommand(query));
        query = "title=\"My Title\" and keyword=\"some keywords\" and year=\"1999\"";
        System.out.println();
        System.out.println("CQL: " + query);
        System.out.println("360: " + parser.doCQL2MetasearchCommand(query));
    }

    static {
        INDEX_MAP.put("keyword", " ");
        INDEX_MAP.put("title", "cs.title=");
        INDEX_MAP.put("author", "cs.author=");
        INDEX_MAP.put("subject", "cs.subject=");
        INDEX_MAP.put("year", "cs.date=");
        BOOL_RELATION_MAP = new HashMap();
        BOOL_RELATION_MAP.put("and", " and ");
        BOOL_RELATION_MAP.put("or", " or ");
        BOOL_RELATION_MAP.put("not", " not ");
    }
}

