/*
 * Decompiled with CFR 0.152.
 */
package edu.indiana.lib.twinpeaks.util;

import edu.indiana.lib.twinpeaks.util.LogUtils;
import org.apache.commons.logging.Log;

public class ByteUtils {
    private static Log _log = LogUtils.getLog(ByteUtils.class);

    private ByteUtils() {
    }

    public static int indexOf(byte[] source, String matchString) {
        return ByteUtils.indexOf(source, matchString.getBytes());
    }

    public static int indexOf(byte[] source, byte[] match) {
        for (int i = 0; i < source.length; ++i) {
            if (!ByteUtils.startsWith(source, i, match)) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(byte[] source, String matchString) {
        return ByteUtils.lastIndexOf(source, matchString.getBytes());
    }

    public static int lastIndexOf(byte[] source, byte[] match) {
        if (source.length < match.length) {
            return -1;
        }
        for (int i = source.length - match.length; i >= 0; --i) {
            if (!ByteUtils.startsWith(source, i, match)) continue;
            return i;
        }
        return -1;
    }

    public static boolean startsWith(byte[] source, byte[] match) {
        return ByteUtils.startsWith(source, 0, match);
    }

    public static boolean startsWith(byte[] source, int offset, byte[] match) {
        if (match.length > source.length - offset) {
            return false;
        }
        for (int i = 0; i < match.length; ++i) {
            if (source[offset + i] == match[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(byte[] source, byte[] match) {
        if (match.length != source.length) {
            return false;
        }
        return ByteUtils.startsWith(source, 0, match);
    }

    public static void getBytes(byte[] source, int srcBegin, int srcEnd, byte[] destination, int dstBegin) {
        System.arraycopy(source, srcBegin, destination, dstBegin, srcEnd - srcBegin);
    }

    public static byte[] subbytes(byte[] source, int srcBegin, int srcEnd) {
        byte[] destination = new byte[srcEnd - srcBegin];
        ByteUtils.getBytes(source, srcBegin, srcEnd, destination, 0);
        return destination;
    }

    public static byte[] subbytes(byte[] source, int srcBegin) {
        return ByteUtils.subbytes(source, srcBegin, source.length);
    }

    public static void main(String[] args) throws Exception {
        byte[] byteText = args[0].getBytes();
        int index = ByteUtils.indexOf(byteText, "XXX");
        int last = ByteUtils.lastIndexOf(byteText, "XXX");
        _log.debug((Object)("Index = " + index));
        _log.debug((Object)("Last  = " + last));
        _log.debug((Object)("equal = " + ByteUtils.equals(byteText, "XXX".getBytes())));
    }
}

