/*
 * Decompiled with CFR 0.152.
 */
package edu.indiana.lib.twinpeaks.util;

import edu.indiana.lib.twinpeaks.util.LogUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;

public class ParameterMap {
    private static Log _log = LogUtils.getLog(ParameterMap.class);
    private static final int PREFIXSIZE = 4;
    private static final int MAXVALUE = 65535;
    private HashMap _parameterMap = new HashMap();
    private Map.Entry _entry;
    private int _fill = 0;

    public synchronized void clear() {
        this._parameterMap.clear();
    }

    public synchronized Iterator getParameterMapIterator() {
        return this._parameterMap.entrySet().iterator();
    }

    public synchronized boolean nextParameterMapEntry(Iterator iterator) {
        if (!iterator.hasNext()) {
            this._entry = null;
            return false;
        }
        this._entry = (Map.Entry)iterator.next();
        return true;
    }

    public synchronized String getParameterNameFromIterator() {
        return ((String)this._entry.getKey()).substring(4);
    }

    public synchronized String getParameterValueFromIterator() {
        return (String)this._entry.getValue();
    }

    public synchronized void setParameterMapValue(String name, String value) {
        String uniqueName = this.generateFillText() + name;
        this._parameterMap.put(uniqueName, value);
    }

    public synchronized String getParameterMapValue(String name) {
        Iterator iterator = this.getParameterMapIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String mapName = ((String)entry.getKey()).substring(4);
            if (!mapName.equals(name)) continue;
            return (String)entry.getValue();
        }
        return null;
    }

    public synchronized String getParameterMapName(String value) {
        Iterator iterator = this.getParameterMapIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String mapValue = (String)entry.getValue();
            if (!mapValue.equals(value)) continue;
            return ((String)entry.getKey()).substring(4);
        }
        return null;
    }

    private synchronized int getFillSeed() {
        return this._fill++;
    }

    private String generateFillText() {
        int value = this.getFillSeed();
        if (value < 0 || value > 65535) {
            throw new UnsupportedOperationException("Value " + value + " out of range");
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            result.insert(0, Integer.toHexString(value & 0xF));
            value >>= 4;
        }
        return result.toString();
    }

    public synchronized int populateMapFromUrlArguments(String url, String delimiter) {
        String parameters = url;
        int count = 0;
        if (url.startsWith("?")) {
            parameters = url.length() == 1 ? "" : url.substring(1);
        } else if (url.indexOf("://") != -1) {
            int index = url.indexOf(63);
            parameters = "";
            if (index != -1 && index != url.length()) {
                parameters = url.substring(index + 1);
            }
        }
        String[] p = parameters.split(delimiter);
        for (int i = 0; i < p.length; ++i) {
            int index = p[i].indexOf("=");
            if (index == -1) continue;
            this.setParameterMapValue(p[i].substring(0, index), p[i].substring(index + 1));
            ++count;
        }
        return count;
    }
}

