/*
 * Decompiled with CFR 0.152.
 */
package edu.indiana.lib.twinpeaks.search.singlesearch.musepeer;

import edu.indiana.lib.twinpeaks.search.HttpTransactionQueryBase;
import edu.indiana.lib.twinpeaks.search.singlesearch.CqlParser;
import edu.indiana.lib.twinpeaks.util.DomUtils;
import edu.indiana.lib.twinpeaks.util.LogUtils;
import edu.indiana.lib.twinpeaks.util.SearchException;
import edu.indiana.lib.twinpeaks.util.SessionContext;
import edu.indiana.lib.twinpeaks.util.SessionTimeoutException;
import edu.indiana.lib.twinpeaks.util.StatusUtils;
import edu.indiana.lib.twinpeaks.util.StringUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Query
extends HttpTransactionQueryBase {
    private static final Logger log = LoggerFactory.getLogger(Query.class);
    public static final boolean DISPLAY_XML = false;
    public static final String RECORDS_PER_PAGE = "10";
    private static final String RECORDS_PER_TARGET = "50";
    private final String APPLICATION = SessionContext.uniqueSessionName(this);
    private static final String NO_SESSION = "Not logged on. Please logon first.";
    private String _database;
    private String _museSearchString;
    private int _targetCount;
    private long _transactionId;
    private static final long ONE_SECOND = 1000L;
    private long _timeLimit;

    @Override
    public void parseRequest(Map parameterMap) {
        super.parseRequest(parameterMap);
        if (this.getRequestParameter("guid") == null || this.getRequestParameter("url") == null) {
            throw new IllegalArgumentException("Missing GUID or URL");
        }
        String action = this.getRequestParameter("action");
        log.debug("*** Beginning action: " + action);
        if ("startsearch".equalsIgnoreCase(action)) {
            if (this.getRequestParameter("targets") == null || this.getRequestParameter("username") == null || this.getRequestParameter("password") == null) {
                throw new IllegalArgumentException("Missing target list, username, or password");
            }
            String searchCriteria = this.parseCql(this.getRequestParameter("searchString"));
            this.getSessionContext().put("SEARCH_QUERY", searchCriteria);
        }
    }

    @Override
    public void doQuery() {
        this._database = this.getRequestParameter("database");
        this.setRedirectBehavior(1);
        this.setQueryMethod("POST");
        this.setUrl(this.getRequestParameter("url"));
        this.setSearchString(this.getSearchString());
        String action = this.getRequestParameter("action");
        if (action.equalsIgnoreCase("startSearch")) {
            StatusUtils.initialize(this.getSessionContext(), this.getRequestParameter("targets"));
            StatusUtils.setAsyncSearch(this.getSessionContext());
            StatusUtils.setAsyncInit(this.getSessionContext());
            this.clearParameters();
            this.doLogoffCommand();
            this.submit();
            this.setSessionId(null);
            this.displayXml("Logoff", this.getResponseDocument());
            this.clearParameters();
            this.doLogonCommand();
            this.submit();
            this.displayXml("Login", this.getResponseDocument());
            this.validateResponse("LOGON");
            this.clearParameters();
            this.doSearchCommand();
            this.submit();
            this.displayXml("Search", this.getResponseDocument());
            this.validateResponse("SEARCH");
            this.setSearchStatusTimeout(60L);
            return;
        }
        if (StatusUtils.doingAsyncInit(this.getSessionContext())) {
            this.clearParameters();
            this.doProgressCommand();
            this.submit();
            this.displayXml("Progress command done", this.getResponseDocument());
            this.validateResponse("PROGRESS");
            if (!this.setSearchStatus(this.getResponseDocument())) {
                throw new SearchException("Asset not ready");
            }
            StatusUtils.clearAsyncInit(this.getSessionContext());
            if (StatusUtils.getActiveTargetCount(this.getSessionContext()) == 0) {
                throw new SearchException("Asset not ready");
            }
        }
        this.doResultsCommand();
        this.displayXml("Results", this.getResponseDocument());
    }

    private void doLogonCommand() throws SearchException {
        String username = this.getRequestParameter("username");
        String password = this.getRequestParameter("password");
        log.debug("Logging in as \"" + username + "\"");
        this.setParameter("action", "logon");
        this.setParameter("userID", username);
        this.setParameter("userPwd", password);
        this.setParameter("templateFile", "xml/index.xml");
        this.setParameter("errorTemplate", "xml/error.xml");
    }

    private void doLogoffCommand() throws SearchException {
        this.setParameter("action", "logoff");
        this.setParameter("sessionID", this.getSessionId());
        this.setParameter("templateFile", "xml/index.xml");
        this.setParameter("errorTemplate", "xml/error.xml");
    }

    private void doSearchCommand() throws SearchException {
        String searchCriteria = this.getSearchString();
        log.debug("Search criteria: " + searchCriteria);
        this.setParameter("action", "search");
        this.setParameter("xml", "true");
        this.setParameter("sessionID", this.getSessionId());
        this.setParameter("queryStatement", searchCriteria);
        String targets = this.getRequestParameter("targets");
        StringTokenizer targetParser = new StringTokenizer(targets);
        this._targetCount = targetParser.countTokens();
        while (targetParser.hasMoreTokens()) {
            String target = targetParser.nextToken();
            this.setParameter("dbList", target);
            log.debug("SEARCH: added DB " + target);
        }
        this.setParameter("limitsMaxPerSource", this.getPageSize());
        this.setParameter("limitsMaxPerPage", "0");
        this.setFormattingFiles();
    }

    private void doProgressCommand() throws SearchException {
        this.setParameter("action", "progress");
        this.setParameter("xml", "true");
        this.setParameter("sessionID", this.getSessionId());
        this.setParameter("searchReferenceID", this.getReferenceId());
        this.setParameter("errorTemplate", "xml/error.xml");
        this.setParameter("errorFormat", "error2XML.xsl");
    }

    private void doPaginationCommand(String page, int firstRecord, int pageSize) {
        String start = Integer.toString(firstRecord);
        String total = Integer.toString(firstRecord - 1);
        log.debug("Using result set name \"" + this.getResultSetName() + "\"");
        this.setParameter("action", page);
        this.setParameter("xml", "true");
        this.setParameter("sessionID", this.getSessionId());
        this.setParameter("searchReferenceID", this.getReferenceId());
        this.setParameter("resultSet", this.getResultSetName());
        this.setDbList();
        log.debug("PAGE: start = " + start + ", first = " + start + ", total = " + total + ", pageSize = " + pageSize);
        this.setParameter("start", start);
        this.setParameter("firstRetrievedRecord", start);
        this.setParameter("limitsMaxPerSource", String.valueOf(pageSize));
        this.setParameter("limitsMaxPerPage", String.valueOf(pageSize));
        this.setFormattingFiles();
    }

    private void doMoreCommand(int firstRecord, int pageSize, int totalRemaining) {
        String start = Integer.toString(firstRecord);
        String first = Integer.toString(firstRecord - Math.min(pageSize, totalRemaining));
        String total = Integer.toString(firstRecord - 1);
        String limit = Integer.toString(Math.min(pageSize, totalRemaining));
        log.debug("MORE: using result set name \"" + this.getResultSetName() + "\"");
        log.debug("MORE: queryStatement = " + this.getSearchString());
        this.setParameter("action", "more");
        this.setParameter("actionType", "SEARCH");
        this.setParameter("xml", "true");
        this.setParameter("sessionID", this.getSessionId());
        this.setParameter("searchReferenceID", this.getReferenceId());
        this.setParameter("resultSet", this.getResultSetName());
        this.setParameter("queryStatement", this.getSearchString());
        this.setDbList();
        log.debug("MORE: start = " + start + ", first = " + first + ", total = " + total + ", pageSize = " + pageSize + ", remaining = " + totalRemaining + ", page limit = " + limit);
        this.setParameter("start", start);
        this.setParameter("firstRetrievedRecord", first);
        this.setParameter("limitsMaxPerSource", limit);
        this.setParameter("limitsMaxPerPage", limit);
        this.setFormattingFiles();
    }

    private void doResultsCommand() throws SearchException {
        int start = this.getSessionContext().getInt("startRecord");
        int pageSize = Integer.parseInt(this.getPageSize());
        int totalRemaining = StatusUtils.getAllRemainingHits(this.getSessionContext());
        log.debug(pageSize + " VS " + totalRemaining);
        if (start == 1) {
            this.clearParameters();
            this.doPaginationCommand("previous", start, Math.min(pageSize, totalRemaining));
            this.submit();
            this.validateResponse("PREVIOUS");
            return;
        }
        this.clearParameters();
        this.doMoreCommand(start, pageSize, totalRemaining);
        this.submit();
        this.validateResponse("MORE");
    }

    private void setFormattingFiles() {
        this.setParameter("recordFormat", "raw.xsl");
        this.setParameter("headerTemplate", "xml/list-header.xml");
        this.setParameter("footerTemplate", "xml/list-footer.xml");
        this.setParameter("errorTemplate", "xml/error.xml");
        this.setParameter("errorFormat", "error2XML.xsl");
    }

    private void setDbList() {
        Iterator targetIterator = StatusUtils.getStatusMapEntrySetIterator(this.getSessionContext());
        int count = 0;
        while (targetIterator.hasNext()) {
            Map.Entry entry = (Map.Entry)targetIterator.next();
            String target = (String)entry.getKey();
            HashMap map = StatusUtils.getStatusMapForTarget(this.getSessionContext(), target);
            String status = (String)map.get("STATUS");
            if (!"ACTIVE".equals(status)) continue;
            this.setParameter("dbList", target);
            ++count;
        }
        log.debug(count + " active database(s)");
    }

    private void validateResponse(String action) throws SearchException {
        log.debug("VALIDATE: " + action);
        Document document = this.getResponseDocument();
        Element element = document.getDocumentElement();
        if (element != null && element.getTagName().equals(action)) {
            if (action.equals("LOGON")) {
                element = DomUtils.getElement(element, "SESSION_ID");
                String sessionId = DomUtils.getText(element);
                this.setSessionId(sessionId);
                log.debug("Saved Muse session ID \"" + sessionId + "\"");
                return;
            }
            if (action.equals("SEARCH") || action.equals("MORE")) {
                Element searchElement = element;
                element = DomUtils.getElement(element, "REFERENCE_ID");
                String id = DomUtils.getText(element);
                this.setReferenceId(id);
                log.debug("Saved search reference ID \"" + this.getReferenceId() + "\"");
                if (action.equals("SEARCH")) {
                    element = DomUtils.getElement(searchElement, "RESULT_SET_NAME");
                    id = DomUtils.getText(element);
                    this.setResultSetName(id);
                    log.debug("Saved result set name \"" + this.getResultSetName() + "\"");
                }
                return;
            }
            log.debug("No \"cleanup\" activities implemented for " + action);
            return;
        }
        element = document.getDocumentElement();
        if (element != null && element.getTagName().equals("ERROR")) {
            element = DomUtils.getElement(element, "MESSAGE");
        }
        if (element == null) {
            String errorText = action + ": Unexpected document format";
            LogUtils.displayXml(log, errorText, document);
            StatusUtils.setGlobalError(this.getSessionContext(), errorText);
            throw new SearchException(errorText);
        }
        String message = DomUtils.getText(element);
        String errorText = action + " error: " + (StringUtils.isNull(message) ? "*unknown*" : message);
        LogUtils.displayXml(log, errorText, document);
        if (message.endsWith(NO_SESSION)) {
            this.removeQueryUrl(this.APPLICATION);
            StatusUtils.setGlobalError(this.getSessionContext(), "Session timed out");
            throw new SessionTimeoutException();
        }
        StatusUtils.setGlobalError(this.getSessionContext(), errorText);
        throw new SearchException(errorText);
    }

    private boolean setSearchStatus(Document document) throws SearchException {
        String commandStatus;
        Element rootElement = document.getDocumentElement();
        NodeList nodeList = DomUtils.getElementList(rootElement, "ITEM");
        Element statusElement = DomUtils.getElement(rootElement, "STATUS");
        String status = "0";
        String finalStatus = "unknown";
        boolean timedOut = this.searchTimedOut();
        int targetCount = nodeList.getLength();
        int active = 0;
        int total = 0;
        boolean totalHits = false;
        int complete = 0;
        for (int i = 0; i < targetCount; ++i) {
            String text;
            Element recordElement = (Element)nodeList.item(i);
            Element element = DomUtils.selectFirstElementByAttributeValue(recordElement, "ENTRY", "key", "targetID");
            String target = DomUtils.getText(element);
            HashMap map = StatusUtils.getStatusMapForTarget(this.getSessionContext(), target);
            element = DomUtils.selectFirstElementByAttributeValue(recordElement, "ENTRY", "key", "status");
            status = DomUtils.getText(element);
            if (status == null) {
                status = "0";
                element = DomUtils.selectFirstElementByAttributeValue(recordElement, "ENTRY", "key", "message");
                text = DomUtils.getText(element);
                if (text != null && "Not Started".equals(text)) {
                    status = "100";
                }
            }
            if ((text = DomUtils.getText(element = DomUtils.selectFirstElementByAttributeValue(recordElement, "ENTRY", "key", "estimate"))) == null) {
                text = "0";
            }
            int estimate = Integer.parseInt(text);
            map.put("ESTIMATE", "0");
            map.put("STATUS", "DONE");
            if (estimate > 0) {
                map.put("ESTIMATE", String.valueOf(estimate));
                total += estimate;
                map.put("STATUS", "ACTIVE");
                ++active;
                status = "100";
            }
            map.put("PERCENT_COMPLETE", status);
            if ("100".equals(status)) {
                ++complete;
            }
            log.debug("****** Target: " + target + ", status = " + status + ", all searches complete? " + (complete == targetCount) + ", timedout? " + timedOut);
        }
        this.getSessionContext().putInt("TOTAL_ESTIMATE", total);
        this.getSessionContext().putInt("maxRecords", total);
        this.getSessionContext().putInt("active", active);
        finalStatus = "not finished";
        if (statusElement != null && "1".equals(commandStatus = DomUtils.getText(statusElement))) {
            finalStatus = "complete";
        }
        return finalStatus.equals("complete") || timedOut;
    }

    private void setSearchStatusTimeout(long numberOfSeconds) {
        this._timeLimit = System.currentTimeMillis() + numberOfSeconds * 1000L;
    }

    private boolean searchTimedOut() {
        return System.currentTimeMillis() >= this._timeLimit;
    }

    private int getTargetCount() {
        return this._targetCount;
    }

    private String getPageSize() {
        return "30";
    }

    private String getSessionId() {
        return (String)this.getSessionContext().get("SESSION_ID");
    }

    private void setSessionId(String sessionId) {
        this.getSessionContext().put("SESSION_ID", sessionId);
    }

    private String getReferenceId() {
        return (String)this.getSessionContext().get("REFERENCE_ID");
    }

    private void setReferenceId(String referenceNumber) {
        this.getSessionContext().put("REFERENCE_ID", referenceNumber);
    }

    private String getResultSetName() {
        return (String)this.getSessionContext().get("RESULT_SET_NAME");
    }

    private void setResultSetName(String name) {
        this.getSessionContext().put("RESULT_SET_NAME", name);
    }

    @Override
    public String getSearchString() {
        return (String)this.getSessionContext().get("SEARCH_QUERY");
    }

    private String parseCql(String cql) throws IllegalArgumentException {
        log.debug("Initial CQL Criteria: " + cql);
        CqlParser parser = new CqlParser();
        String result = parser.doCQL2MetasearchCommand(cql);
        log.debug("Processed Result: " + result);
        return result;
    }

    private Element getElement(Element parent, String elementName) {
        try {
            Element root = parent;
            if (root == null) {
                root = this.getResponseDocument().getDocumentElement();
            }
            return DomUtils.getElement(root, elementName);
        }
        catch (Exception exception) {
            throw new SearchException(exception.toString());
        }
    }

    private Element getElement(String elementName) {
        return this.getElement(null, elementName);
    }

    private void displayXml(String text, Object xmlObject) {
    }
}

