/*
 * Decompiled with CFR 0.152.
 */
package edu.indiana.lib.osid.base.repository.http;

import edu.indiana.lib.osid.base.repository.http.AssetIterator;
import edu.indiana.lib.osid.base.repository.http.Managers;
import edu.indiana.lib.osid.base.repository.http.ObjectIterator;
import edu.indiana.lib.osid.base.repository.http.PartIterator;
import edu.indiana.lib.osid.base.repository.http.Record;
import edu.indiana.lib.osid.base.repository.http.RecordIterator;
import edu.indiana.lib.osid.base.repository.http.RecordStructure;
import edu.indiana.lib.osid.base.repository.http.RecordStructureIterator;
import edu.indiana.lib.osid.base.repository.http.Type;
import java.io.Serializable;
import java.util.Vector;
import org.osid.id.IdManager;
import org.osid.repository.Part;
import org.osid.repository.RepositoryException;
import org.osid.shared.Id;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Asset
extends edu.indiana.lib.osid.base.repository.Asset {
    private static final Logger log = LoggerFactory.getLogger(Asset.class);
    private org.osid.shared.Type assetType = new Type("mit.edu", "asset", "library_content");
    private org.osid.shared.Type recordStructureType = new Type("mit.edu", "recordStructure", "library_content");
    private org.osid.shared.Type dcRecordStructureType = new Type("mit.edu", "recordStructure", "dublinCore");
    private org.osid.shared.Type vueRecordStructureType = new Type("tufts.edu", "recordStructure", "vue");
    private IdManager idManager = Managers.getIdManager();
    private Id id = null;
    private Id repositoryId = null;
    private String idString = null;
    private String displayName = null;
    private String description = null;
    private org.osid.shared.Type type = null;
    private Vector recordVector = new Vector();
    private String content = null;

    protected Asset(String displayName, String description, String idString, Id repositoryId) throws RepositoryException {
        this.displayName = displayName;
        this.description = description;
        this.repositoryId = repositoryId;
        this.type = new Type("mit.edu", "asset", "library_content");
        try {
            this.id = this.idManager.getId(idString);
        }
        catch (Throwable t) {
            log.error(t.getMessage());
        }
    }

    @Override
    public String getDisplayName() throws RepositoryException {
        return this.displayName;
    }

    @Override
    public String getDescription() throws RepositoryException {
        return this.description;
    }

    @Override
    public Id getId() throws RepositoryException {
        return this.id;
    }

    @Override
    public Id getRepository() throws RepositoryException {
        return this.repositoryId;
    }

    @Override
    public Serializable getContent() throws RepositoryException {
        return this.content;
    }

    @Override
    public void updateContent(Serializable content) throws RepositoryException {
        this.content = (String)((Object)content);
    }

    @Override
    public org.osid.repository.AssetIterator getAssets() throws RepositoryException {
        return new AssetIterator(new Vector());
    }

    @Override
    public org.osid.repository.AssetIterator getAssetsByType(org.osid.shared.Type assetType) throws RepositoryException {
        if (assetType == null) {
            throw new RepositoryException("Null argument");
        }
        return new AssetIterator(new Vector());
    }

    @Override
    public org.osid.repository.Record createRecord(Id recordStructureId) throws RepositoryException {
        if (recordStructureId == null) {
            throw new RepositoryException("Null argument");
        }
        try {
            Record record = new Record(recordStructureId, this.idManager);
            this.recordVector.addElement(record);
            return record;
        }
        catch (Throwable t) {
            log.error(t.getMessage());
            throw new RepositoryException("Operation failed ");
        }
    }

    @Override
    public void deleteRecord(Id recordId) throws RepositoryException {
        if (recordId == null) {
            throw new RepositoryException("Null argument");
        }
        try {
            int size = this.recordVector.size();
            for (int i = 0; i < size; ++i) {
                org.osid.repository.Record record = (org.osid.repository.Record)this.recordVector.elementAt(i);
                if (!record.getId().isEqual(recordId)) continue;
                this.recordVector.removeElementAt(i);
                return;
            }
            throw new RepositoryException("Unknown Id ");
        }
        catch (Throwable t) {
            log.error(t.getMessage());
            throw new RepositoryException("Operation failed ");
        }
    }

    @Override
    public org.osid.repository.RecordIterator getRecords() throws RepositoryException {
        return new RecordIterator(this.recordVector);
    }

    @Override
    public org.osid.repository.RecordIterator getRecordsByRecordStructure(Id recordStructureId) throws RepositoryException {
        if (recordStructureId == null) {
            throw new RepositoryException("Null argument");
        }
        try {
            return new RecordIterator(this.recordVector);
        }
        catch (Throwable t) {
            log.error(t.getMessage());
            throw new RepositoryException("Operation failed ");
        }
    }

    public org.osid.shared.Type getAssetType() throws RepositoryException {
        return this.type;
    }

    @Override
    public org.osid.repository.RecordStructureIterator getRecordStructures() throws RepositoryException {
        Vector<RecordStructure> results = new Vector<RecordStructure>();
        results.addElement(new RecordStructure());
        return new RecordStructureIterator(results);
    }

    @Override
    public org.osid.repository.RecordStructure getContentRecordStructure() throws RepositoryException {
        return new RecordStructure();
    }

    @Override
    public org.osid.repository.Record getRecord(Id recordId) throws RepositoryException {
        if (recordId == null) {
            throw new RepositoryException("Null argument");
        }
        try {
            int size = this.recordVector.size();
            for (int i = 0; i < size; ++i) {
                org.osid.repository.Record record = (org.osid.repository.Record)this.recordVector.elementAt(i);
                if (!record.getId().isEqual(recordId)) continue;
                return record;
            }
            throw new RepositoryException("Unknown Id ");
        }
        catch (Throwable t) {
            log.error(t.getMessage());
            throw new RepositoryException("Operation failed ");
        }
    }

    @Override
    public Part getPart(Id partId) throws RepositoryException {
        if (partId == null) {
            throw new RepositoryException("Null argument");
        }
        try {
            int size = this.recordVector.size();
            for (int i = 0; i < size; ++i) {
                org.osid.repository.Record record = (org.osid.repository.Record)this.recordVector.elementAt(i);
                org.osid.repository.PartIterator partIterator = record.getParts();
                while (partIterator.hasNextPart()) {
                    Part part = partIterator.nextPart();
                    if (!part.getId().isEqual(partId)) continue;
                    return part;
                }
            }
            throw new RepositoryException("Unknown Id ");
        }
        catch (Throwable t) {
            log.error(t.getMessage());
            throw new RepositoryException("Operation failed ");
        }
    }

    @Override
    public Serializable getPartValue(Id partId) throws RepositoryException {
        Part part = this.getPart(partId);
        return part.getValue();
    }

    @Override
    public org.osid.repository.PartIterator getPartByPart(Id partStructureId) throws RepositoryException {
        if (partStructureId == null) {
            throw new RepositoryException("Null argument");
        }
        try {
            Vector<Part> results = new Vector<Part>();
            int size = this.recordVector.size();
            for (int i = 0; i < size; ++i) {
                org.osid.repository.Record record = (org.osid.repository.Record)this.recordVector.elementAt(i);
                org.osid.repository.PartIterator partIterator = record.getParts();
                while (partIterator.hasNextPart()) {
                    Part part = partIterator.nextPart();
                    if (!part.getPartStructure().getId().isEqual(partStructureId)) continue;
                    results.addElement(part);
                }
            }
            return new PartIterator(results);
        }
        catch (Throwable t) {
            log.error(t.getMessage());
            throw new RepositoryException("Operation failed ");
        }
    }

    @Override
    public org.osid.shared.ObjectIterator getPartValueByPart(Id partStructureId) throws RepositoryException {
        Vector<Serializable> results = new Vector<Serializable>();
        org.osid.repository.PartIterator partIterator = this.getPartByPart(partStructureId);
        while (partIterator.hasNextPart()) {
            results.addElement(partIterator.nextPart().getValue());
        }
        try {
            return new ObjectIterator(results);
        }
        catch (Throwable t) {
            log.error(t.getMessage());
            throw new RepositoryException("Operation failed ");
        }
    }

    @Override
    public org.osid.shared.ObjectIterator getPartValuesByPartStructure(Id partStructureId) throws RepositoryException {
        if (partStructureId == null) {
            throw new RepositoryException("Null argument");
        }
        try {
            Vector<Serializable> results = new Vector<Serializable>();
            org.osid.repository.PartIterator partIterator = this.getPartsByPartStructure(partStructureId);
            while (partIterator.hasNextPart()) {
                Part part = partIterator.nextPart();
                results.addElement(part.getValue());
            }
            return new ObjectIterator(results);
        }
        catch (Throwable t) {
            log.error(t.getMessage());
            throw new RepositoryException("Operation failed ");
        }
    }

    @Override
    public org.osid.repository.PartIterator getPartsByPartStructure(Id partStructureId) throws RepositoryException {
        if (partStructureId == null) {
            throw new RepositoryException("Null argument");
        }
        try {
            Vector<Part> results = new Vector<Part>();
            org.osid.repository.RecordIterator recordIterator = this.getRecords();
            while (recordIterator.hasNextRecord()) {
                org.osid.repository.Record record = recordIterator.nextRecord();
                org.osid.repository.PartIterator partIterator = record.getParts();
                while (partIterator.hasNextPart()) {
                    Part part = partIterator.nextPart();
                    if (!part.getPartStructure().getId().isEqual(partStructureId)) continue;
                    results.addElement(part);
                }
            }
            return new PartIterator(results);
        }
        catch (Throwable t) {
            log.error(t.getMessage());
            throw new RepositoryException("Operation failed ");
        }
    }

    public org.osid.repository.RecordIterator getRecordsByRecordStructureType(org.osid.shared.Type recordStructureType) throws RepositoryException {
        if (recordStructureType == null) {
            throw new RepositoryException("Null argument");
        }
        if (!(recordStructureType.isEqual(this.recordStructureType) || recordStructureType.isEqual(this.dcRecordStructureType) || recordStructureType.isEqual(this.vueRecordStructureType))) {
            throw new RepositoryException("Unknown Type ");
        }
        Vector<org.osid.repository.Record> results = new Vector<org.osid.repository.Record>();
        int size = this.recordVector.size();
        for (int i = 0; i < size; ++i) {
            org.osid.repository.Record r = (org.osid.repository.Record)this.recordVector.elementAt(i);
            if (!r.getRecordStructure().getType().isEqual(recordStructureType)) continue;
            results.addElement(r);
        }
        return new RecordIterator(results);
    }
}

